/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.decorators;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.ui.AHistoryTextField;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.iov.IOView;
import com.sigrity.orbit.iov.IOViewBlock;
import com.sigrity.orbit.iov.IOViewDecorator;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.HeadlessException;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class ReplaceDecorator
extends IOViewDecorator {
    HashMap<String, Net> pinToNet = new HashMap();
    Integer order;
    Device.SourceType sourceType;
    String deviceNameToReplace = "SCAN_MUX";
    String templateToReplaceWith = "lvcmos18_vddo_ns";
    String spacerTemplateName = "sp05000_216_ns";

    @Override
    public void decorate() {
        if (!this.getOk()) {
            return;
        }
        if (DeviceTemplate.getDeviceTemplate((Substrate)IOView.theIOView.getRootDevicePath().getSubstrate(), (String)this.templateToReplaceWith) == null) {
            ALog.logWarn((String)(this.templateToReplaceWith + " is not a valid template"));
            return;
        }
        if (DeviceTemplate.getDeviceTemplate((Substrate)IOView.theIOView.getRootDevicePath().getSubstrate(), (String)this.spacerTemplateName) == null) {
            ALog.logWarn((String)(this.spacerTemplateName + " is not a valid template"));
            return;
        }
        for (IOViewBlock iovb : this.input) {
            if (iovb.getName().equals(this.deviceNameToReplace)) {
                Device d = iovb.getDevicePath().getLast();
                this.saveAttributes(iovb.getDevicePath());
                d.deleteFromDb();
                IOViewBlock replace = this.addToOutput(this.deviceNameToReplace, this.templateToReplaceWith);
                this.restoreAttributes(replace.getDevicePath());
                this.addToOutput("spacer", this.spacerTemplateName);
                continue;
            }
            this.copyToOutput(iovb);
        }
    }

    protected boolean getOk() {
        UserQuestionsDialog dlg = null;
        dlg = new UserQuestionsDialog(OrbitIO.getMainWindow());
        dlg.init();
        if (dlg.getOk()) {
            this.deviceNameToReplace = dlg.getDeviceName();
            this.templateToReplaceWith = dlg.getReplaceName();
            this.spacerTemplateName = dlg.getSpacerName();
            return true;
        }
        return false;
    }

    protected void saveAttributes(DevicePath path) {
        DeviceTemplate die = path.pathToLowestDie().getDeviceTemplate();
        DeviceTemplate dt = path.getDeviceTemplate();
        for (PinTemplate pt : dt.getPins()) {
            Net n = NetMap.getNetAt((Net)pt.getNet(), (DevicePath)path, (DeviceTemplate)die);
            if (n.isUnused() || n.getDeviceTemplate() != die) continue;
            this.pinToNet.put(pt.getName(), n);
        }
        this.sourceType = path.getLast().getSourceType();
        this.order = (Integer)path.getLast().getValue("IOView.UndecoratedOrder");
    }

    protected void restoreAttributes(DevicePath path) {
        Device device = path.getLast();
        for (PinInstance pi : device.getPins()) {
            Net n = this.pinToNet.get(pi.getPinTemplate().getName());
            if (n == null) continue;
            NetMap.mapThroughPath((DevicePath)path, (PinInstance)pi, (String)n.getName());
        }
        path.getLast().setSourceType(this.sourceType);
        path.getLast().setValue("IOView.UndecoratedOrder", (Object)this.order);
    }

    static class UserQuestionsDialog
    extends JDialog {
        boolean ok = false;
        AHistoryTextField deviceName;
        AHistoryTextField replaceName;
        AHistoryTextField spacerName;
        protected ActionListener mOk = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ok = true;
                deviceName.saveCurrentEntryToHistory();
                replaceName.saveCurrentEntryToHistory();
                spacerName.saveCurrentEntryToHistory();
                UIUtil.closeWindow((Window)this);
            }
        };

        public boolean getOk() {
            return this.ok;
        }

        public String getDeviceName() {
            return this.deviceName.getText();
        }

        public String getReplaceName() {
            return this.replaceName.getText();
        }

        public String getSpacerName() {
            return this.spacerName.getText();
        }

        public UserQuestionsDialog(Window owner) throws HeadlessException {
            super(owner);
        }

        protected void init() {
            this.setTitle("Device Substituition Dialog");
            this.setModal(true);
            GridBagManager l = new GridBagManager(this.getContentPane());
            l.pushFill();
            l.add("Device Name To Replace:");
            this.deviceName = new AHistoryTextField("MRU", "Decorator.replace.deviceName");
            this.deviceName.setAutoSave(true);
            l.add((Component)((Object)this.deviceName), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            l.newline();
            l.add("Template Name To Replace With:");
            this.replaceName = new AHistoryTextField("MRU", "Decorator.replace.replaceName");
            this.replaceName.setAutoSave(true);
            l.add((Component)((Object)this.replaceName), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            l.newline();
            l.add("Template Name of Spacer:");
            this.spacerName = new AHistoryTextField("MRU", "Decorator.replace.spacerName");
            this.spacerName.setAutoSave(true);
            l.add((Component)((Object)this.spacerName), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            l.newline();
            l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
            JButton btnOk = new JButton("OK");
            l.add((Component)btnOk, (GridBagConstraints)GridBagManager.RIGHT);
            btnOk.addActionListener(this.mOk);
            JButton btnClose = new JButton("Cancel");
            l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT);
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)this, (AbstractButton)btnClose, (JButton)btnOk);
            this.pack();
            this.setMinimumSize(this.getPreferredSize());
            UIUtil.center((Component)this);
            this.setVisible(true);
        }
    }
}

