/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.decorators;

import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.iov.IOViewBlock;
import com.sigrity.orbit.iov.IOViewDecorator;
import java.util.LinkedList;
import java.util.List;

public class SpecialDecorator
extends IOViewDecorator {
    protected String mType;
    protected long mSpace1;

    public void setSpace1(double space) {
        Db db = OrbitIO.getCurDb();
        Design currentDesign = Design.getDesign((Db)db);
        Unit.Distance unit = currentDesign.getUnit();
        this.mSpace1 = unit.fromUser(space);
    }

    public void setType(String type) {
        this.mType = type;
    }

    @Override
    public void decorate() {
        if (this.mType.equals("a")) {
            this.decorateA();
        }
    }

    public void decorateA() {
        long totalWidth = 0L;
        int totalIO = 0;
        for (IOViewBlock iovb : this.input) {
            totalWidth += iovb.getTemplate().getBB().width();
            ++totalIO;
        }
        int index = 0;
        while (index < totalIO) {
            IOViewBlock cover = this.addToOutput("lvcmos18_5s_right_150_fc_inst", "lvcmos18_5s_right_150_fc");
            Device d = cover.getDevicePath().getLast();
            Device interfaceDevice = cover.getDevicePath().getParent().getLast();
            PinInstance vssPin = d.getPinByName("VSS");
            String netName = interfaceDevice.getName() + "_VSS";
            NetMap.mapThroughPath((DevicePath)cover.getDevicePath(), (PinInstance)vssPin, (String)netName);
            PinInstance vddoPin = d.getPinByName("VDDO");
            netName = interfaceDevice.getName() + "_VDDO";
            NetMap.mapThroughPath((DevicePath)cover.getDevicePath(), (PinInstance)vddoPin, (String)netName);
            this.addToOutput("sp00960_272_ns_inst", "sp00960_272_ns");
            CoveredCellsStatus stats = this.inject(this.mSpace1, index);
            index += stats.num;
            int pinIndex = 1;
            for (HierPin hp : stats.ios) {
                String thisNetName = hp.getTopMostNet().getName();
                PinInstance bumpPin = d.getPinByName("S" + pinIndex);
                NetMap.mapThroughPath((DevicePath)cover.getDevicePath(), (PinInstance)bumpPin, (String)thisNetName);
                ++pinIndex;
            }
            IOViewBlock power = this.addToOutput("lvcmos18_vddo_ns_inst", "lvcmos18_vddo_ns");
            d = power.getDevicePath().getLast();
            vssPin = d.getPinByName("VSS");
            netName = interfaceDevice.getName() + "_VSS";
            NetMap.mapThroughPath((DevicePath)power.getDevicePath(), (PinInstance)vssPin, (String)netName);
            vddoPin = d.getPinByName("VDDO");
            netName = interfaceDevice.getName() + "_VDDO";
            NetMap.mapThroughPath((DevicePath)power.getDevicePath(), (PinInstance)vddoPin, (String)netName);
            this.addToOutput("sp00960_272_ns_inst", "sp00960_272_ns");
        }
    }

    protected CoveredCellsStatus inject(long needToConsume, int start) {
        Device thisInstance;
        long thisInstanceWidth;
        long iConsumed = 0L;
        int usedCount = 0;
        CoveredCellsStatus rtn = new CoveredCellsStatus();
        for (int i = start; i < this.input.size() && iConsumed + (thisInstanceWidth = Math.min((thisInstance = ((IOViewBlock)this.input.get(i)).getDevicePath().getLast()).getTemplate().getBB().width(), thisInstance.getTemplate().getBB().height())) <= needToConsume; ++i) {
            this.copyToOutput((IOViewBlock)this.input.get(i));
            List ioList = thisInstance.getTemplate().getIOPorts();
            for (PinTemplate pt : ioList) {
                HierPin hp = new HierPin(((IOViewBlock)this.input.get(i)).getDevicePath(), thisInstance.getPin(pt));
                rtn.ios.add(hp);
            }
            iConsumed += thisInstanceWidth;
            ++usedCount;
        }
        rtn.num = usedCount;
        rtn.width = iConsumed;
        return rtn;
    }

    public void decorateB() {
    }

    static class CoveredCellsStatus {
        int num;
        long width;
        LinkedList<HierPin> ios = new LinkedList();

        CoveredCellsStatus() {
        }
    }
}

