/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.eda;

import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class NetCutManager {
    private int mArity = 0;
    protected ArrayList<HierPin> dynSide = new ArrayList();
    protected ArrayList<PortsOnANet> staticSide = new ArrayList();
    protected ArrayList<DevicePath> dynamicPaths = new ArrayList();
    protected Selection.SelSet selSet = null;

    public void addDynamicForSelSet(Selection.SelSet selSet2) {
        this.selSet = selSet2;
    }

    public void addDynamicDevicePath(DevicePath dp) {
        this.dynamicPaths.add(dp);
    }

    public void deriveNetCutSet() {
        HashSet<Net> crossingNets = new HashSet<Net>();
        HashSet<Net> doesNotCrossNets = new HashSet<Net>();
        ArrayList<DevicePath> dynamicDescendents = new ArrayList<DevicePath>();
        if (this.selSet != null) {
            for (Selection.SelObj selObj : this.selSet.values()) {
                IterableIterator I1 = selObj.getPaths();
                while (I1.hasNext()) {
                    Iterator curPath = (DevicePath)I1.next();
                    if (selObj.getDbObject() instanceof PinInstance) {
                        this.processPin(crossingNets, doesNotCrossNets, dynamicDescendents, (DevicePath)curPath, (PinInstance)selObj.getDbObject());
                        continue;
                    }
                    if (!(selObj.getDbObject() instanceof Device)) continue;
                    curPath = new DevicePath((DevicePath)curPath, (Device)selObj.getDbObject());
                    this.dynamicPaths.add((DevicePath)curPath);
                    for (DevicePath dpDescendent : curPath.getDescendants()) {
                        dynamicDescendents.add(dpDescendent);
                    }
                }
            }
        } else {
            for (DevicePath dpDynamicParent : this.dynamicPaths) {
                for (DevicePath dpDescendent : dpDynamicParent.getDescendants()) {
                    dynamicDescendents.add(dpDescendent);
                }
            }
        }
        for (DevicePath dpDescendent : dynamicDescendents) {
            Device dDynamic = dpDescendent.getLast();
            for (PinInstance dp : dDynamic.getPins()) {
                this.processPin(crossingNets, doesNotCrossNets, dynamicDescendents, dpDescendent, dp);
            }
        }
    }

    private void processPin(HashSet<Net> crossingNets, HashSet<Net> doesNotCrossNets, ArrayList<DevicePath> dynamicDescendents, DevicePath dpDescendent, PinInstance dp) {
        boolean foundOnStaticSide = false;
        HierPin dpp = new HierPin(dpDescendent, dp);
        Net topNet = dpp.getTopMostNet();
        if (topNet.isUnused()) {
            return;
        }
        if (!doesNotCrossNets.contains(topNet) && !crossingNets.contains(topNet)) {
            int staticIndex = 0;
            List connectedPorts = NetMap.getConnectedDevicePathPorts((Net)dpp.getNet(), (DevicePath)dpDescendent);
            for (HierPin candidateDevicePathPort : connectedPorts) {
                if (dynamicDescendents.contains(candidateDevicePathPort.getPath()) || candidateDevicePathPort.getPath().equals((Object)dpDescendent) || candidateDevicePathPort.getPin().getType() == PinTemplate.Type.WIREEND || candidateDevicePathPort.getPinTemplate().getIsVirtual()) continue;
                if (!foundOnStaticSide) {
                    staticIndex = this.addDynSide(dpp);
                }
                this.addStaticSide(candidateDevicePathPort, staticIndex);
                foundOnStaticSide = true;
            }
            if (foundOnStaticSide) {
                crossingNets.add(topNet);
            } else {
                doesNotCrossNets.add(topNet);
            }
        }
    }

    public ArrayList<Connection> getClosestConnectionSet(APoint2D offset) {
        int size = this.mArity;
        ArrayList<Connection> connList = new ArrayList<Connection>();
        for (int i = 0; i < size; ++i) {
            Connection c = new Connection(this.getIthDynamic(i), this.closestStatic(offset, i), true);
            connList.add(c);
        }
        return connList;
    }

    protected int addDynSide(HierPin dPort) {
        this.dynSide.add(this.mArity, dPort);
        this.staticSide.add(new PortsOnANet());
        ++this.mArity;
        return this.mArity - 1;
    }

    protected int size() {
        return this.mArity;
    }

    protected void addStaticSide(HierPin sPort, int staticIndex) {
        ArrayList<HierPin> points = this.staticSide.get((int)staticIndex).dpps;
        points.add(sPort);
    }

    protected HierPin getIthDynamic(int ith) {
        return this.dynSide.get(ith);
    }

    protected HierPin closestStatic(APoint2D offset, int ith) {
        APoint2D dynXY = new APoint2D();
        dynXY.setLoc(this.dynSide.get(ith).getWorldLoc());
        if (offset != null) {
            dynXY = dynXY.add(offset);
        }
        ArrayList<HierPin> sPorts = this.staticSide.get((int)ith).dpps;
        int candidates = sPorts.size();
        boolean foundOne = false;
        int bestIndex = 0;
        long bestDist = 0L;
        for (int i = 0; i < candidates; ++i) {
            long dist = dynXY.distance(sPorts.get(i).getWorldLoc());
            if (i != 0 && Math.abs(dist) >= bestDist) continue;
            bestDist = Math.abs(dist);
            bestIndex = i;
            foundOne = true;
        }
        if (foundOne) {
            return sPorts.get(bestIndex);
        }
        return null;
    }

    public static ArrayList<Connection> deriveClosestConnectionsSet(DevicePath dp) {
        NetCutManager ncs = new NetCutManager();
        ncs.addDynamicDevicePath(dp);
        ncs.deriveNetCutSet();
        return ncs.getClosestConnectionSet(null);
    }

    protected static class PortsOnANet {
        ArrayList<HierPin> dpps = new ArrayList();

        protected PortsOnANet() {
        }
    }
}

