/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.flowman;

import com.sigrity.acl.ALog;
import com.sigrity.flowman.Flow;
import com.sigrity.flowman.FlowStep;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import org.w3c.dom.Element;

public abstract class AbstractFlowStep
extends AbstractAction
implements FlowStep {
    public static final String XATR_DESC = "desc";
    public static final String XATR_HELP = "help";
    protected Flow mFlow = null;
    protected static Map<String, String> sAttributeMap = AbstractFlowStep.getAttributeMap();

    public AbstractFlowStep() {
    }

    public AbstractFlowStep(Flow toFlow, AbstractFlowStep src) {
        this.mFlow = toFlow;
        Object[] keys = src.getKeys();
        if (keys != null) {
            for (Object key : keys) {
                if (!(key instanceof String)) {
                    ALog.logError((String)"Non-string (%s) key found in FlowStep.", (Object[])new Object[]{key == null ? "null" : key.getClass().getName()});
                    assert (false);
                    continue;
                }
                this.putValue((String)key, src.getValue((String)key));
            }
        }
    }

    @Override
    public void setFlow(Flow flow) {
        this.mFlow = flow;
    }

    @Override
    public Flow getFlow() {
        return this.mFlow;
    }

    @Override
    public String getName() {
        return (String)this.getValue("Name");
    }

    @Override
    public String getDesc() {
        return (String)this.getValue("ShortDescription");
    }

    @Override
    public String getHelp() {
        return (String)this.getValue("LongDescription");
    }

    private static Map<String, String> getAttributeMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("Name", "name");
        map.put("ShortDescription", XATR_DESC);
        map.put("LongDescription", XATR_HELP);
        return map;
    }

    protected boolean saveValueIfSet(String actionKey, Element xElement, String xAttr) {
        Object o = this.getValue(actionKey);
        if (o == null) {
            return true;
        }
        if (o instanceof String) {
            xElement.setAttribute(xAttr, (String)o);
            return true;
        }
        ALog.logError((Throwable)new Exception("Invalid value."), (String)"Invalid value type while saving flow step.", (Object[])new Object[0]);
        assert (false);
        return false;
    }

    protected boolean loadValueIfFound(String actionKey, Element xElement, String xAttr) {
        String val = xElement.getAttribute(xAttr);
        if (val != null) {
            this.putValue(actionKey, val);
        }
        return true;
    }

    @Override
    public boolean read(Element xe) {
        if (xe == null) {
            ALog.logError((String)"Invalid flow definition.");
            return false;
        }
        for (Map.Entry<String, String> ent : sAttributeMap.entrySet()) {
            if (this.loadValueIfFound(ent.getKey(), xe, ent.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean write(Element xe) {
        xe.setAttribute("type", this.getClass().getName());
        for (Map.Entry<String, String> ent : sAttributeMap.entrySet()) {
            if (this.saveValueIfSet(ent.getKey(), xe, ent.getValue())) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        StringBuilder props = new StringBuilder();
        Object[] keys = this.getKeys();
        if (keys != null) {
            for (Object key : this.getKeys()) {
                String sep = "";
                if (props.length() > 0) {
                    sep = ", ";
                }
                props.append(String.format("%s%s: %s", sep, key, this.getValue("" + key)));
            }
        }
        return String.format("%s[%s]", this.getClass().getName(), props);
    }

    public void setSmallIcon(Icon icon) {
        this.putValue("SmallIcon", icon);
    }

    public Icon getSmallIcon() {
        return (Icon)this.getValue("SmallIcon");
    }
}

