/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.flowman;

import bsh.EvalError;
import bsh.Interpreter;
import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.xml.AXDomUtil;
import com.sigrity.flowman.FlowStep;
import com.sigrity.flowman.step.Group;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Flow
extends Group {
    public static final String XATR_ENTRY = "entry";
    public static final String XTAG_SCRIPTLIBRARY = "scriptLibrary";
    public static final String XTAG_PREREQ = "prereq";
    public static final String XTAG_SCRIPT = "script";
    public static final String FLOW_FILE_EXT = "flow";
    public static final String FLOW_FILE_DESC = "Flow definition file";
    public static final AFileFilter FILEFILTER_FLOWDEF;
    public static boolean DEBUG;
    protected URL mSource = null;
    protected Interpreter mInterpreter = null;
    protected LinkedHashMap<String, FlowStep> mName2FlowStep = new LinkedHashMap();
    protected String mEntryPath = null;
    protected String mLibraryScript = "";
    protected String mPrereqScript = "";
    protected boolean mDirty;
    private static LinkedHashSet<FlowListener> sListeners;

    public static Flow readFlow(URL url) {
        Flow flow = new Flow();
        if (!flow.read(url)) {
            return null;
        }
        return flow;
    }

    public static FlowStep readStep(Flow flow, Element elStep) {
        Class<?> cls;
        String name = elStep.getAttribute("name");
        if (name == null) {
            ALog.logError((String)"Flow step definition contains no '%s', it is being ignored:\n%s", (Object[])new Object[]{"name", elStep.toString()});
            return null;
        }
        String type = elStep.getAttribute("type");
        if (type == null) {
            ALog.logError((String)"Flow step '%s' definition contains no '%s', it is being ignored.", (Object[])new Object[]{name, "type"});
            return null;
        }
        try {
            cls = Class.forName(type);
        }
        catch (ClassNotFoundException e) {
            ALog.logError((Throwable)e, (String)"The class '%s' specified for FlowStep '%s' could not be found.", (Object[])new Object[]{type, name});
            return null;
        }
        if (!FlowStep.class.isAssignableFrom(cls)) {
            ALog.logError((String)"Flow step definition '%s' is invalid, '%s' does not implement the interface '%s'.", (Object[])new Object[]{name, cls.getName(), FlowStep.class.getName()});
            return null;
        }
        FlowStep step = null;
        try {
            step = (FlowStep)cls.newInstance();
        }
        catch (Exception e) {
            ALog.logError((Throwable)e, (String)"Unable to instantiate '%s' for flow step '%s'.", (Object[])new Object[]{cls.getName(), name});
            return null;
        }
        if (flow != null) {
            step.setFlow(flow);
        }
        if (!step.read(elStep)) {
            ALog.logError((String)"Error reading flow step '%s'.", (Object[])new Object[]{name});
            return null;
        }
        return step;
    }

    public Flow() {
        this.mFlow = this;
    }

    public String getEntryPath() {
        return this.mEntryPath;
    }

    public boolean read(URL url) {
        this.mSource = url;
        Element elDoc = AXDomUtil.getDocumentElement((URL)url);
        return this.read(elDoc);
    }

    public boolean canWrite(URL location) {
        if (location == null && this.mSource != null) {
            location = this.mSource;
        }
        if (location == null) {
            return false;
        }
        if (location.getProtocol().equalsIgnoreCase("file")) {
            String loc = location.getFile();
            try {
                loc = URLDecoder.decode(loc, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            File f = new File(loc);
            return f.canWrite();
        }
        try {
            URLConnection connection = location.openConnection();
            connection.setDoOutput(true);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean write(URL location) {
        boolean bl;
        block14: {
            if (location == null && this.mSource != null) {
                location = this.mSource;
            }
            if (location == null) {
                ALog.logError((String)"No write target location specified.");
                return false;
            }
            Element xeDoc = AXDomUtil.createXmlDoc((String)FLOW_FILE_EXT);
            if (!super.write(xeDoc)) {
                return false;
            }
            if (this.mLibraryScript.length() > 0) {
                Element xe = AXDomUtil.addElement((Element)xeDoc, (String)XTAG_SCRIPTLIBRARY);
                CDATASection cdata = xeDoc.getOwnerDocument().createCDATASection(this.mLibraryScript);
                xe.appendChild(cdata);
            }
            if (this.mPrereqScript.length() > 0) {
                Element xep = AXDomUtil.addElement((Element)xeDoc, (String)XTAG_PREREQ);
                Element xes = AXDomUtil.addElement((Element)xep, (String)XTAG_SCRIPT);
                CDATASection cdata = xeDoc.getOwnerDocument().createCDATASection(this.mPrereqScript);
                xes.appendChild(cdata);
            }
            OutputStream os = this.getOutputStream(location);
            try {
                boolean result = AXDomUtil.serialize((Node)xeDoc, (OutputStream)os);
                if (result) {
                    this.mSource = location;
                    this.setDirty(false);
                }
                bl = result;
                if (os == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    ALog.logError((Throwable)e, (String)"Unable to write to '%s'.", (Object[])new Object[]{location.toExternalForm()});
                    return false;
                }
            }
            os.close();
        }
        return bl;
    }

    private OutputStream getOutputStream(URL location) throws IOException {
        OutputStream os;
        if (location.getProtocol().equalsIgnoreCase("file")) {
            String loc = location.getFile();
            loc = URLDecoder.decode(loc, "UTF-8");
            File f = new File(loc);
            os = new FileOutputStream(f);
        } else {
            URLConnection connection = location.openConnection();
            connection.setDoOutput(true);
            os = connection.getOutputStream();
        }
        return os;
    }

    public URL getSource() {
        return this.mSource;
    }

    public void evalLibraryScript() {
        if (this.mLibraryScript.length() > 0) {
            try {
                this.evalThrowError(this.mLibraryScript);
            }
            catch (Exception e) {
                ALog.logError((Throwable)e, (String)"Error evaluating library script for '%s'.", (Object[])new Object[]{this});
            }
        }
    }

    @Override
    public boolean read(Element xe) {
        if (!super.read(xe)) {
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Element elLib : AXDomUtil.getChildElems((Node)xe, (String)XTAG_SCRIPTLIBRARY)) {
            stringBuilder.append(elLib.getTextContent());
        }
        this.mLibraryScript = this.mLibraryScript + stringBuilder.toString();
        this.evalLibraryScript();
        for (Element elPreReq : AXDomUtil.getChildElems((Node)xe, (String)XTAG_PREREQ)) {
            if (this.processPreReq(elPreReq)) continue;
            ALog.logError((String)"Prerequisite processing failed, cannot load flow.");
            return false;
        }
        this.mEntryPath = xe.getAttribute(XATR_ENTRY);
        for (Element elStep : AXDomUtil.getChildElems((Node)xe, (String)"step")) {
            FlowStep step = Flow.readStep(this, elStep);
            if (step == null) continue;
            String name = step.getName();
            this.mName2FlowStep.put(name, step);
        }
        return true;
    }

    public void setLibraryScript(String s) {
        this.mLibraryScript = s;
    }

    public String getLibraryScript() {
        return this.mLibraryScript;
    }

    public void setPrereqScript(String s) {
        this.mPrereqScript = s;
    }

    public String getPrereqScript() {
        return this.mPrereqScript;
    }

    protected boolean processPreReq(Element xe) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Element xeScript : AXDomUtil.getChildElems((Node)xe, (String)XTAG_SCRIPT)) {
            stringBuilder.append(xeScript.getTextContent());
        }
        this.mPrereqScript = this.mPrereqScript + stringBuilder.toString();
        Object result = this.eval(this.mPrereqScript);
        if (result != null && Boolean.class.isAssignableFrom(result.getClass())) {
            return (Boolean)result;
        }
        ALog.logError((String)"Failed to process prequisite:\n%s", (Object[])new Object[]{this.mPrereqScript});
        return false;
    }

    public Object invoke(FlowStep step) {
        if (!step.isEnabled()) {
            ALog.logWarn((String)"The step not currently enabled, it is not being invoked.");
            return null;
        }
        Cp.getCp().setInterpreterValue("Flow", (Object)this);
        step.actionPerformed(new FlowStepInvokeActionEvent());
        Cp.getCp().unsetInterpreterValue("Flow");
        return step.getResult();
    }

    public Object evalThrowError(String script) throws EvalError {
        if (this.mInterpreter == null) {
            Cp cp = Cp.getCp();
            if (cp != null) {
                this.mInterpreter = cp.createChildInterpreter();
            }
            if (this.mInterpreter == null) {
                this.mInterpreter = new Interpreter();
            }
        }
        return this.mInterpreter.eval(script);
    }

    public Object eval(String script) {
        try {
            return this.evalThrowError(script);
        }
        catch (EvalError e) {
            ALog.logError((Throwable)e, (String)e.getMessage(), (Object[])new Object[0]);
            return null;
        }
    }

    public void setDirty(boolean b) {
        boolean changed = this.mDirty != b;
        this.mDirty = b;
        if (changed) {
            Flow.fireFlowDirtyChanged(this);
        }
    }

    public boolean getDirty() {
        return this.mDirty;
    }

    @Override
    public String toString() {
        return String.format("Flow '%s' (%s)", this.getName(), this.getSource());
    }

    public static void addFlowListener(FlowListener l) {
        sListeners.add(l);
    }

    public static void fireFlowDirtyChanged(Flow f) {
        for (FlowListener l : sListeners) {
            l.dirtyChanged(f);
        }
    }

    static {
        Cp.getCp().eval("import com.sigrity.acl.*;");
        FILEFILTER_FLOWDEF = new AFileFilter(FLOW_FILE_EXT, FLOW_FILE_DESC);
        DEBUG = false;
        sListeners = new LinkedHashSet();
    }

    public static interface FlowListener {
        public void dirtyChanged(Flow var1);
    }

    public class FlowStepInvokeActionEvent
    extends ActionEvent {
        public FlowStepInvokeActionEvent() {
            super(Flow.this, 0, "Invoke");
        }
    }
}

