/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.flowman;

import com.sigrity.acl.AEmptyItr;
import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.IterableIterator;
import com.sigrity.flowman.FlowStep;
import com.sigrity.flowman.ui.FMUtil;
import java.util.HashMap;

public class FlowStepRegistry {
    protected static FlowStepRegistry sRegistry = new FlowStepRegistry();
    public static final String ACTIONPROPKEY_REGNAME = FlowStepRegistry.class.getName() + ".name";
    public static final String ACTIONPROPKEY_REGGRP = FlowStepRegistry.class.getName() + ".group";
    protected HashMap<String, Group> mGroups = new HashMap();

    public static FlowStep registerStep(String group, String name, FlowStep step) {
        return sRegistry.put(group, name, step);
    }

    public static FlowStep unregisterStep(String group, String name) {
        return sRegistry.remove(group, name);
    }

    public static IterableIterator<String> getGroups() {
        return sRegistry.groupNames();
    }

    public static IterableIterator<FlowStep> getSteps(String group) {
        return sRegistry.steps(group);
    }

    public static String getRegisteredName(FlowStep step) {
        Object o = step.getValue(ACTIONPROPKEY_REGNAME);
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        return o.toString();
    }

    public static String getShortGroupName(String groupName) {
        int i = groupName.lastIndexOf(46);
        if (i < 0 || i >= groupName.length() - 1) {
            return groupName;
        }
        return groupName.substring(i + 1);
    }

    public FlowStep put(String group, String name, FlowStep step) {
        step.putValue(ACTIONPROPKEY_REGNAME, name);
        step.putValue(ACTIONPROPKEY_REGGRP, group);
        Group g = this.getGroup(group, true);
        return g.put(name, step);
    }

    public FlowStep get(String group, String name) {
        Group g = this.getGroup(group, false);
        if (g == null) {
            return null;
        }
        return (FlowStep)g.get(name);
    }

    public FlowStep remove(String group, String name) {
        Group g = this.getGroup(group, false);
        if (g == null) {
            return null;
        }
        FlowStep step = (FlowStep)g.remove(name);
        if (step != null) {
            step.putValue(ACTIONPROPKEY_REGNAME, null);
            step.putValue(ACTIONPROPKEY_REGGRP, null);
        }
        return step;
    }

    public IterableIterator<String> groupNames() {
        return new AIterableItr(this.mGroups.keySet());
    }

    public IterableIterator<Group> groups() {
        return new AIterableItr(this.mGroups.values());
    }

    public IterableIterator<String> stepNames(String group) {
        Group g = this.getGroup(group, false);
        if (g == null) {
            return AEmptyItr.create();
        }
        return new AIterableItr(g.keySet());
    }

    public IterableIterator<FlowStep> steps(String group) {
        Group g = this.getGroup(group, false);
        if (g == null) {
            return AEmptyItr.create();
        }
        return new AIterableItr(g.values());
    }

    protected Group getGroup(String group, boolean create) {
        Group g = this.mGroups.get(group);
        if (g == null && create) {
            g = new Group();
            this.mGroups.put(group, g);
        }
        return g;
    }

    static {
        FMUtil.registerStandardSteps();
    }

    protected static class Group
    extends HashMap<String, FlowStep> {
        protected Group() {
        }
    }
}

