/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.flowman;

import com.google.common.collect.Lists;
import com.sigrity.acl.ALog;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.flowman.Flow;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.filechooser.FileFilter;

public class FlowWS {
    private static final String DEFAULT_FLOW_NAME = "GeneralFlow.flow";
    public static final File DEFAULT_FLOW_FILE = Settings.findExampleFile((String)"GeneralFlow.flow");
    protected static final int MAX_RECENT_FLOWS = 16;
    protected static LinkedList<String> sRecentFlows = new LinkedList();
    private final OrbitGuiWS mGuiWS;
    private Action mOpenFlow = new AbstractAction("Open Flow..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            AFileChooser fc = new AFileChooser();
            fc.setFileFilter((FileFilter)Flow.FILEFILTER_FLOWDEF);
            if (fc.showOpenDialog((Component)FlowWS.this.mGuiWS.getMainFrame()) != 0) {
                return;
            }
            File f = fc.getSelectedFile();
            URI uri = f.toURI();
            try {
                URL url = uri.toURL();
                FlowWS.this.openFlow(url);
            }
            catch (MalformedURLException e1) {
                ALog.logError((Throwable)e1, (String)"Error reading flow definition '%s'.", (Object[])new Object[]{uri.toASCIIString()});
            }
        }
    };

    public static void addRecentFlow(String url) {
        sRecentFlows.remove(url);
        sRecentFlows.push(url);
        while (sRecentFlows.size() > 16) {
            sRecentFlows.removeLast();
        }
        FlowWS.saveRecentFlowList();
    }

    public static void removeRecentFlow(String url) {
        sRecentFlows.remove(url);
    }

    public static void restoreSettings() {
        String flowPath;
        sRecentFlows.clear();
        Settings mruFlowSettings = Settings.getSettings((String)"MRUFlows");
        int i = 0;
        while ((flowPath = (String)mruFlowSettings.getSettingOfClass("File" + i, String.class)) != null) {
            sRecentFlows.add(flowPath);
            ++i;
        }
    }

    public static void saveRecentFlowList(List<Flow> flows) {
        sRecentFlows.clear();
        for (Flow f : flows) {
            if (f.getSource() == null) continue;
            try {
                sRecentFlows.add(f.getSource().toURI().toURL().toString());
            }
            catch (MalformedURLException | URISyntaxException e) {
                ALog.logWarn((Throwable)e, (String)"Fail saving flow %s", (Object[])new Object[]{f});
            }
        }
        FlowWS.saveRecentFlowList();
    }

    public static void saveRecentFlowList() {
        String defaultFlow = null;
        try {
            defaultFlow = DEFAULT_FLOW_FILE.toURI().toURL().toString();
        }
        catch (MalformedURLException e) {
            ALog.logError((String)"Fail: save flow list");
        }
        Settings s = Settings.getSettings((String)"MRUFlows");
        s.removeAll(Settings.Type.User);
        int valid = 0;
        for (int i = 0; i < sRecentFlows.size(); ++i) {
            String url = sRecentFlows.get(i);
            if (url.equals(defaultFlow)) continue;
            s.putSetting("File" + valid, (Object)url);
            ++valid;
        }
        s.save();
    }

    public FlowWS(OrbitGuiWS guiWS) {
        this.mGuiWS = guiWS;
    }

    public boolean openFlow(File file) {
        URI uri = file.toURI();
        try {
            URL url = uri.toURL();
            return this.openFlow(url);
        }
        catch (MalformedURLException e1) {
            ALog.logError((Throwable)e1, (String)"Error reading flow definition '%s'.", (Object[])new Object[]{uri.toASCIIString()});
            return false;
        }
    }

    public boolean openFlow(URL url) {
        Flow flow = Flow.readFlow(url);
        if (flow == null) {
            sRecentFlows.remove(url.toExternalForm());
            return false;
        }
        if (!this.mGuiWS.getFlowManVisible()) {
            this.mGuiWS.setFlowManVisible(true);
        }
        if (this.mGuiWS.getFlowManPanel().showFlow(flow)) {
            FlowWS.addRecentFlow(url.toExternalForm());
        }
        return true;
    }

    public void initFlowManager() {
        String flowPath;
        List<String> openedFlow = new ArrayList<String>();
        Settings mruFlowManagerSettings = Settings.getSettings((String)"MRUFlows");
        int i = 0;
        while ((flowPath = (String)mruFlowManagerSettings.getSettingOfClass("File" + i, String.class)) != null) {
            openedFlow.add(flowPath);
            ++i;
        }
        if (DEFAULT_FLOW_FILE != null) {
            try {
                String path = DEFAULT_FLOW_FILE.toURI().toURL().toString();
                if (!openedFlow.contains(path)) {
                    openedFlow.add(path);
                }
            }
            catch (MalformedURLException e1) {
                ALog.logWarn((String)"Cannot open default flow file '%s'", (Object[])new Object[]{DEFAULT_FLOW_NAME});
            }
        }
        if (openedFlow.isEmpty()) {
            if (!this.mGuiWS.getFlowManVisible()) {
                this.mGuiWS.setFlowManVisible(true);
            }
            return;
        }
        openedFlow = Lists.reverse(openedFlow);
        ALog.logDebug((String)"Initializing flow manager.");
        openedFlow.forEach(flowFile -> {
            try {
                this.openFlow(new URL((String)flowFile));
            }
            catch (MalformedURLException e1) {
                ALog.logError((Throwable)e1, (String)"Error reading flow definition '%s'.", (Object[])new Object[]{flowFile});
            }
        });
    }

    public void updateRecentFlows(JMenu jmenu, String hint) {
        if ("prepareContents".equals(hint)) {
            jmenu.removeAll();
            for (int i = 0; i < sRecentFlows.size(); ++i) {
                String label = Integer.toHexString(i + 1).toUpperCase() + ":";
                JMenuItem mi = jmenu.add(new OpenFlowAction(label, sRecentFlows.get(i)));
                UIUtil.setUniqueMnemonic((JMenu)jmenu, (AbstractButton)mi);
            }
        } else if ("prepareItem".equals(hint)) {
            jmenu.setEnabled(!sRecentFlows.isEmpty());
        }
    }

    public Action getActionOpenFlow() {
        return this.mOpenFlow;
    }

    protected class OpenFlowAction
    extends AbstractAction {
        protected String mFlowUrl;

        public OpenFlowAction(String prefix, String flowUrl) {
            this.mFlowUrl = flowUrl;
            String name = prefix + " " + flowUrl;
            this.putValue("Name", name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                FlowWS.this.openFlow(new URL(this.mFlowUrl));
            }
            catch (MalformedURLException e1) {
                ALog.logError((Throwable)e1, (String)"The url '%s' is invalid.", (Object[])new Object[]{this.mFlowUrl});
                sRecentFlows.remove(this.mFlowUrl);
            }
        }
    }
}

