/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.flowman;

import bsh.EvalError;
import com.sigrity.acl.ALog;
import com.sigrity.acl.app.AApp;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.ui.AFloatWindow;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.xml.AXDomUtil;
import com.sigrity.flowman.AbstractFlowStep;
import com.sigrity.flowman.Flow;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Date;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ScriptedFlowStep
extends AbstractFlowStep {
    public static final String XELEM_SCRIPT = "script";
    public static final String XELEM_ENABLED = "enabled";
    protected String mScript = null;
    protected String mEnabledScript = null;
    protected Date mLastPerformed = null;
    protected Object mLastResult = null;

    public ScriptedFlowStep() {
    }

    public ScriptedFlowStep(Flow toFlow, ScriptedFlowStep src) {
        super(toFlow, src);
        this.mScript = src.mScript;
    }

    public String getScript() {
        return this.mScript == null ? "" : this.mScript;
    }

    public void setScript(String script) {
        this.mScript = script;
    }

    public String getEnabledScript() {
        return this.mEnabledScript == null ? "" : this.mEnabledScript;
    }

    public void setEnabledScript(String script) {
        this.mEnabledScript = script;
    }

    protected Object evalThrowError(String s) throws EvalError {
        if (this.mFlow != null) {
            return this.mFlow.evalThrowError(s);
        }
        return Cp.getCp().evalThrowError(s);
    }

    protected Object eval(String s) {
        if (this.mFlow != null) {
            return this.mFlow.eval(s);
        }
        return Cp.getCp().eval(s);
    }

    @Override
    public ScriptedFlowStep copy(Flow toFlow) {
        return new ScriptedFlowStep(toFlow, this);
    }

    @Override
    public boolean read(Element xe) {
        if (!super.read(xe)) {
            return false;
        }
        if (AXDomUtil.getChildElems((Node)xe).hasNext()) {
            Element xeScript = AXDomUtil.getNamedElement((Element)xe, (String)XELEM_SCRIPT);
            if (xeScript == null) {
                ALog.logWarn((String)"No script is defined for the flow step '%s':\n%s", (Object[])new Object[]{this.getName()});
            } else {
                this.mScript = xeScript.getTextContent();
            }
            Element xeEnabled = AXDomUtil.getNamedElement((Element)xe, (String)XELEM_ENABLED);
            if (xeEnabled != null) {
                this.mEnabledScript = xeEnabled.getTextContent();
            }
        } else {
            this.mScript = xe.getTextContent();
        }
        return true;
    }

    @Override
    public boolean write(Element xe) {
        if (!super.write(xe)) {
            return false;
        }
        Element xeScript = AXDomUtil.addElement((Element)xe, (String)XELEM_SCRIPT);
        CDATASection cdataScript = xe.getOwnerDocument().createCDATASection(this.mScript);
        xeScript.appendChild(cdataScript);
        if (this.getEnabledScript().length() > 0) {
            Element xeEnabledScript = AXDomUtil.addElement((Element)xe, (String)XELEM_ENABLED);
            CDATASection cdataEnabledScript = xe.getOwnerDocument().createCDATASection(this.mEnabledScript);
            xeEnabledScript.appendChild(cdataEnabledScript);
        }
        return true;
    }

    @Override
    public boolean hasAction() {
        return this.mScript != null;
    }

    @Override
    public boolean isEnabled() {
        if (this.mEnabledScript == null || this.mEnabledScript.trim().length() == 0) {
            return true;
        }
        try {
            Object o = this.evalThrowError(this.mEnabledScript);
            if (o instanceof Boolean) {
                return (Boolean)o;
            }
        }
        catch (EvalError e1) {
            EvalError ee = e1;
            EventQueue.invokeLater(() -> ALog.logError((Throwable)ee, (String)"An error occurred during evaluation of the 'enabled' script associated with the flow step '%s':\n%s", (Object[])new Object[]{this.getName(), this.mScript}));
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.mScript != null) {
            Window owner = null;
            AApp app = AApp.getApp();
            if (app != null) {
                owner = app.getMainWin();
            }
            ScriptRunner sr = new ScriptRunner(owner);
            sr.run();
        }
        this.mLastPerformed = new Date();
    }

    @Override
    public float getComplete() {
        return this.mLastPerformed == null ? 0.0f : 1.0f;
    }

    @Override
    public void resetState() {
        this.mLastPerformed = null;
    }

    @Override
    public Object getResult() {
        return this.mLastResult;
    }

    protected class ScriptRunner
    extends AFloatWindow {
        protected Thread mThread;
        protected Runnable mTask;

        public ScriptRunner(Window owner) {
            super(owner);
            this.mThread = null;
            this.mTask = () -> {
                try {
                    ScriptedFlowStep.this.mLastResult = ScriptedFlowStep.this.evalThrowError(ScriptedFlowStep.this.mScript);
                }
                catch (EvalError e1) {
                    ScriptedFlowStep.this.mLastResult = null;
                    ALog.logError((Throwable)e1, (String)"An error occurred during evaluation of the script associated with the flow step '%s':\n%s", (Object[])new Object[]{this.getName(), ScriptedFlowStep.this.mScript});
                }
                finally {
                    EventQueue.invokeLater(() -> UIUtil.closeWindow((Window)((Object)this)));
                }
            };
            this.setPinnable(false);
            this.setPinned(true);
            this.setUndecorated(true);
            this.setModalityType(Dialog.ModalityType.MODELESS);
            this.setRecallBounds(false);
            this.getRootPane().getActionMap().remove("CloseDialogAction");
            GridBagManager l = GridBagManager.layout((Container)this.getContentPane());
            String name = ScriptedFlowStep.this.getDesc();
            if (name == null || name.length() == 0) {
                name = "Step";
            }
            l.add(String.format("Flow step '%s' in progress...", name));
            this.pack();
            UIUtil.center((Component)((Object)this));
        }

        public void run() {
            this.setVisible(true);
            EventQueue.invokeLater(this.mTask);
        }
    }
}

