/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.flowman.step;

import bsh.EvalError;
import com.sigrity.acl.AColor;
import com.sigrity.acl.ALog;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.ADecoratedIcon;
import com.sigrity.acl.xml.AXDomUtil;
import com.sigrity.flowman.AbstractActionBasedStep;
import com.sigrity.flowman.Flow;
import java.awt.Color;
import javax.swing.Action;
import javax.swing.Icon;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;

public class ActionBasedStep
extends AbstractActionBasedStep {
    public static final String XELEM_GETACTION = "GetAction";
    protected boolean mDebug = Flow.DEBUG;
    protected String mGetActionScript = null;
    protected Action mAction = null;

    public ActionBasedStep() {
        this.initIcon();
    }

    public ActionBasedStep(String name) {
        this();
        this.putValue("Name", name);
    }

    public ActionBasedStep(Flow flow, ActionBasedStep src) {
        super(flow, src);
        this.mGetActionScript = src.mGetActionScript;
        this.initIcon();
    }

    private void initIcon() {
        AColorIcon a = new AColorIcon(16, 16, AColor.CLEAR, AColor.CLEAR);
        AColorIcon b = new AColorIcon(12, 12, AColor.CLEAR, Color.GRAY);
        this.setSmallIcon((Icon)new ADecoratedIcon((Icon)a, (Icon)b, ADecoratedIcon.POSX.CENTER, ADecoratedIcon.POSY.CENTER));
    }

    @Override
    public ActionBasedStep copy(Flow toFlow) {
        return new ActionBasedStep(toFlow, this);
    }

    @Override
    public boolean read(Element xe) {
        if (!super.read(xe)) {
            return false;
        }
        Element xeGetAction = AXDomUtil.getNamedElement((Element)xe, (String)XELEM_GETACTION);
        if (xeGetAction == null) {
            ALog.logError((String)"Unable to read 'ActionBased' flow step as there is no '%s' element.", (Object[])new Object[]{XELEM_GETACTION});
            return false;
        }
        this.mGetActionScript = xeGetAction.getTextContent();
        return true;
    }

    @Override
    public boolean write(Element xe) {
        if (!super.write(xe)) {
            return false;
        }
        Element xeGetAction = AXDomUtil.addElement((Element)xe, (String)XELEM_GETACTION);
        CDATASection cdata = xe.getOwnerDocument().createCDATASection(this.mGetActionScript);
        xeGetAction.appendChild(cdata);
        return true;
    }

    @Override
    public Action getBaseAction() {
        if (this.mAction == null) {
            try {
                Object o = Cp.getCp().evalThrowError(this.mGetActionScript);
                if (o instanceof Action) {
                    this.mAction = (Action)o;
                } else {
                    String returnedType = o == null ? "null" : o.getClass().getName();
                    ALog.logError((String)"The script provided to retrieve the Action for an ActionBasedStep did not return an Action object, it returned '%s':\n%s", (Object[])new Object[]{returnedType, this.mGetActionScript});
                }
            }
            catch (EvalError e1) {
                ALog.log((ALog.ALogLevel)(this.mDebug ? ALog.LVL_ERR : ALog.LVL_DEBUG), (Throwable)e1, (String)"An error occurred during evaluation of an action retrieval script for an ActionBasedStep:\n%s", (Object[])new Object[]{this.mGetActionScript});
            }
        }
        return this.mAction;
    }

    public void setGetActionScript(String script) {
        this.mGetActionScript = script;
    }
}

