/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.flowman.step;

import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.xml.AXDomUtil;
import com.sigrity.flowman.AbstractFlowStep;
import com.sigrity.flowman.Flow;
import com.sigrity.flowman.FlowIcons;
import com.sigrity.flowman.FlowStep;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Group
extends AbstractFlowStep {
    public static final String XATR_GROUPTYPE = "groupType";
    protected ArrayList<FlowStep> mSteps = new ArrayList();

    public Group() {
        this.setSmallIcon(FlowIcons.GROUP);
    }

    public Group(Flow flow, Group src) {
        super(flow, src);
        for (FlowStep step : src.mSteps) {
            this.mSteps.add(step.copy(this.mFlow));
        }
        this.setSmallIcon(FlowIcons.GROUP);
    }

    @Override
    public Group copy(Flow toFlow) {
        return new Group(toFlow, this);
    }

    @Override
    public boolean read(Element xe) {
        if (!super.read(xe)) {
            return false;
        }
        for (Element xeChoice : AXDomUtil.getChildElems((Node)xe, (String)"step")) {
            FlowStep step = Flow.readStep(this.mFlow, xeChoice);
            if (step == null) continue;
            this.mSteps.add(step);
        }
        return true;
    }

    @Override
    public boolean write(Element xe) {
        if (!super.write(xe)) {
            return false;
        }
        for (FlowStep step : this.getSteps()) {
            if (step.write(AXDomUtil.addElement((Element)xe, (String)"step"))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasAction() {
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    @Override
    public float getComplete() {
        float done = 0.0f;
        for (FlowStep s : this.mSteps) {
            done = Math.max(done, s.getComplete());
        }
        return done;
    }

    @Override
    public void resetState() {
        for (FlowStep s : this.mSteps) {
            s.resetState();
        }
    }

    @Override
    public Object getResult() {
        LinkedList<Object> results = new LinkedList<Object>();
        for (FlowStep s : this.mSteps) {
            if (!((double)s.getComplete() >= 1.0)) continue;
            results.add(s.getResult());
        }
        return results;
    }

    public IterableIterator<FlowStep> getSteps() {
        return AIterableItr.itr(this.mSteps);
    }

    public void addChildStep(int index, FlowStep step) {
        this.mSteps.add(index, step);
    }

    public FlowStep removeChildStep(int index) {
        return this.mSteps.remove(index);
    }
}

