/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.flowman.ui;

import com.sigrity.acl.ALog;
import com.sigrity.flowman.FlowStep;
import com.sigrity.flowman.ui.FlowStepTransferable;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class FMClipboardUtil {
    public static void putStepOnClipboard(FlowStep step) {
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            cb.setContents(new FlowStepTransferable(step), null);
        }
        catch (IllegalStateException ise) {
            ALog.logWarn((Throwable)ise, (String)"Unable to update clipboard.", (Object[])new Object[0]);
        }
    }

    public static FlowStep getStepFromClipboard() {
        Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
        try {
            Transferable cbContents = cb.getContents(null);
            if (cbContents == null) {
                return null;
            }
            if (!cbContents.isDataFlavorSupported(FlowStepTransferable.FLAVOR)) {
                return null;
            }
            Object data = cbContents.getTransferData(FlowStepTransferable.FLAVOR);
            return (FlowStep)data;
        }
        catch (IllegalStateException ise) {
            ALog.logWarn((Throwable)ise, (String)"Unable to read from clipboard.", (Object[])new Object[0]);
            return null;
        }
        catch (IOException ioe) {
            ALog.logWarn((Throwable)ioe, (String)"Error reading from clipboard.", (Object[])new Object[0]);
            return null;
        }
        catch (UnsupportedFlavorException ufe) {
            assert (false);
            return null;
        }
    }
}

