/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.flowman.ui;

import com.sigrity.acl.app.AApp;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.flowman.FlowIcons;
import com.sigrity.flowman.ui.FlowWindow;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Map;
import javax.swing.Icon;

public class FlowManager
extends AApp {
    public static final String APP_VERSION = "0.0 Alpha";
    public static final String APP_NAME = "SiJFlowManager";
    public static final String SSEC_FLOWMANUI = "FlowManUI";
    public static final String SENT_ADIALOG_SETTINGS = "ADlg_";
    public static final String SENT_MAINBOUNDS = "FMUI_Main_Bounds";
    protected FlowWindow mFlowWindow = null;

    public static void main(String[] args) {
        Map cargs = FlowManager.parseCmdLineArgs((String[])args);
        System.setProperty("swing.boldMetal", "false");
        FlowManager flowManager = new FlowManager();
        String flow = (String)cargs.get("flow");
        if (flow != null) {
            flowManager.openFlow(flow);
        }
    }

    public FlowManager() {
        ADialog.setSettingsSection((String)SSEC_FLOWMANUI);
        ADialog.setSettingsPrefix((String)SENT_ADIALOG_SETTINGS);
        if (AApp.getApp() == null) {
            AApp.setApp((AApp)this);
        }
        this.mFlowWindow = new FlowWindow(null);
        this.mFlowWindow.setIconImage(UIUtil.getAwtImage((Icon)FlowIcons.FLOW));
        this.mFlowWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                FlowManager.this.saveSettings();
            }

            @Override
            public void windowClosed(WindowEvent e) {
                FlowManager.this.mFlowWindow.removeWindowListener(this);
                FlowManager.this.mFlowWindow = null;
            }
        });
        this.restoreSettings();
        if (AApp.getApp().getMainWin() == null) {
            AApp.getApp().setMainWin((Window)((Object)this.mFlowWindow));
        }
        this.setMainWin((Window)((Object)this.mFlowWindow));
        this.mFlowWindow.setVisible(true);
    }

    public String getName(boolean fullName) {
        return APP_NAME;
    }

    public String getVersion() {
        return APP_VERSION;
    }

    public boolean openFlow(String path) {
        return this.mFlowWindow.openFlow(path);
    }

    protected void saveSettings() {
        Settings s = Settings.getSettings((String)SSEC_FLOWMANUI);
        if (this.mFlowWindow != null) {
            s.putSetting(SENT_MAINBOUNDS, (Object)this.mFlowWindow.getBounds());
        }
        s.save();
    }

    protected void restoreSettings() {
        Rectangle r;
        Settings s = Settings.getSettings((String)SSEC_FLOWMANUI);
        if (this.mFlowWindow != null && (r = (Rectangle)s.getSettingOfClass(SENT_MAINBOUNDS, Rectangle.class)) != null) {
            this.mFlowWindow.setBounds(r);
        }
    }
}

