/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.flowman.ui;

import com.cadence.plaf.InnovusColorScheme;
import com.sigrity.acl.AColor;
import com.sigrity.acl.ui.AColorIcon;
import com.sigrity.acl.ui.ADecoratedIcon;
import com.sigrity.flowman.FlowIcons;
import com.sigrity.flowman.FlowStep;
import com.sigrity.flowman.step.Group;
import com.sigrity.flowman.step.SeparatorGroup;
import com.sigrity.flowman.ui.FlowTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.text.Style;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import javax.swing.tree.TreeCellRenderer;

public class FlowNodeTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    protected Icon ICON_NONE = new AColorIcon(14, 14, AColor.CLEAR, Color.GRAY);
    protected Font mBaseFont = null;
    protected Font mBoldFont = null;
    protected Font mLinkFont = null;
    protected Color mBaseColor = null;
    protected Color mLinkColor = null;
    protected JTree mTree;
    protected Object mValue;
    protected boolean mSelected;
    protected boolean mHasFocus;
    protected boolean mDrawsFocusBorderAroundIcon;
    protected boolean mDrawDashedFocusIndicator;
    protected Color mTreeBGColor;
    protected Color mFocusBGColor;
    protected Color mTextSelectionColor;
    protected Color mTextNonSelectionColor;
    protected Color mBGSelectionColor;
    protected Color mBGNonSelectionColor;
    protected Color mBorderSelectionColor;

    public FlowNodeTreeCellRenderer() {
        this.setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
        this.setTextNonSelectionColor(UIManager.getColor("Tree.textForeground"));
        this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.textBackground"));
        this.setBorderSelectionColor(UIManager.getColor("Tree.selectionBorderColor"));
        this.mDrawsFocusBorderAroundIcon = true;
        this.mDrawDashedFocusIndicator = true;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Color c;
        float complete;
        boolean enabled;
        Color c2;
        this.reset();
        String stringValue = tree.convertValueToText(value, sel, expanded, leaf, row, hasFocus);
        this.mTree = tree;
        this.mHasFocus = hasFocus;
        this.mValue = value;
        this.setText(stringValue);
        Color fg = null;
        JTree.DropLocation dropLocation = tree.getDropLocation();
        fg = dropLocation != null && dropLocation.getChildIndex() == -1 && tree.getRowForPath(dropLocation.getPath()) == row ? ((c2 = UIManager.getColor("Tree.dropCellForeground")) != null ? c2 : this.getTextSelectionColor()) : (sel ? this.getTextSelectionColor() : this.getTextNonSelectionColor());
        this.setForeground(fg);
        this.setComponentOrientation(tree.getComponentOrientation());
        this.mSelected = sel;
        FlowTreeNode ftn = (FlowTreeNode)((Object)value);
        FlowStep step = ftn == null ? null : ftn.getStep();
        boolean bl = enabled = step != null && step.isEnabled();
        if (step instanceof SeparatorGroup) {
            this.setFontBold();
            this.setForeground(InnovusColorScheme.COLOR_TITLE);
        } else if (step instanceof Group) {
            this.setFontBold();
        } else if (step != null && step.isEnabled() && step.hasAction()) {
            this.setFontLink();
            this.setColorLink();
        }
        Object icon = null;
        icon = ftn == null ? this.ICON_NONE : (enabled ? ftn.getIcon() : ftn.getDisabledIcon());
        float f = complete = step == null ? Float.NaN : step.getComplete();
        if (!Float.isNaN(complete) && step.getComplete() >= 1.0f) {
            icon = step instanceof Group ? FlowIcons.GROUP_COMPLETE : (icon != null ? new ADecoratedIcon((Icon)icon, FlowIcons.CHECK) : FlowIcons.CHECK);
        }
        this.setIcon((Icon)icon);
        String tt = null;
        if (step != null) {
            tt = step.getDesc();
        }
        if (tt != null && tt.length() == 0) {
            tt = null;
        }
        this.setToolTipText(tt);
        if (!enabled && (c = UIManager.getColor("Label.disabledForeground")) != null) {
            this.setForeground(c);
        }
        return this;
    }

    public void setFontBold() {
        this.setFont(this.mBoldFont);
    }

    public void setFontLink() {
        this.setFont(this.mLinkFont);
    }

    public void setColorLink() {
        this.setForeground(this.mLinkColor);
    }

    public void setTextSelectionColor(Color newColor) {
        this.mTextSelectionColor = newColor;
    }

    public Color getTextSelectionColor() {
        return this.mTextSelectionColor;
    }

    public void setTextNonSelectionColor(Color newColor) {
        this.mTextNonSelectionColor = newColor;
    }

    public Color getTextNonSelectionColor() {
        return this.mTextNonSelectionColor;
    }

    public void setBackgroundSelectionColor(Color newColor) {
        this.mBGSelectionColor = newColor;
    }

    public Color getBackgroundSelectionColor() {
        return this.mBGSelectionColor;
    }

    public void setBackgroundNonSelectionColor(Color newColor) {
        this.mBGNonSelectionColor = newColor;
    }

    public Color getBackgroundNonSelectionColor() {
        return this.mBGNonSelectionColor;
    }

    public void setBorderSelectionColor(Color newColor) {
        this.mBorderSelectionColor = newColor;
    }

    public Color getBorderSelectionColor() {
        return this.mBorderSelectionColor;
    }

    @Override
    public void setFont(Font font) {
        if (font instanceof FontUIResource) {
            font = null;
        }
        super.setFont(font);
    }

    @Override
    public Font getFont() {
        Font font = super.getFont();
        if (font == null && this.mTree != null) {
            font = this.mTree.getFont();
        }
        return font;
    }

    @Override
    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    @Override
    public void paint(Graphics g) {
        Color c;
        FlowTreeNode ftn = (FlowTreeNode)((Object)this.mValue);
        FlowStep step = ftn == null ? null : ftn.getStep();
        g = g.create();
        Point parentOffset = SwingUtilities.convertPoint(this, 0, 0, this.getParent());
        int rowWidth = this.mTree.getWidth();
        int rowX = -parentOffset.x;
        Shape oldClip = g.getClip();
        Rectangle visibleTree = this.mTree.getVisibleRect();
        visibleTree.x -= parentOffset.x;
        visibleTree.y -= parentOffset.y;
        Rectangle newClip = new Rectangle(rowX, 0, rowWidth, this.getHeight());
        newClip = newClip.intersection(visibleTree);
        g.setClip(newClip);
        if (!this.isEnabled() && (c = UIManager.getColor("Label.disabledForeground")) != null) {
            this.setForeground(c);
        }
        if (step instanceof SeparatorGroup) {
            int y = this.getBaseline(this.getWidth(), this.getHeight()) + 1;
            g.setColor(Color.DARK_GRAY);
            g.drawLine(0, y, visibleTree.width, y);
        }
        g.setClip(oldClip);
        super.paint(g);
    }

    protected int getLabelStart() {
        Icon currentI = this.getIcon();
        if (currentI != null && this.getText() != null) {
            return currentI.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
        }
        return 0;
    }

    protected void reset() {
        if (this.mBaseColor == null) {
            this.mBaseColor = this.getForeground();
        }
        if (this.mBaseFont == null) {
            HTMLEditorKit ek;
            StyleSheet ss;
            Style s;
            this.mBaseFont = this.getFont();
            if (this.mBaseFont != null) {
                this.mBoldFont = this.mBaseFont.deriveFont(1);
                HashMap<TextAttribute, Integer> map = new HashMap<TextAttribute, Integer>();
                map.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
                this.mLinkFont = this.mBaseFont.deriveFont(map);
            }
            if ((s = (ss = (ek = new HTMLEditorKit()).getStyleSheet()).getStyle("a")) != null) {
                this.mLinkColor = ss.getForeground(s);
            }
        }
        if (this.mBaseColor != null) {
            this.setForeground(this.mBaseColor);
        }
        if (this.mBaseFont != null) {
            this.setFont(this.mBaseFont);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension retDimension = super.getPreferredSize();
        if (retDimension != null) {
            retDimension = new Dimension(retDimension.width + 3, retDimension.height + 4);
        }
        return retDimension;
    }

    @Override
    public void validate() {
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void repaint() {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (propertyName.equals("text") || (propertyName.equals("font") || propertyName.equals("foreground")) && oldValue != newValue && this.getClientProperty("html") != null) {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }
}

