/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.flowman.ui;

import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.AList;
import com.sigrity.acl.ui.AListModel;
import com.sigrity.acl.ui.ASplitPane;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.flowman.FlowStep;
import com.sigrity.flowman.FlowStepRegistry;
import com.sigrity.flowman.ui.FMClipboardUtil;
import com.sigrity.flowman.ui.FlowStepTransferable;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.TransferHandler;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FlowStepSelector
extends ADialog {
    protected GroupList mGroups = new GroupList();
    protected StepList mSteps = new StepList();

    public FlowStepSelector(Window owner) {
        super(owner);
        this.setTitle("Flow Step Selector");
        GridBagManager l = GridBagManager.layout((Container)this.getContentPane());
        JPanel pnlGroups = new JPanel();
        GridBagManager lGroups = GridBagManager.layout((Container)pnlGroups);
        lGroups.addNl("Groups:");
        lGroups.add((Component)new JScrollPane(this.mGroups), (GridBagConstraints)GridBagManager.FILLALL);
        JPanel pnlSteps = new JPanel();
        GridBagManager lSteps = GridBagManager.layout((Container)pnlSteps);
        lSteps.addNl("Steps:");
        lSteps.add((Component)new JScrollPane(this.mSteps), (GridBagConstraints)GridBagManager.FILLALL);
        ASplitPane splitter = new ASplitPane(1, pnlGroups, pnlSteps);
        l.add((Component)splitter, (GridBagConstraints)GridBagManager.FILLALL);
        l.newline();
        l.pushFillX();
        l.add("Copy or drag steps from the right-hand list");
        l.addFillX();
        JButton btnClose = (JButton)l.add((Component)new JButton("Close"), (GridBagConstraints)GridBagManager.RIGHT);
        l.pop();
        UIUtil.enableEscCloseMinSize((Window)((Object)this), (AbstractButton)btnClose);
        this.pack();
        if (this.mGroups.getModel().getSize() > 0) {
            this.mGroups.setSelectedIndex(0);
        }
    }

    public static void test(String[] path) {
        for (String group : FlowStepRegistry.getGroups()) {
            System.out.println(String.format("%s (%s):", FlowStepRegistry.getShortGroupName(group), group));
            for (FlowStep step : FlowStepRegistry.getSteps(group)) {
                System.out.println(String.format("%s (%s)", step.getName(), FlowStepRegistry.getRegisteredName(step)));
            }
        }
    }

    public class StepList
    extends JList<FlowStep>
    implements ListSelectionListener {
        protected String mCurGrp = null;
        protected AListModel<FlowStep> mModel = new AListModel();

        public StepList() {
            this.setModel(this.mModel);
            this.setCellRenderer(new CellRenderer());
            FlowStepSelector.this.mGroups.addListSelectionListener(this);
            this.setSelectionMode(0);
            StepListMouseAdapter mouseAdapter = new StepListMouseAdapter();
            this.addMouseListener(mouseAdapter);
            this.addMouseMotionListener(mouseAdapter);
            this.setDragEnabled(true);
            this.setTransferHandler(new SLTransferHandler());
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            String newSel = (String)FlowStepSelector.this.mGroups.getSelectedValue();
            if (newSel == null && this.mCurGrp == null) {
                return;
            }
            if (newSel != null && newSel.equals(this.mCurGrp)) {
                return;
            }
            this.mModel.clear();
            this.mCurGrp = newSel;
            if (this.mCurGrp == null) {
                return;
            }
            for (FlowStep step : FlowStepRegistry.getSteps(this.mCurGrp)) {
                this.mModel.addItem(step);
            }
            this.mModel.sort((s1, s2) -> s1.getName().compareTo(s2.getName()));
        }

        public FlowStep getSelectedStep() {
            Object o = this.getSelectedValue();
            if (o instanceof FlowStep) {
                return (FlowStep)o;
            }
            return null;
        }

        protected void showContextMenu(MouseEvent e) {
            Rectangle r;
            JPopupMenu menu = new JPopupMenu();
            Point p = new Point(e.getX(), e.getY());
            int index = this.locationToIndex(p);
            if (index != -1 && !(r = this.getCellBounds(index, index)).contains(p)) {
                index = -1;
            }
            if (index < 0) {
                this.clearSelection();
            } else {
                this.setSelectedIndex(index);
            }
            FlowStep step = (FlowStep)this.getSelectedValue();
            if (step == null) {
                return;
            }
            menu.add(new CopyStep(step));
            menu.show(this, e.getX(), e.getY());
        }

        public class SLTransferHandler
        extends TransferHandler {
            @Override
            public int getSourceActions(JComponent c) {
                return 1;
            }

            @Override
            protected Transferable createTransferable(JComponent c) {
                FlowStep step = StepList.this.getSelectedStep();
                if (step == null) {
                    return null;
                }
                return new FlowStepTransferable(step);
            }
        }

        public class CellRenderer
        extends DefaultListCellRenderer {
            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof FlowStep) {
                    FlowStep step = (FlowStep)value;
                    this.setText(step.getName());
                    this.setToolTipText(step.getDesc());
                }
                return this;
            }
        }

        public class StepListMouseAdapter
        extends MouseAdapter {
            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    FlowStepSelector.this.mSteps.showContextMenu(e);
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    FlowStepSelector.this.mSteps.showContextMenu(e);
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    FlowStepSelector.this.mSteps.showContextMenu(e);
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
            }
        }

        public class CopyStep
        extends AbstractAction {
            protected FlowStep mStep;

            public CopyStep(FlowStep step) {
                super("Copy");
                this.mStep = step;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                FMClipboardUtil.putStepOnClipboard(this.mStep);
            }
        }
    }

    public class GroupList
    extends AList<String> {
        protected AListModel<String> mModel = new AListModel();

        public GroupList() {
            this.getSelectionModel().setSelectionMode(1);
            for (String group : FlowStepRegistry.getGroups()) {
                this.mModel.addItem(group);
            }
            this.setModel(this.mModel);
            this.setCellRenderer(new CellRenderer());
        }

        protected class CellRenderer
        extends DefaultListCellRenderer {
            protected CellRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                if (value instanceof String) {
                    String grpName = (String)value;
                    this.setText(FlowStepRegistry.getShortGroupName(grpName));
                    this.setToolTipText(grpName);
                }
                return this;
            }
        }
    }
}

