/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.flowman.ui;

import com.sigrity.acl.ALog;
import com.sigrity.flowman.FlowStep;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class FlowStepTransferable
implements Transferable {
    public static final String MimeType = String.format("%s;class=%s", "application/x-java-jvm-local-objectref", FlowStep.class.getName());
    public static final DataFlavor FLAVOR = FlowStepTransferable.createFlavor(MimeType);
    protected static final DataFlavor[] FLAVORS = new DataFlavor[]{FLAVOR, DataFlavor.stringFlavor};
    protected FlowStep mFlowStep;

    private static DataFlavor createFlavor(String mime) {
        DataFlavor flavor = null;
        try {
            flavor = new DataFlavor(MimeType);
        }
        catch (ClassNotFoundException cnfe) {
            assert (false);
            ALog.logError((Throwable)cnfe, (String)"Error initializing FlowStepTransferable class.", (Object[])new Object[0]);
        }
        return flavor;
    }

    public FlowStepTransferable(FlowStep step) {
        this.mFlowStep = step;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor == FLAVOR) {
            return this.mFlowStep;
        }
        if (flavor == DataFlavor.stringFlavor) {
            return this.mFlowStep.toString();
        }
        assert (false);
        throw new UnsupportedFlavorException(flavor);
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return FLAVORS;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor == FLAVOR || flavor == DataFlavor.stringFlavor;
    }
}

