/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.flowman.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.AFloatWindow;
import com.sigrity.acl.ui.ATabbedPane;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.flowman.Flow;
import com.sigrity.flowman.ui.FlowPanel;
import com.sigrity.flowman.ui.FlowTree;
import com.sigrity.flowman.ui.editor.FlowStepEditorDlg;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.ToolTipManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.plaf.TabbedPaneUI;

public class FlowTabs
extends ATabbedPane {
    public final Action mOpenFlow = new AbstractAction("Open Flow..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            FlowTabs.this.selectAndOpenFlow();
        }
    };

    public FlowTabs() {
        this.setDefaultToClosable(true);
        this.setTabLayoutPolicy(1);
        this.setTabPlacement(3);
        UIUtil.installPopupMenu((Component)this, (JPopupMenu)new ContextMenu());
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void selectAndOpenFlow() {
        URL url;
        AFileChooser fc = new AFileChooser();
        fc.addChoosableFileFilter((FileFilter)Flow.FILEFILTER_FLOWDEF);
        fc.setFileFilter((FileFilter)Flow.FILEFILTER_FLOWDEF);
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(false);
        if (fc.showOpenDialog((Component)this) != 0) {
            return;
        }
        File f = fc.getSelectedFile();
        if (f == null) {
            return;
        }
        URI uri = f.toURI();
        try {
            url = uri.toURL();
        }
        catch (MalformedURLException e1) {
            ALog.logError((Throwable)e1, (String)"Error reading flow definition '%s'.", (Object[])new Object[]{uri.toASCIIString()});
            return;
        }
        Flow flow = Flow.readFlow(url);
        if (flow == null) {
            return;
        }
        this.openFlow(flow);
    }

    public boolean openFlow(String url) {
        URL u;
        try {
            u = new URL(url);
        }
        catch (MalformedURLException e1) {
            ALog.logError((Throwable)e1, (String)"Error reading flow definition '%s', invalid URL.", (Object[])new Object[]{url});
            return false;
        }
        Flow flow = Flow.readFlow(u);
        if (flow == null) {
            return false;
        }
        return this.openFlow(flow);
    }

    public boolean openFlow(Flow flow) {
        FlowPanel flowPanel = new FlowPanel(flow);
        this.addTab(flow.getName(), null, flowPanel);
        this.setSelectedComponent(flowPanel);
        this.saveOpenedFlow();
        return true;
    }

    private void saveOpenedFlow() {
        Settings s = Settings.getSettings((String)"MRUFlows");
        s.removeAll(Settings.Type.User);
        for (int i = 0; i != this.getTabCount(); ++i) {
            String filePath = ((FlowPanel)this.getComponentAt(i)).getFlow().getSource().toString();
            s.putSetting("File" + i, (Object)filePath);
        }
        s.save();
    }

    @Override
    public boolean closeTab(Component c) {
        if (this.indexOfComponent(c) < 0) {
            return false;
        }
        this.remove(c);
        this.saveOpenedFlow();
        return true;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        int index;
        if (this.ui != null && (index = ((TabbedPaneUI)this.ui).tabForCoordinate(this, event.getX(), event.getY())) >= 0) {
            return this.getToolTipTextAt(index);
        }
        return super.getToolTipText(event);
    }

    @Override
    public String getToolTipTextAt(int index) {
        URL url;
        Component c = this.getComponentAt(index);
        if (!(c instanceof FlowPanel)) {
            return super.getToolTipTextAt(index);
        }
        FlowPanel fp = (FlowPanel)c;
        Object tip = "";
        String desc = fp.getFlow().getDesc();
        if (desc != null && desc.length() > 0) {
            tip = (String)tip + String.format("<b>%s</b>", desc);
        }
        if ((url = fp.getFlow().getSource()) != null) {
            if (((String)tip).length() > 0) {
                tip = (String)tip + "<br/>\n";
            }
            tip = (String)tip + String.format("%s", url.toExternalForm());
        }
        if (((String)tip).length() == 0) {
            return null;
        }
        return String.format("<html>%s</html>", tip);
    }

    public class FlowProperties
    extends AbstractAction {
        protected FlowPanel mFlowPanel;

        public FlowProperties(FlowPanel fp) {
            super("Properties...");
            this.mFlowPanel = fp;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Flow flow = this.mFlowPanel.getFlow();
            String oldScriptLibrary = flow.getLibraryScript().trim();
            FlowStepEditorDlg ui = new FlowStepEditorDlg(UIUtil.getParentWindow((Component)FlowTabs.this), flow);
            ui.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
            ui.setVisible(true);
            if (ui.getSaved()) {
                int idx;
                if (!oldScriptLibrary.equals(flow.getLibraryScript().trim())) {
                    flow.evalLibraryScript();
                }
                if ((idx = FlowTabs.this.indexOfComponent(this.mFlowPanel)) >= 0) {
                    FlowTabs.this.getTabComponentAt(idx);
                    FlowTabs.this.setTitleAt(idx, flow.getName());
                }
            }
        }
    }

    public class FlowSave
    extends AbstractAction {
        protected boolean mAs;
        protected FlowPanel mFlowPanel;

        public FlowSave(FlowPanel fp, boolean as) {
            super(as ? "Save As..." : "Save");
            this.mAs = false;
            this.mFlowPanel = null;
            this.mFlowPanel = fp;
            this.mAs = as;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Flow flow = this.mFlowPanel.getFlow();
            if (this.mAs || flow.getSource() == null) {
                AFileChooser fc = new AFileChooser();
                fc.addChoosableFileFilter((FileFilter)Flow.FILEFILTER_FLOWDEF);
                fc.setFileFilter((FileFilter)Flow.FILEFILTER_FLOWDEF);
                if (fc.showSaveDialog((Component)FlowTabs.this) == 0) {
                    File f = fc.getSelectedFile();
                    URI uri = f.toURI();
                    try {
                        flow.write(uri.toURL());
                    }
                    catch (MalformedURLException e1) {
                        ALog.logError((Throwable)e1, (String)"Error writing to file '%s'.", (Object[])new Object[]{uri.toString()});
                    }
                }
            } else {
                flow.write((URL)null);
            }
            FlowTabs.this.saveOpenedFlow();
        }
    }

    public class FlowEditItem
    extends JCheckBoxMenuItem
    implements ActionListener {
        protected FlowTree mTree;

        public FlowEditItem(FlowPanel fp) {
            super("Edit");
            this.mTree = null;
            this.mTree = fp.mTree;
            this.setSelected(this.mTree.getEditMode());
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.mTree.setEditMode(!this.mTree.getEditMode());
        }
    }

    public class FlowCloser
    extends AbstractAction {
        protected FlowPanel mFlowPanel;

        public FlowCloser(FlowPanel fp) {
            super("Close", AFloatWindow.ICON_CLOSE);
            this.mFlowPanel = null;
            this.mFlowPanel = fp;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FlowTabs.this.remove(this.mFlowPanel);
            FlowTabs.this.saveOpenedFlow();
        }
    }

    public class ContextMenu
    extends JPopupMenu
    implements PopupMenuListener {
        public ContextMenu() {
            this.addPopupMenuListener(this);
        }

        @Override
        public void show(Component invoker, int x, int y) {
            this.prepareMenu(x, y);
            super.show(invoker, x, y);
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        protected void prepareMenu(int x, int y) {
            Component c;
            this.removeAll();
            this.add(FlowTabs.this.mOpenFlow);
            FlowPanel fp = null;
            Flow flow = null;
            int tabIdx = FlowTabs.this.indexAtLocation(x, y);
            if (tabIdx >= 0 && (c = FlowTabs.this.getComponentAt(tabIdx)) instanceof FlowPanel) {
                fp = (FlowPanel)c;
                flow = fp.getFlow();
            }
            if (fp != null) {
                this.addSeparator();
                if (flow != null) {
                    this.add(new FlowEditItem(fp));
                    if (fp.getEditMode()) {
                        this.add(new FlowProperties(fp));
                        if (fp.getFlow().getSource() != null && fp.getFlow().canWrite(null)) {
                            this.add(new FlowSave(fp, false));
                        }
                        this.add(new FlowSave(fp, true));
                    }
                }
                this.add(new FlowCloser(fp));
            }
        }
    }
}

