/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.flowman.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.ui.atree.ATree;
import com.sigrity.acl.ui.atree.ATreeModel;
import com.sigrity.acl.ui.atree.ATreeNode;
import com.sigrity.flowman.Flow;
import com.sigrity.flowman.FlowStep;
import com.sigrity.flowman.step.Group;
import com.sigrity.flowman.step.SeparatorGroup;
import com.sigrity.flowman.ui.FMClipboardUtil;
import com.sigrity.flowman.ui.FlowNodeTreeCellRenderer;
import com.sigrity.flowman.ui.FlowStepSelector;
import com.sigrity.flowman.ui.FlowStepTransferable;
import com.sigrity.flowman.ui.FlowTreeNode;
import com.sigrity.flowman.ui.editor.FlowStepEditorDlg;
import com.sigrity.orbit.OrbitIO;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class FlowTree
extends ATree {
    public static final String Setting_AutoCollapseInactiveNode = "AutoCollapseInactiveNode";
    protected static boolean Setting_AutoCollapseInactiveNode_Default = false;
    protected boolean mEditMode = false;
    protected Flow mFlow;
    protected Point mMouseDownAt = null;
    protected FlowTreeNode mLastCursorNode = null;
    protected Cp.Listener mCpListener = new Cp.Listener(){

        public void cmdEnd(String cmd, boolean record) {
            FlowTree.this.repaint();
        }

        public void cmdStart(String cmd, boolean record) {
        }
    };
    FlowStepSelector mFlowStepSelector = null;

    public FlowTree(Flow flow) {
        TreePath path;
        this.mFlow = flow;
        this.setRootVisible(false);
        this.setShowsRootHandles(false);
        this.setCellRenderer(new FlowNodeTreeCellRenderer());
        this.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0));
        FlowTreeMouseAdapter mouseAdapter = new FlowTreeMouseAdapter();
        this.addMouseListener(mouseAdapter);
        this.addMouseMotionListener(mouseAdapter);
        this.addMouseWheelListener(mouseAdapter);
        this.getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent((JComponent)((Object)this));
        ATreeModel model = new ATreeModel();
        FlowTreeNode rootNode = new FlowTreeNode((FlowStep)this.mFlow, model);
        model.setRoot((TreeNode)((Object)rootNode));
        this.setModel((TreeModel)model);
        this.setRootVisible(false);
        UIUtil.expandTreeLevels((JTree)((Object)this), (int)1);
        String entryPath = flow.getEntryPath();
        if (entryPath != null && entryPath.length() > 0 && (path = rootNode.findStep(entryPath)) != null) {
            this.setSelectionPath(path);
        }
        this.setTransferHandler(new FTTransferHandler());
        this.setDropMode(DropMode.INSERT);
        this.setDragEnabled(true);
    }

    public Flow getFlow() {
        return this.mFlow;
    }

    public void setEditMode(boolean f) {
        this.mEditMode = f;
    }

    public boolean getEditMode() {
        return this.mEditMode;
    }

    public TreePath getPath(Point p, boolean wholeRow) {
        if (wholeRow) {
            TreePath path = this.getClosestPathForLocation(p.x, p.y);
            if (path == null) {
                return null;
            }
            Rectangle pathBounds = this.getPathBounds(path);
            if (pathBounds == null || pathBounds.getHeight() == 0.0) {
                return null;
            }
            if (p.y < pathBounds.y || p.y > pathBounds.y + pathBounds.height) {
                return null;
            }
            return path;
        }
        return this.getPathForLocation(p.x, p.y);
    }

    public boolean removeNode(TreePath path) {
        FlowTreeNode child;
        if (path.getPathCount() <= 1) {
            return false;
        }
        TreePath parentPath = path.getParentPath();
        FlowTreeNode parent = (FlowTreeNode)((Object)parentPath.getLastPathComponent());
        int idx = parent.removeChild(child = (FlowTreeNode)((Object)path.getLastPathComponent()));
        if (idx < 0) {
            return false;
        }
        this.mFlow.setDirty(true);
        this.getModel().treeNodesRemoved((Object)this, parentPath.getPath(), new int[]{idx}, new Object[]{child});
        FlowStep parentStep = parent.getStep();
        if (parentStep instanceof Group) {
            Group group = (Group)parentStep;
            group.removeChildStep(idx);
        }
        return true;
    }

    public boolean addNode(TreePath pathParent, int idx, FlowTreeNode child) {
        if (pathParent.getPathCount() < 1) {
            return false;
        }
        FlowTreeNode parent = (FlowTreeNode)((Object)pathParent.getLastPathComponent());
        int addedIdx = parent.addChild(child, idx);
        if (addedIdx < 0) {
            return false;
        }
        this.mFlow.setDirty(true);
        this.getModel().treeNodesInserted((Object)this, pathParent.getPath(), new int[]{addedIdx}, new Object[]{child});
        return true;
    }

    public void updateNodeDisplay(TreePath path) {
        TreePath parent;
        if (path == null || path.getPathCount() < 1) {
            return;
        }
        this.getModel().nodeChanged((TreeNode)path.getLastPathComponent());
        int row = this.getRowForPath(path);
        if (row >= 0) {
            Rectangle r = this.getPathBounds(path);
            this.repaint(r);
        }
        if ((parent = path.getParentPath()) != null) {
            this.updateNodeDisplay(parent);
        }
    }

    public void showContextMenu(MouseEvent e) {
        JPopupMenu menu = new JPopupMenu();
        TreePath path = this.getPath(e.getPoint(), true);
        TreePath pathSel = this.getPath(e.getPoint(), true);
        if (pathSel != null && !this.isPathSelected(pathSel)) {
            this.setSelectionPath(pathSel);
        }
        if (this.mEditMode) {
            if (path != null) {
                FlowTreeNode targetNode = (FlowTreeNode)((Object)path.getLastPathComponent());
                menu.add(new ShowFlowStepSelector());
                menu.add(new AddSeparatorAction(path));
                menu.addSeparator();
                menu.add(new EditNode(path));
                menu.add(new DeleteNode(path));
                menu.addSeparator();
                menu.add(new CutNode(path));
                menu.add(new CopyNode(path));
                if (FMClipboardUtil.getStepFromClipboard() != null) {
                    menu.add(new PasteNode(path, NodePosition.Before));
                    menu.add(new PasteNode(path, NodePosition.After));
                    if (targetNode.getStep() instanceof Group) {
                        menu.add(new PasteNode(path, NodePosition.Child));
                    }
                }
            } else {
                menu.add(new ShowFlowStepSelector());
                if (FMClipboardUtil.getStepFromClipboard() != null) {
                    menu.addSeparator();
                    menu.add(new PasteNode(null, null));
                }
            }
        } else {
            menu.add(new EditNode(path));
        }
        OrbitIO.getGuiWorkspace().beautify(menu);
        if (menu.getComponentCount() > 0) {
            menu.show((Component)((Object)this), e.getX(), e.getY());
        }
    }

    public boolean insertCopyOfStep(TreePath parentPath, int index, FlowStep srcStep, boolean testOnly) {
        Group parentGroupStep;
        if (FlowTree.pathContainsStep(parentPath, srcStep)) {
            return false;
        }
        if (testOnly) {
            return true;
        }
        FlowTreeNode parentNode = (FlowTreeNode)((Object)parentPath.getLastPathComponent());
        FlowStep step = srcStep.copy(this.mFlow);
        FlowTreeNode newNode = new FlowTreeNode(step, (ATreeNode)parentNode);
        if (!this.addNode(parentPath, index, newNode)) {
            return false;
        }
        if (parentNode.getStep() instanceof Group && (parentGroupStep = (Group)parentNode.getStep()) != null) {
            parentGroupStep.addChildStep(index, step);
        }
        return true;
    }

    protected void updateCursor(MouseEvent e) {
        if (e == null) {
            this.setCursor(null);
        } else {
            TreePath path = this.getPath(e.getPoint(), false);
            FlowTreeNode ftn = FlowTree.getNode(path);
            if (ftn != this.mLastCursorNode) {
                Cursor cursor = ftn == null ? null : ftn.getCursor();
                this.setCursor(cursor);
                this.mLastCursorNode = ftn;
            }
        }
    }

    public void addNotify() {
        super.addNotify();
        Cp.getCp().addListener(this.mCpListener);
    }

    public void removeNotify() {
        Cp.getCp().removeListener(this.mCpListener);
        super.removeNotify();
    }

    public void paintImmediately(int x, int y, int w, int h) {
        int newX = this.getX();
        int newW = this.getWidth();
        super.paintImmediately(newX, y, newW, h);
    }

    public boolean autoCollapseNodes() {
        Boolean ret = (Boolean)Settings.get((String)FlowTree.class.getName(), (String)Setting_AutoCollapseInactiveNode, (Object)Setting_AutoCollapseInactiveNode_Default);
        return ret != null && ret != false;
    }

    public static boolean pathContainsStep(TreePath path, FlowStep step) {
        for (Object o : path.getPath()) {
            FlowTreeNode n;
            if (!(o instanceof FlowTreeNode) || (n = (FlowTreeNode)((Object)o)).getStep() != step) continue;
            return true;
        }
        return false;
    }

    public static FlowTreeNode getNode(TreePath path) {
        if (path == null) {
            return null;
        }
        Object node = path.getLastPathComponent();
        if (node instanceof FlowTreeNode) {
            return (FlowTreeNode)((Object)path.getLastPathComponent());
        }
        return null;
    }

    public static FlowStep getStep(TreePath path) {
        FlowTreeNode ftn = FlowTree.getNode(path);
        if (ftn == null) {
            return null;
        }
        return ftn.getStep();
    }

    public class ShowFlowStepSelector
    extends AbstractAction {
        public ShowFlowStepSelector() {
            super("Add Flow Step...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FlowTree.this.mFlowStepSelector == null) {
                FlowTree.this.mFlowStepSelector = new FlowStepSelector(UIUtil.getParentWindow((Component)((Object)FlowTree.this)));
                FlowTree.this.mFlowStepSelector.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent e) {
                        FlowTree.this.mFlowStepSelector.removeWindowListener(this);
                        FlowTree.this.mFlowStepSelector = null;
                    }
                });
                UIUtil.center((Component)((Object)FlowTree.this.mFlowStepSelector));
            }
            FlowTree.this.mFlowStepSelector.setVisible(true);
        }
    }

    public class PasteNode
    extends NodeAction {
        public PasteNode(TreePath relTo, NodePosition pos) {
            super(relTo, pos);
            Object posStr = "Node";
            if (pos != null) {
                posStr = pos == NodePosition.Child ? "Child Node" : "Node " + pos.toString();
            }
            String name = String.format("Paste %s", posStr);
            this.setName(name);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FlowStep pasteStep = FMClipboardUtil.getStepFromClipboard();
            if (pasteStep == null) {
                assert (false);
                return;
            }
            TreePath parentPath = null;
            parentPath = this.mPath == null ? new TreePath(FlowTree.this.getModel().getRoot()) : (this.mPosition == NodePosition.Child ? this.mPath : this.mPath.getParentPath());
            FlowTreeNode parentNode = (FlowTreeNode)((Object)parentPath.getLastPathComponent());
            int index = parentNode.getChildCount();
            if (this.mPosition == NodePosition.After || this.mPosition == NodePosition.Before) {
                if (this.mPath == null) {
                    index = 0;
                } else {
                    int refIdx = parentNode.mFTNChildren.indexOf(this.mPath.getLastPathComponent());
                    index = this.mPosition == NodePosition.After ? refIdx + 1 : refIdx;
                }
            }
            FlowTree.this.insertCopyOfStep(parentPath, index, pasteStep, false);
        }
    }

    public class AddSeparatorAction
    extends NodeAction {
        public AddSeparatorAction(TreePath relTo) {
            super(relTo, NodePosition.After);
            this.setName("Add Separator");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TreePath parentPath = null;
            parentPath = this.mPath == null ? new TreePath(FlowTree.this.getModel().getRoot()) : this.mPath.getParentPath();
            FlowTreeNode parentNode = (FlowTreeNode)((Object)parentPath.getLastPathComponent());
            int index = parentNode.getChildCount();
            if (this.mPath == null) {
                index = 0;
            } else {
                int refIdx = parentNode.mFTNChildren.indexOf(this.mPath.getLastPathComponent());
                index = this.mPosition == NodePosition.After ? refIdx + 1 : refIdx;
            }
            SeparatorGroup separatorStep = new SeparatorGroup();
            FlowTree.this.insertCopyOfStep(parentPath, index, separatorStep, false);
        }
    }

    public class CopyNode
    extends NodeAction {
        public CopyNode(TreePath path) {
            super(path);
            this.setName("Copy");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FMClipboardUtil.putStepOnClipboard(FlowTree.getStep(this.mPath));
        }
    }

    public class CutNode
    extends NodeAction {
        public CutNode(TreePath path) {
            super(path);
            this.setName("Cut");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FMClipboardUtil.putStepOnClipboard(FlowTree.getStep(this.mPath));
            FlowTree.this.removeNode(this.mPath);
        }
    }

    public class DeleteNode
    extends NodeAction {
        public DeleteNode(TreePath path) {
            super(path);
            this.setName("Delete");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FlowTree.this.removeNode(this.mPath);
        }
    }

    public class EditNode
    extends NodeAction {
        public EditNode(TreePath path) {
            super(path);
            this.setName("Edit...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FlowStep step = super.getStep();
            if (step == null) {
                assert (false) : "No node to edit.";
                return;
            }
            FlowStepEditorDlg ui = new FlowStepEditorDlg(UIUtil.getParentWindow((Component)((Object)FlowTree.this)), step);
            ui.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
            ui.setVisible(true);
            if (ui.getSaved()) {
                this.repaintNode();
            }
        }
    }

    protected abstract class NodeAction
    extends AbstractAction {
        protected TreePath mPath;
        protected NodePosition mPosition = null;

        public NodeAction(TreePath path) {
            this.mPath = path;
        }

        public NodeAction(TreePath path, NodePosition pos) {
            this.mPath = path;
            this.mPosition = pos;
        }

        public TreePath getPath() {
            return this.mPath;
        }

        public void setName(String name) {
            this.putValue("Name", name);
        }

        public FlowTreeNode getNode() {
            return this.mPath == null ? null : (FlowTreeNode)((Object)this.mPath.getLastPathComponent());
        }

        public FlowStep getStep() {
            FlowTreeNode ftn = this.getNode();
            return ftn == null ? null : ftn.getStep();
        }

        public void repaintNode() {
            if (this.mPath == null) {
                return;
            }
            FlowTree.this.updateNodeDisplay(this.mPath);
        }
    }

    public class FTTransferHandler
    extends TransferHandler {
        @Override
        public int getSourceActions(JComponent c) {
            return FlowTree.this.mEditMode ? 3 : 0;
        }

        @Override
        public Transferable createTransferable(JComponent c) {
            TreePath path;
            if (!FlowTree.this.mEditMode) {
                return null;
            }
            if (FlowTree.this.mMouseDownAt != null && (path = FlowTree.this.getPath(FlowTree.this.mMouseDownAt, false)) != null && !FlowTree.this.isPathSelected(path)) {
                FlowTree.this.setSelectionPath(path);
            }
            if ((path = FlowTree.this.getSelectionPath()) == null) {
                return null;
            }
            FlowTreeNode selNode = (FlowTreeNode)((Object)path.getLastPathComponent());
            FlowStep step = selNode.getStep();
            if (step == null) {
                return null;
            }
            return new FlowStepTransferable(step);
        }

        @Override
        public void exportDone(JComponent c, Transferable t, int action) {
            if (action == 2) {
                TreePath path = FlowTree.this.getSelectionPath();
                if (path == null) {
                    return;
                }
                FlowTree.this.removeNode(path);
            }
        }

        protected boolean importData(TransferHandler.TransferSupport support, boolean testOnly) {
            if (!FlowTree.this.mEditMode) {
                return false;
            }
            if (!support.getTransferable().isDataFlavorSupported(FlowStepTransferable.FLAVOR)) {
                return false;
            }
            FlowStep srcStep = null;
            try {
                srcStep = (FlowStep)support.getTransferable().getTransferData(FlowStepTransferable.FLAVOR);
            }
            catch (Exception e) {
                ALog.logError((Throwable)e, (String)"Unexpected problem during transfer.", (Object[])new Object[0]);
                return false;
            }
            if (support.isDrop()) {
                JTree.DropLocation dropLoc = (JTree.DropLocation)support.getDropLocation();
                TreePath pathParent = dropLoc.getPath();
                if (pathParent == null) {
                    assert (false);
                    return false;
                }
                FlowTreeNode ftnParent = (FlowTreeNode)((Object)pathParent.getLastPathComponent());
                int index = dropLoc.getChildIndex();
                if (index == -1) {
                    index = ftnParent.getChildCount();
                }
                return FlowTree.this.insertCopyOfStep(pathParent, index, srcStep, testOnly);
            }
            TreePath selPath = FlowTree.this.getSelectionPath();
            if (selPath == null || selPath.getPathCount() < 2) {
                FlowTreeNode rootNode = (FlowTreeNode)((Object)FlowTree.this.getModel().getRoot());
                TreePath rootPath = new TreePath((Object)rootNode);
                return FlowTree.this.insertCopyOfStep(rootPath, rootNode.getChildCount(), srcStep, testOnly);
            }
            if (FlowTree.this.isExpanded(selPath)) {
                return FlowTree.this.insertCopyOfStep(selPath, 0, srcStep, testOnly);
            }
            TreePath parentPath = selPath.getParentPath();
            FlowTreeNode ftnParent = (FlowTreeNode)((Object)parentPath.getLastPathComponent());
            FlowTreeNode ftnSelected = (FlowTreeNode)((Object)selPath.getLastPathComponent());
            int index = ftnParent.getIndex((TreeNode)((Object)ftnSelected)) + 1;
            return FlowTree.this.insertCopyOfStep(parentPath, index, srcStep, testOnly);
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return this.importData(support, true);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            return this.importData(support, false);
        }
    }

    public class FlowTreeMouseAdapter
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent e) {
            FlowTree.this.mMouseDownAt = e.getPoint();
            if (e.isPopupTrigger()) {
                FlowTree.this.showContextMenu(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            FlowTree.this.mMouseDownAt = null;
            if (e.isPopupTrigger()) {
                FlowTree.this.showContextMenu(e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.isPopupTrigger()) {
                FlowTree.this.showContextMenu(e);
            } else if (e.getClickCount() == 1 && e.getButton() == 1) {
                FlowStep step;
                TreePath pathSel = FlowTree.this.getPath(e.getPoint(), true);
                TreePath path = FlowTree.this.getPath(e.getPoint(), false);
                FlowTreeNode ftn = FlowTree.getNode(path);
                if (pathSel != null && !FlowTree.this.isPathSelected(pathSel)) {
                    FlowTree.this.setSelectionPath(pathSel);
                }
                if (ftn != null && (step = ftn.getStep()).isEnabled()) {
                    FlowTree.this.mFlow.invoke(step);
                    EventQueue.invokeLater(() -> FlowTree.this.repaint());
                }
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            FlowTree.this.updateCursor(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            FlowTree.this.updateCursor(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            FlowTree.this.updateCursor(null);
        }
    }

    public static enum NodePosition {
        Before,
        After,
        Child;

    }
}

