/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.flowman.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.ui.atree.ALazyTreeNode;
import com.sigrity.acl.ui.atree.ATreeModel;
import com.sigrity.acl.ui.atree.ATreeNode;
import com.sigrity.flowman.FlowIcons;
import com.sigrity.flowman.FlowStep;
import com.sigrity.flowman.step.Choice;
import com.sigrity.flowman.step.Group;
import com.sigrity.flowman.step.Simple;
import java.awt.Cursor;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.tree.TreePath;

public class FlowTreeNode
extends ALazyTreeNode {
    protected FlowStep mStep;
    protected ArrayList<FlowTreeNode> mFTNChildren = null;

    public FlowTreeNode(FlowStep step, ATreeModel model) {
        super(model);
        this.init(step);
    }

    public FlowTreeNode(FlowStep step, ATreeNode parent) {
        super(parent);
        this.init(step);
    }

    public TreePath findStep(String stepPath) {
        String[] path;
        TreePath res = new TreePath((Object)this);
        FlowTreeNode curNode = this;
        for (String curStepName : path = stepPath.split("/")) {
            if ((curNode = curNode.getNode(curStepName)) == null) {
                ALog.logError((String)"Unable to find flow step '%s', node '%s' does not exist.", (Object[])new Object[]{stepPath, curStepName});
                return null;
            }
            res = res.pathByAddingChild((Object)curNode);
        }
        return res;
    }

    public FlowTreeNode getNode(String stepName) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            FlowTreeNode n = (FlowTreeNode)this.getChildAt(i);
            if (!stepName.equals(n.mStep.getName())) continue;
            return n;
        }
        return null;
    }

    protected void init(FlowStep step) {
        this.mStep = step;
        this.setSortChildren(false);
    }

    public FlowStep getStep() {
        return this.mStep;
    }

    public Cursor getCursor() {
        if (this.mStep.hasAction() && this.mStep.isEnabled()) {
            return Cursor.getPredefinedCursor(12);
        }
        return null;
    }

    public int addChild(FlowTreeNode child, int index) {
        this.populateChildrenAsNeeded();
        if (this.mChildren == null) {
            return -1;
        }
        if (index < 0 || index >= this.mChildren.size()) {
            this.mFTNChildren.add(child);
            return this.mFTNChildren.size() - 1;
        }
        this.mFTNChildren.add(index, child);
        return index;
    }

    public int removeChild(FlowTreeNode node) {
        if (this.mChildren == null) {
            return -1;
        }
        int idx = this.mChildren.lastIndexOf((Object)node);
        if (idx < 0) {
            return -1;
        }
        this.mChildren.remove(idx);
        return idx;
    }

    public ArrayList<FlowTreeNode> populateChildren() {
        if (this.mStep instanceof Group) {
            this.mFTNChildren = new ArrayList();
            for (FlowStep step : ((Group)this.mStep).getSteps()) {
                this.mFTNChildren.add(new FlowTreeNode(step, (ATreeNode)this));
            }
        }
        return this.mFTNChildren;
    }

    public String getText() {
        return String.format(this.mStep.getName(), new Object[0]);
    }

    public Icon getIcon() {
        FlowTreeNode ftnParent;
        if (this.mStep instanceof Simple && this.getParent() instanceof FlowTreeNode && (ftnParent = (FlowTreeNode)this.getParent()).getStep() instanceof Choice) {
            return FlowIcons.SIMPLE_ROUND;
        }
        Icon stepIcon = (Icon)this.mStep.getValue("SmallIcon");
        if (stepIcon != null) {
            return stepIcon;
        }
        return null;
    }

    public boolean isLeaf() {
        return !(this.mStep instanceof Group);
    }

    public String toString() {
        return super.toString() + String.format("{%s}", this.getText());
    }
}

