/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.flowman.ui;

import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.ALinkLabel;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.flowman.Flow;
import com.sigrity.flowman.ui.FlowPanel;
import com.sigrity.flowman.ui.FlowTabs;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class FlowWindow
extends ADialog {
    public static final String TITLE = "Flow Manager";
    protected FlowTabs mFlowTabs = null;
    protected JComponent mOpenFlowComponent = null;

    public FlowWindow(Window parent) {
        this(parent, null);
    }

    public FlowWindow(Window parent, Flow flow) {
        super(parent);
        this.setTitle(TITLE);
        GridBagManager l = GridBagManager.layout((Container)this.getContentPane());
        this.mFlowTabs = new FlowTabs();
        l.add((Component)this.mFlowTabs, (GridBagConstraints)GridBagManager.FILLALL);
        this.mOpenFlowComponent = new OpenFlowComponent();
        l.add((Component)this.mOpenFlowComponent, (GridBagConstraints)GridBagManager.CENTER);
        this.mFlowTabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                Component c = FlowWindow.this.mFlowTabs.getSelectedComponent();
                if (c == null) {
                    FlowWindow.this.allFlowsClosed();
                } else if (c instanceof FlowPanel) {
                    FlowWindow.this.activateFlow((FlowPanel)c);
                } else {
                    FlowWindow.this.activateNonFlow(c);
                }
            }
        });
        this.mFlowTabs.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                FlowWindow.this.mOpenFlowComponent.setVisible(false);
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                FlowWindow.this.mOpenFlowComponent.setVisible(true);
            }
        });
        this.mFlowTabs.setVisible(false);
        this.setMinimumSize(new Dimension(200, 400));
        if (flow != null) {
            this.mFlowTabs.openFlow(flow);
        }
        this.pack();
    }

    public boolean openFlow(String path) {
        return this.mFlowTabs.openFlow(path);
    }

    public boolean openFlow(Flow flow) {
        return this.mFlowTabs.openFlow(flow);
    }

    protected void activateFlow(FlowPanel fp) {
        Flow flow = fp.getFlow();
        if (flow == null) {
            return;
        }
        this.setTitle(flow.getDesc());
        this.mFlowTabs.setVisible(true);
    }

    protected void activateNonFlow(Component c) {
        this.setTitle(TITLE);
        this.mFlowTabs.setVisible(true);
    }

    protected void allFlowsClosed() {
        this.setTitle(TITLE);
        this.mFlowTabs.setVisible(false);
    }

    public class OpenFlowComponent
    extends ALinkLabel {
        protected ActionListener mOpenFlow;

        public OpenFlowComponent() {
            super("Open flow...");
            this.mOpenFlow = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FlowWindow.this.mFlowTabs.selectAndOpenFlow();
                }
            };
            this.addActionListener(this.mOpenFlow);
        }
    }
}

