/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.flowman.ui;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.ui.ADropDownAction;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.AFloatWindow;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.flowman.Flow;
import com.sigrity.flowman.FlowWS;
import com.sigrity.flowman.ui.FlowPanel;
import com.sigrity.flowman.ui.FlowTree;
import com.sigrity.flowman.ui.editor.FlowStepEditorDlg;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.OrbitIcons;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.ToolTipManager;
import javax.swing.filechooser.FileFilter;

public class FlowWorkspacePanel
extends JPanel {
    protected List<Flow> mFlowList = new ArrayList<Flow>();
    protected FlowPanel mFlowPanel = null;
    protected FlowToolBar mFlowToolBar = null;
    private HashMap<Flow, FlowPanel> mFlowPanelMap = new HashMap();

    public FlowWorkspacePanel() {
        this.mFlowToolBar = new FlowToolBar();
        this.switchWorkspace(null);
    }

    public void selectAndOpenFlow() {
        URL url;
        AFileChooser fc = new AFileChooser();
        fc.addChoosableFileFilter((FileFilter)Flow.FILEFILTER_FLOWDEF);
        fc.setFileFilter((FileFilter)Flow.FILEFILTER_FLOWDEF);
        fc.setFileSelectionMode(0);
        fc.setMultiSelectionEnabled(false);
        if (fc.showOpenDialog((Component)this) != 0) {
            return;
        }
        File f = fc.getSelectedFile();
        if (f == null) {
            return;
        }
        URI uri = f.toURI();
        try {
            url = uri.toURL();
        }
        catch (MalformedURLException e1) {
            ALog.logError((Throwable)e1, (String)"Error reading flow definition '%s'.", (Object[])new Object[]{uri.toASCIIString()});
            return;
        }
        Flow flow = Flow.readFlow(url);
        if (flow == null) {
            return;
        }
        this.openFlow(flow);
    }

    public boolean openFlow(String url) {
        URL u;
        try {
            u = new URL(url);
        }
        catch (MalformedURLException e1) {
            ALog.logError((Throwable)e1, (String)"Error reading flow definition '%s', invalid URL.", (Object[])new Object[]{url});
            return false;
        }
        Flow flow = Flow.readFlow(u);
        if (flow == null) {
            return false;
        }
        return this.openFlow(flow);
    }

    public boolean openFlow(Flow flow) {
        this.addFlow(flow);
        try {
            FlowWS.addRecentFlow(flow.getSource().toURI().toURL().toString());
        }
        catch (MalformedURLException | URISyntaxException e) {
            ALog.logError((Throwable)e, (String)"Fail: add recent flow.", (Object[])new Object[0]);
        }
        this.switchWorkspace(flow);
        FlowWS.saveRecentFlowList(this.mFlowList);
        return true;
    }

    public void saveOpenedFlow() {
        FlowWS.saveRecentFlowList(this.mFlowList);
    }

    public Flow getCurrentFlow() {
        if (this.mFlowPanel == null) {
            return null;
        }
        return this.mFlowPanel.getFlow();
    }

    public void addFlow(Flow flow) {
        for (Flow f : AUtil.arrayList(this.mFlowList)) {
            if (!AUtil.equals((Object)f.getSource(), (Object)flow.getSource())) continue;
            this.mFlowList.remove(f);
        }
        this.mFlowList.add(0, flow);
        this.mFlowToolBar.mFlowCbBox.removeAllItems();
        for (Flow f : this.mFlowList) {
            this.mFlowToolBar.mFlowCbBox.addItem(f);
        }
    }

    public void removeFlow(Flow flow) {
        this.mFlowList.remove(flow);
        this.mFlowToolBar.mFlowCbBox.removeItem(flow);
        try {
            FlowWS.removeRecentFlow(flow.getSource().toURI().toURL().toString());
        }
        catch (Exception e) {
            ALog.logError((Throwable)e, (String)"Fail: remove recent flow.", (Object[])new Object[0]);
        }
        FlowWS.saveRecentFlowList(this.mFlowList);
    }

    public void switchWorkspace(Flow flow) {
        this.removeAll();
        GridBagManager l = new GridBagManager((Container)this);
        l.add((Component)this.mFlowToolBar, (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        if (flow == null) {
            l.add((Component)new JPanel(), (GridBagConstraints)GridBagManager.FILLALL);
        } else {
            this.mFlowPanel = this.mFlowPanelMap.computeIfAbsent(flow, FlowPanel::new);
            l.add((Component)this.mFlowPanel, (GridBagConstraints)GridBagManager.FILLALL);
            this.mFlowPanel.revalidate();
            this.mFlowPanel.repaint();
        }
        this.mFlowToolBar.setFlow(flow);
        this.revalidate();
    }

    private Flow getFirstFlow() {
        if (this.mFlowList.isEmpty()) {
            return null;
        }
        return this.mFlowList.get(0);
    }

    private class ActionResetFlowState
    extends AbstractAction {
        public ActionResetFlowState() {
            super("Reset State");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FlowWorkspacePanel.this.mFlowPanel != null) {
                FlowWorkspacePanel.this.mFlowPanel.resetState();
            }
        }
    }

    public class ActionRemoveCurrrentFlow
    extends AbstractAction {
        public ActionRemoveCurrrentFlow() {
            super("Delete", UIUtil.getScaledIcon((Icon)OrbitIcons.CROSS, (int)16, (int)16));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Flow currentFlow = FlowWorkspacePanel.this.getCurrentFlow();
            String title = String.format("Remove '%s' from Favorites?", currentFlow);
            int result = JOptionPane.showConfirmDialog(OrbitIO.getMainWindow(), title, "Warning", 0);
            if (result == 0) {
                FlowWorkspacePanel.this.removeFlow(currentFlow);
                FlowWorkspacePanel.this.saveOpenedFlow();
                FlowWorkspacePanel.this.switchWorkspace(FlowWorkspacePanel.this.getFirstFlow());
            }
        }
    }

    public class ActionFlowProperties
    extends AbstractAction {
        public ActionFlowProperties() {
            super("Details...", UIUtil.getScaledIcon((Icon)OrbitIcons.INFORMATION, (int)16, (int)16));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FlowWorkspacePanel.this.mFlowPanel == null) {
                return;
            }
            Flow flow = FlowWorkspacePanel.this.mFlowPanel.getFlow();
            String oldScriptLibrary = flow.getLibraryScript().trim();
            FlowStepEditorDlg ui = new FlowStepEditorDlg(UIUtil.getParentWindow((Component)FlowWorkspacePanel.this), flow);
            ui.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
            ui.setTitle(String.format("Edit %s", flow));
            ui.setVisible(true);
            if (ui.getSaved() && !oldScriptLibrary.equals(flow.getLibraryScript().trim())) {
                flow.evalLibraryScript();
            }
        }
    }

    public class ActionSaveFlow
    extends AbstractAction {
        protected boolean mAs;

        public ActionSaveFlow(boolean as) {
            super(as ? "Save As..." : "Save", as ? UIUtil.getScaledIcon((Icon)OrbitIcons.SAVE_AS_DISK, (int)16, (int)16) : UIUtil.getScaledIcon((Icon)OrbitIcons.SAVE_DISK, (int)16, (int)16));
            this.mAs = false;
            this.mAs = as;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FlowWorkspacePanel.this.mFlowPanel == null) {
                return;
            }
            Flow flow = FlowWorkspacePanel.this.mFlowPanel.getFlow();
            if (this.mAs || flow.getSource() == null) {
                AFileChooser fc = new AFileChooser();
                fc.addChoosableFileFilter((FileFilter)Flow.FILEFILTER_FLOWDEF);
                fc.setFileFilter((FileFilter)Flow.FILEFILTER_FLOWDEF);
                if (fc.showSaveDialog((Component)FlowWorkspacePanel.this) == 0) {
                    File f = fc.getSelectedFile();
                    URI uri = f.toURI();
                    try {
                        flow.write(uri.toURL());
                        ALog.logInfo((String)"Save flow '%s' to %s.", (Object[])new Object[]{flow.getName(), uri});
                    }
                    catch (MalformedURLException e1) {
                        ALog.logError((Throwable)e1, (String)"Error writing to file '%s'.", (Object[])new Object[]{uri.toString()});
                    }
                }
            } else {
                flow.write((URL)null);
                ALog.logInfo((String)"Save flow '%s' to %s.", (Object[])new Object[]{flow.getName(), flow.getSource()});
            }
            FlowWorkspacePanel.this.saveOpenedFlow();
        }
    }

    public class ActionSetFlowEditable
    extends AbstractAction {
        protected FlowTree mTree;

        public ActionSetFlowEditable() {
            super("Edit Mode", UIUtil.getScaledIcon((Icon)OrbitIcons.EDIT, (int)16, (int)16));
            this.mTree = null;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (FlowWorkspacePanel.this.mFlowPanel == null) {
                return;
            }
            this.mTree = FlowWorkspacePanel.this.mFlowPanel.mTree;
            if (!this.mTree.getEditMode()) {
                ALog.logInfo((String)"Starting Flow Step Edit Mode. Use right-click on Flow Step to modify detail.");
            }
            this.mTree.setEditMode(!this.mTree.getEditMode());
        }
    }

    public class ActionCloseFlow
    extends AbstractAction {
        protected FlowPanel mFlowPanel;

        public ActionCloseFlow(FlowPanel fp) {
            super("Close", AFloatWindow.ICON_CLOSE);
            this.mFlowPanel = null;
            this.mFlowPanel = fp;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FlowWorkspacePanel.this.remove(this.mFlowPanel);
            FlowWorkspacePanel.this.saveOpenedFlow();
        }
    }

    public class ActionOpenFlow
    extends AbstractAction {
        public ActionOpenFlow() {
            super("Open Flow...", UIUtil.getScaledIcon((Icon)OrbitIcons.FILE_OPEN, (int)16, (int)16));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FlowWorkspacePanel.this.selectAndOpenFlow();
        }
    }

    public class ActionCopyFlow
    extends AbstractAction {
        public ActionCopyFlow() {
            super("Copy Current Flow", UIUtil.getScaledIcon((Icon)OrbitIcons.COPY_FILE, (int)16, (int)16));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Flow tmpFlow = new Flow();
            Flow copyedFlow = FlowWorkspacePanel.this.getCurrentFlow();
            if (copyedFlow == null) {
                ALog.logError((String)"Cannot copy the non-source flow. Please save current flow.");
                return;
            }
            tmpFlow.read(copyedFlow.getSource());
            FlowStepEditorDlg ui = new FlowStepEditorDlg(UIUtil.getParentWindow((Component)FlowWorkspacePanel.this), tmpFlow);
            ui.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
            ui.setVisible(true);
            if (!ui.getSaved()) {
                return;
            }
            AFileChooser fc = new AFileChooser();
            fc.addChoosableFileFilter((FileFilter)Flow.FILEFILTER_FLOWDEF);
            fc.setFileFilter((FileFilter)Flow.FILEFILTER_FLOWDEF);
            if (fc.showSaveDialog((Component)FlowWorkspacePanel.this) == 0) {
                File f = fc.getSelectedFile();
                URI uri = f.toURI();
                try {
                    tmpFlow.write(uri.toURL());
                    FlowWorkspacePanel.this.openFlow(tmpFlow);
                }
                catch (MalformedURLException e1) {
                    ALog.logError((Throwable)e1, (String)"Error writing to file '%s'.", (Object[])new Object[]{uri.toString()});
                }
            }
        }
    }

    public class ActionNewFlow
    extends AbstractAction {
        public ActionNewFlow() {
            super("New Flow", UIUtil.getScaledIcon((Icon)OrbitIcons.NEW_FILE, (int)16, (int)16));
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Flow tmpFlow = new Flow();
            FlowStepEditorDlg ui = new FlowStepEditorDlg(UIUtil.getParentWindow((Component)FlowWorkspacePanel.this), tmpFlow);
            ui.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
            ui.setVisible(true);
            if (!ui.getSaved()) {
                return;
            }
            AFileChooser fc = new AFileChooser();
            fc.addChoosableFileFilter((FileFilter)Flow.FILEFILTER_FLOWDEF);
            fc.setFileFilter((FileFilter)Flow.FILEFILTER_FLOWDEF);
            if (fc.showSaveDialog((Component)FlowWorkspacePanel.this) == 0) {
                File f = fc.getSelectedFile();
                URI uri = f.toURI();
                try {
                    tmpFlow.write(uri.toURL());
                    FlowWorkspacePanel.this.openFlow(tmpFlow);
                }
                catch (MalformedURLException e1) {
                    ALog.logError((Throwable)e1, (String)"Error writing to file '%s'.", (Object[])new Object[]{uri.toString()});
                }
            }
        }
    }

    public class FlowToolBar
    extends JPanel {
        protected JComboBox<Flow> mFlowCbBox;

        public FlowToolBar() {
            GridBagManager l = new GridBagManager((Container)this);
            this.mFlowCbBox = new JComboBox<Flow>(){

                @Override
                public String getToolTipText() {
                    Flow flow = (Flow)FlowToolBar.this.mFlowCbBox.getSelectedItem();
                    if (flow != null) {
                        return "<html>" + flow.getSource().toString() + "<br><br>" + flow.getDesc() + "</html>";
                    }
                    return "Select Flow";
                }
            };
            this.mFlowCbBox.setRenderer(new FlowRenderer());
            this.mFlowCbBox.addItemListener(e -> FlowWorkspacePanel.this.switchWorkspace((Flow)e.getItem()));
            Flow.addFlowListener(new Flow.FlowListener(){

                @Override
                public void dirtyChanged(Flow f) {
                    FlowToolBar.this.mFlowCbBox.revalidate();
                    FlowToolBar.this.mFlowCbBox.repaint();
                }
            });
            ToolTipManager.sharedInstance().registerComponent(this.mFlowCbBox);
            l.add(this.mFlowCbBox, (GridBagConstraints)GridBagManager.FILLALL.width(9));
            JPopupMenu menu = new JPopupMenu();
            menu.add(new ActionOpenFlow());
            menu.add(new ActionNewFlow());
            menu.add(new ActionCopyFlow());
            menu.addSeparator();
            menu.add(new ActionSaveFlow(false));
            menu.add(new ActionSaveFlow(true));
            menu.add(new ActionSetFlowEditable());
            menu.addSeparator();
            menu.add(new ActionRemoveCurrrentFlow());
            menu.addSeparator();
            menu.add(new ActionResetFlowState());
            menu.addSeparator();
            menu.add(new ActionFlowProperties());
            JButton b = new JButton(new ActionOpenFlow());
            b.setIcon(OrbitIcons.FILE_OPEN);
            b.setText("");
            UIUtil.makeToolBarButton((AbstractButton)b);
            this.addHeadButton(l, b, "Open Flow");
            JButton dropBtn = ADropDownAction.makeButton((JPopupMenu)menu, (AbstractButton)b);
            this.addHeadButton(l, dropBtn, "More");
        }

        protected <T extends AbstractButton> void addHeadButton(GridBagManager l, T b, String tooltip) {
            l.add(b, (GridBagConstraints)GridBagManager.LEFT.noInsets());
            b.setMargin(new Insets(0, 0, 0, 0));
            b.setToolTipText(tooltip);
        }

        public void setFlow(Flow flow) {
            this.mFlowCbBox.setSelectedItem(flow);
        }
    }

    private static class FlowRenderer
    extends DefaultListCellRenderer {
        private FlowRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Component c = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            if (value instanceof Flow) {
                Flow flow = (Flow)value;
                this.setText((String)(flow.getDirty() ? "*" + flow.getName() : flow.getName()));
                this.setToolTipText(flow.getDesc());
                this.setIcon(flow.getSmallIcon());
            } else {
                this.setText("New...");
            }
            return c;
        }
    }
}

