/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.flowman.ui.editor;

import com.sigrity.acl.ui.AUiStandards;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.flowman.FlowStep;
import com.sigrity.flowman.ui.editor.FlowStepEditorRegistry;
import com.sigrity.flowman.ui.editor.FlowStepSubEditor;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;

public class FlowStepEditorPanel
extends JPanel {
    protected FlowStep mStep;
    protected JLabel mTypeLabel;
    protected JTextField mTxtName;
    protected JTextField mTxtDesc;
    protected JTextPane mTxtHelp;
    protected FlowStepSubEditor mSubEditor;

    public FlowStepEditorPanel(FlowStep step) {
        this.mStep = step;
        GridBagManager l = GridBagManager.layout((Container)this);
        l.add("Type:");
        this.mTypeLabel = l.add(step.getClass().getSimpleName());
        l.newline();
        l.add("Name:");
        this.mTxtName = (JTextField)l.add((Component)new JTextField(AUiStandards.getColumnsId()), (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        l.add("Description:");
        this.mTxtDesc = (JTextField)l.add((Component)new JTextField(), (GridBagConstraints)GridBagManager.FILLX);
        l.newline();
        l.add("Help:", (GridBagConstraints)GridBagManager.TOPLEFT);
        this.mTxtHelp = new JTextPane();
        JScrollPane spHelp = new JScrollPane(this.mTxtHelp, 20, 30);
        l.add((Component)spHelp, (GridBagConstraints)GridBagManager.FILLX);
        Dimension d = spHelp.getPreferredSize();
        spHelp.setPreferredSize(new Dimension(d.width, d.height * 2));
        l.newline();
        this.mSubEditor = FlowStepEditorRegistry.getEditorFor(this.mStep);
        if (this.mSubEditor == null) {
            this.mSubEditor = new NonEditingSubEditor(this.mStep);
        }
        this.mSubEditor.layout(l);
        l.newline();
        this.setMinimumSize(this.getPreferredSize());
        this.populateData();
    }

    public FlowStep getFlowStep() {
        return this.mStep;
    }

    public boolean isModified() {
        if (!this.mTxtName.getText().equals(this.mStep.getName())) {
            return true;
        }
        if (!this.mTxtDesc.getText().equals(this.mStep.getDesc())) {
            return true;
        }
        if (!this.mTxtHelp.getText().equals(this.mStep.getHelp())) {
            return true;
        }
        if (this.mTypeLabel.getIcon() != this.mStep.getValue("SmallIcon")) {
            return true;
        }
        return this.mSubEditor.isModified();
    }

    public boolean saveData() {
        this.mStep.putValue("Name", this.mTxtName.getText());
        this.mStep.putValue("ShortDescription", this.mTxtDesc.getText());
        this.mStep.putValue("LongDescription", this.mTxtHelp.getText());
        this.mStep.putValue("SmallIcon", this.mTypeLabel.getIcon());
        if (this.mStep.getFlow() != null) {
            this.mStep.getFlow().setDirty(true);
        }
        return this.mSubEditor.saveData();
    }

    protected void populateData() {
        this.mTxtName.setText(this.mStep.getName());
        this.mTxtDesc.setText(this.mStep.getDesc());
        this.mTxtHelp.setText(this.mStep.getHelp());
        this.mTypeLabel.setIcon((Icon)this.mStep.getValue("SmallIcon"));
        this.mSubEditor.populateData();
    }

    protected static class NonEditingSubEditor
    extends FlowStepSubEditor {
        public NonEditingSubEditor(FlowStep step) {
            super(step);
        }

        @Override
        public boolean canEdit(FlowStep step) {
            return true;
        }

        @Override
        public boolean isModified() {
            return false;
        }

        @Override
        public void populateData() {
        }

        @Override
        public boolean saveData() {
            return true;
        }

        @Override
        public void layout(GridBagManager l) {
        }
    }
}

