/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.flowman.ui.editor;

import com.sigrity.acl.ALog;
import com.sigrity.flowman.FlowStep;
import com.sigrity.flowman.ui.editor.FlowStepSubEditor;
import com.sigrity.flowman.ui.editor.StandardFlowStepEditors;
import java.lang.reflect.Constructor;
import java.util.HashMap;

public class FlowStepEditorRegistry {
    protected static HashMap<Class<? extends FlowStep>, Class<? extends FlowStepSubEditor>> mEditors = new HashMap();

    public static FlowStepSubEditor getEditorFor(FlowStep step) {
        Class<? extends FlowStepSubEditor> fseClass = mEditors.get(step.getClass());
        if (fseClass == null) {
            return null;
        }
        try {
            Constructor<? extends FlowStepSubEditor> ctor = fseClass.getConstructor(FlowStep.class);
            return ctor.newInstance(step);
        }
        catch (Exception e) {
            ALog.logError((Throwable)e, (String)"Unable to instantiate flow step editor '%s' for flow step of class'%s'.", (Object[])new Object[]{fseClass.getName(), step.getClass().getName()});
            return null;
        }
    }

    public static void register(Class<? extends FlowStep> stepClass, Class<? extends FlowStepSubEditor> editorClass) {
        mEditors.put(stepClass, editorClass);
    }

    static {
        StandardFlowStepEditors.registerStandardEditors();
    }
}

