/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.flowman.ui.editor;

import com.sigrity.acl.ui.ABshEditorPane;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.flowman.Flow;
import com.sigrity.flowman.FlowStep;
import com.sigrity.flowman.step.Choice;
import com.sigrity.flowman.step.Group;
import com.sigrity.flowman.step.Sequence;
import com.sigrity.flowman.step.Simple;
import com.sigrity.flowman.ui.editor.FlowStepEditorRegistry;
import com.sigrity.flowman.ui.editor.FlowStepSubEditor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;

public class StandardFlowStepEditors {
    public static void registerStandardEditors() {
        FlowStepEditorRegistry.register(Flow.class, FlowPropertiesEditUI.class);
        FlowStepEditorRegistry.register(Simple.class, SimpleStepEditUI.class);
        FlowStepEditorRegistry.register(Group.class, GroupStepEditUI.class);
        FlowStepEditorRegistry.register(Choice.class, GroupStepEditUI.class);
        FlowStepEditorRegistry.register(Sequence.class, GroupStepEditUI.class);
    }

    public static class FlowPropertiesEditUI
    extends FlowStepSubEditor {
        protected ABshEditorPane mEditorScriptLibrary;
        protected ABshEditorPane mEditorScriptPrereq;

        public FlowPropertiesEditUI(FlowStep step) {
            super(step);
        }

        @Override
        public boolean canEdit(FlowStep step) {
            return true;
        }

        @Override
        public void populateData() {
            Flow flow = this.getStep();
            String scriptLibrary = flow.getLibraryScript();
            this.mEditorScriptLibrary.setText(scriptLibrary.trim());
            String scriptPrereq = flow.getPrereqScript();
            this.mEditorScriptPrereq.setText(scriptPrereq.trim());
        }

        @Override
        public boolean isModified() {
            Flow flow = this.getStep();
            return !this.mEditorScriptLibrary.getText().equals(flow.getLibraryScript().trim()) || !this.mEditorScriptPrereq.getText().equals(flow.getPrereqScript().trim());
        }

        @Override
        public boolean saveData() {
            Flow flow = this.getStep();
            flow.setLibraryScript(this.mEditorScriptLibrary.getText());
            flow.setPrereqScript(this.mEditorScriptPrereq.getText());
            return true;
        }

        public Flow getStep() {
            return (Flow)this.mStep;
        }

        @Override
        public void layout(GridBagManager l) {
            JLabel lbl = l.add("Script Library:", (GridBagConstraints)GridBagManager.TOPLEFT);
            lbl.setToolTipText("Script to run during flow load; may define methods to be called by the flow");
            this.mEditorScriptLibrary = (ABshEditorPane)l.addScroll((Component)new ABshEditorPane(), (GridBagConstraints)GridBagManager.FILLALL);
            l.newline();
            lbl = l.add("Prerequisite:", (GridBagConstraints)GridBagManager.TOPLEFT);
            lbl.setToolTipText("The script to run to determine if flow prerequisites are met(return false to to disable the flow");
            this.mEditorScriptPrereq = (ABshEditorPane)l.addScroll((Component)new ABshEditorPane(), (GridBagConstraints)GridBagManager.FILLALL);
        }
    }

    public static class GroupStepEditUI
    extends FlowStepSubEditor {
        protected JList<FlowStep> mSubsteps;

        public GroupStepEditUI(FlowStep step) {
            super(step);
        }

        @Override
        public boolean canEdit(FlowStep step) {
            return step instanceof Group;
        }

        @Override
        public void populateData() {
            DefaultListModel lm = (DefaultListModel)this.mSubsteps.getModel();
            lm.clear();
            for (FlowStep step : this.getStep().getSteps()) {
                lm.addElement(step);
            }
        }

        @Override
        public boolean isModified() {
            return false;
        }

        @Override
        public boolean saveData() {
            return true;
        }

        public Group getStep() {
            return (Group)this.mStep;
        }

        @Override
        public void layout(GridBagManager l) {
            l.add("Contains:", (GridBagConstraints)GridBagManager.TOPLEFT);
            this.mSubsteps = (JList)l.addScroll(new JList(new DefaultListModel()), (GridBagConstraints)GridBagManager.FILLALL);
            this.mSubsteps.setSelectionMode(0);
            this.mSubsteps.setCellRenderer(new CellRenderer());
        }

        protected static class CellRenderer
        extends DefaultListCellRenderer {
            protected CellRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                FlowStep step = (FlowStep)value;
                this.setText(step.getName());
                this.setToolTipText(step.getDesc());
                return this;
            }
        }
    }

    public static class SimpleStepEditUI
    extends FlowStepSubEditor {
        protected ABshEditorPane mEditorScript;
        protected ABshEditorPane mEditorScriptEnabled;

        public SimpleStepEditUI(FlowStep step) {
            super(step);
        }

        @Override
        public boolean canEdit(FlowStep step) {
            return step instanceof Simple;
        }

        @Override
        public void populateData() {
            Simple step = this.getStep();
            String script = step.getScript();
            this.mEditorScript.setText(script.trim());
            String scriptEnabled = step.getEnabledScript();
            this.mEditorScriptEnabled.setText(scriptEnabled.trim());
        }

        @Override
        public boolean isModified() {
            Simple step = this.getStep();
            return !this.mEditorScript.getText().equals(step.getScript().trim()) || !this.mEditorScriptEnabled.getText().equals(step.getEnabledScript().trim());
        }

        @Override
        public boolean saveData() {
            Simple step = this.getStep();
            step.setScript(this.mEditorScript.getText());
            step.setEnabledScript(this.mEditorScriptEnabled.getText());
            return true;
        }

        public Simple getStep() {
            return (Simple)this.mStep;
        }

        @Override
        public void layout(GridBagManager l) {
            JLabel lbl = l.add("Action script:", (GridBagConstraints)GridBagManager.TOPLEFT);
            lbl.setToolTipText("The script to run when the step is activated");
            this.mEditorScript = (ABshEditorPane)l.addScroll((Component)new ABshEditorPane(), (GridBagConstraints)GridBagManager.FILLALL);
            l.newline();
            lbl = l.add("Enabled script:", (GridBagConstraints)GridBagManager.TOPLEFT);
            lbl.setToolTipText("The script to run to determine if the step is enabled (return true to enable");
            this.mEditorScriptEnabled = (ABshEditorPane)l.addScroll((Component)new ABshEditorPane(), (GridBagConstraints)GridBagManager.FILLALL);
        }
    }
}

