/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit;

import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.RegexFilterField;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.lic.LSession;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HDLView;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.SchemView;
import com.sigrity.orbit.ui.OrbitIcons;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;

public class AbstractView
extends DbDialog {
    JScrollPane scrollPane;
    JEditorPane verilogPane;
    RegexFilterField findField;
    LinkedList<Rectangle> views = new LinkedList();
    protected ActionListener mNextResultAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    };
    protected ActionListener mPrevResultAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    };
    protected RegexFilterField.FilterListener mFilterListener = new RegexFilterField.FilterListener(){

        public void filter(Pattern pattern) {
            if (pattern != null) {
                // empty if block
            }
        }
    };

    public static AbstractView create(Window owner, AAppView view, String dPathString) {
        AbstractView abstractView;
        DevicePath dPath = DevicePath.fromString((Db)OrbitIO.getCurDb(), (String)dPathString);
        try {
            abstractView = new AbstractView(view, owner, dPath);
        }
        catch (Exception e) {
            return null;
        }
        abstractView.setVisible(true);
        return abstractView;
    }

    protected AbstractView(AAppView view, Component owner, DevicePath dPath) throws LSession.NoLicenseException {
        super(view.getDb(), owner);
        try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)this.mDb, (String)"Initialize IOView");){
            this.init(dPath);
        }
    }

    protected void init(DevicePath path) {
        this.setTitle("HDLView " + path.toString());
        GridBagManager l = new GridBagManager(this.getContentPane());
        l.push((Container)new JPanel(), (GridBagConstraints)GridBagManager.FILLALL);
        l.pushFillX();
        l.add("Find: ");
        this.findField = (RegexFilterField)l.add((Component)new RegexFilterField(this.mFilterListener), (GridBagConstraints)GridBagManager.FILLX.noInsets());
        JButton nextResult = new JButton();
        nextResult.setIcon(OrbitIcons.SRCH_NEXT);
        nextResult.setMargin(new Insets(0, 0, 0, 0));
        nextResult.addActionListener(this.mNextResultAction);
        l.add((Component)nextResult);
        JButton prevResult = new JButton();
        prevResult.setIcon(OrbitIcons.SRCH_PREV);
        prevResult.setMargin(new Insets(0, 0, 0, 0));
        prevResult.addActionListener(this.mPrevResultAction);
        l.add((Component)prevResult);
        JLabel findResults = new JLabel("");
        l.add((Component)findResults);
        l.popNl();
        l.pushFill();
        this.verilogPane = new HDLView(path);
        JScrollPane scolledVerilogPane = new JScrollPane(this.verilogPane);
        scolledVerilogPane.setPreferredSize(new Dimension(500, 500));
        SchemView schemView = new SchemView();
        schemView.setPath(path);
        JSplitPane splitPane = new JSplitPane(0, scolledVerilogPane, schemView);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(150);
        l.add((Component)splitPane, (GridBagConstraints)GridBagManager.FILLALL);
        l.popNl();
        l.pushFillX();
        l.addFillX();
        JButton btnClose = new JButton("Close");
        UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, null);
        l.add((Component)btnClose, (GridBagConstraints)GridBagManager.RIGHT_REMAINX);
        l.popNl();
        this.setResizable(true);
        this.pack();
        UIUtil.center((Component)((Object)this));
        this.verilogPane.requestFocusInWindow();
        this.verilogPane.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        this.verilogPane.setCaretPosition(0);
        schemView.start();
    }
}

