/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.MutableBoolean;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Text;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.ARect;
import com.sigrity.acl.xml.AXDomUtil;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ArrowXMLRead {
    private static String ContactContextName = "ArrowXML";

    public static void parseArrowXML(String pathName, String brdName) {
        File f = new File(pathName);
        if (!f.canRead()) {
            ALog.logError((String)("Can not open " + f.getAbsolutePath() + " for reading"));
            return;
        }
        Element xeRoot = AXDomUtil.getDocumentElement((File)f);
        if (xeRoot == null) {
            return;
        }
        for (Element xeDrawing : AXDomUtil.getChildElems((Node)xeRoot, (String)"drawing")) {
            boolean board = AXDomUtil.checkIfElementExists((Element)xeDrawing, (String)"board", (String)"");
            if (board) {
                ArrowXMLRead.parseBrdXML(pathName, brdName);
                return;
            }
            ArrowXMLRead.parseLibXML(pathName);
        }
    }

    public static void parseBrdXML(String pathName, String brdName) {
        int dimLayer = 0;
        File f = new File(pathName);
        Db db = OrbitIO.getCurDb();
        Design currentDesign = Design.getDesign((Db)db);
        double designDbuPerMicron = Design.getUnitDistDbuPerMicron((Db)db);
        Unit unit = new Unit("mm", designDbuPerMicron * 1000.0);
        if (!f.canRead()) {
            ALog.logError((String)("Can not open " + f.getAbsolutePath() + " for reading"));
            return;
        }
        Element xeRoot = AXDomUtil.getDocumentElement((File)f);
        if (xeRoot == null) {
            return;
        }
        Substrate s = Substrate.create((Db)OrbitIO.getCurDb(), (String)brdName);
        long sHeight = 0L;
        for (Element xeDrawing : AXDomUtil.getChildElems((Node)xeRoot, (String)"drawing")) {
            for (Element xeLayers : AXDomUtil.getChildElems((Node)xeDrawing, (String)"layers")) {
                for (Object xeLayer : AXDomUtil.getChildElems((Node)xeLayers, (String)"layer")) {
                    String name;
                    String visible;
                    if (xeLayer.getAttribute("name").equals("Dimension")) {
                        dimLayer = Integer.parseInt(xeLayer.getAttribute("number"));
                    }
                    if ((visible = xeLayer.getAttribute("visible")) == null || !visible.equals("yes") || (name = xeLayer.getAttribute("name")) == null || name.isEmpty()) continue;
                    Layer l = Layer.create((Substrate)s, (String)name);
                    l.setHeight(1000000L);
                    sHeight += l.getHeight();
                }
            }
            s.setHeight(sHeight);
            for (Element xeBoard : AXDomUtil.getChildElems((Node)xeDrawing, (String)"board")) {
                Object xeLayer;
                DeviceTemplate dtParent = DeviceTemplate.create((Substrate)s, (String)brdName, (boolean)true);
                for (Element xePlain : AXDomUtil.getChildElems((Node)xeBoard, (String)"plain")) {
                    ARect bounds = null;
                    for (Element xeWire : AXDomUtil.getChildElems((Node)xePlain, (String)"wire")) {
                        if (Integer.parseInt(xeWire.getAttribute("layer")) != dimLayer) continue;
                        long x1 = unit.fromUser(Double.parseDouble(xeWire.getAttribute("x1")));
                        long x2 = unit.fromUser(Double.parseDouble(xeWire.getAttribute("x2")));
                        long y1 = unit.fromUser(Double.parseDouble(xeWire.getAttribute("y1")));
                        long y2 = unit.fromUser(Double.parseDouble(xeWire.getAttribute("y2")));
                        long xMin = Math.min(x1, x2);
                        long yMin = Math.min(y1, y2);
                        long xMax = Math.max(x1, x2);
                        long yMax = Math.max(y1, y2);
                        ARect r = new ARect(xMin, yMin, xMax, yMax);
                        if (bounds == null) {
                            bounds = new ARect(new ARect(r));
                            continue;
                        }
                        bounds.expand(r);
                    }
                    dtParent.setBounds(bounds);
                    dtParent.setType(DeviceTemplate.Type.BOARD);
                    Device.create((String)brdName, (DeviceTemplate)dtParent, (DeviceTemplate)currentDesign);
                    for (Element xeText : AXDomUtil.getChildElems((Node)xePlain, (String)"text")) {
                        DeviceTemplate dtTextParent = s.getDeviceTemplate(brdName);
                        String textValue = xeText.getTextContent();
                        String textX = xeText.getAttribute("x");
                        String textY = xeText.getAttribute("y");
                        String textLayerStr = ArrowXMLRead.getLayerName(xeText.getAttribute("layer"), f);
                        Layer textLayer = s.getLayer(textLayerStr);
                        long x = unit.fromUser(Double.parseDouble(textX));
                        long y = unit.fromUser(Double.parseDouble(textY));
                        APoint2D loc = new APoint2D(x, y);
                        if (textLayer == null) continue;
                        Text text = Text.create((DbObject)dtTextParent, (Layer)textLayer, (String)textValue);
                        text.setHeight(Long.MIN_VALUE);
                        Text.PlacementType pType = Text.PlacementType.Manual;
                        text.setPlaceType(pType);
                        text.setLoc(loc);
                        if (xeText.getAttribute("rot").equals("R90")) {
                            text.setRotate(270.0f);
                            continue;
                        }
                        if (xeText.getAttribute("rot").equals("R180")) {
                            text.setRotate(180.0f);
                            continue;
                        }
                        if (xeText.getAttribute("rot").equals("R270")) {
                            text.setRotate(90.0f);
                            continue;
                        }
                        if (xeText.getAttribute("rot").equals("MR90")) {
                            text.setRotate(270.0f);
                            text.setMirror(true);
                            continue;
                        }
                        if (xeText.getAttribute("rot").equals("MR180")) {
                            text.setRotate(180.0f);
                            text.setMirror(true);
                            continue;
                        }
                        if (!xeText.getAttribute("rot").equals("MR270")) continue;
                        text.setRotate(90.0f);
                        text.setMirror(true);
                    }
                }
                xeLayer = AXDomUtil.getChildElems((Node)xeBoard, (String)"libraries").iterator();
                while (xeLayer.hasNext()) {
                    Element xeLibraries = (Element)xeLayer.next();
                    for (Object xeLibrary : AXDomUtil.getChildElems((Node)xeLibraries, (String)"library")) {
                        for (Element xePackages : AXDomUtil.getChildElems((Node)xeLibrary, (String)"packages")) {
                            for (Element xePackage : AXDomUtil.getChildElems((Node)xePackages, (String)"package")) {
                                PinTemplate pinTemplate;
                                long y;
                                long x;
                                String pinY;
                                String pinX;
                                String pinName;
                                ARect bounds = null;
                                for (Element xeWire : AXDomUtil.getChildElems((Node)xePackage, (String)"wire")) {
                                    long x1 = unit.fromUser(Double.parseDouble(xeWire.getAttribute("x1")));
                                    long x2 = unit.fromUser(Double.parseDouble(xeWire.getAttribute("x2")));
                                    long y1 = unit.fromUser(Double.parseDouble(xeWire.getAttribute("y1")));
                                    long y2 = unit.fromUser(Double.parseDouble(xeWire.getAttribute("y2")));
                                    long xMin = Math.min(x1, x2);
                                    long yMin = Math.min(y1, y2);
                                    long xMax = Math.max(x1, x2);
                                    long yMax = Math.max(y1, y2);
                                    ARect r = new ARect(xMin, yMin, xMax, yMax);
                                    if (bounds == null) {
                                        bounds = new ARect(new ARect(r));
                                        continue;
                                    }
                                    bounds.expand(r);
                                }
                                DeviceTemplate dt = DeviceTemplate.create((Substrate)s, (String)xePackage.getAttribute("name"), (boolean)true);
                                dt.setType(DeviceTemplate.Type.PACKAGEDDIE);
                                dt.setBounds(bounds);
                                for (Element xePad : AXDomUtil.getChildElems((Node)xePackage, (String)"pad")) {
                                    pinName = xePad.getAttribute("name");
                                    pinX = xePad.getAttribute("x");
                                    pinY = xePad.getAttribute("y");
                                    String diam = xePad.getAttribute("diameter");
                                    if (diam == null || diam.isEmpty()) {
                                        diam = xePad.getAttribute("drill");
                                    }
                                    long radius = unit.fromUser(Double.parseDouble(diam));
                                    x = unit.fromUser(Double.parseDouble(pinX));
                                    y = unit.fromUser(Double.parseDouble(pinY));
                                    pinTemplate = PinTemplate.create((Net)dt.getNetUnused(), (String)pinName);
                                    pinTemplate.setLoc(new APoint2D(x, y));
                                    ACircle c = new ACircle(0L, 0L, radius /= 2L);
                                    ArrayList<LayerShape> shapes = new ArrayList<LayerShape>();
                                    for (Layer l : s.getLayers()) {
                                        LayerShape ls = LayerShape.create(null, (Layer)l, null, (AGeom)c);
                                        shapes.add(ls);
                                    }
                                    MutableBoolean created = new MutableBoolean();
                                    PadTemplate padTemplate = PadTemplate.getEquiv((Db)db, (String)ContactContextName, (Substrate)s, shapes, (String)dt.getName(), (MutableBoolean)created);
                                    pinTemplate.setPadTemplate(padTemplate);
                                    pinTemplate.setRotate(90.0f);
                                }
                                for (Element xeSMD : AXDomUtil.getChildElems((Node)xePackage, (String)"smd")) {
                                    pinName = xeSMD.getAttribute("name");
                                    pinX = xeSMD.getAttribute("x");
                                    pinY = xeSMD.getAttribute("y");
                                    String pindx = xeSMD.getAttribute("dx");
                                    String pindy = xeSMD.getAttribute("dy");
                                    String rot = xeSMD.getAttribute("rot");
                                    x = unit.fromUser(Double.parseDouble(pinX));
                                    y = unit.fromUser(Double.parseDouble(pinY));
                                    pinTemplate = PinTemplate.create((Net)dt.getNetUnused(), (String)pinName);
                                    pinTemplate.setLoc(new APoint2D(x, y));
                                    long dx = unit.fromUser(Double.parseDouble(pindx));
                                    long dy = unit.fromUser(Double.parseDouble(pindy));
                                    Layer layer = s.getLayer("Top");
                                    ARect r = new ARect(-dx / 2L, -dy / 2L, dx / 2L, dy / 2L);
                                    ArrayList<LayerShape> shapes = new ArrayList<LayerShape>();
                                    LayerShape ls = LayerShape.create(null, (Layer)layer, null, (AGeom)r);
                                    shapes.add(ls);
                                    MutableBoolean created = new MutableBoolean();
                                    PadTemplate padTemplate = PadTemplate.getEquiv((Db)db, (String)ContactContextName, (Substrate)s, shapes, (String)dt.getName(), (MutableBoolean)created);
                                    pinTemplate.setPadTemplate(padTemplate);
                                    if (!rot.equals("R90")) continue;
                                    pinTemplate.setRotate(90.0f);
                                }
                            }
                        }
                    }
                }
                Layer topLayer = (Layer)s.getLayers(Layer.TopFirstSort).next();
                for (Element xeElements : AXDomUtil.getChildElems((Node)xeBoard, (String)"elements")) {
                    Object xeLibrary;
                    xeLibrary = AXDomUtil.getChildElems((Node)xeElements, (String)"element").iterator();
                    while (xeLibrary.hasNext()) {
                        Element xeElement = (Element)xeLibrary.next();
                        DeviceTemplate dt = DeviceTemplate.getDeviceTemplate((Substrate)s, (String)xeElement.getAttribute("package"));
                        Device d = Device.create((String)xeElement.getAttribute("name"), (DeviceTemplate)dt, (DeviceTemplate)dtParent);
                        long deviceX = unit.fromUser(Double.parseDouble(xeElement.getAttribute("x")));
                        long deviceY = unit.fromUser(Double.parseDouble(xeElement.getAttribute("y")));
                        APoint2D devLoc = new APoint2D(deviceX, deviceY);
                        d.setLoc(devLoc);
                        if (xeElement.getAttribute("rot").equals("R90")) {
                            d.setRotate(270.0f);
                        } else if (xeElement.getAttribute("rot").equals("R180")) {
                            d.setRotate(180.0f);
                        } else if (xeElement.getAttribute("rot").equals("R270")) {
                            d.setRotate(90.0f);
                        } else if (xeElement.getAttribute("rot").equals("MR90")) {
                            d.setRotate(270.0f);
                            d.setMirror(true);
                        } else if (xeElement.getAttribute("rot").equals("MR180")) {
                            d.setRotate(180.0f);
                            d.setMirror(true);
                        } else if (xeElement.getAttribute("rot").equals("MR270")) {
                            d.setRotate(90.0f);
                            d.setMirror(true);
                        }
                        dt.setValue("height", (Object)1000000L);
                        d.setMountLayer(topLayer);
                    }
                }
                for (Element xeSignals : AXDomUtil.getChildElems((Node)xeBoard, (String)"signals")) {
                    DeviceTemplate dtBoard = DeviceTemplate.getDeviceTemplate((Substrate)s, (String)brdName);
                    for (Element xeSignal : AXDomUtil.getChildElems((Node)xeSignals, (String)"signal")) {
                        String netName = xeSignal.getAttribute("name");
                        Net boardNet = dtBoard.createNet(netName);
                        for (Element xeContactRef : AXDomUtil.getChildElems((Node)xeSignal, (String)"contactref")) {
                            String padName;
                            String deviceName = xeContactRef.getAttribute("element");
                            Device device = dtBoard.getChild(deviceName);
                            if (device == null) continue;
                            DeviceTemplate dt = device.getTemplate();
                            PinTemplate pt = dt.getPinByName(padName = xeContactRef.getAttribute("pad"));
                            Net deviceNet = pt.getNet();
                            if (deviceNet.isUnused()) {
                                deviceNet = dt.getNet(padName);
                                if (deviceNet == null) {
                                    deviceNet = dt.createNet(padName);
                                }
                                pt.setNet(deviceNet);
                            }
                            NetMap.mapChildNet((Device)device, (Net)deviceNet, (Net)boardNet);
                        }
                        for (Element xeWire : AXDomUtil.getChildElems((Node)xeSignal, (String)"wire")) {
                            long x1 = unit.fromUser(Double.parseDouble(xeWire.getAttribute("x1")));
                            long x2 = unit.fromUser(Double.parseDouble(xeWire.getAttribute("x2")));
                            long y1 = unit.fromUser(Double.parseDouble(xeWire.getAttribute("y1")));
                            long y2 = unit.fromUser(Double.parseDouble(xeWire.getAttribute("y2")));
                            long width = unit.fromUser(Double.parseDouble(xeWire.getAttribute("width")));
                            APath path = new APath(width);
                            path.addPoint(x1, y1);
                            path.addPoint(x2, y2);
                            String layerNum = xeWire.getAttribute("layer");
                            String layerName = ArrowXMLRead.getLayerName(layerNum, f);
                            if (layerName == null) continue;
                            Layer layer = s.getLayer(layerName);
                            Wire.create((Net)boardNet, (Layer)layer, (APath)path);
                        }
                    }
                }
            }
        }
        PadTemplate.releaseAdoptContext((Db)db, (String)ContactContextName);
    }

    public static String getLayerName(String layerNum, File f) {
        if (!f.canRead()) {
            ALog.logError((String)("Can not open " + f.getAbsolutePath() + " for reading"));
            return null;
        }
        Element xeRoot = AXDomUtil.getDocumentElement((File)f);
        if (xeRoot == null) {
            return null;
        }
        for (Element xeDrawing : AXDomUtil.getChildElems((Node)xeRoot, (String)"drawing")) {
            for (Element xeLayers : AXDomUtil.getChildElems((Node)xeDrawing, (String)"layers")) {
                for (Element xeLayer : AXDomUtil.getChildElems((Node)xeLayers, (String)"layer")) {
                    if (!xeLayer.getAttribute("number").equals(layerNum)) continue;
                    return xeLayer.getAttribute("name");
                }
            }
        }
        ALog.logError((String)"No layer name found for layer number '%s'", (Object[])new Object[]{layerNum});
        return null;
    }

    public static void parseLibXML(String pathName) {
        Db db = OrbitIO.getCurDb();
        double designDbuPerMicron = Design.getUnitDistDbuPerMicron((Db)db);
        Unit unit = new Unit("mm", designDbuPerMicron * 1000.0);
        File f = new File(pathName);
        if (!f.canRead()) {
            ALog.logError((String)("Can not open " + f.getAbsolutePath() + " for reading"));
            return;
        }
        Element xeRoot = AXDomUtil.getDocumentElement((File)f);
        if (xeRoot == null) {
            return;
        }
        Substrate s = Substrate.create((Db)OrbitIO.getCurDb(), (String)"eagle");
        for (Element xeDrawing : AXDomUtil.getChildElems((Node)xeRoot, (String)"drawing")) {
            for (Element xeLayers : AXDomUtil.getChildElems((Node)xeDrawing, (String)"layers")) {
                for (Element xeLayer : AXDomUtil.getChildElems((Node)xeLayers, (String)"layer")) {
                    String name;
                    String visible = xeLayer.getAttribute("visible");
                    if (visible == null || !visible.equals("yes") || (name = xeLayer.getAttribute("name")) == null || name.isEmpty()) continue;
                    Layer.create((Substrate)s, (String)name);
                }
            }
            for (Element xeLibrary : AXDomUtil.getChildElems((Node)xeDrawing, (String)"library")) {
                for (Element xePackages : AXDomUtil.getChildElems((Node)xeLibrary, (String)"packages")) {
                    for (Element xePackage : AXDomUtil.getChildElems((Node)xePackages, (String)"package")) {
                        PinTemplate pinTemplate;
                        long y;
                        long x;
                        String pinY;
                        String pinX;
                        String pinName;
                        String name = xePackage.getAttribute("name");
                        if (name == null || name.isEmpty()) continue;
                        ARect bounds = null;
                        for (Element xeWire : AXDomUtil.getChildElems((Node)xePackage, (String)"wire")) {
                            long x1 = unit.fromUser(Double.parseDouble(xeWire.getAttribute("x1")));
                            long x2 = unit.fromUser(Double.parseDouble(xeWire.getAttribute("x2")));
                            long y1 = unit.fromUser(Double.parseDouble(xeWire.getAttribute("y1")));
                            long y2 = unit.fromUser(Double.parseDouble(xeWire.getAttribute("y2")));
                            long xMin = Math.min(x1, x2);
                            long yMin = Math.min(y1, y2);
                            long xMax = Math.max(x1, x2);
                            long yMax = Math.max(y1, y2);
                            ARect r = new ARect(xMin, yMin, xMax, yMax);
                            if (bounds == null) {
                                bounds = new ARect(new ARect(r));
                                continue;
                            }
                            bounds.expand(r);
                        }
                        DeviceTemplate dt = DeviceTemplate.create((Substrate)s, (String)name, (boolean)true);
                        dt.setBounds(bounds);
                        dt.setType(DeviceTemplate.Type.PACKAGEDDIE);
                        for (Element xeSMD : AXDomUtil.getChildElems((Node)xePackage, (String)"smd")) {
                            pinName = xeSMD.getAttribute("name");
                            pinX = xeSMD.getAttribute("x");
                            pinY = xeSMD.getAttribute("y");
                            String pindx = xeSMD.getAttribute("dx");
                            String pindy = xeSMD.getAttribute("dy");
                            String rot = xeSMD.getAttribute("rot");
                            x = unit.fromUser(Double.parseDouble(pinX));
                            y = unit.fromUser(Double.parseDouble(pinY));
                            pinTemplate = PinTemplate.create((Net)dt.getNetUnused(), (String)pinName);
                            pinTemplate.setLoc(new APoint2D(x, y));
                            long dx = unit.fromUser(Double.parseDouble(pindx));
                            long dy = unit.fromUser(Double.parseDouble(pindy));
                            Layer layer = s.getLayer("Top");
                            ARect r = new ARect(-dx / 2L, -dy / 2L, dx / 2L, dy / 2L);
                            ArrayList<LayerShape> shapes = new ArrayList<LayerShape>();
                            LayerShape ls = LayerShape.create(null, (Layer)layer, null, (AGeom)r);
                            shapes.add(ls);
                            MutableBoolean created = new MutableBoolean();
                            PadTemplate padTemplate = PadTemplate.getEquiv((Db)db, (String)ContactContextName, (Substrate)s, shapes, (String)dt.getName(), (MutableBoolean)created);
                            System.out.println(x);
                            pinTemplate.setPadTemplate(padTemplate);
                            if (!rot.equals("R90")) continue;
                            pinTemplate.setRotate(90.0f);
                        }
                        for (Element xePad : AXDomUtil.getChildElems((Node)xePackage, (String)"pad")) {
                            pinName = xePad.getAttribute("name");
                            pinX = xePad.getAttribute("x");
                            pinY = xePad.getAttribute("y");
                            String diam = xePad.getAttribute("diameter");
                            if (diam == null || diam.isEmpty()) {
                                diam = xePad.getAttribute("drill");
                            }
                            long radius = unit.fromUser(Double.parseDouble(diam));
                            x = unit.fromUser(Double.parseDouble(pinX));
                            y = unit.fromUser(Double.parseDouble(pinY));
                            pinTemplate = PinTemplate.create((Net)dt.getNetUnused(), (String)pinName);
                            pinTemplate.setLoc(new APoint2D(x, y));
                            ACircle c = new ACircle(0L, 0L, radius /= 2L);
                            Layer layer = s.getLayer("Top");
                            ArrayList<LayerShape> shapes = new ArrayList<LayerShape>();
                            LayerShape ls = LayerShape.create(null, (Layer)layer, null, (AGeom)c);
                            shapes.add(ls);
                            MutableBoolean created = new MutableBoolean();
                            PadTemplate padTemplate = PadTemplate.getEquiv((Db)db, (String)ContactContextName, (Substrate)s, shapes, (String)dt.getName(), (MutableBoolean)created);
                            pinTemplate.setPadTemplate(padTemplate);
                            pinTemplate.setRotate(90.0f);
                        }
                    }
                }
            }
        }
        PadTemplate.releaseAdoptContext((Db)db, (String)ContactContextName);
    }

    public static void instantiateAll(String devicePathString) {
        DevicePath devicePath = DevicePath.fromEscapedString((Db)OrbitIO.getCurDb(), (String)devicePathString);
        if (devicePath == null) {
            ALog.logWarn((String)"DevicePath '%s' does not exist", (Object[])new Object[]{devicePathString});
            return;
        }
        DeviceTemplate dt = devicePath.getDeviceTemplate();
        Substrate s = dt.getSubstrate();
        LinkedList<DeviceTemplate> list = new LinkedList<DeviceTemplate>();
        for (DeviceTemplate part : AUtil.linkedList((Iterator)s.getDeviceTemplates())) {
            if (part == dt) continue;
            list.add(part);
        }
        int max = 900;
        long lastX = 0L;
        long maxY = 0L;
        for (DeviceTemplate part : list) {
            Device d = Device.create((String)part.getName(), (DeviceTemplate)part, (DeviceTemplate)dt);
            d.setLoc(new APoint2D(lastX, 0L));
            maxY = Math.max(part.getBB().height(), maxY);
            lastX += part.getBB().width() + 100L;
            if (--max >= 0) continue;
            return;
        }
        Device.scheduleManageAllUnplaceQs((Db)OrbitIO.getCurDb());
    }
}

