/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit;

import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.AVector;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPort;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.canvas_modes.AbstractViewMode;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JComponent;

public class BusView {
    protected Overlay overlay = null;
    protected boolean drawing = false;
    Db db;
    DesignView2D view;
    static BusView theBusView = null;
    HashSet<DevicePair> devicePairSet = new HashSet();

    private BusView() {
    }

    public static boolean isActive() {
        return theBusView != null;
    }

    public static void showBusView() {
        if (theBusView == null) {
            theBusView = new BusView();
        }
        BusView.theBusView.view = (DesignView2D)OrbitIO.getCurView();
        BusView.theBusView.db = OrbitIO.getCurDb();
        BusView.theBusView.devicePairSet.clear();
        theBusView.show();
    }

    public static void unShowBusView() {
        if (BusView.theBusView.overlay != null) {
            BusView.theBusView.view.removeOverlay(BusView.theBusView.overlay);
            BusView.theBusView.overlay = null;
            theBusView = null;
            OrbitIO.getApp().refreshCurrentView(true);
        }
    }

    protected void show() {
        this.derivePairs();
        this.deriveCenters();
        if (this.overlay == null) {
            this.overlay = new Overlay();
            this.view.addOverlay(this.overlay);
        } else {
            this.overlay.repaint();
        }
    }

    protected void deriveCenters() {
        for (DevicePair devicePair : this.devicePairSet) {
            if (devicePair.getSize() == 0) continue;
            double x0 = 0.0;
            double y0 = 0.0;
            double x1 = 0.0;
            double y1 = 0.0;
            for (PortPair pp : devicePair.pairs) {
                HierPort hpa = pp.a;
                HierPort hpb = pp.b;
                APoint2D pa = hpa.getWorldLoc();
                APoint2D pb = hpb.getWorldLoc();
                x0 += (double)pa.getX();
                y0 += (double)pa.getY();
                x1 += (double)pb.getX();
                y1 += (double)pb.getY();
            }
            devicePair.c1 = new APoint2D((long)(x0 /= (double)devicePair.getSize()), (long)(y0 /= (double)devicePair.getSize()));
            devicePair.c2 = new APoint2D((long)(x1 /= (double)devicePair.getSize()), (long)(y1 /= (double)devicePair.getSize()));
        }
    }

    protected void derivePairs() {
        ArrayList<DevicePath> deviceList = new ArrayList<DevicePath>();
        Design design = Design.getDesign((Db)this.db);
        Selection s = design.getCurSelection();
        for (DevicePath dp : design.getDescendantDevices()) {
            if (!s.contains((DbObject)dp.getLast())) continue;
            deviceList.add(dp);
        }
        int size = deviceList.size();
        for (int i = 0; i < size; ++i) {
            DevicePath dpA = (DevicePath)deviceList.get(i);
            for (int j = i + 1; j < size; ++j) {
                DevicePath dpB = (DevicePath)deviceList.get(j);
                DevicePair devicePair = this.derivePair(dpA, dpB);
                if (devicePair.getSize() <= 2) continue;
                this.devicePairSet.add(devicePair);
            }
        }
    }

    protected DevicePair derivePair(DevicePath a, DevicePath b) {
        Net topNet;
        DevicePair devicePair = new DevicePair();
        devicePair.p1 = a;
        devicePair.p2 = b;
        HashMap<Net, HierPort> netToHierPort = new HashMap<Net, HierPort>();
        HashSet<Net> topNets = new HashSet<Net>();
        for (PinTemplate pinTemplateA : a.getDeviceTemplate().getPins()) {
            topNet = NetMap.getTopmostNet((Net)pinTemplateA.getNet(), (DevicePath)a);
            if (topNets.contains(topNet)) continue;
            topNets.add(topNet);
            PortTemplate portTemplate = pinTemplateA.getFirstPortTemplate();
            netToHierPort.put(topNet, new HierPort(a, portTemplate));
        }
        for (PinTemplate pinTemplateB : b.getDeviceTemplate().getPins()) {
            topNet = NetMap.getTopmostNet((Net)pinTemplateB.getNet(), (DevicePath)b);
            if (!topNets.contains(topNet)) continue;
            topNets.remove(topNet);
            HierPort hpa = (HierPort)netToHierPort.get(topNet);
            HierPort hpb = new HierPort(b, pinTemplateB.getFirstPortTemplate());
            PortPair portPair = new PortPair();
            portPair.a = hpa;
            portPair.b = hpb;
            devicePair.pairs.add(portPair);
        }
        return devicePair;
    }

    public class Overlay
    extends JComponent {
        int colorIndex = 0;

        public String nextColor() {
            String[] colorTable = new String[]{"ffff0000", "ff00ff00", "ff0000ff", "ffffff00", "ffff00ff", "ff00ffff", "ff7f0000", "ff007f00", "ff00007f", "ff7f7f00", "ff7f007f", "ff007f7f"};
            String retColor = colorTable[this.colorIndex];
            ++this.colorIndex;
            if (this.colorIndex >= colorTable.length) {
                this.colorIndex = 0;
            }
            return retColor;
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            if (BusView.this.drawing) {
                return;
            }
            AbstractViewMode avm = (AbstractViewMode)BusView.this.view.getCurMode();
            if (avm.isNavigationInProgress()) {
                return;
            }
            this.colorIndex = 0;
            BusView.this.drawing = true;
            Graphics2D g = (Graphics2D)graphics;
            DesignCanvas2D.prepareGraphics(g);
            g.setFont(new Font("SansSerif", 0, 12));
            DesignView2D v2 = BusView.this.view;
            DesignCanvas2D.XForm xform = v2.getCanvas().getXForm();
            for (DevicePair devicePair : BusView.this.devicePairSet) {
                APoint2D c1 = devicePair.c1;
                Point a = xform.getScreenPt(c1);
                APoint2D c2 = devicePair.c2;
                Point b = xform.getScreenPt(c2);
                int w = devicePair.getSize();
                Color c = AUtil.colorFromString((String)this.nextColor());
                g.setColor(c);
                g.setStroke(new BasicStroke((float)w / 50.0f, 1, 2));
                g.drawLine(a.x, a.y, b.x, b.y);
                AffineTransform oldT = g.getTransform();
                AVector v = new AVector((long)a.x, (long)a.y, (long)b.x, (long)b.y);
                ALine l = new ALine((long)a.x, (long)a.y, (long)b.x, (long)b.y);
                APoint2D center = l.center();
                double angle = -v.angle() + 1.5707963267948966;
                AffineTransform t = new AffineTransform(oldT);
                t.translate(center.getX(), center.getY());
                t.rotate(angle);
                g.setTransform(t);
                g.setColor(Color.BLACK);
                g.drawString(Integer.toString(w), 0, 0);
                g.setTransform(oldT);
                g.setStroke(new BasicStroke(0.0f, 1, 2));
                g.setColor(c);
                for (PortPair pp : devicePair.pairs) {
                    APoint2D pppa = pp.a.getWorldLoc();
                    Point p1 = xform.getScreenPt(pppa);
                    g.drawLine(a.x, a.y, p1.x, p1.y);
                    APoint2D pppb = pp.b.getWorldLoc();
                    Point p2 = xform.getScreenPt(pppb);
                    g.drawLine(b.x, b.y, p2.x, p2.y);
                }
            }
            BusView.this.drawing = false;
        }
    }

    class DevicePair {
        protected DevicePath p1;
        protected DevicePath p2;
        protected HashSet<PortPair> pairs = new HashSet();
        APoint2D c1;
        APoint2D c2;

        DevicePair() {
        }

        public int getSize() {
            return this.pairs.size();
        }
    }

    class PortPair {
        HierPort a;
        HierPort b;

        PortPair() {
        }
    }
}

