/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.CCTFile;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.sigrity.acl.AExpression;
import com.sigrity.acl.AFile;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.BidiLinkHashMap;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.StreamIterableIterator;
import com.sigrity.acl.Unit;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.Constraint;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.RuleSet;
import com.sigrity.acl.db.std.SchedConn;
import com.sigrity.orbit.CCTFile.CCTFileConstraints;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.RuleSetMgr;
import com.sigrity.orbit.export.CCTFileIn;
import com.sigrity.orbit.export.CCTFileOutDo;
import com.sigrity.orbit.export.CCTFileOutDof;
import com.sigrity.orbit.export.CCTFileOutDsn;
import com.sigrity.orbit.export.CCTFileOutSes;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;

public class CCTFile {
    public static final String APR_VIA_NAME = "VIA_USER";
    public static final long APR_RESOLUTION = 1L;
    public static final String CLASS_DIFF_PREFIX = "_difpr_";
    protected List<PadTemplate> mLimitViaPadStackList;
    protected List<CCTFileConstraints.CCTConstraint> mConstraints;
    protected LinkedList<BundleConstraint> mBundleConstraints = new LinkedList();
    protected Map<String, HierInst<PinTemplate>> mHPinMap = new HashMap<String, HierInst<PinTemplate>>();
    protected BidiLinkHashMap<String, Layer> mLayerMap = new BidiLinkHashMap();
    protected LinkedList<String> mSLayers = new LinkedList();
    protected BiMap<String, Net> mNetMap = HashBiMap.create();
    protected HashMap<String, Net> mSNetMap = new HashMap();
    protected HashMap<String, ArrayList<String>> mNetPinMap = new HashMap();
    protected HashMap<PinTemplate, String> mPinTMap = new HashMap();
    protected HashMap<APair<String, String>, LinkedList<String>> mSPinPairs = new HashMap();
    protected BiMap<String, String> mDiffPairs = HashBiMap.create();
    protected Map<String, List<String>> mClassMap = new HashMap<String, List<String>>();
    protected Map<Net, String> mDiffNet2ClassMap = new HashMap<Net, String>();
    protected Set<PinTemplate> mPinPairSet = new HashSet<PinTemplate>();
    protected ViaPattern mViaPattern;
    protected double mDetourRatio;
    protected boolean mAllowLoop;
    protected boolean mSequenceDriven;
    protected boolean mFastMode;
    protected String mDofLayer = "";
    protected File mOverrideDoFile = null;
    protected int mMaxTimeSec = Integer.MAX_VALUE;
    protected long mMaxPass = Long.MAX_VALUE;
    protected Map<String, Float> mEarlyStopParams = null;
    protected boolean mMassageNames = true;
    private RouteAngle mRouteAngle = RouteAngle.FortyFive;
    private Map<Net, CCTFileConstraints.CCTConstraint> mDiffPairCons = new HashMap<Net, CCTFileConstraints.CCTConstraint>();
    protected RoutingFlow mRoutingFlow = RoutingFlow.Unspecified;

    public void setDofLayer(String layer) {
        this.mDofLayer = layer;
    }

    public String getDofLayer() {
        return this.mDofLayer;
    }

    public void setMassageNames(boolean set) {
        this.mMassageNames = set;
    }

    public void setRoutingFlow(RoutingFlow rf) {
        this.mRoutingFlow = rf;
    }

    public static String formatId(String name) {
        name = name.replace(' ', '_');
        name = name.replace('(', '_');
        name = name.replace(')', '_');
        name = name.replace(';', '_');
        name = name.replace('\'', '_');
        return name;
    }

    public static String formatDeviceName(DevicePath devP) {
        Object name = devP.toString();
        name = CCTFile.formatId((String)name);
        name = (String)name + "/";
        return name;
    }

    public static String formatStringList(List<String> list) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String s : list) {
            if (!first) {
                sb.append(' ');
            }
            sb.append(CCTFile.getElement(s));
            first = false;
        }
        return sb.toString();
    }

    public static String getElement(String str) {
        if (str.contains(" ") || str.contains("(") || str.contains(")")) {
            str = String.format("'%s'", str);
        }
        return str;
    }

    public String getPortMappedName(HierInst<PinTemplate> hP, PortTemplate port) {
        PinTemplate pT = (PinTemplate)hP.getDbObject();
        String pinId = this.mPinTMap.get(pT);
        String prefix = CCTFile.formatDeviceName((DevicePath)hP.first) + "-" + pinId;
        return String.format("%s:%d", prefix, port.getPortNum());
    }

    public IterableIterator<String> getPortMappedNames(HierInst<PinTemplate> hP) {
        PinTemplate pT = (PinTemplate)hP.getDbObject();
        return new StreamIterableIterator(pT.getPortTemplates().stream().map(port -> this.getPortMappedName(hP, (PortTemplate)port)));
    }

    public void deriveMaps(DevicePath devPath, Set<Net> selectedNets, List<Bundle> selectBundles, Map<Layer, Boolean> layers, Map<APair<HierInst<PinTemplate>, HierInst<PinTemplate>>, LinkedList<Layer>> selectedPinPairs) {
        if (devPath == null || layers == null || layers.isEmpty()) {
            return;
        }
        int[] index = new int[]{1};
        this.mNetMap.clear();
        this.mSNetMap.clear();
        this.mClassMap.clear();
        this.mBundleConstraints.clear();
        LinkedHashSet<PinTemplate> pinPairSet = new LinkedHashSet<PinTemplate>();
        for (APair<HierInst<PinTemplate>, HierInst<PinTemplate>> e : selectedPinPairs.keySet()) {
            pinPairSet.add((PinTemplate)((HierInst)e.getFirst()).getDbObject());
            pinPairSet.add((PinTemplate)((HierInst)e.getSecond()).getDbObject());
        }
        this.setPinPairSet(pinPairSet);
        DeviceTemplate dT = devPath.getDeviceTemplate();
        dT.getNets().stream().filter(net -> !net.isUnused()).forEach(net -> {
            if (this.mMassageNames) {
                this.mNetMap.put((Object)String.format("net%s", index[0]), net);
                if (selectedNets.contains(net)) {
                    this.mSNetMap.put(String.format("net%s", index[0]), (Net)net);
                }
                index[0] = index[0] + 1;
            } else {
                this.mNetMap.put((Object)net.getName(), net);
                if (selectedNets.contains(net)) {
                    this.mSNetMap.put(net.getName(), (Net)net);
                }
            }
        });
        index[0] = 1;
        this.mPinTMap.clear();
        devPath.getDescendants().stream().forEach(devP -> {
            Device dev = devP.getLast();
            DeviceTemplate devT = dev.getTemplate();
            devT.getPins().forEach(pinT -> {
                if (pinT.getType() == PinTemplate.Type.TOPOLOGYPOINT && !pinPairSet.contains(pinT)) {
                    return;
                }
                if (this.mPinTMap.get(pinT) != null) {
                    return;
                }
                if (this.mPinTMap.containsValue(pinT.getName())) {
                    this.mPinTMap.put((PinTemplate)pinT, String.format("%s_%d", pinT.getName(), index[0]));
                    index[0] = index[0] + 1;
                } else {
                    this.mPinTMap.put((PinTemplate)pinT, pinT.getName());
                }
            });
        });
        this.mHPinMap.clear();
        this.mNetPinMap.clear();
        this.mNetMap.entrySet().stream().forEach(n -> {
            Net net = (Net)n.getValue();
            String netName = (String)n.getKey();
            ArrayList list = new ArrayList();
            NetMap.getConnectedHierPins((DevicePath)devPath, (Net)net).stream().forEach(hP -> {
                PinTemplate pT = (PinTemplate)hP.getSecond();
                if (pT.getType() == PinTemplate.Type.TOPOLOGYPOINT && !pinPairSet.contains(pT)) {
                    return;
                }
                if (pT.getSubstrate() != devPath.getSubstrate()) {
                    return;
                }
                String pinId = this.mPinTMap.get(pT);
                if (pinId == null) {
                    ALog.flogWarn((String)"A problem encountered with pin template pin mapping.", (Object[])new Object[0]);
                    return;
                }
                for (String key : this.getPortMappedNames((HierInst<PinTemplate>)hP)) {
                    this.mHPinMap.put(key, (HierInst<PinTemplate>)hP);
                    list.add(key);
                }
                index[0] = index[0] + 1;
            });
            this.mNetPinMap.put(netName, list);
        });
        this.mNetMap.entrySet().stream().forEach(rec -> {
            String name = (String)rec.getKey();
            Net net = (Net)rec.getValue();
            if (this.mDiffPairs.get((Object)name) != null || this.mDiffPairs.inverse().get((Object)name) != null) {
                return;
            }
            Net mate = Net.getDiffPairMate((Net)net, (DevicePath)devPath);
            if (mate == null) {
                return;
            }
            String mateName = (String)this.mNetMap.inverse().get((Object)mate);
            if (mateName == null) {
                return;
            }
            this.mDiffPairs.put((Object)name, (Object)mateName);
        });
        this.mLayerMap.clear();
        this.mSLayers.clear();
        index[0] = 1;
        layers.entrySet().stream().forEach(rec -> {
            Layer layer = (Layer)rec.getKey();
            boolean selected = (Boolean)rec.getValue();
            String layerName = this.mMassageNames ? String.format("layer%s", index[0]) : layer.getName();
            this.mLayerMap.put((Object)layerName, (Object)layer);
            index[0] = index[0] + 1;
            if (selected) {
                this.mSLayers.add(layerName);
            }
        });
        this.mSPinPairs.clear();
        selectedPinPairs.entrySet().stream().forEach(entry -> {
            boolean hasPortA = false;
            boolean hasPortB = false;
            UnaryOperator convertToFullPath = hp -> {
                DevicePath pinPath = hp.getPath();
                if (pinPath.getIsAbsolute() || !devPath.getIsAbsolute()) {
                    return hp;
                }
                DeviceTemplate pinPathRoot = pinPath.getRoot();
                DevicePath absolutePinPath = devPath.pathTo(pinPathRoot).addPath(pinPath);
                return new HierInst(absolutePinPath, (DbObject)((PinTemplate)hp.getDbObject()));
            };
            HierInst hpA = (HierInst)convertToFullPath.apply((HierInst)((APair)entry.getKey()).first);
            HierInst hpB = (HierInst)convertToFullPath.apply((HierInst)((APair)entry.getKey()).second);
            for (String portKeyA : this.getPortMappedNames((HierInst<PinTemplate>)hpA)) {
                hasPortA = true;
                for (String portKeyB : this.getPortMappedNames((HierInst<PinTemplate>)hpB)) {
                    hasPortB = true;
                    LinkedList<String> layerStrs = new LinkedList<String>();
                    if (entry.getValue() != null) {
                        for (Layer l : (LinkedList)entry.getValue()) {
                            String layerStr = l != null ? (String)this.mLayerMap.getKey((Object)l) : "";
                            if (layerStr == null || layerStr.isEmpty()) continue;
                            layerStrs.add(layerStr);
                        }
                    }
                    this.mSPinPairs.put((APair<String, String>)new APair((Object)portKeyA, (Object)portKeyB), layerStrs);
                }
            }
            if (!hasPortA || !hasPortB) {
                ALog.flogWarn((String)"A problem encountered with selected pin pair mapping '%s'.", (Object[])new Object[]{entry.getKey()});
            }
        });
        ALog.logDebug((String)"APR select %d pin pairs.", (Object[])new Object[]{this.mSPinPairs.size()});
        selectBundles.stream().forEach(entry -> {
            BundleConstraint bc = new BundleConstraint();
            bc.mBundleId = CCTFile.formatId(entry.getName());
            for (SchedConn sc : entry.getSchedConn()) {
                Net topANet = NetMap.getNetAt((Net)sc.getDPPA().getNet(), (DevicePath)sc.getDPPA().getPath(), (DeviceTemplate)entry.getTemplate());
                String netName = (String)this.mNetMap.inverse().get((Object)topANet);
                if (netName == null) {
                    ALog.logInfo((String)"A problem encountered with selected bundle net mapping.");
                } else {
                    bc.mNets.add(netName);
                }
                HierInst hip1 = new HierInst((DevicePath)sc.getAbsDPPA().first, (DbObject)((PinInstance)sc.getAbsDPPA().second).getPinTemplate());
                HierInst hip2 = new HierInst((DevicePath)sc.getAbsDPPB().first, (DbObject)((PinInstance)sc.getAbsDPPB().second).getPinTemplate());
                for (String portKeyA : this.getPortMappedNames((HierInst<PinTemplate>)hip1)) {
                    for (String portKeyB : this.getPortMappedNames((HierInst<PinTemplate>)hip2)) {
                        bc.mFromTo.add((APair<String, String>)new APair((Object)portKeyA, (Object)portKeyB));
                    }
                }
            }
            LinkedList<String> ls = new LinkedList<String>();
            for (Layer l : entry.getLayers()) {
                String layerName = (String)this.mLayerMap.getKey((Object)l);
                if (layerName == null) {
                    ALog.logInfo((String)"A problem encountered with selected bundle layer mapping.");
                    continue;
                }
                ls.add(layerName);
            }
            bc.mLayerGroup.add((APair<Integer, LinkedList<String>>)new APair((Object)-1, ls));
            this.mBundleConstraints.add(bc);
        });
        this.computeClass();
    }

    private void computeClass() {
        HashSet classNameSet = new HashSet();
        for (Map.Entry diffPair : this.mDiffPairs.entrySet()) {
            String baseName;
            List<String> nets = List.of((String)diffPair.getKey(), (String)diffPair.getValue());
            String groupName = AUtil.getPrettyPrefixName(nets);
            String result = baseName = CLASS_DIFF_PREFIX + groupName;
            int i = 1;
            while (classNameSet.contains(result)) {
                result = baseName + i;
                ++i;
            }
            this.mDiffNet2ClassMap.put((Net)this.mNetMap.get(diffPair.getKey()), result);
            this.mDiffNet2ClassMap.put((Net)this.mNetMap.get(diffPair.getValue()), result);
            this.mClassMap.put(result, nets);
        }
    }

    public Map<String, HierInst<PinTemplate>> getHPinMap() {
        return this.mHPinMap;
    }

    public HashMap<PinTemplate, String> getPinTMap() {
        return this.mPinTMap;
    }

    public HashMap<String, ArrayList<String>> getNetPinMap() {
        return this.mNetPinMap;
    }

    public BiMap<String, Net> getNetMap() {
        return this.mNetMap;
    }

    public HashMap<String, Net> getSNetMap() {
        return this.mSNetMap;
    }

    public BidiLinkHashMap<String, Layer> getLayerMap() {
        return this.mLayerMap;
    }

    public HashMap<APair<String, String>, LinkedList<String>> getSelectedPinPairs() {
        return this.mSPinPairs;
    }

    public BiMap<String, String> getDiffPairs() {
        return this.mDiffPairs;
    }

    public LinkedList<String> getSelectedLayers() {
        return this.mSLayers;
    }

    public List<CCTFileConstraints.CCTConstraint> getConstraints() {
        return this.mConstraints;
    }

    public LinkedList<BundleConstraint> getBundleConstraints() {
        return this.mBundleConstraints;
    }

    public List<PadTemplate> getLimitViaPadStackList() {
        return this.mLimitViaPadStackList;
    }

    public ViaPattern getViaPattern() {
        return this.mViaPattern;
    }

    public double getDetourRatio() {
        return this.mDetourRatio;
    }

    public boolean getAllowLoop() {
        return this.mAllowLoop;
    }

    public boolean getSequenceDriver() {
        return this.mSequenceDriven;
    }

    public boolean getFastMode() {
        return this.mFastMode;
    }

    public Set<PinTemplate> getPinPairSet() {
        return this.mPinPairSet;
    }

    private void setPinPairSet(Set<PinTemplate> pinPairSet) {
        this.mPinPairSet = pinPairSet;
    }

    public void setConfiguration(List<PadTemplate> limitViaPadStackList, List<CCTFileConstraints.CCTConstraint> constraints, ViaPattern viaPattern, double detourRatio, boolean allowLoop, boolean sequenceDriven, boolean fastMode) {
        this.mLimitViaPadStackList = limitViaPadStackList;
        this.mConstraints = constraints;
        this.mViaPattern = viaPattern;
        this.mDetourRatio = detourRatio;
        this.mAllowLoop = allowLoop;
        this.mSequenceDriven = sequenceDriven;
        this.mFastMode = fastMode;
    }

    public void setOverrideDoFile(File doFile) {
        this.mOverrideDoFile = doFile;
    }

    public void setMaxTimeSec(int seconds) {
        this.mMaxTimeSec = seconds;
    }

    public int getMaxTimeSec() {
        return this.mMaxTimeSec;
    }

    public void setMaxPass(long maxPass) {
        this.mMaxPass = maxPass;
    }

    public long getMaxPass() {
        return this.mMaxPass;
    }

    protected String getUniqueName(String baseName) {
        Object unique = baseName;
        int i = 1;
        while (this.mLayerMap.containsKey(unique)) {
            unique = baseName + i++;
        }
        return unique;
    }

    public ImportData importFile(File file, String devicePathString, FileType fileType) {
        if (fileType == FileType.DesignFile) {
            ALog.logError((String)"Do not support reading design file '%s' yet!", (Object[])new Object[]{file.getName()});
            return new ImportData(false, null);
        }
        Db db = OrbitIO.getCurDb();
        if (db == null) {
            return new ImportData(false, null);
        }
        DevicePath rootPath = DevicePath.fromString((Db)db, (String)devicePathString);
        if (rootPath == null) {
            ALog.logError((Throwable)new RuntimeException(String.format("Invalid DevicePath '%s'.", devicePathString)));
            return new ImportData(false, null);
        }
        CCTFileIn reader = new CCTFileIn();
        boolean ret = reader.read(file, rootPath, fileType, this);
        return new ImportData(ret, reader);
    }

    public boolean write(File file, DevicePath rootPath, FileType type) {
        if (type == FileType.DesignFile) {
            CCTFileOutDsn dsn = new CCTFileOutDsn(file, rootPath, this);
            dsn.writeDesign();
        } else if (type == FileType.SessionFile) {
            CCTFileOutSes ses = new CCTFileOutSes(file, rootPath, this);
            ses.writeSession();
        } else if (type == FileType.DoFile) {
            CCTFileOutDo doo = new CCTFileOutDo(file, rootPath, this);
            doo.writeDo();
        } else if (type == FileType.DofFile) {
            CCTFileOutDof dof = new CCTFileOutDof(file, rootPath, this);
            if (this.mOverrideDoFile != null) {
                dof.setDoPath(this.mOverrideDoFile);
            }
            dof.setRoutingFlow(this.mRoutingFlow);
            dof.writeDof();
        } else {
            throw new IllegalArgumentException(String.format("Unsupport file type %s", new Object[]{type}));
        }
        if (!AFile.isFileReadable((File)file)) {
            ALog.logWarn((String)"Cannot read file %s.", (Object[])new Object[]{file});
        }
        if (file.length() == 0L) {
            ALog.logWarn((String)"Found empty output file %s.", (Object[])new Object[]{file});
        }
        return true;
    }

    public static long getWidthRule(DeviceTemplate devT) {
        long cons = 0L;
        RuleSet aRuleSet = RuleSetMgr.getMyRuleSet((DbObject)devT);
        if (aRuleSet == null) {
            return cons;
        }
        AExpression expr = (AExpression)RuleSetMgr.getConstraintValue((RuleSet)aRuleSet, (Constraint.Descriptor)Constraint.WIRE_WIDTH, null);
        if (expr == null) {
            return cons;
        }
        Unit unit = Design.getUnit((Db)aRuleSet.getDb());
        cons = unit.fromUserString((String)expr.evaluate());
        return cons;
    }

    public static long getClearanceRule(DeviceTemplate devT) {
        long cons = 0L;
        RuleSet aRuleSet = RuleSetMgr.getMyRuleSet((DbObject)devT);
        if (aRuleSet == null) {
            return cons;
        }
        return (Long)RuleSetMgr.getConstraintValue((RuleSet)aRuleSet, (Constraint.Descriptor)Constraint.WIRE_CLEAR, null);
    }

    public static boolean isCCTLayer(Layer layer) {
        return layer.getType() == Layer.LayerType.Route || layer.getType() == Layer.LayerType.Signal || layer.getType() == Layer.LayerType.Power || layer.getType() == Layer.LayerType.Mixed || layer.getType() == Layer.LayerType.Jumper || layer.getType() == Layer.LayerType.Unknown;
    }

    public static String deriveFileName(String devName, FileType type) {
        String fileName = null;
        if (devName.isEmpty()) {
            return fileName;
        }
        if (type.equals((Object)FileType.DesignFile)) {
            fileName = String.format("%s.dsn", devName);
        } else if (type.equals((Object)FileType.DoFile)) {
            fileName = String.format("%s.do", devName);
        } else if (type.equals((Object)FileType.DofFile)) {
            fileName = String.format("%s.dof", devName);
        } else if (type.equals((Object)FileType.RouteFile)) {
            fileName = String.format("%s.rte", devName);
        } else if (type.equals((Object)FileType.SessionFile)) {
            fileName = String.format("%s.ses", devName);
        }
        return fileName;
    }

    public void setRouteAngle(RouteAngle routeAngle) {
        this.mRouteAngle = routeAngle;
    }

    public RouteAngle getRouteAngle() {
        return this.mRouteAngle;
    }

    public Map<String, List<String>> getClassesDef() {
        return this.mClassMap;
    }

    public void setDiffPairConstraints(Map<Net, CCTFileConstraints.CCTConstraint> diffPairCons) {
        this.mDiffPairCons = diffPairCons;
    }

    public Map<Net, CCTFileConstraints.CCTConstraint> getDiffConstraints() {
        return this.mDiffPairCons;
    }

    public String getDiffPairClass(Net net) {
        return this.mDiffNet2ClassMap.get(net);
    }

    public void setEarlyStopParams(Map<String, Float> params) {
        this.mEarlyStopParams = params;
    }

    public Map<String, Float> getEarlyStopParams() {
        return this.mEarlyStopParams;
    }

    public static class BundleConstraint {
        public String mBundleId;
        public List<APair<Integer, LinkedList<String>>> mLayerGroup = new LinkedList<APair<Integer, LinkedList<String>>>();
        public List<String> mNets = new LinkedList<String>();
        public List<APair<String, String>> mFromTo = new LinkedList<APair<String, String>>();
    }

    public static class ImportData {
        public final boolean result;
        public final CCTFileIn cctIn;

        ImportData(boolean result, CCTFileIn cctIn) {
            this.result = result;
            this.cctIn = cctIn;
        }
    }

    public static enum RoutingFlow {
        Full,
        Global,
        Detail,
        Unspecified;

    }

    protected static interface Reader {
        public String newLineString();

        public String nextToken();

        public String currentToken();

        public void pushbackToken(String var1);

        public void skipLine();

        public boolean skipTokens(int var1);

        public boolean findToken(String var1);

        public ArrayList<String> readTokens(int var1);
    }

    public static enum RouteAngle {
        FortyFive("FortyFive", "45 \u00b0"),
        Ninety("Ninety", "90 \u00b0");

        private final String name;
        private final String userName;

        private RouteAngle(String name, String userName) {
            this.name = name;
            this.userName = userName;
        }

        public boolean equalsName(String otherName) {
            return this.name.equals(otherName);
        }

        public String toString() {
            return this.name;
        }

        public String getUserName() {
            return this.userName;
        }
    }

    public static enum ViaPattern {
        Spiral,
        Stagger,
        Staircase;

    }

    public static enum FileType {
        DesignFile,
        DoFile,
        DofFile,
        SessionFile,
        RouteFile,
        WireFile,
        ConFile;

    }
}

