/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.CCTFile;

import com.google.common.base.Enums;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitIO;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.Set;
import java.util.stream.Collectors;

public class CCTFileConstraints {
    protected Db mDb = null;
    protected Device mDevice;
    protected DevicePath mDevicePath;
    protected DeviceTemplate mDeviceTemplate;
    protected LinkedList<CCTConstraint> mNetList = new LinkedList();
    public final Map<Net, CCTConstraint> mDiffPairMap = new HashMap<Net, CCTConstraint>();
    static final OptionalDouble CONS_DEFAULT_WIDTH = OptionalDouble.empty();
    static final OptionalDouble CONS_DEFAULT_CLEARANCE = OptionalDouble.empty();
    private static ConstraintType[] mConsList = new ConstraintType[]{new ConstraintType(ConstraintId.width, CONS_DEFAULT_WIDTH), new ConstraintType(ConstraintId.clearance, CONS_DEFAULT_CLEARANCE)};
    private static ConstraintType[] mDiffPairCons = new ConstraintType[]{new ConstraintType(ConstraintId.diffpair_line_width, CONS_DEFAULT_WIDTH), new ConstraintType(ConstraintId.neck_down_gap, CONS_DEFAULT_CLEARANCE), new ConstraintType(ConstraintId.neck_down_width, CONS_DEFAULT_CLEARANCE)};
    private static final Set<ConstraintId> mClearanceRuleId = new HashSet<ConstraintId>(Arrays.stream(mConsList).map(ct -> ct.getId()).filter(id -> !id.equals((Object)ConstraintId.width)).collect(Collectors.toList()));

    public static boolean isClearanceTypeId(ConstraintId id) {
        return mClearanceRuleId.contains((Object)id);
    }

    public CCTFileConstraints(DevicePath devPath) {
        this.mDb = devPath.getDb();
        this.mDevicePath = devPath;
        this.mDevice = this.mDevicePath.getLast();
        this.mDeviceTemplate = this.mDevicePath.getDeviceTemplate();
    }

    public LinkedList<CCTConstraint> getConstraints() {
        if (this.mNetList.isEmpty()) {
            this.loadDefault();
        }
        return this.mNetList;
    }

    public Map<Net, CCTConstraint> getDiffPairConstraints() {
        return this.mDiffPairMap;
    }

    public void setConstraintsFromCsv(Map<String, List<String>> class2Nets, Map<String, Map<String, Map<String, String>>> class2LayeredRule, Map<APair<String, String>, Map<String, String>> classes2LayeredClearance, APair<OptionalDouble, OptionalDouble> baseRule) {
        HashMap grpMap = new HashMap();
        HashMap grp2grpMap = new HashMap();
        class2Nets.forEach((grp, members) -> {
            CCTConstraint cct = new CCTConstraint((String)grp, (List<String>)members);
            grpMap.put(grp, cct);
            this.mNetList.add(cct);
        });
        classes2LayeredClearance.forEach((key, val) -> {
            if (((String)key.first).equals(key.second)) {
                ((CCTConstraint)grpMap.get(key.first)).setLayeredRule((Map<String, String>)val, ConstraintId.clearance);
            } else {
                CCTConstraint cct = (CCTConstraint)grp2grpMap.get(key);
                if (cct == null) {
                    cct = new CCTConstraint((String)key.first, (String)key.second);
                    this.mNetList.add(cct);
                    grp2grpMap.put(key, cct);
                }
                cct.setLayeredRule((Map<String, String>)val, ConstraintId.clearance);
            }
        });
        class2LayeredRule.forEach((grp, val) -> val.forEach((name, rules) -> {
            Optional ruleType = Enums.getIfPresent(ConstraintId.class, (String)name).toJavaUtil();
            if (ruleType.isPresent()) {
                ((CCTConstraint)grpMap.get(grp)).setLayeredRule((Map<String, String>)rules, (ConstraintId)((Object)((Object)((Object)ruleType.get()))));
            } else {
                ALog.logWarn((String)("Rule " + name + " is not supported"));
            }
        }));
        if (((OptionalDouble)baseRule.first).isPresent() && ((OptionalDouble)baseRule.second).isPresent()) {
            this.mNetList.stream().filter(cons -> cons.getName().equals("PCB")).forEach(cct -> {
                cct.setWidth(((OptionalDouble)baseRule.first).getAsDouble());
                cct.setAllClearance(((OptionalDouble)baseRule.second).getAsDouble());
            });
        }
    }

    public void setConstraints(double width, double clearance) {
        this.mNetList.stream().forEach(cct -> {
            for (ConstraintType ct : cct.mList) {
                if (ct.id.equals((Object)ConstraintId.width)) {
                    ct.setValue(width);
                    continue;
                }
                ct.setValue(clearance);
            }
        });
    }

    public void setDiffPairConstraints(double width, double neckGap, double neckWidth) {
        this.mDiffPairMap.values().stream().forEach(cct -> {
            for (ConstraintType ct : cct.mList) {
                if (ct.id.equals((Object)ConstraintId.diffpair_line_width)) {
                    ct.setValue(width);
                    continue;
                }
                if (ct.id.equals((Object)ConstraintId.neck_down_gap)) {
                    ct.setValue(neckGap);
                    continue;
                }
                if (!ct.id.equals((Object)ConstraintId.neck_down_width)) continue;
                ct.setValue(neckWidth);
            }
        });
    }

    public void loadDefault() {
        CCTConstraint c;
        this.mNetList.clear();
        CCTConstraint cons = new CCTConstraint(RuleType.PCB);
        cons.setName("PCB");
        this.mNetList.add(cons);
        for (Net net : this.mDeviceTemplate.getNets()) {
            if (net.isUnused()) continue;
            c = new CCTConstraint(RuleType.NET);
            c.setName(net.getName());
            this.mNetList.add(c);
        }
        for (Net net : this.mDeviceTemplate.getNets()) {
            if (net.isUnused()) continue;
            c = new CCTConstraint(RuleType.NET);
            c.setName(net.getName());
            this.mNetList.add(c);
        }
        for (Net net : this.mDeviceTemplate.getNets()) {
            Net mate = Net.getDiffPairMate((Net)net, (DevicePath)this.mDevicePath);
            if (net.isUnused() || mate == null || this.mDiffPairMap.containsKey(mate)) continue;
            CCTConstraint c2 = new CCTConstraint(RuleType.CLASS);
            this.mDiffPairMap.put(net, c2);
            this.mDiffPairMap.put(mate, c2);
        }
    }

    public void loadFromCsv(String filePath) {
        Db db = OrbitIO.getCurDb();
        if (db == null) {
            return;
        }
        if (filePath == null || filePath.isEmpty()) {
            ALog.logError((String)"Input file is invalid");
            return;
        }
        File inputFile = new File(filePath);
        this.mNetList.clear();
        try (BufferedReader input = new BufferedReader(new FileReader(inputFile));){
            String curLine = input.readLine();
            while (curLine != null) {
                this.processLine(curLine);
                curLine = input.readLine();
            }
            ALog.logInfo((String)"Constraints updated from file %s.", (Object[])new Object[]{filePath});
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Cannot read constraint csv file.", (Object[])new Object[0]);
        }
    }

    protected void processLine(String line) {
        String[] tokens = line.split(",");
        int numTokens = tokens.length;
        if (numTokens == 0) {
            return;
        }
        String str = tokens[0];
        if (str.isEmpty()) {
            return;
        }
        CCTConstraint cons = new CCTConstraint();
        for (int num = 1; num < numTokens; ++num) {
            String value = tokens[num];
            if (num == 1) {
                if (value.equals("PCB")) {
                    cons.setType(RuleType.PCB);
                } else {
                    cons.setType(RuleType.NET);
                }
                cons.setName(value);
                continue;
            }
            cons.mList[num - 2].setValue(Double.parseDouble(value));
        }
        this.mNetList.add(cons);
    }

    public void writeToCsv(String filePath) {
        PrintStream out = null;
        Db db = OrbitIO.getCurDb();
        if (db == null) {
            return;
        }
        if (filePath == null || filePath.isEmpty()) {
            ALog.logError((String)"Target file is invalid");
            return;
        }
        try {
            out = new PrintStream(filePath);
        }
        catch (FileNotFoundException e) {
            ALog.logError((Throwable)e, (String)"Cannot open '%s'", (Object[])new Object[]{filePath});
            return;
        }
        for (CCTConstraint cons : this.mNetList) {
            StringBuilder line = new StringBuilder();
            line.append(cons.getName());
            line.append(",");
            for (ConstraintType ct : cons.mList) {
                line.append(ct.value);
                line.append(",");
            }
            out.println(line);
        }
        out.close();
        ALog.logInfo((String)"Constraints written to file %s.", (Object[])new Object[]{filePath});
    }

    public class CCTConstraint {
        protected RuleType mType;
        protected String mName;
        protected ConstraintType[] mList;
        protected String[] mMembers = new String[0];
        public final Map<String, CCTConstraint> mLayerRuleMap = new HashMap<String, CCTConstraint>();

        public CCTConstraint() {
            this(RuleType.UNKNOWN);
        }

        public CCTConstraint(RuleType type) {
            this.mType = type;
            this.mList = type == RuleType.CLASS ? Arrays.stream(mDiffPairCons).map(ConstraintType::copy).collect(Collectors.toList()).toArray(new ConstraintType[0]) : Arrays.stream(mConsList).map(ConstraintType::copy).collect(Collectors.toList()).toArray(new ConstraintType[0]);
        }

        public CCTConstraint(RuleType type, boolean allRules) {
            this(type);
            if (allRules) {
                this.mList = Arrays.stream(ConstraintId.values()).map(id -> new ConstraintType((ConstraintId)((Object)id), OptionalDouble.empty())).collect(Collectors.toList()).toArray(new ConstraintType[0]);
            }
        }

        public CCTConstraint(RuleType type, Double defaultValue) {
            this(type);
            for (ConstraintType ct : this.mList) {
                ct.setValue(defaultValue);
            }
        }

        public CCTConstraint(String grpName, List<String> members) {
            this(RuleType.GROUP);
            this.mName = grpName;
            this.mMembers = members.toArray(new String[0]);
        }

        public CCTConstraint(String grp1, String grp2) {
            this(RuleType.GROUP_GROUP);
            this.mName = grp1;
            this.mMembers = new String[]{grp2};
        }

        public String getName() {
            return this.mName;
        }

        public void setName(String name) {
            this.mName = name;
        }

        public RuleType getType() {
            return this.mType;
        }

        public void setType(RuleType t) {
            this.mType = t;
        }

        public ConstraintType[] getClearances() {
            return this.mList;
        }

        public String[] getMembers() {
            return this.mMembers;
        }

        public Map<String, CCTConstraint> getLayerRule() {
            return this.mLayerRuleMap;
        }

        public boolean hasRule(int id) {
            return this.mList[id].hasValue();
        }

        public double getRule(int id) {
            return this.mList[id].getValue();
        }

        public void setClearance(int id, double value) {
            this.mList[id].setValue(value);
        }

        public void setLayeredRule(Map<String, String> data, ConstraintId id) {
            data.forEach((layer, rawValue) -> {
                CCTConstraint cct = this.mLayerRuleMap.getOrDefault(layer, new CCTConstraint(RuleType.LAYER, true));
                if (CCTFileConstraints.isClearanceTypeId(id)) {
                    OptionalDouble v = RuleValueInterpreter.getDoubleValue(id, rawValue);
                    cct.setAllClearance(v.getAsDouble());
                } else {
                    cct.setRule(id, (String)rawValue);
                }
                cct.setName((String)layer);
                this.mLayerRuleMap.put((String)layer, cct);
            });
        }

        public void setAllClearance(Double value) {
            for (ConstraintType ct : this.mList) {
                if (!mClearanceRuleId.contains((Object)ct.getId())) continue;
                ct.setValue(value);
            }
        }

        public void setRule(ConstraintId id, String value) {
            for (ConstraintType ct : this.mList) {
                if (ct.getId() != id) continue;
                if (RuleValueInterpreter.isStringValueConstraint(id)) {
                    RuleValueInterpreter.getStringValue(id, value).ifPresent(ct::setStringValue);
                    continue;
                }
                RuleValueInterpreter.getDoubleValue(id, value).ifPresent(ct::setValue);
            }
        }

        public void setWidth(Double value) {
            for (ConstraintType ct : this.mList) {
                if (ct.getId() != ConstraintId.width) continue;
                ct.setValue(value);
                break;
            }
        }

        public ConstraintType[] getList() {
            return this.mList;
        }
    }

    public static class RuleValueInterpreter {
        protected static final ConstraintId[] STRING_RULES = new ConstraintId[]{ConstraintId.region};
        protected static final Set<ConstraintId> STRING_RULE_SET = new HashSet<ConstraintId>(Arrays.asList(STRING_RULES));

        private RuleValueInterpreter() {
        }

        public static boolean isStringValueConstraint(ConstraintId id) {
            return STRING_RULE_SET.contains((Object)id);
        }

        public static boolean isStringValueRule(String rule) {
            Optional id = Enums.getIfPresent(ConstraintId.class, (String)rule).toJavaUtil();
            if (id.isPresent()) {
                return RuleValueInterpreter.isStringValueConstraint((ConstraintId)((Object)id.get()));
            }
            return false;
        }

        public static OptionalDouble getDoubleValue(ConstraintId id, String value) {
            if (RuleValueInterpreter.isStringValueConstraint(id)) {
                return OptionalDouble.empty();
            }
            try {
                Double ruleValue = Double.valueOf(value);
                return OptionalDouble.of(ruleValue);
            }
            catch (NumberFormatException e) {
                ALog.logWarn((String)("Unsupported rule value " + value + "for rule name: " + id.name()));
                return OptionalDouble.empty();
            }
        }

        public static Optional<String> getStringValue(ConstraintId id, String value) {
            if (RuleValueInterpreter.isStringValueConstraint(id)) {
                return Optional.of(value);
            }
            return Optional.empty();
        }
    }

    public static class ConstraintType {
        protected ConstraintId id;
        protected OptionalDouble value = OptionalDouble.empty();
        protected Optional<String> stringValue = Optional.empty();

        private ConstraintType(ConstraintId a, OptionalDouble c) {
            this.id = a;
            this.value = c;
        }

        private ConstraintType(ConstraintId a, OptionalDouble c, Optional<String> s) {
            this.id = a;
            this.value = c;
            this.stringValue = s;
        }

        public ConstraintType copy() {
            return new ConstraintType(this.id, this.value, this.stringValue);
        }

        public void setValue(double val) {
            this.value = OptionalDouble.of(val);
        }

        public double getValue() {
            double defaultValue = 20.0;
            if (this.value.isEmpty()) {
                ALog.flogWarn((String)"CCTFileConstraint: use default constraint value %f for %s", (Object[])new Object[]{defaultValue, this.getName()});
                return defaultValue;
            }
            return this.value.getAsDouble();
        }

        public boolean hasValue() {
            return this.value.isPresent();
        }

        public Optional<String> getStringValue() {
            return this.stringValue;
        }

        public void setStringValue(String v) {
            this.stringValue = Optional.of(v);
        }

        public String getName() {
            return this.id.name();
        }

        public ConstraintId getId() {
            return this.id;
        }
    }

    public static enum RuleType {
        PCB,
        NET,
        CLASS,
        LAYER,
        GROUP,
        GROUP_GROUP,
        UNKNOWN;

    }

    public static enum ConstraintId {
        width,
        clearance,
        diffpair_line_width,
        neck_down_gap,
        neck_down_width,
        edge_primary_gap,
        max_uncoupled_length,
        phase_tolerance_length,
        region;

    }
}

