/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.CCTFile;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbFieldDef;
import com.sigrity.acl.db.DbLoader;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.CCTFile.CCTFile;
import com.sigrity.orbit.CCTFile.CCTFileReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class CCTFileDBProcessor
implements DbLoader {
    public static final String DEFAULT_ROOTDEVNAME = "WireFile";
    public static final String DEFAULT_LENGTH_UNIT = "m";
    public static final long MICRONPERMETER = 1000000L;
    protected Db mDb;
    protected Design mDbDesign = null;
    protected APoint2D mOffsetOrigin = new APoint2D();
    protected RouteFileSection mRouteSection = null;
    protected CCTFile.Reader mReader;
    protected String mRootDeviceName;
    protected Device mRootDevice = null;
    protected boolean mReadTrace = false;
    protected boolean mReadShape = false;
    protected Substrate mSubstrate;
    protected CCTFileUnit mInternalUnit = null;
    protected CCTFileGeomParser mGeomParser = null;
    protected DeviceTemplate.Type deviceTemplateType;
    protected int mLayerOrder = 0;
    protected static int mKeyIndex = 0;
    protected String mDeviceTemplatePrefix = null;
    protected String mDefaultPadStackName = "~DefaultPadStack";
    protected HashMap<String, String> mRenamedDeviceTemplates = new HashMap();
    protected HashMap<String, DeviceTemplate> mCreatedDeviceTemplate = new HashMap();

    public CCTFileDBProcessor(Db db, CCTFile.Reader reader, String rootDeviceName, String deviceTemplatePrefix, DeviceTemplate.Type deviceTemplateType, boolean readWire, boolean readShape) {
        this.mDb = db;
        this.mReader = reader;
        this.mRootDeviceName = rootDeviceName;
        this.mDeviceTemplatePrefix = deviceTemplatePrefix;
        this.deviceTemplateType = deviceTemplateType;
        this.mReadTrace = readWire;
        this.mReadShape = readShape;
        this.mDbDesign = Design.getDesign((Db)this.mDb);
        if (this.mDbDesign == null) {
            this.mDbDesign = Design.create((Db)this.mDb);
        }
        this.mInternalUnit = new CCTFileUnit(this.mDb);
        this.mGeomParser = new CCTFileGeomParser();
    }

    public void mkDesign() {
        this.mRouteSection = new RouteFileSection(null, "design");
        this.mRouteSection.mSectionDef = new SectionDef("", ".end", SectionKeyCompType.EQUALS, RouteFileSection.class);
        this.mRouteSection.parse("design");
        this.createDb();
    }

    public DbLoader.DbLoadingForeignKey getLoadingKeyVal(DbObject dbo, DbFieldDef keyField) {
        if (dbo == this.mRootDevice) {
            return new DbLoader.StringForeignKey("[null]");
        }
        return new DbLoader.StringForeignKey(String.format("[null:%d]", dbo.getDbObjId()));
    }

    protected String getDeviceTemplateName(String baseName) {
        return this.mDeviceTemplatePrefix == null ? baseName : String.format("%s%s", this.mDeviceTemplatePrefix, baseName);
    }

    protected DeviceTemplate getDeviceTemplate(String baseName) {
        String name = this.getDeviceTemplateName(baseName);
        String rename = this.mRenamedDeviceTemplates.get(baseName);
        if (rename != null) {
            name = rename;
        }
        return DeviceTemplate.getDeviceTemplate((Substrate)this.mSubstrate, (String)name);
    }

    protected DeviceTemplate createDeviceTemplate(String baseName) {
        String name = baseName = this.getDeviceTemplateName(baseName);
        int i = 1;
        while (DeviceTemplate.getDeviceTemplate((Substrate)this.mSubstrate, (String)name) != null) {
            name = String.format("%s%d", baseName, i);
            ++i;
        }
        if (!name.equalsIgnoreCase(baseName)) {
            this.mRenamedDeviceTemplates.put(baseName, name);
            ALog.logInfo((String)"DeviceTemplate '%s' already exists, renamed to '%s'.", (Object[])new Object[]{baseName, name});
        }
        DeviceTemplate dt = new DeviceTemplate(name, this.mSubstrate);
        dt.setType(this.deviceTemplateType);
        return dt;
    }

    protected <T extends CCTFileSection> T getCCTFileSection(CCTFileSection parent, Class<T> cls, String key) {
        assert (parent != null);
        return parent.getSubSection(cls, key);
    }

    protected void createSubstrate(CCTFilePackage pkgSection) {
        String substrateName = Substrate.getUniqueName((Db)this.mDb, (String)(pkgSection.mName + "_Template"));
        this.mSubstrate = Substrate.create((Db)this.mDb, (String)substrateName);
    }

    protected void createLayers(CCTFilePackage pkgSection) {
        Iterator itrLayer = pkgSection.getSubSection(CCTFileLayer.class);
        ArrayList<CCTFileLayer> listLayer = new ArrayList<CCTFileLayer>();
        while (itrLayer != null && itrLayer.hasNext()) {
            listLayer.add((CCTFileLayer)itrLayer.next());
        }
        Collections.sort(listLayer);
        for (CCTFileLayer cCTFileLayer : listLayer) {
            Layer l = Layer.create((Substrate)this.mSubstrate, (String)cCTFileLayer.mName);
            if (cCTFileLayer.mThickness > 0.0) {
                l.setHeight((long)cCTFileLayer.mThickness);
            }
            if (cCTFileLayer.mWidth > 0.0) {
                l.setWidth((long)cCTFileLayer.mWidth);
            }
            if (cCTFileLayer.mType == null) continue;
            l.setType(cCTFileLayer.mType);
        }
        int order = listLayer.size() - 1;
        for (CCTFileLayer ls : listLayer) {
            Layer l = this.mSubstrate.getLayer(ls.mName);
            if (l == null) continue;
            l.setOrder(order--);
        }
        Iterator iterator = pkgSection.getSubSection(CCTFilePadStackDef.class);
        while (iterator != null && iterator.hasNext()) {
            CCTFilePadStackDef ps = (CCTFilePadStackDef)iterator.next();
            PadTemplate pt = PadTemplate.create((Db)this.mDb, (Substrate)this.mSubstrate, (String)ps.mName);
            Iterator itrPad = ps.getSubSection(CCTFilePadDef.class);
            while (itrPad != null && itrPad.hasNext()) {
                CCTFilePadDef padDef = (CCTFilePadDef)itrPad.next();
                Iterator itrGeom = padDef.getSubSection(CCTFilePad.class);
                if (itrGeom == null || !itrGeom.hasNext()) continue;
                CCTFilePad pad = (CCTFilePad)itrGeom.next();
                Layer l = this.mSubstrate.getLayer(padDef.mLayerName);
                if (l == null) continue;
                LayerShape.create((Db)this.mDb, (Layer)l, (DbObject)pt, (AGeom)pad.mGeom);
            }
        }
        this.mDefaultPadStackName = "~DefaultPadStack";
        int i = 0;
        while (PadTemplate.get((Db)this.mDb, (Substrate)this.mSubstrate, (String)this.mDefaultPadStackName) != null) {
            this.mDefaultPadStackName = this.mDefaultPadStackName + i;
            ++i;
        }
        PadTemplate ptDefault = PadTemplate.create((Db)this.mDb, (Substrate)this.mSubstrate, (String)this.mDefaultPadStackName);
        ACircle geomDefault = new ACircle(0L, 0L, Design.micronToInternal((Db)this.mDb, (double)200.0));
        for (Layer l : this.mDb.getObjects(Layer.class)) {
            LayerShape.create((Db)this.mDb, (Layer)l, (DbObject)ptDefault, (AGeom)geomDefault);
        }
    }

    protected void createComponents(CCTFilePackage pkgSection) {
        this.createCircuit(pkgSection, pkgSection);
        Iterator itrConns = this.mRouteSection.getSubSection(CCTFileConnect.class);
        while (itrConns != null && itrConns.hasNext()) {
            this.createCircuit(pkgSection, (CCTFileSection)itrConns.next());
        }
    }

    protected void createPorts(CCTFilePackage pkgSection, CCTFileSection section, Device device) {
        boolean pkgFlag = pkgSection == section;
        Iterator<Object> itrNode = null;
        DeviceTemplate dt = device.getTemplate();
        itrNode = !pkgFlag ? this.getComponentNodes(pkgSection, (CCTFileConnect)section).iterator() : pkgSection.getSubSection(CCTFileNode.class);
        int nodeCnt = 0;
        long x1 = Long.MAX_VALUE;
        long y1 = Long.MAX_VALUE;
        long x2 = Long.MIN_VALUE;
        long y2 = Long.MIN_VALUE;
        HashSet<PadTemplate> pts = new HashSet<PadTemplate>();
        while (itrNode != null && itrNode.hasNext()) {
            CCTFileNode node = (CCTFileNode)itrNode.next();
            long x = node.mPoint.getX();
            long y = node.mPoint.getY();
            if (x < x1) {
                x1 = x;
            }
            if (x > x2) {
                x2 = x;
            }
            if (y < y1) {
                y1 = y;
            }
            if (y > y2) {
                y2 = y;
            }
            ++nodeCnt;
            if (!node.isPin() || pkgFlag && this.getSectionOfPin(node.mName, pkgSection) != null) continue;
            Net net = this.createNet(device, node.mNetName);
            PinTemplate dtp = PinTemplate.create((Net)net, (String)node.mName);
            PadTemplate pt = PadTemplate.get((Db)this.mDb, (Substrate)this.mSubstrate, (String)node.mPadStackName);
            if (pt == null) {
                pt = PadTemplate.get((Db)this.mDb, (Substrate)this.mSubstrate, (String)this.mDefaultPadStackName);
            }
            dtp.setPadTemplate(pt);
            dtp.setLoc(new APoint2D(node.mPoint));
            dtp.setType(PinTemplate.Type.BALLPAD);
            PinInstance dp = new PinInstance(node.mPinName, device, dtp);
            this.mDb.add((DbObject)dp);
            if (pkgFlag) continue;
            pts.add(pt);
        }
        APoint2D extSpace = pkgFlag ? this.getPackageExtSpace() : this.getExtSpace(pts.iterator());
        ARect bound = null;
        if (nodeCnt > 0) {
            bound = new ARect(x1, y1, x2, y2);
            bound.expandBy(extSpace.getX(), extSpace.getY(), extSpace.getX(), extSpace.getY());
            if (pkgFlag) {
                this.mOffsetOrigin.setLoc(-bound.getLL().getX(), -bound.getLL().getY());
            }
            bound.moveBy(this.mOffsetOrigin);
        } else {
            bound = new ARect(0L, 0L, 0L, 0L);
        }
        device.setLoc(bound.getLL());
        dt.setBounds((AGeom)new ARect(0L, 0L, bound.width(), bound.height()));
        for (PinInstance p : device.getPins()) {
            PinTemplate dtp = p.getPinTemplate();
            APoint2D loc = dtp.getLoc();
            loc.moveBy(this.mOffsetOrigin.getX() - bound.getLL().getX(), this.mOffsetOrigin.getY() - bound.getLL().getY());
            dtp.setLoc(loc);
        }
    }

    protected void createWires(CCTFilePackage pkgSection, CCTFileSection section, Device device) {
        Iterator itrTrace = pkgSection.getSubSection(CCTFileTrace.class);
        while (itrTrace != null && itrTrace.hasNext()) {
            CCTFileTrace trace = (CCTFileTrace)itrTrace.next();
            if (trace.mStartNode == null || trace.mEndNode == null) continue;
            CCTFileNode nodeStart = pkgSection.getSubSection(CCTFileNode.class, trace.mStartNode);
            CCTFileNode nodeEnd = pkgSection.getSubSection(CCTFileNode.class, trace.mEndNode);
            assert (nodeStart.mLayerName.equals(nodeEnd.mLayerName));
            APath path = new APath(trace.mWidth, new APoint2D[]{nodeStart.mPoint, nodeEnd.mPoint});
            Layer l = this.mSubstrate.getLayer(nodeStart.mLayerName);
            Net net = this.createNet(device, trace.mNetName);
            Wire.create((Net)net, (Layer)l, (APath)path);
        }
    }

    protected void createDb() {
        CCTFilePackage pkgSection = this.getPackageSection();
        if (pkgSection == null) {
            return;
        }
        this.mDb.setActiveLoader((DbLoader)this);
        this.mDb.setHistoryEnabled(false);
        this.mDb.setListenersEnabled(false);
        this.createSubstrate(pkgSection);
        this.createLayers(pkgSection);
        this.createComponents(pkgSection);
        this.mDb.setActiveLoader(null);
        this.mDb.setListenersEnabled(true);
        this.mDb.setHistoryEnabled(true);
    }

    protected Device createCircuit(CCTFilePackage pkgSection, CCTFileSection section) {
        boolean pkgFlag = section == pkgSection;
        DeviceTemplate dt = this.createDeviceTemplate(section.mName);
        dt.setSourceType(DeviceTemplate.SourceType.USER);
        dt.setSubstrate(this.mSubstrate);
        dt.setIsSynthesized(false);
        dt.setType(pkgFlag ? DeviceTemplate.Type.PACKAGE : DeviceTemplate.Type.PACKAGEDDIE);
        this.mDb.add((DbObject)dt);
        Design tplParent = pkgFlag ? this.mDbDesign : this.mRootDevice.getTemplate();
        String deviceName = pkgFlag && this.mRootDeviceName != null && !this.mRootDeviceName.isEmpty() ? Device.getUniqueName((DeviceTemplate)tplParent, (String)this.mRootDeviceName) : Device.getUniqueName((DeviceTemplate)tplParent, (String)section.mName);
        Device device = new Device(deviceName, (DeviceTemplate)tplParent, dt);
        device.setLoc(new APoint2D(0L, 0L));
        device.setIsPlaced(true);
        device.setSynthesized(false);
        this.mDb.add((DbObject)device);
        if (pkgFlag) {
            this.mRootDevice = device;
        }
        this.createPorts(pkgSection, section, device);
        if (this.mReadTrace) {
            this.createWires(pkgSection, section, device);
        }
        return device;
    }

    protected CCTFilePackage getPackageSection() {
        Iterator itr = this.mRouteSection.getSubSection(CCTFilePackage.class);
        if (itr == null || !itr.hasNext()) {
            return null;
        }
        return (CCTFilePackage)itr.next();
    }

    protected ArrayList<CCTFileNode> getComponentNodes(CCTFilePackage pkgSection, CCTFileConnect connSection) {
        ArrayList<CCTFileNode> nodes = new ArrayList<CCTFileNode>();
        Iterator itr = connSection.getSubSection(CCTFileConnectItem.class);
        while (itr != null && itr.hasNext()) {
            CCTFileNode node;
            CCTFileConnectItem item = (CCTFileConnectItem)itr.next();
            if (item.mPkgName != null && !item.mPkgName.equalsIgnoreCase(pkgSection.mName) || (node = pkgSection.getSubSection(CCTFileNode.class, item.mPkgNode)) == null) continue;
            nodes.add(node);
        }
        return nodes;
    }

    protected CCTFileConnect getSectionOfPin(String pinName, CCTFilePackage pkg) {
        Iterator itr = this.mRouteSection.getSubSection(CCTFileConnect.class);
        while (itr != null && itr.hasNext()) {
            CCTFileConnect connect = (CCTFileConnect)itr.next();
            if (connect.getSubSection(CCTFileConnectItem.class, pinName) == null) continue;
            return connect;
        }
        return null;
    }

    protected Net createNet(Device device, String name) {
        Net net = null;
        DeviceTemplate template = device.getTemplate();
        if (name == null || name.isEmpty()) {
            name = "NetUnused";
        }
        if ((net = template.getNet(name)) == null) {
            net = Net.create((DeviceTemplate)template, (String)name);
        }
        if (this.mRootDevice != device && net != null && NetMap.getParentNet((Device)device, (Net)net) == null) {
            Net netRoot = Net.getOrCreate((DeviceTemplate)this.mRootDevice.getTemplate(), (String)name);
            NetMap.mapChildNet((Device)device, (Net)net, (Net)netRoot);
        }
        return net;
    }

    protected APoint2D getPackageExtSpace() {
        return this.getExtSpace((Iterator<PadTemplate>)this.mDb.getObjects(PadTemplate.class));
    }

    protected APoint2D getExtSpace(Iterator<PadTemplate> itrPad) {
        APoint2D extSpace = new APoint2D(0L, 0L);
        while (itrPad.hasNext()) {
            PadTemplate pt = itrPad.next();
            for (LayerShape ls : pt.getLayerShapes()) {
                ARect rc = ls.getGeom().getBounds();
                if (rc.width() > extSpace.getX()) {
                    extSpace.setX(rc.width());
                }
                if (rc.height() <= extSpace.getY()) continue;
                extSpace.setY(rc.height());
            }
        }
        return extSpace;
    }

    protected class CCTFileConnectItem
    extends CCTFileSection {
        protected String mPtlNode;
        protected String mPkgName;
        protected String mPkgNode;

        public CCTFileConnectItem(CCTFileSection parent, String key) {
            super(parent, key);
            this.mPtlNode = key;
        }

        @Override
        protected void parseProperty(String key) {
            this.mPkgNode = CCTFileDBProcessor.this.mReader.nextToken();
            int n = this.mPkgNode.indexOf(46);
            if (n >= 0) {
                this.mPkgName = this.mPkgNode.substring(0, n);
                this.mPkgNode = this.mPkgNode.substring(n + 1);
            }
            this.mName = this.mPkgNode;
        }
    }

    protected class CCTFileConnect
    extends CCTFileSection {
        protected String mPartialName;

        public CCTFileConnect(CCTFileSection parent, String key) {
            super(parent, key);
            this.addSectionHandler(new SectionDef("", CCTFileDBProcessor.this.mReader.newLineString(), SectionKeyCompType.EQUALS, CCTFileConnectItem.class));
        }

        public CCTFileConnectItem getConnectItem(String pkgName, String nodeName) {
            Iterator itr = this.getSubSection(CCTFileConnectItem.class);
            while (itr != null && itr.hasNext()) {
                CCTFileConnectItem item = (CCTFileConnectItem)itr.next();
                if (!item.mPkgName.equals(pkgName) || !item.mPkgNode.equals(nodeName)) continue;
                return item;
            }
            return null;
        }

        @Override
        protected void parseProperty(String key) {
            this.mName = CCTFileDBProcessor.this.mReader.nextToken();
            this.mPartialName = CCTFileDBProcessor.this.mReader.nextToken();
        }
    }

    protected class CCTFilePartialCkt
    extends CCTFileSection {
        public CCTFilePartialCkt(CCTFileSection parent, String key) {
            super(parent, key);
        }

        @Override
        protected void parseProperty(String key) {
            this.mName = CCTFileDBProcessor.this.mReader.nextToken();
        }
    }

    protected class CCTFilePad
    extends CCTFileSection {
        protected AGeom mGeom;

        public CCTFilePad(CCTFileSection parent, String key) {
            super(parent, key);
            this.mGeom = null;
        }

        @Override
        protected void parseProperty(String key) {
            this.mName = "_pad_" + key + mKeyIndex++;
            String sGeom = CCTFileDBProcessor.this.mReader.nextToken();
            this.mGeom = (AGeom)CCTFileDBProcessor.this.mGeomParser.parse(sGeom, false);
        }
    }

    protected class CCTFilePadDef
    extends CCTFileSection {
        protected String mLayerName;

        public CCTFilePadDef(CCTFileSection parent, String key) {
            super(parent, key);
            this.addSectionHandler(new SectionDef("regular", CCTFileDBProcessor.this.mReader.newLineString(), SectionKeyCompType.EQUALS, CCTFilePad.class));
            this.addSectionHandler(new SectionDef("anti", CCTFileDBProcessor.this.mReader.newLineString(), SectionKeyCompType.EQUALS, CCTFilePad.class));
            this.addSectionHandler(new SectionDef("thermal", CCTFileDBProcessor.this.mReader.newLineString(), SectionKeyCompType.EQUALS, CCTFilePad.class));
        }

        @Override
        protected void parseProperty(String key) {
            this.mName = "_PADDEF_" + mKeyIndex++;
            this.mLayerName = CCTFileDBProcessor.this.mReader.nextToken();
        }
    }

    protected class CCTFilePadStackDef
    extends CCTFileSection {
        public CCTFilePadStackDef(CCTFileSection parent, String key) {
            super(parent, key);
            this.addSectionHandler(new SectionDef(".paddef", ".endpaddef", SectionKeyCompType.EQUALS, CCTFilePadDef.class));
        }

        @Override
        protected void parseProperty(String key) {
            this.mName = CCTFileDBProcessor.this.mReader.nextToken();
        }
    }

    protected class CCTFileTrace
    extends CCTFileSection {
        protected String mNetName;
        protected String mStartNode;
        protected String mEndNode;
        protected long mWidth;

        public CCTFileTrace(CCTFileSection parent, String key) {
            super(parent, key);
            this.mWidth = Design.micronToInternal((Db)CCTFileDBProcessor.this.mDb, (double)100.0);
            StringTokens ss = new StringTokens(key, new String[]{"::"});
            this.mNetName = ss.get(1);
        }

        @Override
        protected void parseProperty(String key) {
            String s = CCTFileDBProcessor.this.mReader.nextToken();
            while (s != null && !s.equalsIgnoreCase(CCTFileReader.NEWLINE)) {
                if (s.equalsIgnoreCase("startingnode")) {
                    CCTFileDBProcessor.this.mReader.skipTokens(1);
                    this.mStartNode = CCTFileDBProcessor.this.mReader.nextToken();
                } else if (s.equalsIgnoreCase("endingnode")) {
                    CCTFileDBProcessor.this.mReader.skipTokens(1);
                    this.mEndNode = CCTFileDBProcessor.this.mReader.nextToken();
                } else if (s.equalsIgnoreCase("width")) {
                    CCTFileDBProcessor.this.mReader.skipTokens(1);
                    String w = CCTFileDBProcessor.this.mReader.nextToken();
                    this.mWidth = (long)CCTFileDBProcessor.this.mInternalUnit.CCTFileToInternal(w, CCTFileDBProcessor.DEFAULT_LENGTH_UNIT);
                }
                s = CCTFileDBProcessor.this.mReader.nextToken();
            }
        }
    }

    protected class CCTFileNode
    extends CCTFileSection {
        protected String mPinName;
        protected String mNetName;
        protected APoint2D mPoint;
        protected String mLayerName;
        protected String mPadStackName;

        public CCTFileNode(CCTFileSection parent, String key) {
            super(parent, key);
            this.mPinName = null;
            this.mNetName = null;
            StringTokens ss = new StringTokens(key, new String[]{"!!", "::"});
            this.mPinName = ss.get(1);
            this.mNetName = ss.get(2);
        }

        public boolean isPin() {
            return this.mPinName != null && !this.mPinName.isEmpty();
        }

        @Override
        protected void parseProperty(String key) {
            String x = "";
            String y = "";
            String s = CCTFileDBProcessor.this.mReader.nextToken();
            while (s != null && !s.equalsIgnoreCase(CCTFileDBProcessor.this.mReader.newLineString())) {
                if (s.equalsIgnoreCase("x")) {
                    CCTFileDBProcessor.this.mReader.skipTokens(1);
                    x = CCTFileDBProcessor.this.mReader.nextToken();
                } else if (s.equalsIgnoreCase("y")) {
                    CCTFileDBProcessor.this.mReader.skipTokens(1);
                    y = CCTFileDBProcessor.this.mReader.nextToken();
                } else if (s.equalsIgnoreCase("layer")) {
                    CCTFileDBProcessor.this.mReader.skipTokens(1);
                    this.mLayerName = CCTFileDBProcessor.this.mReader.nextToken();
                } else if (s.equalsIgnoreCase("padstack")) {
                    CCTFileDBProcessor.this.mReader.skipTokens(1);
                    this.mPadStackName = CCTFileDBProcessor.this.mReader.nextToken();
                }
                s = CCTFileDBProcessor.this.mReader.nextToken();
            }
            this.mPoint = new APoint2D((long)CCTFileDBProcessor.this.mInternalUnit.CCTFileToInternal(x, CCTFileDBProcessor.DEFAULT_LENGTH_UNIT), (long)CCTFileDBProcessor.this.mInternalUnit.CCTFileToInternal(y, CCTFileDBProcessor.DEFAULT_LENGTH_UNIT));
        }
    }

    protected class CCTFileLayer
    extends CCTFileSection
    implements Comparable<CCTFileLayer> {
        protected double mThickness;
        protected double mWidth;
        protected String mShape;
        protected String mType;
        protected int mOrder;

        public CCTFileLayer(CCTFileSection parent, String key) {
            super(parent, key);
            this.mThickness = 0.0;
            this.mWidth = 0.0;
            this.mShape = null;
            this.mType = null;
            this.mOrder = -1;
            this.mOrder = CCTFileDBProcessor.this.mLayerOrder++;
        }

        @Override
        protected void parseProperty(String key) {
            String t = CCTFileDBProcessor.this.mReader.nextToken();
            while (t != null && !t.equalsIgnoreCase(CCTFileDBProcessor.this.mReader.newLineString())) {
                if (t.equalsIgnoreCase("thickness")) {
                    CCTFileDBProcessor.this.mReader.skipTokens(1);
                    t = CCTFileDBProcessor.this.mReader.nextToken();
                    this.mThickness = CCTFileDBProcessor.this.mInternalUnit.CCTFileToInternal(t, CCTFileDBProcessor.DEFAULT_LENGTH_UNIT);
                } else if (t.equalsIgnoreCase("width")) {
                    CCTFileDBProcessor.this.mReader.skipTokens(1);
                    t = CCTFileDBProcessor.this.mReader.nextToken();
                    this.mWidth = CCTFileDBProcessor.this.mInternalUnit.CCTFileToInternal(t, CCTFileDBProcessor.DEFAULT_LENGTH_UNIT);
                } else if (t.equalsIgnoreCase("shape")) {
                    CCTFileDBProcessor.this.mReader.skipTokens(1);
                    this.mShape = CCTFileDBProcessor.this.mReader.nextToken();
                } else if (t.equalsIgnoreCase("type")) {
                    CCTFileDBProcessor.this.mReader.skipTokens(1);
                    this.mType = CCTFileDBProcessor.this.mReader.nextToken();
                }
                t = CCTFileDBProcessor.this.mReader.nextToken();
            }
        }

        @Override
        public int compareTo(CCTFileLayer o) {
            return this.mOrder - o.mOrder;
        }
    }

    protected class CCTFileShapeGeom
    extends CCTFileSection {
        protected String mNetName;
        protected AGeom mGeom;

        public CCTFileShapeGeom(CCTFileSection parent, String key) {
            super(parent, key);
            this.mGeom = null;
        }

        @Override
        protected void parseProperty(String key) {
            int i;
            StringTokens ss = new StringTokens(key, new String[]{"::"});
            if (ss.countTokens() != 2 || !CCTFileDBProcessor.this.mReader.findToken("color") || !CCTFileDBProcessor.this.mReader.skipTokens(2)) {
                return;
            }
            this.mNetName = ss.get(1);
            this.mNetName = this.mNetName.replace("+", "");
            this.mNetName = this.mNetName.replace("-", "");
            String[] t = new String[]{"polygon", "box", "circle"};
            for (i = 0; i < t.length; ++i) {
                if (!this.mName.startsWith(t[i])) continue;
                this.mGeom = (AGeom)CCTFileDBProcessor.this.mGeomParser.parse(t[i], true);
                break;
            }
            assert (i < t.length);
        }
    }

    protected class CCTFileShape
    extends CCTFileSection {
        public CCTFileShape(CCTFileSection parent, String key) {
            super(parent, key);
            this.addSectionHandler(new SectionDef("polygon", CCTFileDBProcessor.this.mReader.newLineString(), SectionKeyCompType.STARTSWITH, CCTFileShapeGeom.class));
            this.addSectionHandler(new SectionDef("circle", CCTFileDBProcessor.this.mReader.newLineString(), SectionKeyCompType.STARTSWITH, CCTFileShapeGeom.class));
            this.addSectionHandler(new SectionDef("box", CCTFileDBProcessor.this.mReader.newLineString(), SectionKeyCompType.STARTSWITH, CCTFileShapeGeom.class));
        }

        @Override
        protected void parseProperty(String key) {
            this.mName = CCTFileDBProcessor.this.mReader.nextToken();
        }
    }

    protected class CCTFilePackage
    extends CCTFileSection {
        public CCTFilePackage(CCTFileSection parent, String key) {
            super(parent, key);
            CCTFileDBProcessor.this.mLayerOrder = 0;
            if (CCTFileDBProcessor.this.mReadShape) {
                this.addSectionHandler(new SectionDef(".shape", ".endshape", SectionKeyCompType.EQUALS, CCTFileShape.class));
            }
            this.addSectionHandler(new SectionDef("plane", CCTFileDBProcessor.this.mReader.newLineString(), SectionKeyCompType.STARTSWITH, CCTFileLayer.class));
            this.addSectionHandler(new SectionDef("signal", CCTFileDBProcessor.this.mReader.newLineString(), SectionKeyCompType.STARTSWITH, CCTFileLayer.class));
            this.addSectionHandler(new SectionDef("node", CCTFileDBProcessor.this.mReader.newLineString(), SectionKeyCompType.STARTSWITH, CCTFileNode.class));
            if (CCTFileDBProcessor.this.mReadTrace) {
                this.addSectionHandler(new SectionDef("trace", CCTFileReader.NEWLINE, SectionKeyCompType.STARTSWITH, CCTFileTrace.class));
            }
            this.addSectionHandler(new SectionDef(".padstackdef", ".endpadstackdef", SectionKeyCompType.EQUALS, CCTFilePadStackDef.class));
        }

        @Override
        protected void parseProperty(String key) {
            this.mName = CCTFileDBProcessor.this.mReader.nextToken();
        }

        @Override
        public boolean onUnHandleSection(String key, CCTFileSection parent) {
            if (key.startsWith("patch")) {
                String shape = null;
                String layer = null;
                String s = CCTFileDBProcessor.this.mReader.nextToken();
                while (s != null && !s.equalsIgnoreCase(CCTFileDBProcessor.this.mReader.newLineString())) {
                    if (s.equalsIgnoreCase("shape")) {
                        CCTFileDBProcessor.this.mReader.skipTokens(1);
                        shape = CCTFileDBProcessor.this.mReader.nextToken();
                    } else if (s.equalsIgnoreCase("layer")) {
                        CCTFileDBProcessor.this.mReader.skipTokens(1);
                        layer = CCTFileDBProcessor.this.mReader.nextToken();
                    }
                    s = CCTFileDBProcessor.this.mReader.nextToken();
                }
                if (shape != null && layer != null) {
                    CCTFileLayer cLayer = this.getSubSection(CCTFileLayer.class, layer);
                    cLayer.mShape = shape;
                }
            }
            return true;
        }
    }

    protected class RouteFileSection
    extends CCTFileSection {
        protected String mTitle;

        public RouteFileSection(CCTFileSection parent, String key) {
            super(parent, key);
            this.addSectionHandler(new SectionDef(".package", ".endpackage", SectionKeyCompType.EQUALS, CCTFilePackage.class));
            this.addSectionHandler(new SectionDef(".partialckt", ".endpartialckt", SectionKeyCompType.EQUALS, CCTFilePartialCkt.class));
            this.addSectionHandler(new SectionDef(".connect", ".endc", SectionKeyCompType.EQUALS, CCTFileConnect.class));
        }

        @Override
        protected void parseProperty(String key) {
            this.mTitle = CCTFileDBProcessor.this.mReader.nextToken();
        }
    }

    protected abstract class CCTFileSection
    implements Parser {
        protected String mName;
        protected CCTFileSection mParent = null;
        protected SectionDef mSectionDef = SectionDef.NONE_SECTIONDEF;
        protected ArrayList<SectionDef> mSubSectionDefs = new ArrayList();
        protected HashMap<Class<?>, HashMap<String, CCTFileSection>> mSubSections = new HashMap();

        public CCTFileSection(CCTFileSection parent, String key) {
            this.mParent = parent;
            this.mName = key;
        }

        protected abstract void parseProperty(String var1);

        public <T extends CCTFileSection> void addSectionHandler(SectionDef secDef) {
            this.mSubSectionDefs.add(secDef);
        }

        public CCTFileSection newSection(String key, CCTFileSection parent) {
            CCTFileSection section = null;
            for (SectionDef def : this.mSubSectionDefs) {
                if (!this.isInterestedSection(def, key)) continue;
                Class<?> cls = def.mClass;
                try {
                    section = (CCTFileSection)cls.getDeclaredConstructor(CCTFileDBProcessor.class, CCTFileSection.class, String.class).newInstance(CCTFileDBProcessor.this, parent, key);
                    section.mSectionDef = def;
                }
                catch (Exception e) {
                    ALog.logError((String)"Failed to create the instance of %s : %s", (Object[])new Object[]{cls.getName(), e.getMessage()});
                }
                break;
            }
            return section;
        }

        public boolean onUnHandleSection(String key, CCTFileSection parent) {
            return true;
        }

        public boolean onNewSubSection(CCTFileSection section) {
            return true;
        }

        public void onEndSection() {
        }

        public <T extends CCTFileSection> T getSubSection(Class<T> cls, String key) {
            HashMap<String, CCTFileSection> map = this.mSubSections.get(cls);
            if (map == null) {
                return null;
            }
            return (T)map.get(key);
        }

        public <T extends CCTFileSection> Iterator<T> getSubSection(Class<?> cls) {
            HashMap<String, CCTFileSection> map = this.mSubSections.get(cls);
            if (map == null) {
                return null;
            }
            return map.values().iterator();
        }

        @Override
        public Object parse(String key) {
            this.parseProperty(key);
            if (!CCTFileDBProcessor.this.mReader.currentToken().equals(CCTFileDBProcessor.this.mReader.newLineString())) {
                CCTFileDBProcessor.this.mReader.skipLine();
            }
            CCTFileDBProcessor.this.mReader.pushbackToken(CCTFileDBProcessor.this.mReader.newLineString());
            String t = CCTFileDBProcessor.this.mReader.nextToken();
            while (t != null && !t.isEmpty()) {
                if (this.isEndSection(t)) {
                    this.onEndSection();
                    return this;
                }
                if (!t.equals(CCTFileDBProcessor.this.mReader.newLineString())) {
                    CCTFileSection section = this.newSection(t, this);
                    if (section == null) {
                        if (!this.onUnHandleSection(key, this)) break;
                        CCTFileDBProcessor.this.mReader.skipLine();
                    } else {
                        if (!this.onNewSubSection(section)) break;
                        section.parse(t);
                        this.addCreatedSection(section);
                    }
                }
                t = CCTFileDBProcessor.this.mReader.nextToken();
            }
            this.onEndSection();
            return this;
        }

        protected boolean isEndSection(String key) {
            return this.mSectionDef.mEndKey.equalsIgnoreCase(key);
        }

        protected boolean isInterestedSection(SectionDef def, String key) {
            return def.mStartKey.isEmpty() || def.mKeyType == SectionKeyCompType.EQUALS && def.mStartKey.equalsIgnoreCase(key) || def.mKeyType == SectionKeyCompType.STARTSWITH && key.startsWith(def.mStartKey) || def.mKeyType == SectionKeyCompType.ENDSWITH && key.endsWith(def.mStartKey);
        }

        protected void addCreatedSection(CCTFileSection section) {
            HashMap<String, CCTFileSection> map = this.mSubSections.get(section.getClass());
            if (map == null) {
                map = new HashMap();
                this.mSubSections.put(section.getClass(), map);
            }
            map.put(section.mName, section);
        }
    }

    protected static class SectionDef {
        protected String mStartKey;
        protected String mEndKey;
        protected Class<?> mClass;
        protected SectionKeyCompType mKeyType = SectionKeyCompType.EQUALS;
        protected static final SectionDef NONE_SECTIONDEF = new SectionDef("", "", SectionKeyCompType.EQUALS, null);

        public SectionDef(String startKey, String endKey, SectionKeyCompType keyType, Class<?> cls) {
            this.mStartKey = startKey;
            this.mEndKey = endKey;
            this.mKeyType = keyType;
            this.mClass = cls;
        }
    }

    protected class CCTFileGeomParser {
        protected CCTFileGeomParser() {
        }

        public Object parse(String type, boolean withCoordinate) {
            APolygon geom = null;
            ArrayList<String> l = null;
            int i = 0;
            if (type.equals("polygon")) {
                geom = new APolygon();
                while ((l = CCTFileDBProcessor.this.mReader.readTokens(2)) != null) {
                    geom.addPoint((long)CCTFileDBProcessor.this.mInternalUnit.CCTFileToInternal(l.get(0), CCTFileDBProcessor.DEFAULT_LENGTH_UNIT), (long)CCTFileDBProcessor.this.mInternalUnit.CCTFileToInternal(l.get(1), CCTFileDBProcessor.DEFAULT_LENGTH_UNIT));
                }
            } else if (type.equals("circle")) {
                geom = new ACircle();
                if (withCoordinate) {
                    l = CCTFileDBProcessor.this.mReader.readTokens(3);
                    ((ACircle)geom).setCenter((long)CCTFileDBProcessor.this.mInternalUnit.CCTFileToInternal(l.get(i++), CCTFileDBProcessor.DEFAULT_LENGTH_UNIT), (long)CCTFileDBProcessor.this.mInternalUnit.CCTFileToInternal(l.get(i++), CCTFileDBProcessor.DEFAULT_LENGTH_UNIT));
                } else {
                    l = CCTFileDBProcessor.this.mReader.readTokens(1);
                }
                ((ACircle)geom).setR((long)CCTFileDBProcessor.this.mInternalUnit.CCTFileToInternal(l.get(i), CCTFileDBProcessor.DEFAULT_LENGTH_UNIT));
            } else if (type.equals("box")) {
                geom = new ARect();
                long x = 0L;
                long y = 0L;
                if (withCoordinate) {
                    l = CCTFileDBProcessor.this.mReader.readTokens(4);
                    x = (long)CCTFileDBProcessor.this.mInternalUnit.CCTFileToInternal(l.get(i++), CCTFileDBProcessor.DEFAULT_LENGTH_UNIT);
                    y = (long)CCTFileDBProcessor.this.mInternalUnit.CCTFileToInternal(l.get(i++), CCTFileDBProcessor.DEFAULT_LENGTH_UNIT);
                } else {
                    l = CCTFileDBProcessor.this.mReader.readTokens(2);
                }
                ((ARect)geom).setLL(x, y);
                ((ARect)geom).setUR(x + (long)CCTFileDBProcessor.this.mInternalUnit.CCTFileToInternal(l.get(i++), CCTFileDBProcessor.DEFAULT_LENGTH_UNIT), y + (long)CCTFileDBProcessor.this.mInternalUnit.CCTFileToInternal(l.get(i), CCTFileDBProcessor.DEFAULT_LENGTH_UNIT));
            } else if (type.equals("square")) {
                assert (!withCoordinate);
                geom = new ARect();
                l = CCTFileDBProcessor.this.mReader.readTokens(1);
                long w = (long)CCTFileDBProcessor.this.mInternalUnit.CCTFileToInternal(l.get(i), CCTFileDBProcessor.DEFAULT_LENGTH_UNIT);
                ((ARect)geom).setLL(0L, 0L);
                ((ARect)geom).setUR(w, w);
            } else if (type.equals("roundedrect_x") || type.equals("roundedrect_y")) {
                assert (!withCoordinate);
                geom = new ARect();
                l = CCTFileDBProcessor.this.mReader.readTokens(2);
                ((ARect)geom).setLL(0L, 0L);
                ((ARect)geom).setUR((long)CCTFileDBProcessor.this.mInternalUnit.CCTFileToInternal(l.get(0), CCTFileDBProcessor.DEFAULT_LENGTH_UNIT), (long)CCTFileDBProcessor.this.mInternalUnit.CCTFileToInternal(l.get(1), CCTFileDBProcessor.DEFAULT_LENGTH_UNIT));
            } else assert (false);
            return geom;
        }
    }

    public static class CCTFileUnit {
        protected HashMap<String, Double> mScaleUnits = new HashMap();
        protected HashMap<String, Long> mInternalScales = new HashMap();

        public CCTFileUnit(Db db) {
            this.mScaleUnits.put(CCTFileDBProcessor.DEFAULT_LENGTH_UNIT, Math.pow(10.0, -3.0));
            this.mScaleUnits.put("t", Math.pow(10.0, 12.0));
            this.mScaleUnits.put("g", Math.pow(10.0, 9.0));
            this.mScaleUnits.put("meg", Math.pow(10.0, 6.0));
            this.mScaleUnits.put("k", Math.pow(10.0, 3.0));
            this.mScaleUnits.put("u", Math.pow(10.0, -6.0));
            this.mScaleUnits.put("n", Math.pow(10.0, -9.0));
            this.mScaleUnits.put("p", Math.pow(10.0, -12.0));
            this.mScaleUnits.put("f", Math.pow(10.0, -15.0));
            Design design = Design.getDesign((Db)db);
            assert (design != null);
            this.mInternalScales.put(CCTFileDBProcessor.DEFAULT_LENGTH_UNIT, 1000000L * design.getInternalPerMicron());
            this.mInternalScales.put("s", 1L);
            this.mInternalScales.put("o", 1L);
            this.mInternalScales.put("f", 1L);
            this.mInternalScales.put("h", 1L);
            this.mInternalScales.put("a", 1L);
            this.mInternalScales.put("v", 1L);
        }

        public double CCTFileToInternal(String s, String defaultUnit) {
            String sUnit = "";
            long nUnit = 0L;
            String sScale = "";
            double nScale = 1.0;
            for (String n : this.mInternalScales.keySet()) {
                if (!s.endsWith(n)) continue;
                sUnit = n;
                break;
            }
            if (sUnit.isEmpty()) {
                sUnit = defaultUnit;
            } else {
                int e = s.length() - sUnit.length();
                if (e <= 0) {
                    return 0.0;
                }
                s = s.substring(0, e);
            }
            assert (this.mInternalScales.containsKey(sUnit));
            nUnit = this.mInternalScales.get(sUnit);
            for (String n : this.mScaleUnits.keySet()) {
                if (!s.endsWith(n)) continue;
                sScale = n;
                break;
            }
            if (!sScale.isEmpty()) {
                int e = s.length() - sScale.length();
                if (e <= 0) {
                    return 0.0;
                }
                s = s.substring(0, e);
                nScale = this.mScaleUnits.get(sScale);
            }
            try {
                return Double.parseDouble(s) * nScale * (double)nUnit;
            }
            catch (NumberFormatException e) {
                ALog.logDebug((Throwable)e);
                return 0.0;
            }
        }

        public double internalToCCTFile(double val, String unit, String scale) {
            double nScale = this.mScaleUnits.get(unit);
            long nUnit = this.mInternalScales.get(scale);
            return val / ((double)nUnit * nScale);
        }
    }

    public static class StringTokens {
        protected ArrayList<String> mTokens = new ArrayList();

        public StringTokens(String str, String[] delims) {
            ArrayList<Integer> pos = new ArrayList<Integer>();
            this.mTokens.add("");
            for (int i = 0; str != null && i < delims.length; ++i) {
                pos.add(str.indexOf(delims[i]));
            }
            int minPos = Integer.MAX_VALUE;
            for (int i = 0; i < pos.size(); ++i) {
                int startPos = (Integer)pos.get(i);
                if (startPos < 0) {
                    this.mTokens.add("");
                    continue;
                }
                if (minPos > startPos) {
                    minPos = startPos;
                }
                int endPos = str.length();
                for (int j = 0; j < pos.size(); ++j) {
                    int k = (Integer)pos.get(j);
                    if (k <= startPos || k >= endPos) continue;
                    endPos = k;
                }
                if (startPos + delims[i].length() == str.length()) {
                    this.mTokens.add("");
                    continue;
                }
                this.mTokens.add(str.substring(startPos + delims[i].length(), endPos));
            }
            if (minPos == Integer.MAX_VALUE) {
                this.mTokens.set(0, str);
            } else {
                this.mTokens.set(0, str.substring(0, minPos));
            }
        }

        public int countTokens() {
            return this.mTokens.size();
        }

        public String get(int index) {
            if (index >= this.mTokens.size()) {
                return null;
            }
            return this.mTokens.get(index);
        }
    }

    protected static interface Parser {
        public Object parse(String var1);
    }

    public static enum SectionKeyCompType {
        EQUALS,
        STARTSWITH,
        ENDSWITH;

    }
}

