/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit.CCTFile;

import com.sigrity.acl.ALog;
import com.sigrity.orbit.CCTFile.CCTFile;
import com.sigrity.orbit.CCTFile.CCTFileDBProcessor;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Stack;

public class CCTFileReader
implements CCTFile.Reader {
    protected static String NEWLINE = "\n";
    protected String mFile;
    protected String mOldToken = null;
    protected String mLineBuffer = "";
    protected CCTFileDBProcessor mProcessor = null;
    protected BufferedReader mInReader = null;
    protected LinkedList<String> mLineTokens = new LinkedList();
    protected Stack<String> mPendingToken = new Stack();

    public void setDbProcessor(CCTFileDBProcessor processor) {
        this.mProcessor = processor;
    }

    public void mkDesign(String file) {
        this.mFile = file;
        try {
            this.mInReader = new BufferedReader(new FileReader(file));
            this.mProcessor.mkDesign();
        }
        catch (FileNotFoundException e) {
            ALog.logError((Throwable)e, (String)"File '%s' not found.", (Object[])new Object[]{file});
        }
    }

    @Override
    public String newLineString() {
        return NEWLINE;
    }

    @Override
    public String nextToken() {
        this.mOldToken = this.readToken();
        if (this.mOldToken != null) {
            this.mOldToken = this.mOldToken.toLowerCase();
        }
        return this.mOldToken;
    }

    @Override
    public String currentToken() {
        return this.mOldToken;
    }

    @Override
    public void pushbackToken(String token) {
        this.mPendingToken.push(token);
    }

    @Override
    public void skipLine() {
        String s = this.nextToken();
        while (s != null && !s.equalsIgnoreCase(NEWLINE)) {
            s = this.nextToken();
        }
    }

    @Override
    public boolean skipTokens(int tokenNum) {
        for (int i = 0; i < tokenNum; ++i) {
            String s = this.nextToken();
            if (s != null && !s.equalsIgnoreCase(NEWLINE)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean findToken(String token) {
        String s;
        while ((s = this.nextToken()) != null && !s.equalsIgnoreCase(NEWLINE)) {
            if (!s.equalsIgnoreCase(token)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ArrayList<String> readTokens(int n) {
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < n; ++i) {
            String s = this.nextToken();
            if (s == null || s.equalsIgnoreCase(NEWLINE)) {
                return null;
            }
            l.add(s);
        }
        return l;
    }

    protected String readLine() throws IOException {
        String s;
        Object line = this.mLineBuffer;
        this.mLineBuffer = "";
        while ((s = this.mInReader.readLine()) != null) {
            if ((s = s.trim()).isEmpty() || s.charAt(0) == '*') continue;
            if (s.charAt(0) == '+') {
                line = (String)line + " " + s.substring(1);
                continue;
            }
            if (((String)line).isEmpty()) {
                line = s;
                continue;
            }
            this.mLineBuffer = s;
            break;
        }
        return ((String)line).isEmpty() ? null : line;
    }

    protected void parseLineTokens() throws IOException {
        String[] tokens;
        assert (this.mLineTokens.isEmpty());
        String s = this.readLine();
        if (s == null || s.isEmpty()) {
            return;
        }
        for (String t : tokens = s.split("\\s+")) {
            int i = t.indexOf(61);
            if (i <= 0) {
                this.mLineTokens.add(t);
                continue;
            }
            this.mLineTokens.add(t.substring(0, i));
            this.mLineTokens.add("=");
            if (i >= t.length() - 1) continue;
            this.mLineTokens.add(t.substring(i + 1));
        }
        this.mLineTokens.add(NEWLINE);
    }

    protected String readToken() {
        if (!this.mPendingToken.empty()) {
            return this.mPendingToken.pop();
        }
        String token = null;
        try {
            if (this.mLineTokens.isEmpty()) {
                this.parseLineTokens();
            }
            if (!this.mLineTokens.isEmpty()) {
                token = this.mLineTokens.removeFirst();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return token;
    }
}

