/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit;

import com.sigrity.acl.AAlphaNumComp;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.orbit.CCTFile.CCTFile;
import com.sigrity.orbit.CCTFile.CCTFileConstraints;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.SubstrateTemplate;
import java.io.File;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;

public class CCTFileCommands {
    protected static Db mDb;
    protected static File mFile;
    protected static CCTFile mCCTFile;
    protected static DevicePath mDevicePath;
    protected static HashSet<Net> mSelectedNets;
    protected static LinkedList<Bundle> mSelectedBundles;
    protected static HashMap<APair<HierInst<PinTemplate>, HierInst<PinTemplate>>, LinkedList<Layer>> mSelectedPinPairs;
    protected static LinkedHashMap<Layer, Boolean> mAllLayers;
    protected static List<CCTFileConstraints.CCTConstraint> mConstraints;
    private static final Comparator<SubstrateTemplate> ALPHA_NUMERIC_ORDER;

    private static void init() {
        mCCTFile = new CCTFile();
        CCTFileCommands.setParams();
        mCCTFile.setMassageNames(false);
        mCCTFile.deriveMaps(mDevicePath, mSelectedNets, mSelectedBundles, mAllLayers, mSelectedPinPairs);
        mCCTFile.setConfiguration(null, mConstraints, CCTFile.ViaPattern.Spiral, 0.4, true, false, true);
    }

    public static boolean writeSession(Db curDb, String devPathStr, String filePathStr) {
        boolean status = false;
        if (curDb == null) {
            ALog.logError((String)"No database specified.");
            return status;
        }
        mDb = curDb;
        mDevicePath = DevicePath.fromString((Db)mDb, (String)devPathStr);
        if (mDevicePath == null) {
            ALog.logWarn((String)"DevicePath '%s' does not exist", (Object[])new Object[]{devPathStr});
            return status;
        }
        mFile = new File(filePathStr);
        status = CCTFileCommands.writeSession();
        return status;
    }

    public static boolean writeSession() {
        CCTFileCommands.init();
        boolean status = mCCTFile.write(mFile, mDevicePath, CCTFile.FileType.SessionFile);
        if (!status) {
            ALog.logError((String)"Error writing DSN (design) file.");
        }
        return status;
    }

    public static void setParams() {
        DeviceTemplate devT = mDevicePath.getDeviceTemplate();
        devT.getNets().stream().filter(net -> !net.isUnused()).forEach(net -> mSelectedNets.add((Net)net));
        mAllLayers.clear();
        AUtil.linkedList(SubstrateTemplate.getSubstrateInstances(mDb, true, false, null)).stream().sorted(ALPHA_NUMERIC_ORDER).forEach(dbObj -> {
            Substrate sub = (Substrate)dbObj.first;
            sub.getLayers(Layer.TopFirstSort).stream().filter(l -> !l.getType().equals((Object)Layer.LayerType.Dielectric) && CCTFile.isCCTLayer(l)).forEach(l -> mAllLayers.put((Layer)l, true));
        });
        CCTFileConstraints mCons = new CCTFileConstraints(mDevicePath);
        mConstraints = mCons.getConstraints();
    }

    static {
        mSelectedNets = new HashSet();
        mSelectedBundles = new LinkedList();
        mSelectedPinPairs = new HashMap();
        mAllLayers = new LinkedHashMap();
        ALPHA_NUMERIC_ORDER = new Comparator<SubstrateTemplate>(){

            @Override
            public int compare(SubstrateTemplate e1, SubstrateTemplate e2) {
                AAlphaNumComp c = AAlphaNumComp.get();
                return c.compare((Object)((Substrate)e1.first).getName(), (Object)((Substrate)e2.first).getName());
            }
        };
    }
}

