/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit;

import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.orbit.verilog.CallTree;
import com.sigrity.tools.dbexplorer.DBEResources;
import edu.uci.ics.jung.graph.DelegateForest;
import java.awt.Color;
import java.awt.Paint;
import javax.swing.Icon;

public class CallGraph {
    protected DelegateForest<Vertex, Edge> mForest = new DelegateForest();

    public CallGraph(CallTree ct) {
        DeviceVertex v = new DeviceVertex("top");
        this.mForest.addVertex((Object)v);
        for (CallTree.TemplateNode node : ct.getNodes()) {
            if (node.isAChild()) continue;
            this.insertNodeAndChildrenAt(node, "top", v);
        }
    }

    protected void insertNodeAndChildrenAt(CallTree.TemplateNode n, String rName, DeviceVertex parentVertex) {
        DeviceVertex v = new DeviceVertex(rName + n.getName());
        CallEdge e = new CallEdge();
        this.mForest.addEdge((Object)e, (Object)parentVertex, (Object)v);
        for (CallTree.InstanceNode ref : n.getReferences()) {
            this.insertNodeAndChildrenAt(ref.getTemplate(), ref.getName(), v);
        }
    }

    public static class CallEdge
    extends Edge {
        protected int mWidth;

        public void setWidth(int w) {
            this.mWidth = w;
        }

        public int getWidth() {
            return this.mWidth;
        }

        @Override
        String getLabel() {
            return Integer.toString(this.mWidth);
        }

        @Override
        Paint getPaint() {
            return Color.CYAN;
        }
    }

    public static class PortVertex
    extends Vertex {
        protected PinTemplate mPort;

        public PortVertex(PinTemplate port) {
            this.mPort = port;
        }

        @Override
        String getLabel() {
            return this.mPort.getName();
        }

        @Override
        Paint getPaint() {
            return Color.CYAN;
        }

        @Override
        Icon getIcon() {
            return DBEResources.ICON_PIN;
        }
    }

    public static class DeviceTemplateVertex
    extends Vertex {
        protected DeviceTemplate mDeviceTemplate;

        public DeviceTemplateVertex(DeviceTemplate dt) {
            this.mDeviceTemplate = dt;
        }

        @Override
        String getLabel() {
            return this.mDeviceTemplate.getName();
        }

        @Override
        Paint getPaint() {
            return Color.YELLOW;
        }

        @Override
        Icon getIcon() {
            return DBEResources.ICON_TEMPLATE;
        }
    }

    public static class DeviceVertex
    extends Vertex {
        protected String mName;

        public DeviceVertex(String name) {
            this.mName = name;
        }

        public String getDevice() {
            return this.mName;
        }

        @Override
        String getLabel() {
            return this.mName;
        }

        @Override
        Paint getPaint() {
            return Color.GREEN;
        }

        @Override
        Icon getIcon() {
            return DBEResources.ICON_DESIGNDEVICES;
        }
    }

    public static abstract class Edge {
        abstract String getLabel();

        abstract Paint getPaint();
    }

    public static abstract class Vertex {
        abstract String getLabel();

        abstract Paint getPaint();

        abstract Icon getIcon();
    }
}

