/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit;

import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.orbit.CallGraph;
import edu.uci.ics.jung.algorithms.layout.BalloonLayout;
import edu.uci.ics.jung.algorithms.layout.CircleLayout;
import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.FRLayout2;
import edu.uci.ics.jung.algorithms.layout.KKLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.RadialTreeLayout;
import edu.uci.ics.jung.algorithms.layout.SpringLayout;
import edu.uci.ics.jung.algorithms.layout.SpringLayout2;
import edu.uci.ics.jung.algorithms.layout.TreeLayout;
import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ScalingControl;
import edu.uci.ics.jung.visualization.decorators.EdgeShape;
import edu.uci.ics.jung.visualization.layout.LayoutTransition;
import edu.uci.ics.jung.visualization.renderers.BasicVertexRenderer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import edu.uci.ics.jung.visualization.util.Animator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.functors.ConstantTransformer;

public class CallGraphPanel
extends JPanel {
    VisualizationViewer<CallGraph.Vertex, CallGraph.Edge> mVisualizationViewer;
    protected String[] mLayoutNames = new String[]{"Radial Tree", "Tree", "FR", "FR2", "KK", "Circle", "Spring", "Spring2", "Balloon"};
    protected Layout<CallGraph.Vertex, CallGraph.Edge>[] mLayouts;

    public CallGraphPanel(CallGraph graph) {
        GridBagManager layout = new GridBagManager((Container)this);
        this.mLayouts = new Layout[]{new RadialTreeLayout(graph.mForest), new TreeLayout(graph.mForest), new FRLayout(graph.mForest), new FRLayout2(graph.mForest), new KKLayout(graph.mForest), new CircleLayout(graph.mForest), new SpringLayout(graph.mForest), new SpringLayout2(graph.mForest), new BalloonLayout(graph.mForest)};
        this.mVisualizationViewer = new VisualizationViewer(this.mLayouts[0]);
        this.mVisualizationViewer.setBackground(Color.white);
        this.mVisualizationViewer.addComponentListener((ComponentListener)new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                super.componentResized(e);
                CallGraphPanel.this.mVisualizationViewer.getGraphLayout().setSize(e.getComponent().getSize());
            }
        });
        RenderContext rc = this.mVisualizationViewer.getRenderContext();
        rc.setEdgeShapeTransformer((Transformer)new EdgeShape.Line());
        rc.setVertexLabelTransformer((Transformer)new NGVertexNameLabeller());
        rc.setArrowFillPaintTransformer((Transformer)new ConstantTransformer((Object)Color.lightGray));
        rc.setVertexFillPaintTransformer((Transformer)new NGVertexPaint());
        rc.setVertexIconTransformer((Transformer)new NGVertexIcon());
        rc.setVertexShapeTransformer((Transformer)new NGVertexShape());
        this.mVisualizationViewer.getRenderer().setVertexRenderer((Renderer.Vertex)new NGVertexRenderer());
        this.mVisualizationViewer.setVertexToolTipTransformer((Transformer)new NGVertexNameLabeller());
        GraphZoomScrollPane panel = new GraphZoomScrollPane(this.mVisualizationViewer);
        layout.add((Component)panel, (GridBagConstraints)GridBagManager.FILLALL);
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.mVisualizationViewer.setGraphMouse((VisualizationViewer.GraphMouse)graphMouse);
        JComboBox modeBox = graphMouse.getModeComboBox();
        modeBox.addItemListener(graphMouse.getModeListener());
        graphMouse.setMode(ModalGraphMouse.Mode.TRANSFORMING);
        CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(CallGraphPanel.this.mVisualizationViewer, 1.1f, CallGraphPanel.this.mVisualizationViewer.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener((ScalingControl)scaler){
            final /* synthetic */ ScalingControl val$scaler;
            {
                this.val$scaler = scalingControl;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.val$scaler.scale(CallGraphPanel.this.mVisualizationViewer, 0.9090909f, CallGraphPanel.this.mVisualizationViewer.getCenter());
            }
        });
        final JComboBox<String> cbLayout = new JComboBox<String>(this.mLayoutNames);
        cbLayout.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                RenderContext rc = CallGraphPanel.this.mVisualizationViewer.getRenderContext();
                String selected = (String)cbLayout.getSelectedItem();
                int idx = Arrays.asList(CallGraphPanel.this.mLayoutNames).indexOf(selected);
                Layout<CallGraph.Vertex, CallGraph.Edge> lNew = CallGraphPanel.this.mLayouts[idx];
                lNew.setSize(CallGraphPanel.this.mVisualizationViewer.getSize());
                Layout lOld = CallGraphPanel.this.mVisualizationViewer.getGraphLayout();
                LayoutTransition lt = new LayoutTransition(CallGraphPanel.this.mVisualizationViewer, lOld, lNew);
                Animator animator = new Animator((IterativeContext)lt);
                animator.start();
                rc.getMultiLayerTransformer().setToIdentity();
                CallGraphPanel.this.mVisualizationViewer.repaint();
            }
        });
        JPanel scaleGrid = new JPanel(new GridLayout(1, 0));
        scaleGrid.setBorder(BorderFactory.createTitledBorder("Zoom"));
        JPanel controls = new JPanel();
        scaleGrid.add(plus);
        scaleGrid.add(minus);
        controls.add(cbLayout);
        controls.add(scaleGrid);
        controls.add(modeBox);
        layout.newline();
        layout.add((Component)controls, (GridBagConstraints)GridBagManager.FILLX);
    }

    protected static class NGVertexRenderer
    extends BasicVertexRenderer<CallGraph.Vertex, CallGraph.Edge> {
        protected NGVertexRenderer() {
        }

        public void paintIconForVertex(RenderContext<CallGraph.Vertex, CallGraph.Edge> rc, CallGraph.Vertex v, Layout<CallGraph.Vertex, CallGraph.Edge> layout) {
            Point2D p = (Point2D)layout.transform((Object)v);
            p = rc.getMultiLayerTransformer().transform(Layer.LAYOUT, p);
            float x = (float)p.getX();
            float y = (float)p.getY();
            GraphicsDecorator g = rc.getGraphicsContext();
            Transformer vertexIconFunction = rc.getVertexIconTransformer();
            Icon icon = (Icon)vertexIconFunction.transform((Object)v);
            Shape s = AffineTransform.getTranslateInstance(x, y).createTransformedShape((Shape)rc.getVertexShapeTransformer().transform((Object)v));
            this.paintShapeForVertex(rc, v, s);
            if (icon != null) {
                int xLoc = (int)((double)x - (double)icon.getIconWidth() / 2.0);
                int yLoc = (int)((double)y - (double)icon.getIconHeight() / 2.0);
                icon.paintIcon(rc.getScreenDevice(), g.getDelegate(), xLoc, yLoc);
            }
        }
    }

    protected static class NGVertexShape
    implements Transformer<CallGraph.Vertex, Shape> {
        protected NGVertexShape() {
        }

        public Shape transform(CallGraph.Vertex v) {
            Icon icon = v.getIcon();
            if (icon == null) {
                return null;
            }
            int w = icon.getIconWidth() + 5;
            int h = icon.getIconHeight() + 5;
            return new Ellipse2D.Float((float)(-w) / 2.0f - 1.0f, (float)(-h) / 2.0f - 1.0f, w, h);
        }
    }

    protected static class NGVertexIcon
    implements Transformer<CallGraph.Vertex, Icon> {
        protected NGVertexIcon() {
        }

        public Icon transform(CallGraph.Vertex v) {
            return v.getIcon();
        }
    }

    protected static class NGVertexPaint
    implements Transformer<CallGraph.Vertex, Paint> {
        protected NGVertexPaint() {
        }

        public Paint transform(CallGraph.Vertex v) {
            return v.getPaint();
        }
    }

    protected static class NGVertexNameLabeller
    implements Transformer<CallGraph.Vertex, String> {
        protected NGVertexNameLabeller() {
        }

        public String transform(CallGraph.Vertex v) {
            return v.getLabel();
        }
    }
}

