/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit;

import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.optimizer.PortPairOpt;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ShowMeTheWay;
import com.sigrity.orbit.UserCommands;
import com.sigrity.orbit.cmd.NetCmd;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class ConnectToParentNetsRegistry {
    static LinkedList<ConnectToParentNetsAction> sRegistry = new LinkedList();

    private ConnectToParentNetsRegistry() {
    }

    public static void add(ConnectToParentNetsAction method) {
        sRegistry.add(method);
    }

    public static LinkedList<ConnectToParentNetsAction> getRegistry() {
        return sRegistry;
    }

    public static void clearRegistry() {
        sRegistry.clear();
    }

    public static ConnectToParentNetsAction getActionByName(String name) {
        for (ConnectToParentNetsAction a : sRegistry) {
            if (!a.getName().equals(name)) continue;
            return a;
        }
        return null;
    }

    private static void registerStandardFunctions() {
        ConnectToParentNetsRegistry.add(new LinearMapAction());
        ConnectToParentNetsRegistry.add(new ShowMe());
        ConnectToParentNetsRegistry.add(new SelectParentAndChildNets());
        ConnectToParentNetsRegistry.add(new SelectParentNets());
        ConnectToParentNetsRegistry.add(new SelectChildNets());
        ConnectToParentNetsRegistry.add(new OptimizeChildNets());
    }

    static {
        ConnectToParentNetsRegistry.registerStandardFunctions();
    }

    static class SelectParentNets
    extends ConnectToParentNetsAction {
        SelectParentNets() {
        }

        @Override
        public String getName() {
            return "Select Parent Nets";
        }

        @Override
        public String getVerb() {
            return "Select Parent Nets";
        }

        @Override
        public void action() {
            DeviceTemplate parentTemplate = this.childDevice.getParent();
            int s = this.parentNames.size();
            for (int i = 0; i < s; ++i) {
                Net parentNet = parentTemplate.getNet((String)this.parentNames.get(i));
                NetCmd.selectNet((Net)parentNet, (boolean)true);
            }
            OrbitIO.getApp().refreshCurrentView(false);
        }
    }

    static class OptimizeChildNets
    extends ConnectToParentNetsAction {
        OptimizeChildNets() {
        }

        @Override
        public String getName() {
            return "Optimize Child Nets";
        }

        @Override
        public String getVerb() {
            return "Optimize Child Nets";
        }

        @Override
        public void action() {
            int s = this.childNames.size();
            PortPairOpt ppo = new PortPairOpt();
            ArrayList<HierPin> childPins = new ArrayList<HierPin>();
            ArrayList<HierPin> parentPins = new ArrayList<HierPin>();
            for (int i = 0; i < s; ++i) {
                Net childNet = this.childDevice.getTemplate().getNet((String)this.childNames.get(i));
                DevicePath childPath = this.childDevice.getADevicePath();
                DevicePath parentPath = childPath.getParent();
                List dpps = NetMap.getConnectedDevicePathPorts((Net)childNet, (DevicePath)childPath);
                for (HierPin dpp : dpps) {
                    if (dpp.getPath().equals((Object)childPath)) {
                        childPins.add(dpp);
                        continue;
                    }
                    if (!dpp.getPath().equals((Object)parentPath)) continue;
                    parentPins.add(dpp);
                }
            }
            ppo.setAPorts(childPins);
            ppo.setBPorts(parentPins);
            ppo.setCanConnectFunction("any");
            PortPairOpt.setRemoveNetMappingOnToSide(false);
            PortPairOpt.setTreatFromAsIndividuals(false);
            ppo.setUseOnlyUsedPortsOnFixedSide(false);
            ppo.setUseOnlyUnusedPortsOnFreeSide(false);
            ppo.optimize(false);
            OrbitIO.getApp().refreshCurrentView(false);
        }
    }

    static class SelectChildNets
    extends ConnectToParentNetsAction {
        SelectChildNets() {
        }

        @Override
        public String getName() {
            return "Select Child Nets";
        }

        @Override
        public String getVerb() {
            return "Select Child Nets";
        }

        @Override
        public void action() {
            int s = this.childNames.size();
            for (int i = 0; i < s; ++i) {
                Net childNet = this.childDevice.getTemplate().getNet((String)this.childNames.get(i));
                Net parentNet = NetMap.getParentNet((Device)this.childDevice, (Net)childNet);
                NetCmd.selectNet((Net)childNet, (boolean)true);
                NetCmd.selectNet((Net)parentNet, (boolean)true);
            }
            OrbitIO.getApp().refreshCurrentView(false);
        }
    }

    static class SelectParentAndChildNets
    extends ConnectToParentNetsAction {
        SelectParentAndChildNets() {
        }

        @Override
        public String getName() {
            return "Select Nets";
        }

        @Override
        public String getVerb() {
            return "Select Nets";
        }

        @Override
        public void action() {
            DeviceTemplate parentTemplate = this.childDevice.getParent();
            int s = Math.min(this.childNames.size(), this.parentNames.size());
            for (int i = 0; i < s; ++i) {
                Net childNet = this.childDevice.getTemplate().getNet((String)this.childNames.get(i));
                Net parentNet = parentTemplate.getNet((String)this.parentNames.get(i));
                NetCmd.selectNet((Net)parentNet, (boolean)true);
                NetCmd.selectNet((Net)childNet, (boolean)true);
            }
            OrbitIO.getApp().refreshCurrentView(false);
        }
    }

    static class ShowMe
    extends ConnectToParentNetsAction {
        ShowMe() {
        }

        @Override
        public String getName() {
            return "Show Me";
        }

        @Override
        public String getVerb() {
            return "ShowMe";
        }

        @Override
        public void action() {
            DeviceTemplate parentTemplate = this.childDevice.getParent();
            int s = Math.min(this.childNames.size(), this.parentNames.size());
            for (int i = 0; i < s; ++i) {
                Net childNet = this.childDevice.getTemplate().getNet((String)this.childNames.get(i));
                Net parentNet = parentTemplate.getNet((String)this.parentNames.get(i));
                DevicePath childPath = this.childDevice.getADevicePath();
                DevicePath parentPath = childPath.getParent();
                ShowMeTheWay.addHierNetPairs(childNet, childPath, parentNet, parentPath);
            }
            OrbitIO.getApp().refreshCurrentView(false);
        }
    }

    static class LinearMapAction
    extends ConnectToParentNetsAction {
        LinearMapAction() {
        }

        @Override
        public String getName() {
            return "Map 1-1";
        }

        @Override
        public String getVerb() {
            return "Map";
        }

        @Override
        public void action() {
            DeviceTemplate parentTemplate = this.childDevice.getParent();
            int s = Math.min(this.childNames.size(), this.parentNames.size());
            for (int i = 0; i < s; ++i) {
                Net childNet = this.childDevice.getTemplate().getNet((String)this.childNames.get(i));
                Net parentNet = parentTemplate.getNet((String)this.parentNames.get(i));
                NetMap.mapChildNet((Device)this.childDevice, (Net)childNet, (Net)parentNet);
            }
            UserCommands.createConnections();
        }
    }

    public static abstract class ConnectToParentNetsAction {
        protected ArrayList<String> parentNames = new ArrayList();
        protected ArrayList<String> childNames = new ArrayList();
        protected Device childDevice;

        public abstract String getName();

        public abstract String getVerb();

        public abstract void action();

        public void clear() {
            this.parentNames.clear();
            this.childNames.clear();
            this.childDevice = null;
        }

        public void addParent(String name) {
            this.parentNames.add(name);
        }

        public void addChild(String name) {
            this.childNames.add(name);
        }

        public void setChildDevice(String devKey) {
            Db db = OrbitIO.getCurDb();
            this.childDevice = (Device)db.getByKeyStr(Device.class, devKey);
        }
    }
}

