/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.ATransformUtil;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.MutableBoolean;
import com.sigrity.acl.Unit;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.parsers.LEFDEFParser;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.AFileChooserControl;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.lic.LSession;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.diff_merge.Compare;
import com.sigrity.orbit.diff_merge.CompareContext;
import com.sigrity.orbit.diff_merge.CompareDevice;
import com.sigrity.orbit.diff_merge.CompareDeviceTemplate;
import com.sigrity.orbit.diff_merge.ComparePinTemplate;
import com.sigrity.orbit.diff_merge.CompareRegistry;
import com.sigrity.orbit.diff_merge.DTDiffMerge;
import com.sigrity.orbit.iov.IOView;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileFilter;

public class DEFMerge {
    protected Device mOrig;
    protected DeviceTemplate mOrigTemplate;
    protected Device mUpdated;
    protected DeviceTemplate mUpdatedTemplate;
    protected boolean mVerbose;
    protected Unit mUnit = null;
    protected DTDiffMerge.Diffs mDiffs = new DTDiffMerge.Diffs();
    protected String mLogFilePath = null;
    protected boolean mMergeNets = true;
    protected boolean mIgnoreDeletedInternalNets = true;
    protected boolean mDetectHierCompressionByName = true;
    protected boolean mDetectMatchesByDefOutName = true;
    protected HashMap<String, DevicePath> mDefOutName2Device = null;
    protected HashMap<DeviceTemplate, LinkedList<APair<Net, Net>>> mEquivNets = new HashMap();
    protected boolean mMergeRun = false;
    protected boolean mPinCompareByNum = false;
    protected CacheManager mCache = new CacheManager();
    protected BiMap<Device, Device> mMatchedDevices = HashBiMap.create();
    protected HashSet<Device> mHierCompressRemoveDevices = new HashSet();
    protected HashSet<Device> mDevicesCreatedByMerge = new HashSet();
    protected CompareRegistry mCompareRegistry;
    protected CompareContext mCompareContext;

    public static void showUI(Window owner) {
        MutableBoolean ok = new MutableBoolean(false);
        ADialog dlg = new ADialog(owner, "DEF Merge");
        dlg.setModal(true);
        GridBagManager l = GridBagManager.layout((JDialog)dlg);
        l.pushFill("Source");
        l.add("DEF File:");
        AFileChooserControl.ChooserInitializer ci = new AFileChooserControl.ChooserInitializer(){

            public void initChooser(JFileChooser fc) {
                fc.setFileFilter((FileFilter)AFileFilter.DEF_FAMILY);
            }
        };
        AFileChooserControl fc = (AFileChooserControl)l.add((Component)new AFileChooserControl(ci), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        AFileChooserControl.ChooserInitializer ciLog = new AFileChooserControl.ChooserInitializer(){

            public void initChooser(JFileChooser fc) {
                fc.setFileFilter((FileFilter)AFileFilter.LOG);
                fc.addChoosableFileFilter((FileFilter)AFileFilter.TXT);
            }
        };
        final AFileChooserControl fcLog = new AFileChooserControl(ciLog);
        fcLog.setUseSaveChooser(true);
        l.pop();
        l.newline();
        l.pushFill("Options");
        JCheckBox cbMergeNets = (JCheckBox)l.add((Component)new JCheckBox("Merge Nets"), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        cbMergeNets.setSelected(true);
        l.newline();
        JCheckBox cbVerbose = (JCheckBox)l.add((Component)new JCheckBox("Verbose Logging"), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        cbVerbose.setSelected(false);
        l.newline();
        final JCheckBox cbLog = (JCheckBox)l.add((Component)new JCheckBox("Log changes to file:"), (GridBagConstraints)GridBagManager.LEFT_REMAINX.insetBottom(0));
        ChangeListener clLog = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                fcLog.setEnabled(cbLog.isSelected());
            }
        };
        cbLog.addChangeListener(clLog);
        clLog.stateChanged(null);
        l.newline();
        l.indent();
        l.add((Component)fcLog, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
        l.newline();
        l.addFillY();
        l.popNl();
        l.pushFillXRemainX();
        l.addFillX();
        JButton btnOk = (JButton)l.add((Component)new JButton("OK"));
        btnOk.addActionListener(e -> {
            try {
                AFieldValidator.validateFileExists((JTextField)fc.getTextField());
                if (cbLog.isSelected()) {
                    AFieldValidator.validateFileWritable((JTextField)fcLog.getTextField());
                }
            }
            catch (AFieldValidator.AFieldValidationException e1) {
                return;
            }
            ok.setValue(true);
            UIUtil.closeWindow((Window)dlg);
        });
        JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
        UIUtil.enableEscCloseDefaultMinSize((JDialog)dlg, (AbstractButton)btnCancel, (JButton)btnOk);
        l.pop();
        dlg.pack();
        dlg.setMinimumSize(dlg.getPreferredSize());
        UIUtil.center((Component)dlg);
        dlg.setVisible(true);
        if (!ok.getValue()) {
            return;
        }
        String defPath = fc.getTextField().getText();
        String logFilePath = fcLog.getTextField().getText();
        boolean mergeNets = cbMergeNets.isSelected();
        boolean verbose = cbVerbose.isSelected();
        Cp.exec(() -> {
            try {
                DEFMerge defMerge = new DEFMerge();
                defMerge.setLogFile(logFilePath);
                defMerge.setMergeNets(mergeNets);
                defMerge.setVerbose(verbose);
                defMerge.mergeFromDEF(defPath);
            }
            catch (LSession.NoLicenseException e1) {
                ALog.logError((Throwable)e1);
            }
        }, (String)"{ unset(\"defMerge\"); defMerge = new com.sigrity.orbit.DEFMerge(); defMerge.setLogFile(\"%s\"); defMerge.setMergeNets(%s); defMerge.setVerbose(%b); defMerge.mergeFromDEF(%s); unset(\"defMerge\"); }", (Object[])new Object[]{logFilePath, mergeNets, verbose, Cp.getFileAsArgument((String)defPath)});
    }

    public void setLogFile(String path) {
        this.mLogFilePath = path;
    }

    public void setMergeNets(boolean mergeNets) {
        this.mMergeNets = mergeNets;
    }

    public void setVerbose(boolean verbose) {
        this.mVerbose = verbose;
    }

    public void setOriginal(Device original) {
        this.mOrig = original;
        this.mOrigTemplate = this.mOrig.getTemplate();
    }

    public void setUpdated(Device updated) {
        this.mUpdated = updated;
        this.mUpdatedTemplate = this.mUpdated.getTemplate();
    }

    private Device getDeviceByName(Db db, String deviceName) {
        LinkedList devices = AUtil.linkedList((Iterator)Device.getDevicesNamed((Db)db, (String)deviceName));
        if (devices.isEmpty()) {
            ALog.logError((String)"Unable to find target merge Device named '%s' in current design.", (Object[])new Object[]{deviceName});
            return null;
        }
        if (devices.size() > 1) {
            String curDevices = devices.stream().map(Device::getQualifiedName).collect(Collectors.joining(", "));
            ALog.logError((String)"Found multiple Devices named '%s' in current design, unable to determine merge target.\n\t[%s]", (Object[])new Object[]{deviceName, curDevices});
            return null;
        }
        return (Device)devices.get(0);
    }

    private String getUniqueTemplateName(Substrate substrate, String originalName) {
        String updatedTemplateName = String.format("%s_Updated", originalName);
        if (DeviceTemplate.getDeviceTemplate((Substrate)substrate, (String)updatedTemplateName) != null) {
            updatedTemplateName = DeviceTemplate.getUniqueName((Substrate)substrate, (String)updatedTemplateName);
        }
        return updatedTemplateName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeFromDEF(String defFilePath) {
        String updatedTemplateName;
        long dbObjectId;
        DeviceTemplate updatedParent;
        Db db;
        block28: {
            String lefDeviceName = LEFDEFParser.getDesignName(defFilePath);
            if (lefDeviceName == null) {
                ALog.logError((String)"Unable to read DESIGN from DEF file '%s'.", (Object[])new Object[]{defFilePath});
                return;
            }
            db = OrbitApp.getCurDb();
            Device originalDevice = this.getDeviceByName(db, lefDeviceName);
            if (originalDevice == null) {
                return;
            }
            updatedParent = DeviceTemplate.create((Substrate)originalDevice.getSubstrate(), (String)"$DEFMergeTemp$", (boolean)true);
            dbObjectId = updatedParent.getDbObjId();
            updatedTemplateName = this.getUniqueTemplateName(originalDevice.getSubstrate(), originalDevice.getTemplate().getName());
            try {
                Device updatedDevice = null;
                LEFDEFParser ldp = new LEFDEFParser(db);
                ldp.setDefParent(updatedParent);
                ldp.setDefTemplateName(updatedTemplateName);
                ldp.skipPins(false);
                ldp.setVerbosity(1);
                ldp.setUniqueify(false);
                ldp.setReadNets(true);
                ldp.setAddUnusedPins(true);
                ldp.setReadRegularWires(true);
                ldp.setReadSpecialNets(true);
                ldp.setReadSpecialWires(true);
                ldp.parseDEF(defFilePath);
                updatedDevice = ldp.getDie();
                if (updatedDevice == null) {
                    ALog.logError((String)"No Device was read from the DEF file.");
                    break block28;
                }
                this.setOriginal(originalDevice);
                this.setUpdated(updatedDevice);
                this.merge();
            }
            catch (LSession.NoLicenseException e) {
                try {
                    ALog.logError((String)"Unable to read DEF.");
                }
                catch (Throwable throwable) {
                    Substrate updatedSubstrate = updatedParent.getSubstrate();
                    Connection.removeAll((Db)db);
                    if (!updatedParent.deleteFromDb()) {
                        ALog.logWarn((String)"Error deleting temporary updated parent DeviceTemplate '%s' from the database.", (Object[])new Object[]{updatedParent.getName()});
                    }
                    DeviceTemplate updatedTemplate = DeviceTemplate.getDeviceTemplate((Substrate)updatedSubstrate, (String)updatedTemplateName);
                    LinkedHashSet<PadTemplate> newPads = new LinkedHashSet<PadTemplate>();
                    if (updatedTemplate != null) {
                        for (PinTemplate pt : updatedTemplate.getPins()) {
                            for (PortTemplate port : pt.getPortTemplates()) {
                                newPads.add(port.getPadTemplate());
                            }
                        }
                        if (!updatedTemplate.deleteFromDb()) {
                            ALog.logWarn((String)"Error deleting temporary updated DeviceTemplate '%s' from the database.", (Object[])new Object[]{updatedTemplateName});
                        }
                        for (PadTemplate pad : db.getObjects(PadTemplate.class)) {
                            if (pad.getDbObjId() <= dbObjectId || !AUtil.empty((Iterator)pad.getPortTemplates())) continue;
                            newPads.add(pad);
                        }
                    }
                    for (PadTemplate pad : newPads) {
                        if (!AUtil.empty((Iterator)pad.getPortTemplates())) continue;
                        pad.deleteFromDb();
                    }
                    throw throwable;
                }
                Substrate updatedSubstrate = updatedParent.getSubstrate();
                Connection.removeAll((Db)db);
                if (!updatedParent.deleteFromDb()) {
                    ALog.logWarn((String)"Error deleting temporary updated parent DeviceTemplate '%s' from the database.", (Object[])new Object[]{updatedParent.getName()});
                }
                DeviceTemplate updatedTemplate = DeviceTemplate.getDeviceTemplate((Substrate)updatedSubstrate, (String)updatedTemplateName);
                LinkedHashSet<PadTemplate> newPads = new LinkedHashSet<PadTemplate>();
                if (updatedTemplate != null) {
                    for (PinTemplate pt : updatedTemplate.getPins()) {
                        for (PortTemplate port : pt.getPortTemplates()) {
                            newPads.add(port.getPadTemplate());
                        }
                    }
                    if (!updatedTemplate.deleteFromDb()) {
                        ALog.logWarn((String)"Error deleting temporary updated DeviceTemplate '%s' from the database.", (Object[])new Object[]{updatedTemplateName});
                    }
                    for (PadTemplate pad : db.getObjects(PadTemplate.class)) {
                        if (pad.getDbObjId() <= dbObjectId || !AUtil.empty((Iterator)pad.getPortTemplates())) continue;
                        newPads.add(pad);
                    }
                }
                for (PadTemplate pad : newPads) {
                    if (!AUtil.empty((Iterator)pad.getPortTemplates())) continue;
                    pad.deleteFromDb();
                }
            }
        }
        Substrate updatedSubstrate = updatedParent.getSubstrate();
        Connection.removeAll((Db)db);
        if (!updatedParent.deleteFromDb()) {
            ALog.logWarn((String)"Error deleting temporary updated parent DeviceTemplate '%s' from the database.", (Object[])new Object[]{updatedParent.getName()});
        }
        DeviceTemplate updatedTemplate = DeviceTemplate.getDeviceTemplate((Substrate)updatedSubstrate, (String)updatedTemplateName);
        LinkedHashSet<PadTemplate> newPads = new LinkedHashSet<PadTemplate>();
        if (updatedTemplate != null) {
            for (PinTemplate pt : updatedTemplate.getPins()) {
                for (PortTemplate port : pt.getPortTemplates()) {
                    newPads.add(port.getPadTemplate());
                }
            }
            if (!updatedTemplate.deleteFromDb()) {
                ALog.logWarn((String)"Error deleting temporary updated DeviceTemplate '%s' from the database.", (Object[])new Object[]{updatedTemplateName});
            }
            for (PadTemplate pad : db.getObjects(PadTemplate.class)) {
                if (pad.getDbObjId() <= dbObjectId || !AUtil.empty((Iterator)pad.getPortTemplates())) continue;
                newPads.add(pad);
            }
        }
        for (PadTemplate pad : newPads) {
            if (!AUtil.empty((Iterator)pad.getPortTemplates())) continue;
            pad.deleteFromDb();
        }
    }

    public boolean merge() {
        if (this.mOrig == null || this.mUpdated == null) {
            ALog.logError((String)"Both the original and updated Devices must be specified before calling DEFMerge.merge().");
            return false;
        }
        if (this.mOrigTemplate == null) {
            ALog.logError((String)"The original device '%s' has no template.", (Object[])new Object[]{this.mOrig.getName()});
            return false;
        }
        if (this.mUpdatedTemplate == null) {
            ALog.logError((String)"The updated device '%s' has no template.", (Object[])new Object[]{this.mUpdated.getName()});
            return false;
        }
        ALog.logInfo((String)"Merging...");
        long timeSpent = System.nanoTime();
        Db db = this.mOrig.getDb();
        Design design = Design.getDesign((Db)db);
        if (design != null) {
            this.mUnit = design.getUnit();
        }
        ALog.ALogFile logFile = null;
        if (this.mLogFilePath != null && !this.mLogFilePath.trim().isEmpty()) {
            File f = new File(this.mLogFilePath);
            AUtil.deleteFile((File)f);
            logFile = new ALog.ALogFile(this.mLogFilePath);
            ALog.getDefaultLogger().addObserver((ALog.ALogObserver)logFile);
        }
        this.mCompareRegistry = CompareRegistry.getCompareRegistry();
        this.mCompareContext = new CompareContext();
        boolean res = this._merge();
        this.mCompareRegistry = null;
        this.mCompareContext = null;
        if (logFile != null) {
            ALog.getDefaultLogger().removeObserver((ALog.ALogObserver)logFile);
        }
        timeSpent = System.nanoTime() - timeSpent;
        if (res) {
            ALog.logInfo((String)"Merge complete, used %.3f seconds.", (Object[])new Object[]{(double)timeSpent / 1.0E9});
        } else {
            ALog.logWarn((String)"Merge failed, used %.3f seconds.", (Object[])new Object[]{(double)timeSpent / 1.0E9});
        }
        ALog.logInfo((String)"Merge %d items.", (Object[])new Object[]{this.mDiffs.size()});
        IOView.buildIOViewFromCanvasUser();
        OrbitIO.refreshViewsOf(db);
        return res;
    }

    private boolean _merge() {
        if (!this.mMergeNets) {
            ALog.logInfo((String)"Net merging disabled.");
        } else if (this.mIgnoreDeletedInternalNets) {
            ALog.logInfo((String)"Ignoring deleted internal Nets.");
        }
        if (this.mDetectHierCompressionByName) {
            ALog.logInfo((String)"Ignoring hierarchy compression detected by Device names.");
        }
        if (this.mDetectMatchesByDefOutName) {
            ALog.logInfo((String)"Detecting matches by DEFOut generated names.");
        }
        this.mDiffs.clear();
        this.compareSubstrates(this.mOrigTemplate.getSubstrate(), this.mUpdatedTemplate.getSubstrate());
        AGeom origBounds = this.mOrigTemplate.getBounds();
        AGeom updatedBounds = this.mUpdatedTemplate.getBounds();
        if (origBounds == null && updatedBounds != null || origBounds != null && updatedBounds == null || !this.mOrigTemplate.getBounds().equals((Object)this.mUpdatedTemplate.getBounds())) {
            this.merge(new CompareDeviceTemplate.BoundsChanged(this.mOrigTemplate, this.mUpdatedTemplate));
        }
        if (this.mOrigTemplate.getType() != this.mUpdatedTemplate.getType()) {
            this.merge(new CompareDeviceTemplate.DeviceTemplateTypeChanged(this.mOrigTemplate, this.mUpdatedTemplate));
        }
        if (!this.isSourceEqual(this.mOrigTemplate, this.mUpdatedTemplate)) {
            this.merge(new CompareDeviceTemplate.DeviceTemplateSourceChanged(this.mOrigTemplate, this.mUpdatedTemplate));
        }
        if (this.mOrigTemplate.getIsSynthesized() != this.mUpdatedTemplate.getIsSynthesized()) {
            this.merge(new CompareDeviceTemplate.DeviceTemplateIsSynthesizedChanged(this.mOrigTemplate, this.mUpdatedTemplate));
        }
        if (this.mMergeNets) {
            this.mergeNets(this.mOrigTemplate, this.mUpdatedTemplate);
        }
        this.mergePins(this.mOrig, this.mUpdated, null);
        if (this.mDetectMatchesByDefOutName) {
            this.mDefOutName2Device = new HashMap();
            for (DevicePath path : this.mOrigTemplate.getDescendantDevices()) {
                String defOutName = (String)path.getLast().getValue("DEFOutName", String.class);
                if (defOutName == null) continue;
                this.mDefOutName2Device.put(defOutName, path);
            }
        }
        this.mergeDescendants(this.mOrig, this.mOrigTemplate, this.mUpdated, this.mUpdatedTemplate, null);
        this.mergeWires(this.mOrigTemplate, this.mUpdatedTemplate);
        for (Device devOrigCompressedOut : this.mHierCompressRemoveDevices) {
            for (Device compressedChild : AUtil.linkedList((Iterator)devOrigCompressedOut.getChildren())) {
                if (this.alreadyProcessed(compressedChild)) continue;
                Device equivUpdatedParent = (Device)this.mMatchedDevices.get((Object)devOrigCompressedOut);
                if (equivUpdatedParent == null) {
                    equivUpdatedParent = this.mUpdated;
                }
                CompareDeviceTemplate.DeviceRemoved diff = new CompareDeviceTemplate.DeviceRemoved(devOrigCompressedOut.getTemplate(), compressedChild, equivUpdatedParent.getParent());
                this.merge(diff);
            }
        }
        if (this.mDetectMatchesByDefOutName) {
            this.mDefOutName2Device = null;
        }
        this.mMergeRun = true;
        return true;
    }

    public boolean getDiffRun() {
        return this.mMergeRun;
    }

    public Collection<Compare.Diff<?>> getDiffs() {
        return this.mDiffs.getDiffs();
    }

    public DeviceTemplate getOriginalTemplate() {
        return this.mOrigTemplate;
    }

    public DeviceTemplate getUpdatedTemplate() {
        return this.mUpdatedTemplate;
    }

    protected void diff(Compare.Diff<?> diff) {
        if (this.mVerbose) {
            ALog.logInfo((String)"Diff: %s", (Object[])new Object[]{diff.getDesc()});
        }
        this.mDiffs.add(diff);
    }

    protected boolean merge(Compare.Diff<?> diff) {
        if (diff == null) {
            return false;
        }
        if (!(diff instanceof Compare.Mergeable)) {
            ALog.logInfo((String)"Unmergable difference: %s", (Object[])new Object[]{diff.getDesc()});
            return false;
        }
        if (this.mVerbose) {
            ALog.flogInfo((String)"Merging: %s", (Object[])new Object[]{diff.getDesc()});
        }
        this.mDiffs.add(diff);
        Compare.Mergeable mergeable = (Compare.Mergeable)diff;
        return mergeable.merge();
    }

    protected void compareSubstrates(Substrate orig, Substrate updated) {
        if (this.mOrigTemplate.getSubstrate().equals((Object)this.mUpdatedTemplate.getSubstrate())) {
            return;
        }
        for (Compare compare : this.mCompareRegistry.getCompares(Substrate.class)) {
            for (Compare.Diff change : compare.getDiffs(this.mCompareContext, this.mOrigTemplate.getSubstrate(), this.mUpdatedTemplate.getSubstrate())) {
                this.mDiffs.add(change);
            }
        }
    }

    protected boolean isSourceEqual(DeviceTemplate orig, DeviceTemplate updated) {
        if (orig.getSourceType() != updated.getSourceType()) {
            return false;
        }
        String origSrcFile = orig.getSourceFile();
        String updatedSrcFile = updated.getSourceFile();
        if (origSrcFile == null) {
            return updatedSrcFile == null;
        }
        return origSrcFile.equals(updatedSrcFile);
    }

    protected void mergePins(Device orig, Device updated, DevicePath origCompressed) {
        PinTemplate portOld;
        DeviceTemplate dtOrig = orig == null ? this.mOrigTemplate : orig.getTemplate();
        DeviceTemplate dtUpdated = updated == null ? this.mUpdatedTemplate : updated.getTemplate();
        this.mCache.reset();
        if (this.mPinCompareByNum && updated != null) {
            for (PinTemplate portNew : updated.getPins()) {
                portOld = this.mCache.getPinByPinNum(orig, portNew.getPinNum());
                if (portOld != null) continue;
                CompareDevice.PinAdded pia = new CompareDevice.PinAdded(orig, (PinInstance)portNew);
                pia.setUnit(this.mUnit);
                if (origCompressed != null) {
                    pia.setXform(origCompressed.getTransform());
                }
                this.merge(pia);
            }
        } else {
            for (PinTemplate portNew : dtUpdated.getPins()) {
                portOld = this.mCache.getPinByName(dtOrig, portNew.getName());
                if (portOld != null) continue;
                CompareDeviceTemplate.PinTemplateAdded pa = new CompareDeviceTemplate.PinTemplateAdded(dtOrig, portNew);
                pa.setUnit(this.mUnit);
                if (origCompressed != null) {
                    pa.setXform(origCompressed.getTransform());
                }
                this.merge(pa);
            }
        }
        this.mCache.reset();
        for (PinTemplate pinOrig : AUtil.linkedList((Iterator)dtOrig.getPins())) {
            PinTemplate pinUpdated = null;
            PinInstance pUpdated = null;
            if (this.mPinCompareByNum && updated != null) {
                PinInstance pOrig = orig.getPin(pinOrig);
                pUpdated = this.mCache.getPinByPinNum(updated, pOrig.getPinNum());
                pinUpdated = pUpdated.getPinTemplate();
                if (!pinOrig.getName().equals(pinUpdated.getName())) {
                    this.merge(new ComparePinTemplate.PinRenamed(pinOrig, pinUpdated));
                }
            } else {
                pinUpdated = this.mCache.getPinByName(dtUpdated, pinOrig.getName());
            }
            if (pinUpdated == null) {
                this.merge(new CompareDeviceTemplate.PinTemplateRemoved(pinOrig));
                continue;
            }
            if (!pinOrig.getNet().getName().equals(pinUpdated.getNet().getName())) {
                this.merge(new ComparePinTemplate.PinNetChanged(pinOrig, pinUpdated));
            }
            if (pinOrig.getDirection() != pinUpdated.getDirection()) {
                this.merge(new ComparePinTemplate.PinDirectionChanged(pinOrig, pinUpdated));
            }
            if (pinOrig.getUse() != pinUpdated.getUse()) {
                this.merge(new ComparePinTemplate.PinUseChanged(pinOrig, pinUpdated));
            }
            if (pinOrig.getType() != pinUpdated.getType()) {
                this.merge(new ComparePinTemplate.PinTypeChanged(pinOrig, pinUpdated));
            }
            for (Compare.Diff diff : AIterableItr.itr(ComparePinTemplate.comparePorts(pinOrig, pinUpdated, null))) {
                if (diff instanceof ComparePinTemplate.PortMoved) {
                    ComparePinTemplate.PortMoved pm = (ComparePinTemplate.PortMoved)diff;
                    pm.setUnit(this.mUnit);
                    if (origCompressed != null) {
                        pm.setXform(origCompressed.getTransform());
                    }
                }
                this.merge(diff);
            }
        }
    }

    protected void mergeDescendants(Device devOrig, DeviceTemplate dtOrig, Device devUpdated, DeviceTemplate dtUpdated, DevicePath origCompressed) {
        for (Device devChildUpdated : dtUpdated.getChildren()) {
            String updatedName = devChildUpdated.getName();
            Device devChildOrig = dtOrig.getChild(updatedName);
            if (devChildOrig != null) continue;
            DevicePath origPath = null;
            if (this.mDetectMatchesByDefOutName) {
                origPath = this.mDefOutName2Device.get(updatedName);
            }
            if (origPath == null && this.mDetectHierCompressionByName && updatedName.contains("/")) {
                origPath = DevicePath.fromString((Db)dtOrig.getDb(), (String)updatedName, (DeviceTemplate)dtOrig);
            }
            if (origPath != null) {
                DevicePath compressedOut = !origPath.isEmpty() ? origPath.getParent() : null;
                this.mMatchedDevices.put((Object)origPath.getLast(), (Object)devChildUpdated);
                this.mergeDevice(origPath.getLast(), devChildUpdated, compressedOut);
                for (int i = 0; i < origPath.size() - 1; ++i) {
                    this.mHierCompressRemoveDevices.add(origPath.get(i));
                }
                continue;
            }
            CompareDeviceTemplate.DeviceAdded diff = new CompareDeviceTemplate.DeviceAdded(this.mCompareContext, dtOrig, devChildUpdated);
            diff.setUnit(this.mUnit);
            if (origCompressed != null) {
                diff.setXform(origCompressed.getTransform());
            }
            this.merge(diff);
            Device newDevice = diff.getAddedByMerge();
            if (newDevice == null) continue;
            this.mDevicesCreatedByMerge.add(newDevice);
        }
        for (Device devChildOrig : AUtil.linkedList((Iterator)dtOrig.getChildren())) {
            if (this.alreadyProcessed(devChildOrig)) continue;
            Device devChildUpdated = dtUpdated.getChild(devChildOrig.getName());
            if (devChildUpdated == null) {
                CompareDeviceTemplate.DeviceRemoved diff = new CompareDeviceTemplate.DeviceRemoved(devOrig.getTemplate(), devChildOrig, devUpdated.getTemplate());
                this.merge(diff);
                continue;
            }
            this.mMatchedDevices.put((Object)devChildOrig, (Object)devChildUpdated);
            this.mergeDevice(devChildOrig, devChildUpdated, origCompressed);
        }
    }

    protected boolean alreadyProcessed(Device origDevice) {
        return this.mHierCompressRemoveDevices.contains(origDevice) || this.mMatchedDevices.containsKey((Object)origDevice) || this.mDevicesCreatedByMerge.contains(origDevice);
    }

    protected void mergeDevice(Device deviceOrig, Device deviceUpdated, DevicePath origCompressed) {
        if (deviceOrig.getTemplate() != deviceUpdated.getTemplate()) {
            this.merge(new CompareDevice.DeviceTemplateChanged(deviceOrig, deviceUpdated));
        }
        APoint2D origLoc = deviceOrig.getLoc();
        if (origCompressed != null) {
            origLoc = origLoc.transform(origCompressed.getTransform());
        }
        if (!origLoc.equals((Object)deviceUpdated.getLoc())) {
            CompareDevice.DeviceMoved dm = new CompareDevice.DeviceMoved(deviceOrig, deviceUpdated, origCompressed == null ? null : origCompressed.getTransform());
            dm.setUnit(this.mUnit);
            if (origCompressed != null) {
                APoint2D ll;
                AffineTransform xform = origCompressed.getTransform();
                APoint2D origin = deviceUpdated.getLocalOrigin();
                if (!origin.equals((Object)(ll = deviceUpdated.getLocalBB().getLL()))) {
                    xform.preConcatenate(AffineTransform.getTranslateInstance(ll.getX() - origin.getX(), ll.getY() - origin.getY()));
                }
                dm.setXform(xform);
            }
            this.merge(dm);
        }
        float origRot = deviceOrig.getRotate();
        if (origCompressed != null) {
            origRot = ATransformUtil.normRot((float)(origCompressed.getRot() + origRot));
        }
        if (origRot != deviceUpdated.getRotate()) {
            this.merge(new CompareDevice.DeviceRotated(deviceOrig, deviceUpdated, 0.0f));
        }
        boolean origMirror = deviceOrig.getMirror();
        if (origCompressed != null && origCompressed.getMirror()) {
            boolean bl = origMirror = !origMirror;
        }
        if (origMirror != deviceUpdated.getMirror()) {
            this.merge(new CompareDevice.DeviceMirrored(deviceOrig, deviceUpdated, origMirror));
        }
        if (deviceOrig.getIsFixed() != deviceUpdated.getIsFixed()) {
            this.merge(new CompareDevice.DeviceFixed(deviceOrig, deviceUpdated));
        }
        if (deviceOrig.getIsPlaced() != deviceUpdated.getIsPlaced()) {
            this.merge(new CompareDevice.DevicePlaced(deviceOrig, deviceUpdated));
        }
        if (this.mMergeNets) {
            this.mergeNets(deviceOrig, deviceUpdated);
        }
        this.mergePins(deviceOrig, deviceUpdated, origCompressed);
        this.mergeDescendants(deviceOrig, deviceOrig.getTemplate(), deviceUpdated, deviceUpdated.getTemplate(), origCompressed);
    }

    protected LinkedList<APair<Net, Net>> mergeNets(DeviceTemplate dtOrig, DeviceTemplate dtUpdated) {
        LinkedList<Object> equivNets = this.mEquivNets.get(dtOrig);
        if (equivNets == null) {
            equivNets = new LinkedList();
            this.mEquivNets.put(dtOrig, equivNets);
            for (Net netOrig : dtOrig.getNets()) {
                Net netUpdated = dtUpdated.getNet(netOrig.getName());
                if (netUpdated == null) {
                    if (this.mIgnoreDeletedInternalNets) continue;
                    this.diff(new CompareDeviceTemplate.NetRemoved(netOrig));
                    continue;
                }
                equivNets.add((APair<Net, Net>)new APair((Object)netOrig, (Object)netUpdated));
            }
            for (Net netUpdated : dtUpdated.getNets()) {
                if (dtOrig.getNet(netUpdated.getName()) != null) continue;
                this.merge(new CompareDeviceTemplate.NetAdded(dtOrig, netUpdated));
            }
        }
        return equivNets;
    }

    protected void mergeNets(Device devOrig, Device devUpdated) {
        LinkedList<APair<Net, Net>> equivNets = this.mergeNets(devOrig.getTemplate(), devUpdated.getTemplate());
        for (APair aPair : equivNets) {
            this.mergeNetMaps(devOrig, (Net)aPair.first, devUpdated, (Net)aPair.second);
        }
    }

    protected void mergeNetMaps(Device deviceChild, Net netOrig, Device deviceUpdated, Net netUpdated) {
        Net netParentOrig = NetMap.getParentNet((Device)deviceChild, (Net)netOrig);
        Net netParentUpdated = NetMap.getParentNet((Device)deviceUpdated, (Net)netUpdated);
        if (netParentOrig != null && netParentUpdated != null) {
            if (!netParentOrig.getName().equals(netParentUpdated.getName())) {
                this.merge(new CompareDevice.NetMapChanged(deviceChild, netOrig, netParentUpdated.getName()));
            }
        } else if (netParentOrig == null && netParentUpdated != null) {
            this.merge(new CompareDevice.NetMapAdded(deviceChild, netOrig, netParentUpdated.getName()));
        } else if (netParentOrig != null && netParentUpdated == null) {
            this.merge(new CompareDevice.NetMapRemoved(deviceChild, netOrig));
        }
    }

    protected void mergeWires(DeviceTemplate deviceOrig, DeviceTemplate deviceUpdated) {
        for (Wire w : AUtil.linkedList((Iterator)deviceOrig.getWires())) {
            w.deleteFromDb();
        }
        for (Wire w : deviceUpdated.getWires()) {
            this.merge(new CompareDeviceTemplate.WireAdded(deviceOrig, w));
        }
    }

    static class CacheManager {
        final Map<DeviceTemplate, Map<String, PinTemplate>> mPinNameMapper = new HashMap<DeviceTemplate, Map<String, PinTemplate>>();
        final Map<Device, Map<Integer, PinInstance>> mPinNumMapper = new HashMap<Device, Map<Integer, PinInstance>>();

        CacheManager() {
        }

        PinInstance getPinByPinNum(Device device, int pinNum) {
            if (device == null || device.getTemplate() == null) {
                return null;
            }
            Map map = this.mPinNumMapper.computeIfAbsent(device, d -> {
                HashMap<Integer, PinInstance> pinNumMapper = new HashMap<Integer, PinInstance>();
                for (PinInstance pinInst : d.getPins()) {
                    assert (!pinNumMapper.containsKey(pinInst.getPinNum()));
                    pinNumMapper.put(pinInst.getPinNum(), pinInst);
                }
                return pinNumMapper;
            });
            return (PinInstance)map.get(pinNum);
        }

        PinTemplate getPinByName(DeviceTemplate dt, String pinName) {
            if (dt == null) {
                return null;
            }
            Map map = this.mPinNameMapper.computeIfAbsent(dt, d -> {
                HashMap<String, PinTemplate> pinNameMapper = new HashMap<String, PinTemplate>();
                for (PinTemplate pt : d.getPins()) {
                    if (pinNameMapper.containsKey(pt.getName())) {
                        ALog.logDebug((String)"Warning: duplicate pin name");
                    }
                    pinNameMapper.put(pt.getName(), pt);
                }
                return pinNameMapper;
            });
            return (PinTemplate)map.get(pinName);
        }

        void reset() {
            this.mPinNameMapper.clear();
            this.mPinNumMapper.clear();
        }
    }
}

