/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit;

import com.sigrity.acl.AColor;
import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.APatternColor;
import com.sigrity.acl.ATransformUtil;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.Connection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Floorplan;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetObject;
import com.sigrity.acl.db.std.Obstacle;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.PortTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.ALine;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierShape;
import com.sigrity.orbit.ui.canvas_modes.AbstractViewMode;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.ViewColorizer;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.WeakHashMap;
import java.util.stream.Stream;
import javax.swing.JComponent;

public class DbObjectHighlighter {
    private static WeakHashMap<DesignView2D, DbObjectHighlighter> gHighliters = new WeakHashMap();
    protected final DesignView2D mView;
    protected final HashSet<HierInst<DbObject>> mHierObjs = new HashSet();
    protected final HashSet<APair<DevicePath, AGeom>> mHierGeoms = new HashSet();
    protected Renderer mRenderer = null;
    boolean mInvalidGraphicsErrorLogged = false;
    protected JComponent mOverlay = new JComponent(){
        {
            this.setOpaque(false);
            this.setBackground(AColor.CLEAR);
        }

        @Override
        protected void paintComponent(Graphics graphics) {
            AbstractViewMode avm;
            if (DbObjectHighlighter.this.mHierObjs.isEmpty() && DbObjectHighlighter.this.mHierGeoms.isEmpty()) {
                return;
            }
            if (!(graphics instanceof Graphics2D)) {
                ALog.logDebug((String)"DbObjectHighlighter error: Image Graphics not Graphics2D.");
                return;
            }
            DesignView2D.ViewMode viewMode = DbObjectHighlighter.this.mView.getCurMode();
            if (viewMode instanceof AbstractViewMode && (avm = (AbstractViewMode)viewMode).isNavigationInProgress()) {
                return;
            }
            if (DbObjectHighlighter.this.mRenderer == null || !DbObjectHighlighter.this.mRenderer.isUpToDate()) {
                if (DbObjectHighlighter.this.mRenderer != null) {
                    DbObjectHighlighter.this.mRenderer.interrupt();
                }
                DbObjectHighlighter.this.mRenderer = new Renderer();
            } else if (!DbObjectHighlighter.this.mRenderer.isAlive()) {
                DbObjectHighlighter.this.mRenderer.paintOverlay(Optional.of(graphics));
            }
        }
    };
    static final GradientPaint HIGHLIGHT_GRADIENT = new GradientPaint(0.0f, 0.0f, Color.yellow, 3.0f, 3.0f, Color.red, true);
    static final BasicStroke HIGHLIGH_STROKE = new BasicStroke(3.0f, 1, 1);
    static final BasicStroke HIGHLIGHT_DASH = new BasicStroke(4.0f, 0, 2, 1.0f, new float[]{5.0f}, 0.0f);
    private static LinkedHashSet<HighlightListener> listeners = new LinkedHashSet();

    public static void highlight(DesignView2D v2d, Selection sel) {
        if (DesignCanvas2D._DisableDrawing || sel == null) {
            return;
        }
        DbObjectHighlighter h = gHighliters.computeIfAbsent(v2d, DbObjectHighlighter::create);
        for (HierInst hobj : sel.getAllHierInsts()) {
            h.highlight((HierInst<DbObject>)hobj);
        }
        DbObjectHighlighter.fireHighlight(h);
    }

    public static void highlight(DesignView2D v2d, HierInst<DbObject> hobj) {
        if (DesignCanvas2D._DisableDrawing || hobj == null || hobj.getDbObject() == null) {
            return;
        }
        DbObjectHighlighter h = gHighliters.computeIfAbsent(v2d, DbObjectHighlighter::create);
        h.highlight(hobj);
        DbObjectHighlighter.fireHighlight(h);
    }

    public static void highlight(DesignView2D v2d, DevicePath path, AGeom g) {
        if (DesignCanvas2D._DisableDrawing) {
            return;
        }
        DbObjectHighlighter h = gHighliters.computeIfAbsent(v2d, DbObjectHighlighter::create);
        h.highlight((APair<DevicePath, AGeom>)new APair((Object)path, (Object)g));
        DbObjectHighlighter.fireHighlight(h);
    }

    public static void highlight(DesignView2D v2d, DevicePath path, DbObject dbo) {
        if (DesignCanvas2D._DisableDrawing) {
            return;
        }
        if (dbo.getDb() == null) {
            return;
        }
        DbObjectHighlighter.highlight(v2d, (HierInst<DbObject>)HierInst.create((DevicePath)path, (DbObject)dbo));
    }

    public static void clear(DesignView2D v2d) {
        DbObjectHighlighter h = gHighliters.get(v2d);
        if (h == null) {
            return;
        }
        h.clear();
        EventQueue.invokeLater(() -> {
            if (!h.getHighlights().findAny().isPresent() && !h.getHighlightsG().findAny().isPresent()) {
                DbObjectHighlighter.dispose(h);
            }
        });
    }

    protected static DbObjectHighlighter create(DesignView2D v2d) {
        assert (!gHighliters.containsKey(v2d));
        return new DbObjectHighlighter(v2d);
    }

    protected static void dispose(DbObjectHighlighter highlighter) {
        DesignView2D v2d = highlighter.getView();
        highlighter.dispose();
        gHighliters.remove(v2d);
    }

    protected DbObjectHighlighter(DesignView2D view) {
        this.mView = view;
        this.mView.addOverlay(this.mOverlay);
        this.mView.getCanvas().observeReimage().subscribe(v -> this.rerender());
    }

    protected void dispose() {
        this.mHierObjs.clear();
        this.mHierGeoms.clear();
        this.disposeRenderer();
        if (this.mView != null && this.mOverlay != null) {
            this.mView.removeOverlay(this.mOverlay);
        }
        this.mOverlay = null;
    }

    protected void disposeRenderer() {
        if (this.mRenderer != null) {
            this.mRenderer.interrupt();
            this.mRenderer = null;
        }
    }

    protected DesignView2D getView() {
        return this.mView;
    }

    protected void highlight(HierInst<DbObject> dbo) {
        this.mHierObjs.add(dbo);
        this.rerender();
    }

    protected void highlight(APair<DevicePath, AGeom> hgeom) {
        this.mHierGeoms.add(hgeom);
        this.rerender();
    }

    protected void clear() {
        if (this.mHierObjs.isEmpty() && this.mHierGeoms.isEmpty()) {
            return;
        }
        this.mHierObjs.clear();
        this.mHierGeoms.clear();
        this.rerender();
        DbObjectHighlighter.fireClear(this);
    }

    public Stream<HierInst<DbObject>> getHighlights() {
        return this.mHierObjs.stream();
    }

    protected Stream<APair<DevicePath, AGeom>> getHighlightsG() {
        return this.mHierGeoms.stream();
    }

    protected void rerender() {
        this.disposeRenderer();
        if (this.mOverlay != null) {
            this.mOverlay.repaint();
        }
    }

    protected void drawHighlightNet(Net net, DevicePath path, Graphics2D g, DesignCanvas2D.XForm xForm) {
        ViewColorizer viewColorizer = this.mView.getColorizer();
        for (HierInst descdendantNetObj : net.getDescendantContents()) {
            NetObject netObj = (NetObject)descdendantNetObj.getDbObject();
            if (netObj.getDb() == null) continue;
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            DevicePath dp = descdendantNetObj.getPath();
            DevicePath fullPath = path.addPath(dp);
            if (netObj instanceof PinTemplate) {
                PinTemplate pinT = (PinTemplate)netObj;
                if (pinT.getIsVirtual()) continue;
                this.drawHighlightPin(pinT, fullPath, g, xForm);
                continue;
            }
            netObj.getShapes().filter(ls -> ls.first != null && ls.second != null && viewColorizer.isVisible(fullPath, (DbObject)netObj, (Layer)ls.first)).forEach(ls -> {
                g.setPaint(HIGHLIGHT_GRADIENT);
                DesignCanvas2D.drawGeom(g, xForm, (AGeom)ls.second, fullPath.getTransform(), Color.yellow);
            });
        }
    }

    protected void drawHighlightDevice(Device device, DevicePath path, Graphics2D g, DesignCanvas2D.XForm xForm) {
        AGeom shape;
        g = (Graphics2D)g.create();
        g.setStroke(new BasicStroke(5.0f));
        g.setPaint(HIGHLIGHT_GRADIENT);
        DeviceTemplate devT = device.getTemplate();
        AGeom aGeom = shape = devT == null ? null : devT.getBounds(true);
        if (shape != null) {
            if (path.getDeviceTemplate() == device.getParent()) {
                path = path.copy();
                path.add(device);
            }
            DesignCanvas2D.drawGeom(g, xForm, shape, path.getTransform(), null, false);
        }
    }

    protected void drawHighlightPin(PinTemplate pt, DevicePath path, Graphics2D g, DesignCanvas2D.XForm xForm) {
        ARect worldBound = xForm.getWorldRect(this.mView.getCanvas().getPaintBounds());
        AGeom localBound = worldBound.transform(ATransformUtil.inverse((AffineTransform)path.getTransform()));
        if (!pt.intersects(localBound)) {
            return;
        }
        for (PortTemplate port : pt.getPortTemplates()) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            this.drawHighlightPort(port, path, g, xForm);
        }
    }

    protected void drawHighlightPort(PortTemplate port, DevicePath path, Graphics2D g, DesignCanvas2D.XForm xForm) {
        ViewColorizer colorizer = this.mView.getColorizer();
        ARect worldBound = xForm.getWorldRect(this.mView.getCanvas().getPaintBounds());
        AGeom localBound = worldBound.transform(ATransformUtil.inverse((AffineTransform)path.getTransform()));
        if (!port.intersects(localBound)) {
            return;
        }
        AffineTransform transform = path.getTransform();
        g.setPaint(HIGHLIGHT_GRADIENT);
        for (LayerShape ls : port.getLayerShapes()) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (!colorizer.getDisplay(path, ls.getLayer())) continue;
            DesignCanvas2D.drawGeom(g, xForm, ls.getGeom().transform(port.getTransform()), transform, Color.yellow);
        }
    }

    protected void drawHighlightBundle(Bundle bundle, DevicePath path, Graphics2D g, DesignCanvas2D.XForm xForm) {
        ViewColorizer viewColorizer = this.mView.getColorizer();
        AffineTransform transform = path.getTransform();
        g.setPaint(HIGHLIGHT_GRADIENT);
        if (viewColorizer.isVisible(path, (DbObject)bundle)) {
            DesignCanvas2D.drawGeom(g, xForm, (AGeom)bundle.getPath(), transform, Color.yellow);
        }
    }

    protected void drawHighlightObstacle(Obstacle obs, DevicePath path, Graphics2D g, DesignCanvas2D.XForm xForm) {
        ViewColorizer colorizer = this.mView.getColorizer();
        AffineTransform transform = path.getTransform();
        g.setPaint(HIGHLIGHT_GRADIENT);
        if (colorizer.isVisible(path, (DbObject)obs)) {
            for (LayerShape ls : obs.getLayerShapes()) {
                if (!colorizer.getDisplay(path, ls.getLayer())) continue;
                DesignCanvas2D.drawGeom(g, xForm, ls.getGeom(), transform, Color.yellow);
            }
        }
    }

    protected void drawHighlightConnection(Connection c, Graphics2D g, DesignCanvas2D.XForm xForm) {
        ViewColorizer viewColorizer = this.mView.getColorizer();
        APatternColor color = viewColorizer.getColor(c);
        ALine line = c.getLine();
        long dx = line.getP0().getY() - line.getP1().getY();
        long dy = line.getP1().getX() - line.getP0().getX();
        dx = (long)((double)dx * 0.3);
        dy = (long)((double)dy * 0.3);
        APoint2D c1 = line.getP0().add(new APoint2D(dx, dy));
        APoint2D c2 = line.getP1().add(new APoint2D(dx, dy));
        Point screenSt = xForm.getScreenPt(line.getP0());
        Point screenEd = xForm.getScreenPt(line.getP1());
        Point screenC1 = xForm.getScreenPt(c1);
        Point screenC2 = xForm.getScreenPt(c2);
        Path2D.Double curve = new Path2D.Double();
        curve.moveTo(screenSt.getX(), screenSt.getY());
        curve.curveTo(screenC1.getX(), screenC1.getY(), screenC2.getX(), screenC2.getY(), screenEd.getX(), screenEd.getY());
        g = (Graphics2D)g.create();
        g.setStroke(HIGHLIGHT_DASH);
        g.setColor(color.getColor());
        g.draw(curve);
    }

    private void drawHighlightPortShape(LayerShape ls, PortTemplate port, DevicePath path, Graphics2D g, DesignCanvas2D.XForm xForm) {
        ViewColorizer viewColorizer = this.mView.getColorizer();
        AffineTransform transform = path.getTransform();
        g.setPaint(HIGHLIGHT_GRADIENT);
        if (viewColorizer.isVisible(path, (DbObject)port, ls.getLayer())) {
            DesignCanvas2D.drawGeom(g, xForm, ls.getGeom().transform(port.getTransform()), transform, Color.yellow);
        }
    }

    public void drawHighlightObject(HierInst<DbObject> hierInst, Graphics2D g, DesignCanvas2D.XForm xForm) {
        DbObject dbo = hierInst.getDbObject();
        DevicePath path = hierInst.getPath();
        if (dbo == null || dbo.getDb() == null || path == null || g == null) {
            return;
        }
        if (dbo instanceof Net) {
            this.drawHighlightNet((Net)dbo, path, g, xForm);
        } else if (dbo instanceof Device) {
            this.drawHighlightDevice((Device)dbo, path, g, xForm);
        } else if (dbo instanceof PinTemplate) {
            this.drawHighlightPin((PinTemplate)dbo, path, g, xForm);
        } else if (dbo instanceof PinInstance) {
            PinTemplate pt = ((PinInstance)dbo).getPinTemplate();
            this.drawHighlightObject((HierInst<DbObject>)HierInst.create((DevicePath)path, (DbObject)pt), g, xForm);
        } else if (dbo instanceof Floorplan) {
            Floorplan fp = (Floorplan)dbo;
            g.setStroke(HIGHLIGH_STROKE);
            g.setColor(fp.getMyInterface().getColor());
            AGeom hull = fp.getHull(path, true);
            DesignCanvas2D.drawGeom(g, xForm, hull, new AffineTransform(), fp.getMyInterface().getColor(), false);
        } else if (dbo instanceof Wire) {
            Wire wire = (Wire)dbo;
            g.setPaint(HIGHLIGHT_GRADIENT);
            DesignCanvas2D.drawGeom(g, xForm, (AGeom)wire.getPath(), path.getTransform(), Color.yellow);
        } else if (!(dbo instanceof Design)) {
            if (dbo instanceof PortTemplate) {
                this.drawHighlightPort((PortTemplate)dbo, path, g, xForm);
            } else if (dbo instanceof Bundle) {
                this.drawHighlightBundle((Bundle)dbo, path, g, xForm);
            } else if (dbo instanceof Obstacle) {
                this.drawHighlightObstacle((Obstacle)dbo, path, g, xForm);
            } else if (!(dbo instanceof Layer) && !(dbo instanceof Substrate)) {
                if (dbo instanceof Connection) {
                    this.drawHighlightConnection((Connection)dbo, g, xForm);
                } else if (dbo instanceof Term) {
                    this.drawHighlightNet(((Term)dbo).getNet(), path, g, xForm);
                } else if (HierShape.class.isInstance(hierInst)) {
                    HierShape hiShape = (HierShape)HierShape.class.cast(hierInst);
                    if (hiShape.getOwner() instanceof PortTemplate) {
                        this.drawHighlightPortShape((LayerShape)dbo, (PortTemplate)hiShape.getOwner(), path, g, xForm);
                    } else {
                        ALog.logDebug((String)"Unsupport highlight object %s.", (Object[])new Object[]{hierInst});
                    }
                } else {
                    ALog.logDebug((String)"Unsupport highlight object %s.", (Object[])new Object[]{hierInst});
                }
            }
        }
    }

    public static boolean hasHighlight(DesignView2D v2d) {
        DbObjectHighlighter h = gHighliters.get(v2d);
        if (h == null) {
            return false;
        }
        return !h.mHierObjs.isEmpty();
    }

    public static void addHighlightListener(HighlightListener l) {
        listeners.add(l);
    }

    public static void removeHighlightListener(HighlightListener l) {
        listeners.remove(l);
    }

    private static void fireHighlight(DbObjectHighlighter lighter) {
        try {
            for (HighlightListener l : listeners) {
                l.highlight(lighter);
            }
        }
        catch (Exception e) {
            ALog.logDebug((Throwable)e, (String)"Something wrong during notifing listener", (Object[])new Object[0]);
        }
    }

    private static void fireClear(DbObjectHighlighter lighter) {
        try {
            for (HighlightListener l : listeners) {
                l.clear(lighter);
            }
        }
        catch (Exception e) {
            ALog.logDebug((Throwable)e, (String)"Something wrong during notifing listener", (Object[])new Object[0]);
        }
    }

    public static interface HighlightListener {
        public void highlight(DbObjectHighlighter var1);

        public void clear(DbObjectHighlighter var1);
    }

    protected class Renderer
    implements Runnable {
        BufferedImage mImg = null;
        DesignCanvas2D.XForm mXForm = null;
        DesignView2D.BgProc mBgProc = null;

        public Renderer() {
            this.mBgProc = DbObjectHighlighter.this.mView.runBackgroundProc("Rendering highlights " + this, this);
        }

        public boolean isAlive() {
            return DbObjectHighlighter.this.mView.isAlive(this.mBgProc);
        }

        public void interrupt() {
            DbObjectHighlighter.this.mView.interrupt(this.mBgProc);
        }

        public boolean isUpToDate() {
            Dimension canvasSize = DbObjectHighlighter.this.mView.getCanvas().getSize();
            return this.mImg != null && AUtil.equals((Object)this.mImg.getWidth(), (Object)canvasSize.width) && AUtil.equals((Object)this.mImg.getHeight(), (Object)canvasSize.height) && AUtil.equals((Object)this.mXForm, (Object)DbObjectHighlighter.this.mView.getCanvas().getXForm());
        }

        public void paintOverlay(Optional<Graphics> optGraphics) {
            if (!EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(() -> this.paintOverlay(optGraphics));
            } else {
                Graphics graphics = optGraphics.orElseGet(() -> DbObjectHighlighter.this.mOverlay == null ? null : DbObjectHighlighter.this.mOverlay.getGraphics());
                if (Thread.currentThread().isInterrupted() || graphics == null || !this.isUpToDate()) {
                    return;
                }
                boolean offset = true;
                graphics.drawImage(this.mImg, 1, 1, null);
                if (!optGraphics.isPresent()) {
                    graphics.dispose();
                }
            }
        }

        @Override
        public void run() {
            DesignCanvas2D canvas = DbObjectHighlighter.this.mView.getCanvas();
            Dimension dim = canvas.getSize();
            this.mXForm = canvas.getXForm().copy();
            this.mImg = canvas.getGraphicsConfiguration().createCompatibleImage(dim.width, dim.height, 3);
            Graphics graphics = this.mImg.getGraphics();
            if (!(graphics instanceof Graphics2D)) {
                if (!DbObjectHighlighter.this.mInvalidGraphicsErrorLogged) {
                    ALog.logDebug((String)"DbObjectHighlighter error: Image Graphics not Graphics2D.");
                    DbObjectHighlighter.this.mInvalidGraphicsErrorLogged = true;
                }
                assert (false);
                return;
            }
            Graphics2D g = (Graphics2D)graphics;
            Point2D.Double scale = canvas.getScale(null);
            g.scale(1.0 / scale.getX(), 1.0 / scale.getY());
            AlphaComposite ac = AlphaComposite.getInstance(3, 0.5f);
            g.setComposite(ac);
            try {
                for (APair<DevicePath, AGeom> aPair : DbObjectHighlighter.this.mHierGeoms) {
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    g.setPaint(HIGHLIGHT_GRADIENT);
                    APolygon p = ((AGeom)aPair.second).toPoly();
                    APath contour = p.toPath();
                    long w = this.mXForm.getWorldLength(5);
                    contour.setWidth(w);
                    DesignCanvas2D.drawGeom(g, this.mXForm, (AGeom)contour, ((DevicePath)aPair.first).getTransform(), Color.yellow);
                }
                for (HierInst hierInst : DbObjectHighlighter.this.mHierObjs) {
                    if (Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    DbObjectHighlighter.this.drawHighlightObject((HierInst<DbObject>)hierInst, g, this.mXForm);
                }
            }
            catch (ConcurrentModificationException cme) {
                return;
            }
            if (!Thread.currentThread().isInterrupted()) {
                this.paintOverlay(Optional.empty());
            }
        }
    }
}

