/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit;

import bsh.Interpreter;
import com.sigrity.acl.AEmptyItr;
import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.ASingletonItr;
import com.sigrity.acl.AStringEscape;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.MutableLong;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.ui.AFieldValidator;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.DbDialog;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.xml.AXDomUtil;
import com.sigrity.orbit.DiffPairs;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.ObjectActionRegistry;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.cmd.NetCmd;
import com.sigrity.orbit.db.DiffPairDetectorRegex;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.JTextComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DiffPairUI {
    public static final String XMLTAG_DIFF_PAIR_DETECTORS = "DiffPairDetectors";
    public static final String XMLTAG_DIFF_PAIR_DETECTOR = "DiffPairDetector";
    public static final ObjectActionRegistry.ActionFactory<HierInst<DbObject>> ActionFactory = (hinst, constraints) -> {
        DbObject dbObj = hinst.getDbObject();
        if (!(dbObj instanceof DeviceTemplate) || dbObj instanceof Design) {
            return AEmptyItr.create();
        }
        DeviceTemplate devT = (DeviceTemplate)dbObj;
        return new ASingletonItr((Object)new ActionCreateDiffPair(devT));
    };

    private DiffPairUI() {
    }

    public static LinkedList<DiffPairs.DiffPair> createDiffPairs(Db db, String devTKey, String detectorName, boolean detectorFromDesign) {
        DeviceTemplate devT = (DeviceTemplate)db.getByKeyStr(DeviceTemplate.class, devTKey);
        if (devT == null) {
            ALog.logError((Throwable)new IllegalArgumentException(), (String)"Invalid DeviceTemplate key '%s' passed to createDiffPairs().", (Object[])new Object[0]);
            return new LinkedList<DiffPairs.DiffPair>();
        }
        DiffPairs.DiffPairDetector detector = null;
        for (DiffPairs.DiffPairDetector d : detectorFromDesign ? DiffPairUI.getDesignDetectors(db) : AIterableItr.itr((Iterator)DiffPairs.getPredefDetectors())) {
            if (d.getName() == null || !d.getName().equals(detectorName)) continue;
            detector = d;
            break;
        }
        if (detector == null) {
            ALog.logError((Throwable)new IllegalArgumentException(), (String)"Unknown DiffPairDetector name '%s' %sfrom design passed to createDiffPairs().", (Object[])new Object[]{detectorName, detectorFromDesign ? "" : "not "});
            return new LinkedList<DiffPairs.DiffPair>();
        }
        return DiffPairs.createPairs((DeviceTemplate)devT, detector);
    }

    public static IterableIterator<DiffPairDetectorRegex> getDesignDetectors(Db db) {
        return db.getObjects(DiffPairDetectorRegex.class);
    }

    public static DiffPairDetectorRegex getFromDesign(DiffPairs.DiffPairDetector d) {
        if (d instanceof DiffPairDetectorRegex && ((DiffPairDetectorRegex)d).getDb() != null) {
            return (DiffPairDetectorRegex)d;
        }
        return null;
    }

    public static List<DiffPairs.DiffPairDetector> importDiffPairDetectors(String filePath) {
        LinkedList<DiffPairs.DiffPairDetector> res = new LinkedList<DiffPairs.DiffPairDetector>();
        Element xeDoc = AXDomUtil.getDocumentElement((File)new File(filePath));
        if (xeDoc == null) {
            return res;
        }
        if (!xeDoc.getTagName().equalsIgnoreCase(XMLTAG_DIFF_PAIR_DETECTORS)) {
            ALog.logError((String)"Document element of '%s' does not have tag name '%s', read aborted.", (Object[])new Object[]{XMLTAG_DIFF_PAIR_DETECTORS});
            return res;
        }
        Interpreter intr = Cp.getCp().getInterpreter();
        MutableLong created = new MutableLong(0L);
        AXDomUtil.getChildElems((Node)xeDoc, (String)XMLTAG_DIFF_PAIR_DETECTOR).stream().forEach(xe -> {
            String cmd = xe.getTextContent();
            try {
                Object o = intr.eval(AStringEscape.escapeJavaCode((String)cmd));
                if (!(o instanceof DiffPairs.DiffPairDetector)) {
                    ALog.logError((String)"The DiffPairDetector creation cmd '%s' from input file '%s' did not create an unexpected object of type %s.", (Object[])new Object[]{cmd, filePath, o == null ? "null" : o.getClass().getName()});
                    return;
                }
                DiffPairs.DiffPairDetector detector = (DiffPairs.DiffPairDetector)o;
                res.add(detector);
                created.setValue(created.getValue() + 1L);
            }
            catch (Exception ex) {
                ALog.logError((Throwable)ex, (String)"Error creating DiffPairDetector using statement(s) '%s' from input file '%s'.", (Object[])new Object[]{cmd, filePath});
            }
        });
        ALog.logInfo((String)"%d detector%s imported.", (Object[])new Object[]{created.getValue(), created.getValue() == 1L ? "" : "s"});
        return res;
    }

    public static void exportDiffPairDetectors(String filePath, String[] detectorCreationStmts) {
        if (filePath == null || detectorCreationStmts == null) {
            ALog.logError((String)"Parameters 'filePath', 'detectorCreationStmts' must be specified for exportDiffPairDetectors. No data will be exported.");
            return;
        }
        Element xeDoc = AXDomUtil.createXmlDoc((String)XMLTAG_DIFF_PAIR_DETECTORS);
        Arrays.asList(detectorCreationStmts).forEach(s -> {
            Element xeDetector = AXDomUtil.addElement((Element)xeDoc, (String)XMLTAG_DIFF_PAIR_DETECTOR);
            xeDetector.setTextContent((String)s);
        });
        try (FileOutputStream os = new FileOutputStream(filePath);){
            AXDomUtil.serialize((Node)xeDoc, (OutputStream)os);
        }
        catch (IOException ex) {
            ALog.logError((Throwable)ex, (String)"Error saving data to '%s'.", (Object[])new Object[]{filePath});
        }
    }

    public static class DiffPairRegexDetectorEditor
    extends JDialog {
        protected Db mDb;
        protected DiffPairDetectorRegex mInitialDetector = null;
        protected DiffPairDetectorRegex mUpdatedDetector = null;
        protected JTextField mName;
        protected JTextArea mDesc;
        protected JTextField mPatternN;
        protected JTextField mFormatP;
        protected JTextField mFormatPairName;
        protected Action mOk = new AbstractAction("OK"){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!this.validateData()) {
                    return;
                }
                if (mInitialDetector == null) {
                    Object o = Cp.exec((String)"%s.create(curDb(), \"%s\", \"%s\", \"%s\", \"%s\", \"%s\")", (Object[])new Object[]{DiffPairDetectorRegex.class.getName(), mName.getText(), mDesc.getText(), mPatternN.getText(), mFormatP.getText(), mFormatPairName.getText()});
                    if (!(o instanceof DiffPairDetectorRegex)) {
                        assert (false);
                        ALog.logError((String)"DiffPairDetectorRegex.create returned invalid value.");
                        return;
                    }
                    mUpdatedDetector = (DiffPairDetectorRegex)o;
                } else {
                    Object o = Cp.exec((String)"%s.update(curDb(), \"%s\", \"%s\", \"%s\", \"%s\", \"%s\", \"%s\")", (Object[])new Object[]{DiffPairDetectorRegex.class.getName(), mInitialDetector.getName(), mName.getText(), mDesc.getText(), mPatternN.getText(), mFormatP.getText(), mFormatPairName.getText()});
                    if (!(o instanceof DiffPairDetectorRegex)) {
                        assert (false);
                        ALog.logError((String)"DiffPairDetectorRegex.update returned invalid value.");
                        return;
                    }
                    mUpdatedDetector = (DiffPairDetectorRegex)o;
                }
                UIUtil.closeWindow((Window)this);
            }
        };

        public DiffPairRegexDetectorEditor(Window owner, Db db, DiffPairDetectorRegex detector) {
            super(owner);
            this.mDb = db;
            this.mInitialDetector = detector;
            this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
            this.setTitle(this.mInitialDetector == null ? "Create New RegEx Detector" : String.format("Edit RegEx Detector '%s'", this.mInitialDetector.getName()));
            GridBagManager l = GridBagManager.layout((JDialog)this);
            l.add("Name:");
            this.mName = (JTextField)l.add((Component)new JTextField(20), (GridBagConstraints)GridBagManager.LEFT_REMAINX);
            this.mName.setMinimumSize(this.mName.getPreferredSize());
            l.newline();
            l.add("Description:");
            this.mDesc = new JTextArea(2, 40);
            l.add((Component)new JScrollPane(this.mDesc), (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            this.mDesc.setLineWrap(true);
            this.mDesc.setWrapStyleWord(true);
            l.newline();
            l.add("N pattern:");
            this.mPatternN = (JTextField)l.add((Component)new JTextField(40), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            l.newline();
            l.add("P format:");
            this.mFormatP = (JTextField)l.add((Component)new JTextField(40), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            l.newline();
            l.add("Pair name format:");
            this.mFormatPairName = (JTextField)l.add((Component)new JTextField(40), (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            l.newline();
            l.pushFillXRemainX();
            l.addFillX();
            JButton btnOK = (JButton)l.add((Component)new JButton(this.mOk));
            JButton btnCancel = (JButton)l.add((Component)new JButton("Cancel"));
            l.pop();
            UIUtil.enableEscCloseDefaultMinSize((JDialog)this, (AbstractButton)btnCancel, (JButton)btnOK);
            this.pack();
            this.setMinimumSize(this.getPreferredSize());
            UIUtil.center((Component)this);
            if (this.mInitialDetector != null) {
                this.mName.setText(this.mInitialDetector.getName());
                this.mDesc.setText(this.mInitialDetector.getDesc());
                this.mPatternN.setText(this.mInitialDetector.getPatternN());
                this.mFormatP.setText(this.mInitialDetector.getFormatP());
                this.mFormatPairName.setText(this.mInitialDetector.getFormatPairName());
            }
        }

        public DiffPairDetectorRegex getInitialDetector() {
            return this.mInitialDetector;
        }

        public DiffPairDetectorRegex getUpdatedDetector() {
            return this.mUpdatedDetector;
        }

        public boolean validateData() {
            try {
                AFieldValidator.validateText((JTextComponent)this.mName);
                AFieldValidator.validateText((JTextComponent)this.mDesc);
                AFieldValidator.validateText((JTextComponent)this.mPatternN);
                AFieldValidator.validateText((JTextComponent)this.mFormatP);
                AFieldValidator.validateText((JTextComponent)this.mFormatPairName);
                String name = this.mName.getText();
                if (this.mInitialDetector == null && DiffPairDetectorRegex.get((Db)this.mDb, (String)name) != null) {
                    throw AFieldValidator.createException((String)name, (String)"name, it is already in use", null, (Component)this.mName);
                }
                try {
                    Pattern.compile(this.mPatternN.getText());
                }
                catch (PatternSyntaxException pe) {
                    throw AFieldValidator.createException((String)this.mPatternN.getText(), (String)"Pattern", (Throwable)pe, (Component)this.mPatternN);
                }
            }
            catch (AFieldValidator.AFieldValidationException fve) {
                return false;
            }
            return true;
        }
    }

    public static class DiffPairCreationUI
    extends DbDialog {
        protected List<DiffPairs.DiffPairDetector> mPredefDetectors = AUtil.linkedList((Iterator)DiffPairs.getPredefDetectors());
        protected DeviceTemplate mDevT;
        protected DefaultListModel<DiffPairs.DiffPairDetector> mLmDiffPairDetectors;
        protected JList<DiffPairs.DiffPairDetector> mLstDetectors;
        protected JButton mBtnAdd;
        protected JButton mBtnDup;
        protected JButton mBtnEdit;
        protected JButton mBtnDel;
        protected JButton mBtnImport;
        protected JButton mBtnExport;
        protected JButton mBtnApply;
        protected Action mActionAdd = new AbstractAction("Add..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                DiffPairRegexDetectorEditor editor = new DiffPairRegexDetectorEditor((Window)((Object)this), mDevT.getDb(), null);
                editor.setVisible(true);
                DiffPairDetectorRegex detector = editor.getUpdatedDetector();
                this.showDetector((DiffPairs.DiffPairDetector)detector);
            }
        };
        protected Action mActionDup = new AbstractAction("Duplicate"){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (int selIdx : mLstDetectors.getSelectedIndices()) {
                    DiffPairs.DiffPairDetector d = mLstDetectors.getModel().getElementAt(selIdx);
                    if (!(d instanceof DiffPairDetectorRegex)) continue;
                    DiffPairDetectorRegex dr = (DiffPairDetectorRegex)d;
                    Object newName = d.getName();
                    newName = ((String)newName).matches(".+-copy[0-9]*$") ? ((String)newName).replaceFirst("(.+-copy)([0-9]+)$", "$1") : (String)newName + "-copy";
                    newName = DiffPairDetectorRegex.getUniqueName((Db)mDb, (String)newName);
                    Object o = Cp.exec((String)"%s.create(curDb(), \"%s\", \"%s\", \"%s\", \"%s\", \"%s\")", (Object[])new Object[]{DiffPairDetectorRegex.class.getName(), newName, dr.getDesc(), dr.getPatternN(), dr.getFormatP(), dr.getFormatPairName()});
                    if (!(o instanceof DiffPairDetectorRegex)) {
                        assert (false);
                        ALog.logError((String)"DiffPairDetectorRegex.create returned invalid value.");
                        return;
                    }
                    DiffPairDetectorRegex newDr = (DiffPairDetectorRegex)o;
                    this.showDetector((DiffPairs.DiffPairDetector)newDr);
                }
            }
        };
        protected Action mActionEdit = new AbstractAction("Edit..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                int[] selIdxs = mLstDetectors.getSelectedIndices();
                if (selIdxs.length != 1) {
                    return;
                }
                DiffPairs.DiffPairDetector d = mLstDetectors.getModel().getElementAt(selIdxs[0]);
                DiffPairDetectorRegex detector = DiffPairUI.getFromDesign(d);
                if (detector == null) {
                    return;
                }
                DiffPairRegexDetectorEditor editor = new DiffPairRegexDetectorEditor((Window)((Object)this), mDevT.getDb(), detector);
                editor.setVisible(true);
                detector = editor.getUpdatedDetector();
                if (detector != null) {
                    mLstDetectors.repaint();
                }
            }
        };
        protected Action mActionDelete = new AbstractAction("Delete"){

            @Override
            public void actionPerformed(ActionEvent e) {
                LinkedList<DiffPairDetectorRegex> toDelete = new LinkedList<DiffPairDetectorRegex>();
                for (int selIdx : mLstDetectors.getSelectedIndices()) {
                    DiffPairs.DiffPairDetector d = mLstDetectors.getModel().getElementAt(selIdx);
                    DiffPairDetectorRegex dpdr = DiffPairUI.getFromDesign(d);
                    if (dpdr == null) continue;
                    toDelete.add(dpdr);
                }
                if (toDelete.isEmpty()) {
                    return;
                }
                String msg = String.format("Do you want to delete %d selected detector%s?", toDelete.size(), toDelete.size() == 1 ? "" : "s");
                if (0 != JOptionPane.showConfirmDialog((Component)((Object)this), msg, "Confirm Delete", 0)) {
                    return;
                }
                try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)mDb, (String)"Delete Detectors");){
                    for (DiffPairDetectorRegex d : toDelete) {
                        Cp.exec((String)"com.sigrity.orbit.db.DiffPairDetectorRegex.get(curDb(), \"%s\").deleteFromDb()", (Object[])new Object[]{d.getName()});
                    }
                }
            }
        };
        protected Action mActionExport = new AbstractAction("Export..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                List detectors = mLstDetectors.getSelectedValuesList().stream().filter(d -> DiffPairUI.getFromDesign(d) != null).collect(Collectors.toList());
                AFileChooser fc = new AFileChooser();
                fc.setFileFilter((FileFilter)AFileFilter.XML);
                fc.setDialogTitle(String.format("Export %d Detector%s", detectors.size(), detectors.size() == 1 ? "" : "s"));
                if (fc.showSaveDialog((Component)((Object)this)) != 0) {
                    return;
                }
                File f = fc.getSelectedFile();
                String s = detectors.stream().map(d -> d.getCreationCommand()).map(cmd -> AStringEscape.escapeJavaCode((String)cmd)).map(cmd -> AStringEscape.escapeDoubleQuotes((String)cmd)).collect(Collectors.joining("\", \"", "\"", "\""));
                Cp.exec((boolean)true, (boolean)false, (String)"%s.exportDiffPairDetectors(%s, new String[]{%s})", (Object[])new Object[]{DiffPairUI.class.getName(), AStringEscape.escapeJavaCode((String)Cp.getFileAsArgument((String)f.getAbsolutePath())), s});
            }
        };
        protected Action mActionImport = new AbstractAction("Import..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                AFileChooser fc = new AFileChooser();
                fc.setFileFilter((FileFilter)AFileFilter.XML);
                fc.setDialogTitle("Import Detectors");
                if (fc.showOpenDialog((Component)((Object)this)) != 0) {
                    return;
                }
                Cp.exec((String)"%s.importDiffPairDetectors(%s)", (Object[])new Object[]{DiffPairUI.class.getName(), Cp.getFileAsArgument((File)fc.getSelectedFile())});
            }
        };
        protected DbClass.DbObjectAdapter mDiffPairDetectorRegexListener = new DbClass.DbObjectAdapter(){

            public void removedObject(DbClass.ObjectRemove remove) {
                this.updateDetectors();
            }

            public void changedObject(DbClass.ObjectChange change) {
                this.updateDetectors();
            }

            public void addedObject(DbClass.ObjectAdd add) {
                this.updateDetectors();
            }
        };

        public DiffPairCreationUI(Window owner, DeviceTemplate devT) {
            super(devT.getDb(), (Component)owner);
            this.mDevT = devT;
            this.setTitle("Create Differential Pairs");
            GridBagManager l = GridBagManager.layout((JDialog)((Object)this));
            l.push((GridBagConstraints)GridBagManager.LEFT_REMAINX.noInsets());
            l.add("For:");
            l.add(devT.getName());
            l.popNl();
            l.push("Use Detectors", (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            this.mLmDiffPairDetectors = new DefaultListModel();
            this.mLstDetectors = new JList<DiffPairs.DiffPairDetector>(this.mLmDiffPairDetectors);
            l.add((Component)new JScrollPane(this.mLstDetectors), (GridBagConstraints)GridBagManager.FILLALL_REMAINX.insetBottom(0));
            l.newline();
            l.push((GridBagConstraints)GridBagManager.FILLX_REMAINX.insetTop(0));
            l.addFillX();
            this.mBtnAdd = (JButton)l.add((Component)new JButton(this.mActionAdd), (GridBagConstraints)GridBagManager.RIGHT.noInsets());
            this.mBtnDup = (JButton)l.add((Component)new JButton(this.mActionDup), (GridBagConstraints)GridBagManager.RIGHT.noInsets());
            this.mBtnEdit = (JButton)l.add((Component)new JButton(this.mActionEdit), (GridBagConstraints)GridBagManager.RIGHT.noInsets());
            this.mBtnDel = (JButton)l.add((Component)new JButton(this.mActionDelete), (GridBagConstraints)GridBagManager.RIGHT.noInsets());
            this.mBtnImport = (JButton)l.add((Component)new JButton(this.mActionImport), (GridBagConstraints)GridBagManager.RIGHT.noInsets().insetLeft(4));
            this.mBtnExport = (JButton)l.add((Component)new JButton(this.mActionExport), (GridBagConstraints)GridBagManager.RIGHT.noInsets().insetRight(1));
            l.pop();
            JButton[] editBtns = new JButton[]{this.mBtnAdd, this.mBtnDup, this.mBtnEdit, this.mBtnDel, this.mBtnImport, this.mBtnExport};
            Font baseFont = this.mBtnAdd.getFont();
            Font smallFont = baseFont.deriveFont((float)baseFont.getSize() - 2.0f);
            Insets smallInsets = new Insets(2, 2, 2, 2);
            for (JButton btn : editBtns) {
                btn.setFont(smallFont);
                btn.setMargin(smallInsets);
            }
            l.popNl();
            l.pushFillXRemainX();
            l.addFillX();
            JLabel lblTip = l.add("Shift/Ctrl to select multiple", (GridBagConstraints)GridBagManager.FILLX);
            lblTip.setFont(lblTip.getFont().deriveFont(2));
            this.mBtnApply = (JButton)l.add((Component)new JButton("Apply"));
            JButton btnClose = (JButton)l.add((Component)new JButton("Close"));
            l.pop();
            this.updateDetectors();
            this.mLstDetectors.setCellRenderer(new DefaultListCellRenderer(){
                Font fontNormal = null;
                Font fontItalic = null;

                @Override
                public Component getListCellRendererComponent(JList<?> list, Object val, int index, boolean selected, boolean hasFocus) {
                    boolean editable;
                    super.getListCellRendererComponent(list, (Object)null, index, selected, hasFocus);
                    DiffPairs.DiffPairDetector dpd = (DiffPairs.DiffPairDetector)val;
                    this.setText(dpd.getName());
                    this.setToolTipText(dpd.getDesc());
                    boolean bl = editable = DiffPairUI.getFromDesign(dpd) != null;
                    if (this.fontNormal == null) {
                        this.fontNormal = this.getFont();
                        this.fontItalic = this.fontNormal.deriveFont(2);
                    }
                    this.setFont(editable ? this.fontItalic : this.fontNormal);
                    return this;
                }
            });
            this.mLstDetectors.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2 && e.getButton() == 1) {
                        mActionEdit.actionPerformed(new ActionEvent(mLstDetectors, 1001, "DoubleClick"));
                    }
                }
            });
            UIUtil.enableEscCloseDefaultMinSize((JDialog)((Object)this), (AbstractButton)btnClose, (JButton)this.mBtnApply);
            this.pack();
            this.setMinimumSize(this.getPreferredSize());
            UIUtil.center((Component)((Object)this));
            this.mBtnApply.addActionListener(e -> {
                int detectorCount = 0;
                long totalCreated = 0L;
                try {
                    try (DbHistory.DbTransaction trans = DbHistory.newDbTransaction((Db)OrbitIO.getCurDb(), (String)"Create Diff Pairs");){
                        for (DiffPairs.DiffPairDetector d : this.mLstDetectors.getSelectedValuesList()) {
                            Object result = Cp.exec((String)"%s.createDiffPairs(curDb(), \"%s\", \"%s\", %b)", (Object[])new Object[]{DiffPairUI.class.getName(), devT.getKeyStr(), d.getName(), DiffPairUI.getFromDesign(d)});
                            if (!(result instanceof LinkedList)) {
                                ALog.logError((String)"Unexpected result of type '%s' from %s.createDiffPairs().", (Object[])new Object[]{result == null ? "null" : result.getClass().getName(), DiffPairUI.class.getName()});
                                continue;
                            }
                            LinkedList pairs = (LinkedList)result;
                            Selection selection = Design.getSelection((Db)devT.getDb());
                            for (DiffPairs.DiffPair pair : pairs) {
                                NetCmd.selectNet((Net)pair.getN(), (boolean)true, (Selection)selection);
                                NetCmd.selectNet((Net)pair.getP(), (boolean)true, (Selection)selection);
                            }
                            ALog.logInfo((String)"%s created %d new differential pairs.", (Object[])new Object[]{d.getName(), pairs.size()});
                            totalCreated += (long)pairs.size();
                            ++detectorCount;
                        }
                    }
                    if (detectorCount <= 1) return;
                }
                catch (Throwable throwable) {
                    if (detectorCount <= true) throw throwable;
                    ALog.logInfo((String)"A total of %d differential pairs were created by %d pair detectors.", (Object[])new Object[]{totalCreated, detectorCount});
                    throw throwable;
                }
                ALog.logInfo((String)"A total of %d differential pairs were created by %d pair detectors.", (Object[])new Object[]{totalCreated, detectorCount});
            });
            this.mLstDetectors.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    this.enableControls();
                }
            });
            this.enableControls();
        }

        public void enableControls() {
            this.mBtnApply.setEnabled(!this.mLstDetectors.getSelectedValuesList().isEmpty());
            int modifiable = 0;
            int unmodifiable = 0;
            int duplicatable = 0;
            for (int selIdx : this.mLstDetectors.getSelectedIndices()) {
                DiffPairs.DiffPairDetector d = this.mLstDetectors.getModel().getElementAt(selIdx);
                if (DiffPairUI.getFromDesign(d) != null) {
                    ++modifiable;
                } else {
                    ++unmodifiable;
                }
                if (!(d instanceof DiffPairDetectorRegex)) continue;
                ++duplicatable;
            }
            this.mBtnAdd.setEnabled(true);
            this.mBtnDup.setEnabled(duplicatable == 1);
            this.mBtnEdit.setEnabled(modifiable == 1 && unmodifiable == 0);
            this.mBtnDel.setEnabled(modifiable > 0);
            this.mBtnExport.setEnabled(modifiable > 0);
        }

        protected void updateDetectors() {
            LinkedList sel = AUtil.linkedList(this.mLstDetectors.getSelectedValuesList());
            this.mLmDiffPairDetectors.clear();
            for (DiffPairs.DiffPairDetector d : AUtil.sort(this.mPredefDetectors.iterator(), (Comparator)DiffPairs.DiffPairDetectorComparator)) {
                this.mLmDiffPairDetectors.addElement(d);
            }
            for (DiffPairs.DiffPairDetector d : AUtil.sort((Iterator)DiffPairUI.getDesignDetectors(this.mDb).iterator(), (Comparator)DiffPairs.DiffPairDetectorComparator)) {
                this.mLmDiffPairDetectors.addElement(d);
            }
            for (DiffPairs.DiffPairDetector d : sel) {
                int idx = this.mLmDiffPairDetectors.indexOf(d);
                if (idx < 0) continue;
                this.mLstDetectors.addSelectionInterval(idx, idx);
            }
        }

        protected void showDetector(DiffPairs.DiffPairDetector d) {
            for (int i = 0; i < this.mLmDiffPairDetectors.getSize(); ++i) {
                DiffPairs.DiffPairDetector cur = this.mLmDiffPairDetectors.get(i);
                if (cur != d) continue;
                this.mLstDetectors.setSelectedIndex(i);
                this.mLstDetectors.scrollRectToVisible(this.mLstDetectors.getCellBounds(i, i));
                break;
            }
        }

        public void addNotify() {
            super.addNotify();
            this.mDb.getDbClass(DiffPairDetectorRegex.class).addObjectListener((DbClass.DbObjectListener)this.mDiffPairDetectorRegexListener, DbClass.DbObjectEventType.getUpdated());
        }

        public void removeNotify() {
            DbClass cls;
            DbClass dbClass = cls = this.mDb == null ? null : this.mDb.getDbClass(DiffPairDetectorRegex.class);
            if (cls != null) {
                cls.removeObjectListener((DbClass.DbObjectListener)this.mDiffPairDetectorRegexListener, DbClass.DbObjectEventType.getUpdated());
            }
            super.removeNotify();
        }
    }

    public static class ActionCreateDiffPair
    extends AbstractAction {
        private final DeviceTemplate mDevT;

        public ActionCreateDiffPair(DeviceTemplate devT) {
            super("Create Differential Pairs...");
            this.mDevT = devT;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            new DiffPairCreationUI(OrbitIO.getMainWindow(), this.mDevT).setVisible(true);
        }
    }
}

