/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit;

import com.sigrity.acl.AAlphaNumComp;
import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPort;
import com.sigrity.orbit.ObjectLocator;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ShowMeTheWay;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.InputMap;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class HDLView
extends JEditorPane {
    static String myId = "hdlView";
    protected Action gotoTop = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            HDLView.this.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        }
    };
    protected Action gotoFind = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    };
    protected Action gotoBot = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Rectangle r = HDLView.this.getBounds();
            Rectangle b = new Rectangle(r.width - 1, r.height - 1, 1, 1);
            HDLView.this.scrollRectToVisible(b);
        }
    };

    public HDLView(DevicePath path) {
        this.setEditable(false);
        this.setContentType("text/html");
        this.setEditable(false);
        DevicePathToVerilogHTML xlate = new DevicePathToVerilogHTML();
        xlate.setPath(path);
        xlate.generate();
        String buffer = xlate.getHTML();
        this.setText(buffer);
        this.addHyperlinkListener(new MyHyperlinkListener());
        ObjectLocator.addListener(new MyObjectLocatorListener());
        this.createKeyBindings();
    }

    protected void createKeyBindings() {
        this.getActionMap().put("TOP", this.gotoTop);
        this.bindKey("T", "TOP");
        this.getActionMap().put("BOT", this.gotoBot);
        this.bindKey("B", "BOT");
        this.getActionMap().put("FIND", this.gotoFind);
        this.bindKey("control F", "FIND");
    }

    public void bindKey(String key, String action) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(key);
        if (keyStroke == null) {
            ALog.logWarn((String)"Invalid key stroke '%s' specified while attempting to bind key stroketo action '%s'.", (Object[])new Object[]{key, action});
            return;
        }
        InputMap inputMap = this.getInputMap(1);
        inputMap.put(keyStroke, action);
    }

    public static class NetSorter
    implements Comparator<Net> {
        @Override
        public int compare(Net pt0, Net pt1) {
            return pt0.getName().compareTo(pt1.getName());
        }
    }

    public static class PinSorter
    implements Comparator<PinTemplate> {
        @Override
        public int compare(PinTemplate pt0, PinTemplate pt1) {
            return pt0.getName().compareTo(pt1.getName());
        }
    }

    public class ChildrenSorter
    implements Comparator<DevicePath> {
        @Override
        public int compare(DevicePath dp0, DevicePath dp1) {
            AAlphaNumComp c = AAlphaNumComp.get();
            return c.compare((Object)dp0.toString(), (Object)dp1.toString());
        }
    }

    class MyHyperlinkListener
    implements HyperlinkListener {
        MyHyperlinkListener() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent evt) {
            if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                String des = evt.getDescription();
                int dotPos = des.indexOf(".");
                String type = des.substring(0, dotPos);
                String name = des.substring(dotPos + 1);
                DevicePath dp = DevicePath.fromString((Db)OrbitIO.getCurDb(), (String)name);
                JEditorPane pane = (JEditorPane)evt.getSource();
                if (type.equals("dt")) {
                    pane.scrollToReference(des);
                } else {
                    ShowMeTheWay.addDevicePath(dp);
                    ObjectLocator.locateDevicePath(dp, myId);
                }
            }
        }
    }

    class DevicePathToVerilogHTML {
        DevicePath path;
        int indentLevel = 0;
        String buffer = "";
        int linkIndex = 0;
        HashSet<DeviceTemplate> printedTemplates = new HashSet();

        DevicePathToVerilogHTML() {
        }

        public void setPath(DevicePath path) {
            this.path = path;
        }

        public void generate() {
            this.buffer = "";
            this.indentLevel = 0;
            this.printlnNoBreak("<html>");
            this.printlnNoBreak("<body>");
            this.printlnNoBreak("<a name=\"ztop\"></a>");
            this.generatePath(this.path);
            this.printlnNoBreak("</body>");
            this.printlnNoBreak("</html>");
        }

        protected void generateNetArgs(DevicePath path) {
            LinkedList<Net> internal = new LinkedList<Net>();
            LinkedList<PinTemplate> external = new LinkedList<PinTemplate>();
            DeviceTemplate dt = path.getDeviceTemplate();
            for (PinTemplate pt : dt.getPins()) {
                external.add(pt);
            }
            for (Net n : dt.getNets()) {
                if (n.isUnused()) continue;
                Net parent = NetMap.getParentNet((Device)path.getLast(), (Net)n);
                if (n.getName().contains("PAD")) {
                    ALog.logInfo((String)"");
                }
                if (parent != null) continue;
                boolean pinConnected = false;
                for (PinTemplate pt : dt.getPins()) {
                    if (!pt.getNet().equals(n)) continue;
                    pinConnected = true;
                    break;
                }
                if (pinConnected || internal.contains(n)) continue;
                internal.add(n);
            }
            Collections.sort(external, new PinSorter());
            Collections.sort(internal, new NetSorter());
            String direction = "inout";
            for (PinTemplate pt : external) {
                PinTemplate.Direction dir = pt.getDirection();
                if (dir.equals((Object)PinTemplate.Direction.IN)) {
                    direction = "input";
                } else if (dir.equals((Object)PinTemplate.Direction.OUT)) {
                    direction = "output";
                }
                this.println(direction + " " + pt.getName() + ";");
            }
            for (Net n : internal) {
                this.println("wire " + n.getName() + ";");
            }
        }

        protected void generatePath(DevicePath path) {
            if (this.printedTemplates.contains(path.getDeviceTemplate())) {
                return;
            }
            this.printedTemplates.add(path.getDeviceTemplate());
            this.println(this.bookMarkTemplate(path.getDeviceTemplate()));
            this.println("module " + path.getDeviceTemplate().getName() + " ()");
            this.println("{");
            ++this.indentLevel;
            this.generateNetArgs(path);
            LinkedList<DevicePath> children = new LinkedList<DevicePath>();
            for (DevicePath child : path.getChildren()) {
                children.add(child);
            }
            Collections.sort(children, new ChildrenSorter());
            for (DevicePath child : children) {
                this.println(this.linkToTemplate(child) + " " + this.linkToDevicePath(child) + " ()");
            }
            --this.indentLevel;
            this.println("}");
            for (DevicePath child : path.getChildren()) {
                this.generatePath(child);
            }
        }

        protected String bookMarkTemplate(DeviceTemplate template) {
            String s = "<a name=\"dt." + template.getName() + "\"></a>";
            return s;
        }

        protected String linkToDevicePath(DevicePath path) {
            String s = "<a style= \"color: red;text-decoration:none\" href=\"dp." + path.toString() + "\">" + path.getLast().getName() + "</a>";
            return s;
        }

        protected String linkToTemplate(DevicePath path) {
            DeviceTemplate template = path.getDeviceTemplate();
            String s = "<a style= \"color: blue;text-decoration:none\" href=\"dt." + template.getName() + "\">" + template.getName() + "</a>";
            return s;
        }

        public String getHTML() {
            return this.buffer;
        }

        public void println(String s) {
            this.indent();
            this.buffer = this.buffer + s;
            this.buffer = this.buffer + "<br>\t";
        }

        public void printlnNoBreak(String s) {
            this.indent();
            this.buffer = this.buffer + s + "\n\t";
        }

        public void indent() {
            for (int i = 0; i < this.indentLevel; ++i) {
                this.buffer = this.buffer + "&nbsp;&nbsp;&nbsp;";
            }
        }
    }

    class MyObjectLocatorListener
    implements ObjectLocator.ObjectLocatorListener {
        MyObjectLocatorListener() {
        }

        @Override
        public boolean locateDevicePath(DevicePath path, String callerId) {
            Device d = path.getLast();
            DeviceTemplate dt = d.getTemplate();
            String des = "dt." + dt.getName();
            HDLView.this.scrollToReference(des);
            return true;
        }

        @Override
        public boolean locateHierPort(HierPort hierPort, String callerId) {
            return false;
        }

        @Override
        public boolean locateHierNet(HierInst<Net> hierNet) {
            return false;
        }
    }
}

