/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit;

import com.google.gson.Gson;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.ACompositeGeom;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGeomWithCutouts;
import com.sigrity.acl.geom.AOutlineGeom;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.IRDropInput;
import com.sigrity.orbit.OrbitIO;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class IRDropCalc {
    private String[] mSrcDevs;
    private String[] mSinkDevs;
    private double[] mSinkDevCurrents;
    private double[] mSinkCurrents;
    private Layer mLayer;
    private Net mNet;
    private String mTopDevPath;
    private Db mdb;
    private int mArcToPolyResolution = 12;
    private double mGeoUnit = 1.0E-12;
    private APolygon mPowerPlaneShape;
    private List<String> mViasSrc = new ArrayList<String>();
    private List<String> mViasSink = new ArrayList<String>();

    public IRDropCalc(String topDevPath) {
        this.mdb = OrbitIO.getCurDb();
        this.mTopDevPath = topDevPath;
    }

    public static List<String> findPowerPlaneVias(Device dev, Layer layer, Net net) {
        ArrayList<String> viaNames = new ArrayList<String>();
        ArrayList<PinTemplate> pps = new ArrayList<PinTemplate>();
        for (PinInstance p : dev.getPins()) {
            for (Wire w : p.getConnectedWires(false).collect(Collectors.toList())) {
                for (HierInst hp : w.getPins()) {
                    PinTemplate pt;
                    if (hp == null || (pt = (PinTemplate)hp.getSecond()).getNet() != net) continue;
                    boolean isRightLayer = false;
                    for (Layer l : pt.getLayersInUse().collect(Collectors.toList())) {
                        if (l != layer) continue;
                        isRightLayer = true;
                    }
                    if (!isRightLayer) continue;
                    pps.add(pt);
                }
            }
        }
        for (PinTemplate pt : pps.stream().distinct().collect(Collectors.toList())) {
            viaNames.add(pt.getName());
        }
        return viaNames;
    }

    public static List<String> findPowerPlaneVias(Device dev, Layer layer, Net net, AGeom planeShape) {
        ArrayList<String> viaNames = new ArrayList<String>();
        for (PinInstance pi : dev.getPins()) {
            HashSet<PinTemplate> visited = new HashSet<PinTemplate>();
            for (PinTemplate pt : IRDropCalc.findConnPinsOnPowPlane(pi.getPinTemplate(), null, layer, net, planeShape, visited)) {
                viaNames.add(pt.getName());
            }
        }
        return viaNames.stream().distinct().collect(Collectors.toList());
    }

    public static List<PinTemplate> findConnPinsOnPowPlane(PinTemplate p, Wire parent_wire, Layer layer, Net net, AGeom planeShape, Set<PinTemplate> visited) {
        APolygon pinShape;
        List geoms1;
        if (visited.contains(p)) {
            return Collections.emptyList();
        }
        visited.add(p);
        if (p.getNet() == net && !(geoms1 = p.getPortTemplate(0).getShapesOnLayer(layer).stream().collect(Collectors.toList())).isEmpty() && (pinShape = ((AGeom)geoms1.get(geoms1.size() - 1)).toPoly()) != null && pinShape.intersects((AGeom)planeShape.toPoly())) {
            return new ArrayList<PinTemplate>(Arrays.asList(p));
        }
        ArrayList<PinTemplate> res = new ArrayList<PinTemplate>();
        for (Wire w : p.getConnectedWires()) {
            if (w == parent_wire || w.getNet() != net) continue;
            for (HierInst hp : w.getPins()) {
                PinTemplate pt;
                if (hp == null || (pt = (PinTemplate)hp.getSecond()) == p) continue;
                res.addAll(IRDropCalc.findConnPinsOnPowPlane(pt, w, layer, net, planeShape, visited));
            }
        }
        return res;
    }

    public void selectPowerPlane(String layerName, String netName) {
        this.mLayer = null;
        for (Layer l : this.mdb.getObjects(Layer.class)) {
            if (!layerName.equals(l.getName())) continue;
            this.mLayer = l;
        }
        if (this.mLayer != null) {
            System.out.println("layer found: " + this.mLayer.getName());
        }
        this.mNet = null;
        for (Net n : this.mdb.getObjects(Net.class)) {
            if (!netName.equals(n.getName())) continue;
            this.mNet = n;
        }
        if (this.mNet != null) {
            System.out.println("net found: " + this.mNet.getName());
        }
    }

    public void setSrcDevs(String[] srcDevs) {
        this.mSrcDevs = srcDevs;
        this.mViasSrc.clear();
    }

    private void genSrcVias() {
        this.mViasSrc.clear();
        System.out.println("-----showing src pins-----");
        for (String devname : this.mSrcDevs) {
            List<String> vias_dev = IRDropCalc.findPowerPlaneVias(Device.fromPath((Db)this.mdb, (String)(this.mTopDevPath + "/" + devname)), this.mLayer, this.mNet, (AGeom)this.mPowerPlaneShape);
            Collections.sort(vias_dev);
            System.out.println(devname + " : " + vias_dev);
            this.mViasSrc.addAll(vias_dev);
        }
    }

    public void setSrcVias(String[] vias) {
        this.mViasSrc = Arrays.asList(vias);
    }

    public void setSinkDevs(String[] sinkDevs, double[] sinkDevCurrents) {
        this.mSinkDevs = sinkDevs;
        this.mViasSink.clear();
        this.mSinkDevCurrents = sinkDevCurrents;
    }

    private void genSinkViasCurrents() {
        ArrayList<Double> sinks_current_list = new ArrayList<Double>();
        System.out.println("-----showing sink pins-----");
        int i = 0;
        for (String devname : this.mSinkDevs) {
            List<String> vias_dev = IRDropCalc.findPowerPlaneVias(Device.fromPath((Db)this.mdb, (String)(this.mTopDevPath + "/" + devname)), this.mLayer, this.mNet, (AGeom)this.mPowerPlaneShape);
            Collections.sort(vias_dev);
            System.out.println(devname + " : " + vias_dev);
            this.mViasSink.addAll(vias_dev);
            double I = this.mSinkDevCurrents[i] / (double)vias_dev.size();
            for (int j = 0; j < vias_dev.size(); ++j) {
                sinks_current_list.add(I);
            }
            ++i;
        }
        this.mSinkCurrents = new double[sinks_current_list.size()];
        for (int k = 0; k < this.mSinkCurrents.length; ++k) {
            this.mSinkCurrents[k] = (Double)sinks_current_list.get(k);
            System.out.println("sink current:  " + this.mViasSink.get(k) + " " + this.mSinkCurrents[k]);
        }
    }

    public void setSinks(String[] vias, double[] currents) {
        this.mViasSink = Arrays.asList(vias);
        this.mSinkCurrents = currents;
    }

    public double[] getGeomPoly(AGeom g) {
        APolygon p1 = null;
        String type = g.getName();
        if (type.equals("circle")) {
            p1 = ((ACircle)g).toClosedPoly(this.mArcToPolyResolution);
        } else if (type.equals("outlinegeom")) {
            ((AOutlineGeom)g).setArcToPolyResultion(this.mArcToPolyResolution);
            p1 = ((AOutlineGeom)g).toPoly();
        }
        return p1.getPointsFloat();
    }

    /*
     * WARNING - void declaration
     */
    public double[] solve(String endpointUrl, int Nx, int Ny) {
        void var17_26;
        void var17_24;
        void var17_22;
        void var17_20;
        List geoms = this.mNet.getMetalShapesOnLayer(this.mLayer).stream().collect(Collectors.toList());
        AGeom g = (AGeom)geoms.get(geoms.size() - 1);
        AGeomWithCutouts gc = (AGeomWithCutouts)g;
        AGeom outer = gc.getOuter();
        AGeom cutout = gc.getCutout();
        System.out.println("outer type is " + outer.getName());
        System.out.println("cutout type is " + cutout.getName());
        AOutlineGeom outer1 = (AOutlineGeom)outer;
        outer1.setArcToPolyResultion(this.mArcToPolyResolution);
        this.mPowerPlaneShape = outer.toPoly();
        double[] outline = this.mPowerPlaneShape.getPointsFloat();
        ACompositeGeom cutout1 = (ACompositeGeom)cutout;
        List holes = cutout1.getChildren().parallelStream().collect(Collectors.toList());
        int i = 0;
        double[][] cutouts = new double[holes.size()][];
        for (Object h : holes) {
            cutouts[i] = this.getGeomPoly((AGeom)h);
            ++i;
        }
        this.genSrcVias();
        this.genSinkViasCurrents();
        double[][] sources = new double[this.mViasSrc.size()][];
        i = 0;
        for (String string : this.mViasSrc) {
            List geoms1 = this.mNet.getPinTemplate(string).getPortTemplate(0).getShapesOnLayer(this.mLayer).stream().collect(Collectors.toList());
            AGeom g1 = (AGeom)geoms1.get(geoms1.size() - 1);
            sources[i] = this.getGeomPoly(g1);
            ++i;
        }
        double[][] sinks = new double[this.mViasSink.size()][];
        i = 0;
        for (String vname : this.mViasSink) {
            List geoms1 = this.mNet.getPinTemplate(vname).getPortTemplate(0).getShapesOnLayer(this.mLayer).stream().collect(Collectors.toList());
            AGeom g1 = (AGeom)geoms1.get(geoms1.size() - 1);
            sinks[i] = this.getGeomPoly(g1);
            ++i;
        }
        boolean bl = false;
        while (var17_20 < outline.length) {
            void v0 = var17_20++;
            outline[v0] = outline[v0] * this.mGeoUnit;
        }
        boolean bl2 = false;
        while (var17_22 < cutouts.length) {
            int n = 0;
            while (n < cutouts[var17_22].length) {
                double[] dArray = cutouts[var17_22];
                int n2 = n++;
                dArray[n2] = dArray[n2] * this.mGeoUnit;
            }
            ++var17_22;
        }
        boolean bl3 = false;
        while (var17_24 < sources.length) {
            int n = 0;
            while (n < sources[var17_24].length) {
                double[] dArray = sources[var17_24];
                int n3 = n++;
                dArray[n3] = dArray[n3] * this.mGeoUnit;
            }
            ++var17_24;
        }
        boolean bl4 = false;
        while (var17_26 < sinks.length) {
            int n = 0;
            while (n < sinks[var17_26].length) {
                double[] dArray = sinks[var17_26];
                int n4 = n++;
                dArray[n4] = dArray[n4] * this.mGeoUnit;
            }
            ++var17_26;
        }
        IRDropInput iRDropInput = new IRDropInput();
        iRDropInput.Nx = Nx;
        iRDropInput.Ny = Ny;
        iRDropInput.sig = 5.96E7;
        iRDropInput.Lz = (double)this.mLayer.getHeight() * this.mGeoUnit;
        System.out.println("thickness: " + Double.toString(this.mLayer.getHeight()));
        iRDropInput.outline = outline;
        iRDropInput.holes = cutouts;
        iRDropInput.sources = sources;
        iRDropInput.sinks = sinks;
        iRDropInput.sinkCurrents = this.mSinkCurrents;
        Gson gson = new Gson();
        String gson_str = gson.toJson((Object)iRDropInput);
        double[] irdrop = new double[]{};
        try {
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder(new URL(endpointUrl).toURI()).POST(HttpRequest.BodyPublishers.ofString(gson_str)).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            irdrop = (double[])gson.fromJson(response.body(), double[].class);
            for (int k2 = 0; k2 < this.mViasSink.size(); ++k2) {
                System.out.println(this.mViasSink.get(k2) + ": " + Double.toString(irdrop[k2]));
            }
            return irdrop;
        }
        catch (Exception exception) {
            return irdrop;
        }
    }
}

