/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit;

import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.ValueGraphBuilder;
import com.google.gson.Gson;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.Metal;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.db.std.Wire;
import com.sigrity.acl.geom.ACircle;
import com.sigrity.acl.geom.ACompositeGeom;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGeomWithCutouts;
import com.sigrity.acl.geom.AOutlineGeom;
import com.sigrity.acl.geom.APath;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.IRDropServerInput;
import com.sigrity.orbit.OrbitIO;
import java.awt.geom.AffineTransform;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.util.Pair;

public class IRDropMultLayer {
    private String mTopDevPathStr;
    private DevicePath mTopDevPath;
    private Device mDevTop;
    private Db mdb;
    private Net mNet;
    private double mVolt;
    private double mGeoUnit;
    private double mSigMLayer;
    private double mSigVia;
    private int mArcToPolyResolution = 12;
    private ArrayList<PinInstance> mSrcPins = new ArrayList();
    private ArrayList<PinInstance> mSinkPins = new ArrayList();
    private ArrayList<Double> mSinkCurrents = new ArrayList();

    public IRDropMultLayer(String topDevPath) {
        this.mdb = OrbitIO.getCurDb();
        this.mTopDevPathStr = topDevPath;
        this.mTopDevPath = DevicePath.fromString((Db)this.mdb, (String)this.mTopDevPathStr);
        this.mDevTop = Device.fromPath((Db)this.mdb, (String)topDevPath);
        this.mGeoUnit = 1.0E-12;
        this.mSigMLayer = 5.96E7;
        this.mSigVia = 5.96E7;
    }

    public APolygon getGeomPoly(AGeom g) {
        APolygon p = null;
        String type = g.getName();
        if (type.equals("circle")) {
            p = ((ACircle)g).toClosedPoly(this.mArcToPolyResolution);
        } else if (type.equals("outlinegeom")) {
            int oldRes = ((AOutlineGeom)g).setArcToPolyResultion(this.mArcToPolyResolution);
            p = ((AOutlineGeom)g).toPoly();
            ((AOutlineGeom)g).setArcToPolyResultion(oldRes);
        } else if (type.equals("rect")) {
            p = ((ARect)g).toPoly();
        } else if (type.contentEquals("path")) {
            p = ((APath)g).toPoly();
        } else if (type.equals("polygon")) {
            p = (APolygon)g;
        } else {
            System.out.println("warnning....AGeom type: " + type + " could not convert to poly");
        }
        return p;
    }

    public APolygon genMetalGeom(Metal metal, ArrayList<APolygon> cps) {
        APolygon op = null;
        cps.clear();
        AGeom gm = metal.getGeom();
        String type = gm.getName();
        if (type.equals("geomwithcutouts")) {
            AGeomWithCutouts gc = (AGeomWithCutouts)gm;
            AOutlineGeom outer = (AOutlineGeom)gc.getOuter();
            outer.setArcToPolyResultion(this.mArcToPolyResolution);
            op = outer.toPoly();
            ACompositeGeom cutouts = (ACompositeGeom)gc.getCutout();
            for (AGeom h : cutouts.getChildren()) {
                cps.add(this.getGeomPoly(h));
            }
        } else if (type.equals("outlinegeom")) {
            AOutlineGeom outer = (AOutlineGeom)gm;
            outer.setArcToPolyResultion(this.mArcToPolyResolution);
            op = outer.toPoly();
        } else {
            op = this.getGeomPoly(gm);
        }
        return op;
    }

    public long getMetalNumCutouts(Metal metal) {
        AGeom gm = metal.getGeom();
        String type = gm.getName();
        if (type.equals("geomwithcutouts")) {
            AGeomWithCutouts gc = (AGeomWithCutouts)gm;
            ACompositeGeom cutouts = (ACompositeGeom)gc.getCutout();
            return cutouts.getChildCount();
        }
        return 0L;
    }

    public void selectPowerNet(String netName, double volt) {
        this.mVolt = volt;
        this.mNet = null;
        for (Net n : this.mdb.getObjects(Net.class)) {
            if (!netName.contentEquals(n.getName())) continue;
            this.mNet = n;
        }
        if (this.mNet != null) {
            System.out.println("net found: " + this.mNet.getName());
        }
    }

    public void genPinShapeConnDueToWires(Map<String, HashSet<Integer>> pinLayers, Map<String, APolygon> pinGeoms, MutableValueGraph<String, Double> pinShapeConnGraph, Map<Metal, HashSet<String>> metalPinShapeMap) {
        for (Wire wire : this.mNet.getWires()) {
            HashSet<String> pinShapesOnMetal;
            APolygon pinPoly;
            List geoms1;
            AffineTransform T;
            double tz = (double)wire.getLayer().getHeight() * this.mGeoUnit;
            Layer layer = wire.getLayer();
            int layerOrder = layer.getOrder();
            long wire_l = wire.getLength();
            long wire_w = wire.getWidth();
            HierInst pa = wire.getPinA();
            HierInst pb = wire.getPinB();
            Object pia_name = "";
            Object pib_name = "";
            AGeom pia_geom = null;
            AGeom pib_geom = null;
            Metal metal_a = null;
            Metal metal_b = null;
            if (pa != null) {
                PinInstance pia = PinInstance.getPinInstance((HierInst)pa, (boolean)true);
                pia_name = IRDropMultLayer.genPinInstName(pia);
                T = pia.getDevice().getTransform().getTransform();
                geoms1 = pia.getPinTemplate().getPortTemplate(0).getShapesOnLayer(layer).stream().collect(Collectors.toList());
                pia_geom = ((AGeom)geoms1.get(geoms1.size() - 1)).transform(T);
            } else {
                APoint2D pt_a = wire.getPath().getFirstPoint();
                ARect pin_shape_a = ARect.create((long)(pt_a.getX() - wire_w / 2L), (long)(pt_a.getY() - wire_w / 2L), (long)(pt_a.getX() + wire_w / 2L), (long)(pt_a.getY() + wire_w / 2L));
                metal_a = this.findFirstOverlapMetal((AGeom)pin_shape_a, layer);
                if (metal_a != null) {
                    pia_name = "virtual_pin_" + wire.getName() + "_A";
                    pia_geom = pin_shape_a;
                }
            }
            if (pb != null) {
                PinInstance pib = PinInstance.getPinInstance((HierInst)pb, (boolean)true);
                pib_name = IRDropMultLayer.genPinInstName(pib);
                T = pib.getDevice().getTransform().getTransform();
                geoms1 = pib.getPinTemplate().getPortTemplate(0).getShapesOnLayer(layer).stream().collect(Collectors.toList());
                pib_geom = ((AGeom)geoms1.get(geoms1.size() - 1)).transform(T);
            } else {
                APoint2D pt_b = wire.getPath().getLastPoint();
                ARect pin_shape_b = ARect.create((long)(pt_b.getX() - wire_w / 2L), (long)(pt_b.getY() - wire_w / 2L), (long)(pt_b.getX() + wire_w / 2L), (long)(pt_b.getY() + wire_w / 2L));
                metal_b = this.findFirstOverlapMetal((AGeom)pin_shape_b, layer);
                if (metal_b != null) {
                    pib_name = "virtual_pin_" + wire.getName() + "_B";
                    pib_geom = pin_shape_b;
                }
            }
            if (((String)pia_name).isEmpty() || ((String)pib_name).isEmpty() || ((String)pia_name).equals(pib_name)) continue;
            if (!pinLayers.containsKey(pia_name)) {
                pinLayers.put((String)pia_name, new HashSet());
            }
            if (!pinLayers.containsKey(pib_name)) {
                pinLayers.put((String)pib_name, new HashSet());
            }
            pinLayers.get(pia_name).add(layerOrder);
            pinLayers.get(pib_name).add(layerOrder);
            if (!pinGeoms.containsKey(pia_name)) {
                pinPoly = this.getGeomPoly(pia_geom);
                if (pinPoly == null) {
                    System.out.println("the pin " + (String)pia_name + " has non supoorted geom type\n");
                    System.exit(1);
                }
                pinGeoms.put((String)pia_name, pinPoly);
            }
            if (!pinGeoms.containsKey(pib_name)) {
                pinPoly = this.getGeomPoly(pib_geom);
                if (pinPoly == null) {
                    System.out.println("the pin " + (String)pib_name + " has non supoorted geom type\n");
                    System.exit(1);
                }
                pinGeoms.put((String)pib_name, pinPoly);
            }
            String pia_shape_name = (String)pia_name + ":" + Integer.toString(layerOrder);
            String pib_shape_name = (String)pib_name + ":" + Integer.toString(layerOrder);
            pinShapeConnGraph.addNode((Object)pia_shape_name);
            pinShapeConnGraph.addNode((Object)pib_shape_name);
            double wire_y = (double)wire_w / (double)wire_l * tz * this.mSigMLayer;
            if (pinShapeConnGraph.hasEdgeConnecting((Object)pia_shape_name, (Object)pib_shape_name)) {
                Double value = (Double)pinShapeConnGraph.edgeValueOrDefault((Object)pia_shape_name, (Object)pib_shape_name, (Object)0.0);
                wire_y += value.doubleValue();
            }
            pinShapeConnGraph.putEdgeValue((Object)pia_shape_name, (Object)pib_shape_name, (Object)wire_y);
            if (metal_a != null) {
                if (!metalPinShapeMap.containsKey(metal_a)) {
                    metalPinShapeMap.put(metal_a, new HashSet());
                }
                pinShapesOnMetal = metalPinShapeMap.get(metal_a);
                pinShapesOnMetal.add(pia_shape_name);
                metalPinShapeMap.put(metal_a, pinShapesOnMetal);
            }
            if (metal_b == null) continue;
            if (!metalPinShapeMap.containsKey(metal_b)) {
                metalPinShapeMap.put(metal_b, new HashSet());
            }
            pinShapesOnMetal = metalPinShapeMap.get(metal_b);
            pinShapesOnMetal.add(pib_shape_name);
            metalPinShapeMap.put(metal_b, pinShapesOnMetal);
        }
    }

    public void genPinShapeConnDueToPinMetalOverlap(Map<String, HashSet<Integer>> pinLayers, Map<String, APolygon> pinGeoms, Map<Metal, HashSet<String>> metalPinShapeMap) {
        Set all_pins = this.mNet.getPinInstances(this.mDevTop).stream().collect(Collectors.toSet());
        all_pins.addAll(this.mSrcPins);
        all_pins.addAll(this.mSinkPins);
        for (Metal metal : this.mNet.getMetals()) {
            Layer layer = metal.getLayer();
            int layerOrder = layer.getOrder();
            AGeom metalGeom = metal.getGeom();
            if (metal.getBB().getArea() < 1.0E18) {
                System.out.println("warnning.......neglect metal that is just too small: " + metal.toString());
                continue;
            }
            if (!metalPinShapeMap.containsKey(metal)) {
                metalPinShapeMap.put(metal, new HashSet());
            }
            HashSet<String> pinShapesOnMetal = metalPinShapeMap.get(metal);
            for (PinInstance p : all_pins) {
                String pinName = IRDropMultLayer.genPinInstName(p);
                List geoms1 = p.getPinTemplate().getPortTemplate(0).getShapesOnLayer(layer).stream().collect(Collectors.toList());
                if (geoms1.isEmpty()) continue;
                AffineTransform T = p.getDevice().getTransform().getTransform();
                AGeom geom = ((AGeom)geoms1.get(geoms1.size() - 1)).transform(T);
                if (!metalGeom.intersects(geom)) continue;
                if (!pinLayers.containsKey(pinName)) {
                    pinLayers.put(pinName, new HashSet());
                }
                pinLayers.get(pinName).add(layerOrder);
                if (!pinGeoms.containsKey(pinName)) {
                    APolygon pinPoly = this.getGeomPoly(geom);
                    if (pinPoly == null) {
                        System.out.println("the pin " + pinName + " has non supoorted geom type\n");
                        System.exit(1);
                    }
                    pinGeoms.put(pinName, pinPoly);
                }
                String p_shape_name = pinName + ":" + Integer.toString(layerOrder);
                pinShapesOnMetal.add(p_shape_name);
            }
            metalPinShapeMap.put(metal, pinShapesOnMetal);
        }
    }

    public void genPinShapeConnDueToPin(Map<String, HashSet<Integer>> pinLayers, Map<String, APolygon> pinGeoms, MutableValueGraph<String, Double> pinShapeConnGraph) {
        Substrate subst = this.mDevTop.getSubstrate();
        List all_layers = subst.getLayers().stream().collect(Collectors.toList());
        double[] layerLocZ = new double[all_layers.size()];
        for (Layer layer : all_layers) {
            layerLocZ[layer.getOrder()] = (double)layer.getZLoc() * this.mGeoUnit;
        }
        for (Map.Entry entry : pinLayers.entrySet()) {
            System.out.println("------------------------------------------");
            String pinName = (String)entry.getKey();
            System.out.println(pinName);
            double pinArea = pinGeoms.get(pinName).getArea() * this.mGeoUnit * this.mGeoUnit;
            double via_y_fac = this.mSigVia * pinArea;
            Object[] layers = new Integer[((HashSet)entry.getValue()).size()];
            layers = ((HashSet)entry.getValue()).toArray(layers);
            Arrays.sort(layers);
            for (int i = 0; i < layers.length; ++i) {
                System.out.print(layers[i]);
                System.out.print(" ");
                if (i >= layers.length - 1) continue;
                String pinShapeName1 = pinName + ":" + Integer.toString((Integer)layers[i]);
                String pinShapeName2 = pinName + ":" + Integer.toString((Integer)layers[i + 1]);
                double via_y = via_y_fac / Math.abs(layerLocZ[(Integer)layers[i + 1]] - layerLocZ[(Integer)layers[i]]);
                pinShapeConnGraph.putEdgeValue((Object)pinShapeName1, (Object)pinShapeName2, (Object)via_y);
            }
            System.out.print("\n");
        }
    }

    public void genPinShapeConnStr(Map<String, HashSet<Integer>> pinLayers, Map<String, APolygon> pinGeoms, MutableValueGraph<String, Double> pinShapeConnGraph, Map<Metal, HashSet<String>> metalPinShapeMap) {
        pinLayers.clear();
        metalPinShapeMap.clear();
        pinGeoms.clear();
        for (Object wire : this.mNet.getWires()) {
            APolygon pinPoly;
            List geoms1;
            AffineTransform T;
            double tz = (double)wire.getLayer().getHeight() * this.mGeoUnit;
            Layer layer = wire.getLayer();
            int n = layer.getOrder();
            HierInst pa = wire.getPinA();
            HierInst pb = wire.getPinB();
            if (pa == null || pb == null || pa == pb) continue;
            PinInstance pia = PinInstance.getPinInstance((HierInst)pa, (boolean)true);
            PinInstance pib = PinInstance.getPinInstance((HierInst)pb, (boolean)true);
            String pia_name = IRDropMultLayer.genPinInstName(pia);
            String pib_name = IRDropMultLayer.genPinInstName(pib);
            if (!pinLayers.containsKey(pia_name)) {
                pinLayers.put(pia_name, new HashSet());
            }
            if (!pinLayers.containsKey(pib_name)) {
                pinLayers.put(pib_name, new HashSet());
            }
            pinLayers.get(pia_name).add(n);
            pinLayers.get(pib_name).add(n);
            if (!pinGeoms.containsKey(pia_name)) {
                T = pia.getDevice().getTransform().getTransform();
                geoms1 = pia.getPinTemplate().getPortTemplate(0).getShapesOnLayer(layer).stream().collect(Collectors.toList());
                if (!geoms1.isEmpty()) {
                    pinPoly = this.getGeomPoly(((AGeom)geoms1.get(geoms1.size() - 1)).transform(T));
                    if (pinPoly == null) {
                        System.out.println("the pin " + pia_name + " has non supoorted geom type\n");
                        System.exit(1);
                    }
                    pinGeoms.put(pia_name, pinPoly);
                }
            }
            if (!pinGeoms.containsKey(pib_name)) {
                T = pib.getDevice().getTransform().getTransform();
                geoms1 = pib.getPinTemplate().getPortTemplate(0).getShapesOnLayer(layer).stream().collect(Collectors.toList());
                if (!geoms1.isEmpty()) {
                    pinPoly = this.getGeomPoly(((AGeom)geoms1.get(geoms1.size() - 1)).transform(T));
                    if (pinPoly == null) {
                        System.out.println("the pin " + pia_name + " has non supoorted geom type\n");
                        System.exit(1);
                    }
                    pinGeoms.put(pib_name, pinPoly);
                }
            }
            String pia_shape_name = IRDropMultLayer.genPinShapeName(pia, n);
            String pib_shape_name = IRDropMultLayer.genPinShapeName(pib, n);
            long wire_l = wire.getLength();
            long wire_w = wire.getWidth();
            pinShapeConnGraph.addNode((Object)pia_shape_name);
            pinShapeConnGraph.addNode((Object)pib_shape_name);
            double wire_y = (double)wire_w / (double)wire_l * tz * this.mSigMLayer;
            if (pinShapeConnGraph.hasEdgeConnecting((Object)pia_shape_name, (Object)pib_shape_name)) {
                Double value = (Double)pinShapeConnGraph.edgeValueOrDefault((Object)pia_shape_name, (Object)pib_shape_name, (Object)0.0);
                wire_y += value.doubleValue();
            }
            pinShapeConnGraph.putEdgeValue((Object)pia_shape_name, (Object)pib_shape_name, (Object)wire_y);
        }
        Set all_pins = this.mNet.getPinInstances(this.mDevTop).stream().collect(Collectors.toSet());
        all_pins.addAll(this.mSrcPins);
        all_pins.addAll(this.mSinkPins);
        for (Metal metal : this.mNet.getMetals()) {
            Layer layer = metal.getLayer();
            int layerOrder = layer.getOrder();
            AGeom aGeom = metal.getGeom();
            if (metal.getBB().getArea() < 1.0E18) continue;
            HashSet<CallSite> pinShapesOnMetal = new HashSet<CallSite>();
            for (PinInstance p : all_pins) {
                String pinName = IRDropMultLayer.genPinInstName(p);
                List geoms1 = p.getPinTemplate().getPortTemplate(0).getShapesOnLayer(layer).stream().collect(Collectors.toList());
                if (geoms1.isEmpty()) continue;
                AffineTransform T = p.getDevice().getTransform().getTransform();
                AGeom geom = ((AGeom)geoms1.get(geoms1.size() - 1)).transform(T);
                if (!aGeom.intersects(geom)) continue;
                if (!pinLayers.containsKey(pinName)) {
                    pinLayers.put(pinName, new HashSet());
                }
                pinLayers.get(pinName).add(layerOrder);
                if (!pinGeoms.containsKey(pinName)) {
                    APolygon pinPoly = this.getGeomPoly(geom);
                    if (pinPoly == null) {
                        System.out.println("the pin " + pinName + " has non supoorted geom type\n");
                        System.exit(1);
                    }
                    pinGeoms.put(pinName, pinPoly);
                }
                String p_shape_name = pinName + ":" + Integer.toString(layerOrder);
                pinShapesOnMetal.add((CallSite)((Object)p_shape_name));
            }
            metalPinShapeMap.put(metal, pinShapesOnMetal);
        }
        Substrate subst = this.mDevTop.getSubstrate();
        List all_layers = subst.getLayers().stream().collect(Collectors.toList());
        double[] layerLocZ = new double[all_layers.size()];
        for (Layer layer : all_layers) {
            layerLocZ[layer.getOrder()] = (double)layer.getZLoc() * this.mGeoUnit;
        }
        for (Map.Entry entry : pinLayers.entrySet()) {
            System.out.println("------------------------------------------");
            String pinName = (String)entry.getKey();
            System.out.println(pinName);
            double pinArea = pinGeoms.get(pinName).getArea() * this.mGeoUnit * this.mGeoUnit;
            double via_y_fac = this.mSigVia * pinArea;
            Object[] layers = new Integer[((HashSet)entry.getValue()).size()];
            layers = ((HashSet)entry.getValue()).toArray(layers);
            Arrays.sort(layers);
            for (int i = 0; i < layers.length; ++i) {
                System.out.print(layers[i]);
                System.out.print(" ");
                if (i >= layers.length - 1) continue;
                String pinShapeName1 = pinName + ":" + Integer.toString((Integer)layers[i]);
                String pinShapeName2 = pinName + ":" + Integer.toString((Integer)layers[i + 1]);
                double via_y = via_y_fac / Math.abs(layerLocZ[(Integer)layers[i + 1]] - layerLocZ[(Integer)layers[i]]);
                pinShapeConnGraph.putEdgeValue((Object)pinShapeName1, (Object)pinShapeName2, (Object)via_y);
            }
            System.out.print("\n");
        }
    }

    public Metal findFirstOverlapMetal(AGeom geom, Layer layer) {
        for (Metal metal : this.mNet.getMetals()) {
            if (metal.getLayer() != layer || !metal.getGeom().intersects(geom)) continue;
            return metal;
        }
        return null;
    }

    public void genPinShapeConn(Map<String, HashSet<Integer>> pinLayers, Map<String, APolygon> pinGeoms, MutableValueGraph<String, Double> pinShapeConnGraph, Map<Metal, HashSet<String>> metalPinShapeMap) {
        pinLayers.clear();
        metalPinShapeMap.clear();
        pinGeoms.clear();
        System.out.println("------generating pin shape connectivity due to wires--------");
        this.genPinShapeConnDueToWires(pinLayers, pinGeoms, pinShapeConnGraph, metalPinShapeMap);
        System.out.println("------generating pin shape connectivity due to pin metal overlap--------");
        this.genPinShapeConnDueToPinMetalOverlap(pinLayers, pinGeoms, metalPinShapeMap);
        System.out.println("------generating pin shape connectivity due to pin itself--------");
        this.genPinShapeConnDueToPin(pinLayers, pinGeoms, pinShapeConnGraph);
    }

    public void setSrcPins(Map<String, List<String>> srcPins) {
        this.mSrcPins.clear();
        for (Map.Entry<String, List<String>> me : srcPins.entrySet()) {
            String devname = me.getKey();
            Device dev = Device.fromPath((Db)this.mdb, (String)(this.mTopDevPath + "/" + devname));
            for (String pinName : me.getValue()) {
                this.mSrcPins.add(dev.getPinByName(pinName));
            }
        }
    }

    public void setSinkPinsCurrents(Map<String, List<Pair<String, Double>>> sinkPinsCurrents) {
        this.mSinkPins.clear();
        this.mSinkCurrents.clear();
        for (Map.Entry<String, List<Pair<String, Double>>> me : sinkPinsCurrents.entrySet()) {
            String devname = me.getKey();
            Device dev = Device.fromPath((Db)this.mdb, (String)(this.mTopDevPath + "/" + devname));
            for (Pair<String, Double> pinNameCurrent : me.getValue()) {
                this.mSinkPins.add(dev.getPinByName((String)pinNameCurrent.getKey()));
                this.mSinkCurrents.add((Double)pinNameCurrent.getValue());
            }
        }
    }

    public static String genPinShapeName(PinInstance p, int layerOrder) {
        String layerName = Integer.toString(layerOrder);
        return IRDropMultLayer.genPinInstName(p) + ":" + layerName;
    }

    public static String genPinInstName(PinInstance p) {
        String dev_name = p.getDevice().getName();
        String pinTemplate_name = p.getName();
        return dev_name + ":" + pinTemplate_name;
    }

    public Map<String, Double> solve(String endpointUrl, int Nx, int Ny) {
        PinInstance p;
        int k;
        long start = System.currentTimeMillis();
        HashMap<String, HashSet<Integer>> pinLayers = new HashMap<String, HashSet<Integer>>();
        HashMap<String, APolygon> pinGeoms = new HashMap<String, APolygon>();
        MutableValueGraph pinShapeConnGraph = ValueGraphBuilder.undirected().build();
        HashMap<Metal, HashSet<String>> metalPinShapeMap = new HashMap<Metal, HashSet<String>>();
        System.out.println("========  generating pin, shape, connectivity ===============");
        this.genPinShapeConn(pinLayers, pinGeoms, (MutableValueGraph<String, Double>)pinShapeConnGraph, metalPinShapeMap);
        int pinShapesNum = 0;
        for (Map.Entry me : pinLayers.entrySet()) {
            pinShapesNum += ((HashSet)me.getValue()).size();
        }
        String[] pinShapeNames = new String[pinShapesNum];
        double[][] pinShapes = new double[pinShapesNum][];
        HashMap<CallSite, Integer> pinShapeNameIdMap = new HashMap<CallSite, Integer>();
        int indx = 0;
        for (Map.Entry me : pinLayers.entrySet()) {
            String pinName = (String)me.getKey();
            APolygon aPolygon = (APolygon)pinGeoms.get(pinName);
            Object[] layers = new Integer[((HashSet)me.getValue()).size()];
            layers = ((HashSet)me.getValue()).toArray(layers);
            Arrays.sort(layers);
            for (int i = 0; i < layers.length; ++i) {
                String pinShapeName = (String)pinName + ":" + Integer.toString((Integer)layers[i]);
                pinShapeNameIdMap.put((CallSite)((Object)pinShapeName), indx);
                pinShapeNames[indx] = pinShapeName;
                pinShapes[indx] = aPolygon.getPointsFloat();
                ++indx;
            }
        }
        int metalsNum = 0;
        int totCutoutsNum = 0;
        for (Map.Entry entry : metalPinShapeMap.entrySet()) {
            Metal metal = (Metal)entry.getKey();
            ++metalsNum;
            totCutoutsNum = (int)((long)totCutoutsNum + this.getMetalNumCutouts(metal));
        }
        double[][] metals = new double[metalsNum][];
        int[] nArray = new int[metalsNum];
        int[] metalLayers = new int[metalsNum];
        int[][] metalPinShapes = new int[metalsNum][];
        double[][] metalCutouts = new double[totCutoutsNum][];
        int indx_metal = 0;
        int indx_cutout = 0;
        for (Map.Entry me : metalPinShapeMap.entrySet()) {
            Metal metal = (Metal)me.getKey();
            metalPinShapes[indx_metal] = new int[((HashSet)me.getValue()).size()];
            int indx_p = 0;
            for (String pinShapeName : (HashSet)me.getValue()) {
                int pinShapeId;
                metalPinShapes[indx_metal][indx_p] = pinShapeId = ((Integer)pinShapeNameIdMap.get(pinShapeName)).intValue();
                ++indx_p;
            }
            metalLayers[indx_metal] = metal.getLayer().getOrder();
            ArrayList<APolygon> cutoutsPolys = new ArrayList<APolygon>();
            APolygon outerPoly = this.genMetalGeom(metal, cutoutsPolys);
            metals[indx_metal] = outerPoly.getPointsFloat();
            nArray[indx_metal] = cutoutsPolys.size();
            for (APolygon h : cutoutsPolys) {
                metalCutouts[indx_cutout] = h.getPointsFloat();
                ++indx_cutout;
            }
            ++indx_metal;
        }
        Substrate subst = this.mDevTop.getSubstrate();
        List all_layers = subst.getLayers().stream().collect(Collectors.toList());
        double[] layerSigLz = new double[all_layers.size()];
        for (Layer layer : all_layers) {
            double Lz = (double)layer.getHeight() * this.mGeoUnit;
            layerSigLz[layer.getOrder()] = Lz * this.mSigMLayer;
        }
        int[] srcPinShapeIndx = new int[this.mSrcPins.size()];
        int[] sinkPinShapeIndx = new int[this.mSinkPins.size()];
        double[] sinkPinShapeCurrent = new double[this.mSinkCurrents.size()];
        for (k = 0; k < this.mSrcPins.size(); ++k) {
            p = this.mSrcPins.get(k);
            boolean isFound = false;
            for (int i = 0; i < all_layers.size(); ++i) {
                String pinShapeName = IRDropMultLayer.genPinShapeName(p, i);
                if (!pinShapeNameIdMap.containsKey(pinShapeName)) continue;
                srcPinShapeIndx[k] = (Integer)pinShapeNameIdMap.get(pinShapeName);
                isFound = true;
                break;
            }
            if (isFound) continue;
            srcPinShapeIndx[k] = -1;
            System.out.println("warning.....src pin " + p.toString() + " not found in net " + this.mNet.getName());
        }
        for (k = 0; k < this.mSinkPins.size(); ++k) {
            p = this.mSinkPins.get(k);
            double pinCurrent = this.mSinkCurrents.get(k);
            boolean isFound = false;
            for (int i = 0; i < all_layers.size(); ++i) {
                String pinShapeName = IRDropMultLayer.genPinShapeName(p, i);
                if (!pinShapeNameIdMap.containsKey(pinShapeName)) continue;
                sinkPinShapeIndx[k] = (Integer)pinShapeNameIdMap.get(pinShapeName);
                sinkPinShapeCurrent[k] = pinCurrent;
                isFound = true;
                break;
            }
            if (isFound) continue;
            sinkPinShapeIndx[k] = -1;
            sinkPinShapeCurrent[k] = 0.0;
            System.out.println("warning.....sink pin " + p.toString() + " not found in net " + this.mNet.getName());
        }
        int numEdges = pinShapeConnGraph.edges().size();
        int[] pinShapeConnRowId = new int[numEdges];
        int[] pinShapeConnColId = new int[numEdges];
        double[] pinShapeConnVal = new double[numEdges];
        int indx_edge = 0;
        Set all_nodes = pinShapeConnGraph.nodes();
        for (String node : all_nodes) {
            for (String nbr_node : pinShapeConnGraph.adjacentNodes((Object)node)) {
                int id2;
                int id1 = (Integer)pinShapeNameIdMap.get(node);
                if (id1 > (id2 = ((Integer)pinShapeNameIdMap.get(nbr_node)).intValue())) continue;
                pinShapeConnRowId[indx_edge] = id1;
                pinShapeConnColId[indx_edge] = id2;
                pinShapeConnVal[indx_edge] = (Double)pinShapeConnGraph.edgeValueOrDefault((Object)node, (Object)nbr_node, (Object)0.0);
                ++indx_edge;
            }
        }
        IRDropMultLayer.scaleArrayArrayValues(metalCutouts, this.mGeoUnit);
        IRDropMultLayer.scaleArrayArrayValues(metals, this.mGeoUnit);
        IRDropMultLayer.scaleArrayArrayValues(pinShapes, this.mGeoUnit);
        IRDropServerInput obj = new IRDropServerInput();
        obj.Nx = Nx;
        obj.Ny = Ny;
        obj.layerSigLz = layerSigLz;
        obj.pinShapes = pinShapes;
        obj.metalCutouts = metalCutouts;
        obj.metalLayers = metalLayers;
        obj.metalNumCutouts = nArray;
        obj.metalPinShapes = metalPinShapes;
        obj.metals = metals;
        obj.srcPinShapeIndx = srcPinShapeIndx;
        obj.sinkPinShapeIndx = sinkPinShapeIndx;
        obj.sinkPinShapeCurrent = sinkPinShapeCurrent;
        obj.pinShapeConnRowId = pinShapeConnRowId;
        obj.pinShapeConnColId = pinShapeConnColId;
        obj.pinShapeConnVal = pinShapeConnVal;
        obj.pinShapeNames = pinShapeNames;
        HashMap<String, Double> irdrop_results = new HashMap<String, Double>();
        Gson gson = new Gson();
        String gson_str = gson.toJson((Object)obj);
        long end = System.currentTimeMillis();
        float sec = (float)(end - start) / 1000.0f;
        System.out.println("time to prepare json obj for server : " + sec + " seconds");
        double[] irdrop = new double[]{};
        try {
            System.out.println("sending request to server....\n");
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder(new URL(endpointUrl).toURI()).POST(HttpRequest.BodyPublishers.ofString(gson_str)).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            irdrop = (double[])gson.fromJson(response.body(), double[].class);
            String file_content = "Device : " + this.mTopDevPathStr + "\n";
            file_content = file_content + "Net : " + this.mNet.getName() + "\n";
            file_content = file_content + "V: " + Double.toString(this.mVolt) + "\n";
            for (int k2 = 0; k2 < sinkPinShapeIndx.length; ++k2) {
                if (sinkPinShapeIndx[k2] < 0) continue;
                String pinName = pinShapeNames[sinkPinShapeIndx[k2]];
                String Vdrop_mv = String.format("%.3f", irdrop[k2] * 1000.0) + "mV";
                String Vdrop_p = String.format("%.4f", irdrop[k2] / this.mVolt * 100.0) + "%";
                System.out.println(pinName + " :  " + Vdrop_mv + " " + Vdrop_p);
                file_content = file_content + pinName + ": " + Vdrop_mv + " " + Vdrop_p + "\n";
                irdrop_results.put(pinName, irdrop[k2]);
            }
            try {
                String file_path = (String)Settings.get((String)"IRDropServer", (String)"ResultFile", (Object)"IRDropResult.txt");
                BufferedWriter writer = new BufferedWriter(new FileWriter(file_path));
                writer.write(file_content);
                writer.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            return irdrop_results;
        }
        catch (Exception e) {
            System.out.println("exception of response from server\n");
            return irdrop_results;
        }
    }

    public static void scaleArrayValues(double[] array, double unit) {
        int i = 0;
        while (i < array.length) {
            int n = i++;
            array[n] = array[n] * unit;
        }
    }

    public static void scaleArrayArrayValues(double[][] array, double unit) {
        for (int i = 0; i < array.length; ++i) {
            int j = 0;
            while (j < array[i].length) {
                double[] dArray = array[i];
                int n = j++;
                dArray[n] = dArray[n] * unit;
            }
        }
    }
}

