/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit;

import bsh.EvalError;
import bsh.Interpreter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Floorplan;
import com.sigrity.acl.db.std.FloorplanPin;
import com.sigrity.acl.db.std.Interface;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PersonalityMap;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.StoredPath;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.APolygon;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPin;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.OrbitIOSettings;
import com.sigrity.orbit.automation.BundleMover;
import com.sigrity.orbit.cmd.NetCmd;
import com.sigrity.orbit.ui.PersonalityUI;
import java.awt.EventQueue;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class InterfaceCmds {
    private static List<NetMap> changedNetMaps = null;
    protected static DbClass.DbObjectListener mNetMapListener = new DbClass.DbObjectAdapter(){

        public void addedObject(DbClass.ObjectAdd add) {
            if (add.getDb().isRecordingHistory()) {
                if (changedNetMaps == null) {
                    changedNetMaps = new LinkedList<NetMap>();
                }
                if (add.getDbObject() instanceof NetMap) {
                    changedNetMaps.add((NetMap)add.getDbObject());
                }
                InterfaceCmds.scheduleUpdateForChangedMapping();
            }
        }
    };
    protected static boolean updateForChangedMapping = false;

    private InterfaceCmds() {
    }

    public static void assignExistingPinsToFloorplanForAllDecendents(Interface intf) {
        InterfaceCmds.assignExistingPinsToFloorplanForAllDecendents(intf, false);
    }

    public static void assignExistingPinsToFloorplanForAllDecendents(Interface intf, boolean includeIOPads) {
        InterfaceCmds.assignExistingPinsToFloorplan(intf, includeIOPads);
        for (Interface cur : intf.getChildren()) {
            InterfaceCmds.assignExistingPinsToFloorplanForAllDecendents(cur);
        }
    }

    public static void assignExistingPinsToFloorplan(Interface intf) {
        InterfaceCmds.assignExistingPinsToFloorplan(intf, false);
    }

    public static void assignExistingPinsToFloorplan(Interface intf, boolean includeIOPads) {
        InterfaceCmds.assignExistingPinsToFloorplan(intf, includeIOPads, false);
    }

    public static void assignExistingPinsToFloorplan(Db db, String intfKeyStr, boolean includeIOPads, boolean updatePersonalityList) {
        Interface intf = (Interface)db.getByKeyStr(Interface.class, intfKeyStr);
        if (intf != null) {
            InterfaceCmds.assignExistingPinsToFloorplan(intf, includeIOPads, updatePersonalityList);
        }
    }

    public static void assignExistingPinsToFloorplan(Interface intf, boolean includeIOPads, boolean updatePersonalityList) {
        for (Net net : intf.getNets(false)) {
            Selection s = new Selection(intf.getDb());
            NetCmd.selectNetPins((Net)net, (boolean)true, (Selection)s, (DeviceTemplate)net.getDeviceTemplate());
            for (Floorplan floorplan : intf.getFloorplans()) {
                for (PinInstance pinInstance : s.get(PinInstance.class)) {
                    if (!includeIOPads && (pinInstance.getType() == PinTemplate.Type.IOPAD || pinInstance.getType() == PinTemplate.Type.UNKNOWN) || pinInstance.getType() == PinTemplate.Type.WIREEND || pinInstance.getType() == PinTemplate.Type.VIA || pinInstance.getType() == PinTemplate.Type.TOPOLOGYPOINT || pinInstance.getType() == PinTemplate.Type.CONTACT) continue;
                    for (DevicePath path : s.getSelectedPaths((DbObject)pinInstance)) {
                        FloorplanPin existingPin;
                        if (!floorplan.canBeIn(path) || (existingPin = FloorplanPin.find((PinTemplate)pinInstance.getPinTemplate(), (DevicePath)path)) != null && (intf.getParent() == null || !existingPin.getOwner().getMyInterface().isInAncestorOf(intf))) continue;
                        floorplan.getMyInterface().addPinToFloorplan(floorplan, path, pinInstance, null);
                        if (!updatePersonalityList) continue;
                        InterfaceCmds.addPersonalityFromPinInstanceIfNecessary(pinInstance, floorplan);
                    }
                }
            }
        }
    }

    public static void addPersonalityFromPinInstanceIfNecessary(PinInstance pinInstance, Floorplan floorplan) {
        boolean found = false;
        for (PersonalityMap pm : pinInstance.getPersonalityMaps()) {
            if (pm.getPersonality() == null) continue;
            found = true;
            if (PersonalityMap.getPersonalities((Personality.Type)Personality.Type.PORT, (DbObject)floorplan).filter(curpm -> curpm.getPersonality() == pm.getPersonality()).count() >= 1L) continue;
            ALog.logInfo((String)("Adding personality '" + pm.getPersonality().getName() + "' to floorplan '" + floorplan.getName() + "'s personality list for interface '" + floorplan.getMyInterface().getName()));
            PersonalityUI.addFloorplanToPersonality((DbObject)floorplan, pm.getPersonality(), false);
        }
        if (!found && !floorplan.getIncludeNoneInIOPersonalityList()) {
            ALog.logInfo((String)("Added <NONE> to floorplan '" + floorplan.getName() + "'s personality list for interface '" + floorplan.getMyInterface().getName()));
            Floorplan.setIncludeNoneInIOPersonalityList((Db)floorplan.getDb(), (String)floorplan.getKeyStr(), (boolean)true, (boolean)false);
        }
    }

    public static void selectFloorplanPins(Selection s, Floorplan floorplan) {
        InterfaceCmds.selectFloorplanPins(s, floorplan, null);
    }

    public static void selectFloorplanPins(Selection s, Floorplan floorplan, DevicePath limitPath) {
        for (FloorplanPin fpPin : floorplan.getAllDescendantPins()) {
            DevicePath devPath = fpPin.getDevicePath();
            for (HierPin hierPin : fpPin.getPinTemplate().getHierarchicalInstances()) {
                if (!devPath.isEndOf((DevicePath)hierPin.first) || limitPath != null && !limitPath.isStartOf((DevicePath)hierPin.first)) continue;
                s.add((DevicePath)hierPin.first, (DbObject)hierPin.second);
            }
        }
    }

    public static void selectFloorplanIOPins(Selection s, Floorplan floorplan) {
        InterfaceCmds.selectFloorplanIOPins(s, floorplan, null);
    }

    public static void selectFloorplanIOPins(Selection s, Floorplan floorplan, DevicePath limitPath) {
        for (FloorplanPin fpPin : floorplan.getIOs()) {
            DevicePath devPath = fpPin.getDevicePath();
            for (HierPin hierPin : fpPin.getPinTemplate().getHierarchicalInstances()) {
                if (!devPath.isEndOf((DevicePath)hierPin.first) || limitPath != null && !limitPath.isStartOf((DevicePath)hierPin.first)) continue;
                s.add((DevicePath)hierPin.first, (DbObject)hierPin.second);
            }
        }
    }

    public static void associateSelectedPinsWithFloorplan(Db db, String interfaceStr, String floorplanStr, boolean removeMode) {
        Interface intf = Interface.find((Db)db, (String)interfaceStr);
        Floorplan fp = (Floorplan)db.getByKeyStr(Floorplan.class, floorplanStr);
        InterfaceCmds.associateSelectedPinsWithFloorplan(intf, fp, removeMode);
    }

    public static void associateSelectedPinsWithFloorplan(Interface intf, Floorplan floorplan, boolean removeMode) {
        Selection constrainingSelection = null;
        Selection s = OrbitIO.getCurDesign().getCurSelection();
        Selection resultSelection = new Selection(s.getDb());
        resultSelection.clearData(false);
        resultSelection.add(s);
        if (removeMode) {
            constrainingSelection = new Selection(s.getDb());
            if (floorplan != null) {
                InterfaceCmds.selectFloorplanPins(constrainingSelection, floorplan);
            } else {
                for (Floorplan curFloorplan : intf.getFloorplans()) {
                    InterfaceCmds.selectFloorplanPins(constrainingSelection, curFloorplan);
                }
            }
        }
        if (constrainingSelection != null) {
            resultSelection.intersect(constrainingSelection);
        }
        BundleMover bundleMover = new BundleMover();
        bundleMover.startBundleMove();
        for (PinInstance pinInstance : resultSelection.get(PinInstance.class)) {
            if (!removeMode && (pinInstance.getType() == PinTemplate.Type.WIREEND || pinInstance.getType() == PinTemplate.Type.UNKNOWN || pinInstance.getType() == PinTemplate.Type.IOPAD || pinInstance.getType() == PinTemplate.Type.VIA || pinInstance.getType() == PinTemplate.Type.TOPOLOGYPOINT)) continue;
            Objects.requireNonNull(floorplan);
            for (DevicePath path : resultSelection.getSelectedPaths((DbObject)pinInstance)) {
                FloorplanPin curPin;
                if (!floorplan.canBeIn(path) || !removeMode && (curPin = FloorplanPin.find((PinTemplate)pinInstance.getPinTemplate(), (DevicePath)path)) != null && curPin.getOwner() == floorplan) continue;
                if (removeMode) {
                    bundleMover.removePinFromBundle(path, pinInstance);
                    floorplan.getMyInterface().removePinFromFloorplan(floorplan, path, pinInstance);
                    continue;
                }
                FloorplanPin curPinAssignment = FloorplanPin.find((PinTemplate)pinInstance.getPinTemplate(), (DevicePath)path);
                if (curPinAssignment != null && curPinAssignment.getRootFloorplan() != floorplan.getRootFloorplan()) {
                    bundleMover.removePinFromBundle(path, pinInstance);
                }
                bundleMover.addPinToBundle(path, pinInstance, floorplan);
                floorplan.getMyInterface().addPinToFloorplan(floorplan, path, pinInstance);
            }
        }
        bundleMover.endBundleMove();
    }

    public static AGeom geomFromStr(String geomStr) {
        AGeom worldGeom = null;
        Interpreter interpreter = Cp.getCp().createChildInterpreter();
        try {
            interpreter.eval("import com.sigrity.acl.geom.*;");
            Object o = interpreter.eval(geomStr);
            if (o instanceof AGeom) {
                worldGeom = (AGeom)o;
            }
        }
        catch (EvalError e) {
            ALog.logError((Throwable)e);
        }
        return worldGeom;
    }

    public static String associatePinsWithFloorplan(Db db, String interfaceStr, String floorplanStr, String geomStr, String areaMode, boolean removeMode, boolean outlineOnlyMode, String limitSubstrateStr, boolean useIOPads) {
        Interface intf = Interface.find((Db)db, (String)interfaceStr);
        Floorplan fp = (Floorplan)db.getByKeyStr(Floorplan.class, floorplanStr);
        AGeom worldGeom = InterfaceCmds.geomFromStr(geomStr);
        return InterfaceCmds.associatePinsWithFloorplan(intf, fp, worldGeom, areaMode, removeMode, outlineOnlyMode, limitSubstrateStr, useIOPads);
    }

    public static String associatePinsWithFloorplan(Db db, String interfaceStr, String floorplanStr, String geomStr, String areaMode, boolean removeMode, boolean outlineOnlyMode, String limitSubstrateStr) {
        Interface intf = Interface.find((Db)db, (String)interfaceStr);
        Floorplan fp = (Floorplan)db.getByKeyStr(Floorplan.class, floorplanStr);
        AGeom worldGeom = InterfaceCmds.geomFromStr(geomStr);
        return InterfaceCmds.associatePinsWithFloorplan(intf, fp, worldGeom, areaMode, removeMode, outlineOnlyMode, limitSubstrateStr);
    }

    public static String associatePinsWithFloorplan(Interface intf, Floorplan floorplan, AGeom worldGeom, String areaMode, boolean removeMode, boolean outlineOnlyMode, String limitSubstrateStr) {
        return InterfaceCmds.associatePinsWithFloorplan(intf, floorplan, worldGeom, areaMode, removeMode, outlineOnlyMode, limitSubstrateStr, false);
    }

    public static String associatePinsWithFloorplan(Interface intf, Floorplan floorplan, AGeom worldGeom, String areaMode, boolean removeMode, boolean outlineOnlyMode, String limitSubstrateStr, boolean useIOPads) {
        if (worldGeom == null) {
            return null;
        }
        Selection sel = OrbitIO.getCurDesign().getCurSelection();
        Selection originalSelection = new Selection(sel.getDb());
        originalSelection.clearData(false);
        originalSelection.add(sel);
        Selection.clearAllCriteria();
        if (removeMode) {
            if (floorplan != null) {
                InterfaceCmds.selectFloorplanPins(sel, floorplan);
            } else {
                for (Floorplan curFloorplan : intf.getFloorplans()) {
                    InterfaceCmds.selectFloorplanPins(sel, curFloorplan);
                }
            }
            Selection.getSelectionCriteria().setMode("Intersect");
        } else {
            Selection.getSelectionCriteria().setMode("Replace");
        }
        Selection.getSelectionCriteria().setPointSelectsSingleItem(false);
        if (limitSubstrateStr != null) {
            Selection.getSelectionCriteria().setLimitToSubstrate(limitSubstrateStr);
        }
        if (outlineOnlyMode) {
            Selection.getSelectionCriteria().setAreaMode(Selection.AreaMode.Touch.toString());
        } else {
            Selection.getSelectionCriteria().setAreaMode(areaMode);
        }
        Selection.getSelectionCriteria().setReferenceClass(PinInstance.class.getName());
        ARect worldRect = null;
        APolygon worldPoly = null;
        if (worldGeom instanceof ARect) {
            worldRect = (ARect)worldGeom;
        } else {
            worldPoly = (APolygon)worldGeom;
        }
        if (worldRect != null) {
            Selection.getSelectionCriteria().setSelArea((AGeom)worldRect);
        } else {
            Selection.getSelectionCriteria().setSelArea((AGeom)worldPoly);
        }
        Selection.select();
        int count = 0;
        int numAlreadyAssigned = 0;
        HashSet ignorePinTypes = AUtil.hashSet((Object[])((PinTemplate.Type[])Settings.get((String)"UserPreferences", (String)"DefaultSelectIgnorePinTypes", (Object)OrbitIOSettings.DEFAULT_SELECT_IGNORE_PIN_TYPES_DEFAULT)));
        BundleMover bundleMover = new BundleMover();
        for (PinInstance pinInstance : sel.get(PinInstance.class)) {
            if (!removeMode && (pinInstance.getType() == PinTemplate.Type.WIREEND || !useIOPads && pinInstance.getType() == PinTemplate.Type.IOPAD || pinInstance.getType() == PinTemplate.Type.UNKNOWN || pinInstance.getType() == PinTemplate.Type.VIA || pinInstance.getType() == PinTemplate.Type.TOPOLOGYPOINT || ignorePinTypes.contains(pinInstance.getType()))) continue;
            for (DevicePath path : sel.getSelectedPaths((DbObject)pinInstance)) {
                Interface curInterface;
                FloorplanPin curPinAssignment = FloorplanPin.find((PinTemplate)pinInstance.getPinTemplate(), (DevicePath)path);
                Interface interface_ = curInterface = curPinAssignment == null ? null : curPinAssignment.getOwner().getMyInterface();
                if (!removeMode && curInterface == intf) continue;
                if (curInterface != null) {
                    curInterface = intf.hasAncestor(curInterface);
                }
                if (!removeMode && curPinAssignment != null && curInterface == null) {
                    ++numAlreadyAssigned;
                    continue;
                }
                ++count;
                if (removeMode) {
                    bundleMover.removePinFromBundle(path, pinInstance);
                    floorplan.getMyInterface().removePinFromFloorplan(floorplan, path, pinInstance);
                    continue;
                }
                bundleMover.addPinToBundle(path, pinInstance, floorplan);
                floorplan.getMyInterface().addPinToFloorplan(floorplan, path, pinInstance);
            }
        }
        if (!removeMode) {
            floorplan.getMyInterface().autoAssignNetsToPins();
        }
        bundleMover.endBundleMove();
        Object msg = null;
        if (numAlreadyAssigned == 1) {
            msg = "One pin is aleady assigned to a floorplan. Cannot re-assign it until it is removed from its current floorplan.";
        } else if (numAlreadyAssigned > 0) {
            msg = numAlreadyAssigned + " pin(s) are aleady assigned to a floorplan. Cannot re-assign them until they are removed from their current floorplan.";
        }
        if (count == 0 && removeMode) {
            msg = "No pins found " + (areaMode.equals(Selection.AreaMode.Touch.toString()) ? "touching" : "inside") + " this " + (floorplan == null ? "Interface" : "Floorplan");
        } else if (count == 0 && limitSubstrateStr != null) {
            msg = "No pins found on substrate '" + limitSubstrateStr + "' " + (areaMode.equals(Selection.AreaMode.Touch.toString()) ? "touching" : "inside") + " this area.";
        }
        OrbitIO.getCurDesign().setCurSelection(originalSelection);
        return msg;
    }

    public static void checkKeyNets(Db db) {
        int count = 0;
        HashMap<Net, Interface> allIntfNets = new HashMap<Net, Interface>();
        HashMap<Net, Interface> allTopmostNets = new HashMap<Net, Interface>();
        for (Interface intf : db.getObjects(Interface.class)) {
            if (intf.getParent() != null) continue;
            List nets = intf.getNets(true);
            for (Net net : nets) {
                Interface cur;
                Net topNet;
                Interface other = (Interface)allIntfNets.get(net);
                if (other != null) {
                    ++count;
                    ALog.logInfo((String)("Conflict found for net '" + net.getName() + "' interfaces '" + other.getName() + "' and '" + intf.getName() + "'"));
                    for (DevicePath path : intf.getNetsReferencedWRT().getHierarchicalInstances()) {
                        topNet = NetMap.getTopmostNet((Net)net, (DevicePath)path);
                        cur = (Interface)allTopmostNets.get(topNet);
                        if (cur != null) continue;
                        allTopmostNets.put(topNet, intf);
                    }
                    continue;
                }
                allIntfNets.put(net, intf);
                for (DevicePath path : intf.getNetsReferencedWRT().getInstancePaths()) {
                    topNet = NetMap.getTopmostNet((Net)net, (DevicePath)path);
                    cur = (Interface)allTopmostNets.get(topNet);
                    if (cur != null && cur != intf) {
                        ++count;
                        ALog.logInfo((String)("Conflict found for top net '" + topNet.getName() + "' interfaces '" + cur.getName() + "' and '" + intf.getName() + "' (Net='" + net.getName() + "')"));
                        continue;
                    }
                    if (cur != null) continue;
                    allTopmostNets.put(topNet, intf);
                }
            }
        }
        ALog.logInfo((String)(count + " net conflicts found"));
    }

    public static void init() {
        Db.addDbListener((Db.DbListener)new Db.DbListenerAdapter(){

            public void dbCreated(Db db) {
                DbClass dbc = db.getDbClass(NetMap.class);
                if (dbc == null) {
                    dbc = db.addDbClass(NetMap.class);
                }
                DbClass.DbObjectEventType[] eventsNM = new DbClass.DbObjectEventType[]{DbClass.DbObjectEventType.ADDED};
                dbc.addObjectListener(mNetMapListener, eventsNM);
            }

            public void dbClosing(Db db) {
                changedNetMaps = null;
            }
        });
    }

    protected static void scheduleUpdateForChangedMapping() {
        if (!updateForChangedMapping) {
            updateForChangedMapping = true;
            Runnable runnable = () -> {
                InterfaceCmds.updateForChangedMapping();
                updateForChangedMapping = false;
            };
            if (EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(runnable);
            } else {
                Cp.getCp().onIdle(runnable);
            }
        }
    }

    protected static void updateForChangedMapping() {
        if (changedNetMaps == null || changedNetMaps.isEmpty()) {
            changedNetMaps = null;
            return;
        }
        if ((changedNetMaps = changedNetMaps.stream().filter(netMap -> netMap.getDb() != null && netMap.getParentNet() != null).collect(Collectors.toList())).isEmpty()) {
            changedNetMaps = null;
            return;
        }
        Db db = changedNetMaps.get(0).getDb();
        if (db == null || db.closed()) {
            changedNetMaps.clear();
            return;
        }
        if (db.getObjectCount(Interface.class) == 0) {
            return;
        }
        DbHistory history = db.getHistory();
        boolean mUseIOPads = (Boolean)Settings.get((String)"GUI", (String)"SelectFloorplanUseIOPads", (Object)false);
        try (DbHistory.DbTransaction transaction = history.newDbTransaction("Update Interface for Net Mapping");){
            for (Interface intf : db.getObjects(Interface.class)) {
                boolean needUpdate = false;
                for (NetMap netMap2 : changedNetMaps) {
                    if (!intf.connectedTo(netMap2.getParentNet())) continue;
                    needUpdate = true;
                    break;
                }
                if (!needUpdate) continue;
                OrbitApp.ChangeWarningSilencer cm = OrbitApp.suppressDbChangeMonitorWarnings();
                try {
                    InterfaceCmds.assignExistingPinsToFloorplan(db, intf.getKeyStr(), mUseIOPads, true);
                }
                finally {
                    if (cm == null) continue;
                    cm.close();
                }
            }
        }
    }

    public static void updateFloorplanPins(Db db) {
        for (Interface intf : db.getObjects(Interface.class)) {
            InterfaceCmds.assignExistingPinsToFloorplan(intf, true, true);
        }
    }

    public static void setInterfaceValue(Db db, String ancestry, String name, int IOcount) {
        Interface intf = Interface.find((Db)db, (String)ancestry);
        if (intf != null) {
            intf.setName(name);
            intf.setExpectedIOCount(IOcount);
        }
    }

    public static void setInterfaceParent(Db db, String child, String parent) {
        Interface parentIntf = Interface.find((Db)db, (String)parent);
        Interface childIntf = Interface.find((Db)db, (String)child);
        if (childIntf != null) {
            childIntf.setParent(parentIntf);
        }
    }

    public static void partitionFloorplanByPinPersonality(Db db, String floorplanKeyStr) {
        Floorplan baseFp = (Floorplan)db.getByKeyStr(Floorplan.class, floorplanKeyStr);
        if (baseFp == null) {
            ALog.flogError((String)"Invalid floorplan from '%s'", (Object[])new Object[]{floorplanKeyStr});
            return;
        }
        Map<Optional, List<FloorplanPin>> group = baseFp.getPins().stream().collect(Collectors.groupingBy(fp -> Optional.ofNullable(fp.getFirstPersonality())));
        Interface intf = baseFp.getMyInterface();
        for (Map.Entry<Optional, List<FloorplanPin>> e : group.entrySet()) {
            Personality p = e.getKey().orElse(null);
            if (p == null) continue;
            List<FloorplanPin> pins = e.getValue();
            String name = intf.getName() + "_" + p.getName();
            Interface gIntf = intf.findChild(name);
            if (gIntf == null) {
                gIntf = Interface.create((Db)intf.getDb(), (String)name, (Interface)intf, (int)pins.size(), (boolean)true);
            }
            for (FloorplanPin pin : pins) {
                Net keyNet = intf.connectedToKeyNet(pin.getNet());
                if (keyNet == null) continue;
                List moveFPins = pin.getSiblingFloorplanPins();
                moveFPins.add(pin);
                LinkedHashMap<DeviceTemplate, HierInst> moveFPinMap = new LinkedHashMap<DeviceTemplate, HierInst>();
                for (FloorplanPin floorplanPin : moveFPins) {
                    DeviceTemplate devT = floorplanPin.getOwner().getDeviceTemplate();
                    moveFPinMap.put(devT, HierInst.create((StoredPath)floorplanPin.getRelPath(), (DbObject)floorplanPin.getPinTemplate()));
                }
                gIntf.addNet(keyNet);
                for (Map.Entry entry : moveFPinMap.entrySet()) {
                    Floorplan fp2 = gIntf.getFloorplan((DeviceTemplate)entry.getKey(), true);
                    FloorplanPin placed = FloorplanPin.create((Floorplan)fp2, (StoredPath)StoredPath.get((DevicePath)((HierInst)entry.getValue()).getPath()), (PinTemplate)((PinTemplate)((HierInst)entry.getValue()).getDbObject()));
                    assert (placed != null);
                }
            }
        }
    }
}

