/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit;

import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.FilteringIterator;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.db.std.NetMap;
import com.sigrity.acl.db.std.PinTemplate;
import com.sigrity.acl.db.std.Term;
import com.sigrity.acl.db.std.TermMap;
import com.sigrity.acl.function.APredicate;
import com.sigrity.acl.ui.AFloatWindow;
import com.sigrity.acl.ui.AMenuUtil;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.ui.graph.AGraphPanel;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.ObjectActionRegistry;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.OrbitIcons;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import com.sigrity.tools.dbexplorer.DBEResources;
import edu.uci.ics.jung.algorithms.layout.CircleLayout;
import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.FRLayout2;
import edu.uci.ics.jung.algorithms.layout.GraphElementAccessor;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.StaticLayout;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Context;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AbstractPopupGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.GraphMousePlugin;
import edu.uci.ics.jung.visualization.renderers.BasicVertexLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.transform.BidirectionalTransformer;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import edu.uci.ics.jung.visualization.transform.shape.ShapeTransformer;
import edu.uci.ics.jung.visualization.transform.shape.TransformingGraphics;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.function.Predicate;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.apache.commons.collections15.Transformer;

public class NetGraphPanel
extends AGraphPanel {
    protected NetGraph mGraph;
    protected JCheckBox mCheckBoxTerm;
    protected JCheckBox mCheckBoxPin;
    static HashSet<String> UndisplayedNetContextMenuItems = AUtil.hashSet(Arrays.asList("Graph Net", "Net"));

    protected NetGraphPanel(NetGraph graph) {
        super(NetGraphPanel.getLayouts(graph));
        this.mGraph = graph;
    }

    public NetGraphPanel(Net net, DevicePath path) {
        this(new NetGraphNet(net, path));
    }

    @Override
    protected AGraphPanel.Viewer createViewer(Layout<AGraphPanel.GPVertex, AGraphPanel.GPEdge> layout) {
        AGraphPanel.Viewer viewer = super.createViewer(layout);
        viewer.getRenderer().setVertexLabelRenderer((Renderer.VertexLabel)new NGVertexLabelRenderer());
        viewer.getRenderContext().setEdgeStrokeTransformer((Transformer)new Transformer<AGraphPanel.GPEdge, Stroke>(){
            float[] test = new float[]{3.0f, 3.0f, 3.0f};
            final Stroke dottedStroke = new BasicStroke(1.0f, 1, 0, 1.0f, this.test, 0.0f);
            final Stroke solidStroke = new BasicStroke(1.0f);

            public Stroke transform(AGraphPanel.GPEdge edge) {
                return edge.getType() == AGraphPanel.GPEdge.Type.DOTTED ? this.dottedStroke : this.solidStroke;
            }
        });
        return viewer;
    }

    @Override
    protected DefaultModalGraphMouse<AGraphPanel.GPVertex, AGraphPanel.GPEdge> createGraphMouse() {
        DefaultModalGraphMouse<AGraphPanel.GPVertex, AGraphPanel.GPEdge> gm = super.createGraphMouse();
        gm.add((GraphMousePlugin)new ContextMenuPlugin());
        return gm;
    }

    @Override
    protected JComponent createViewControls(Layout<AGraphPanel.GPVertex, AGraphPanel.GPEdge>[] layouts, Layout<AGraphPanel.GPVertex, AGraphPanel.GPEdge> selLayout) {
        JPanel wrapper = new JPanel();
        GridBagManager l = GridBagManager.layout((Container)wrapper);
        l.add((Component)super.createViewControls(layouts, selLayout), (GridBagConstraints)GridBagManager.LEFT.noInsets());
        this.mCheckBoxTerm = (JCheckBox)l.add((Component)this.createTermFilterCheckBox());
        this.mCheckBoxPin = (JCheckBox)l.add((Component)this.createPinFilterCheckBox());
        l.addFillX();
        return wrapper;
    }

    protected JCheckBox createTermFilterCheckBox() {
        JCheckBox cb = new JCheckBox("Show Terms");
        if (this.mGraph != null) {
            cb.setSelected(this.mGraph.getTermFilter() == NetGraph.TERM_FILTER_ALL);
        }
        cb.addItemListener(e -> {
            if (cb.isSelected()) {
                this.mGraph.setTermFilter(NetGraph.TERM_FILTER_ALL);
            } else {
                this.mGraph.setTermFilter(NetGraph.TERM_FILTER_HIDE);
            }
            this.setLayouts(NetGraphPanel.getLayouts(this.mGraph));
        });
        return cb;
    }

    protected JCheckBox createPinFilterCheckBox() {
        JCheckBox cb = new JCheckBox("Show Pins");
        if (this.mGraph != null) {
            cb.setSelected(this.mGraph.getPinFilter() == NetGraph.PIN_FILTER_ALL && this.mGraph.getNetFilter() == NetGraph.NET_FILTER_ALL);
        }
        cb.addItemListener(e -> {
            if (cb.isSelected()) {
                this.mGraph.setPinFilter(NetGraph.PIN_FILTER_ALL);
                this.mGraph.setNetFilter(NetGraph.NET_FILTER_ALL);
            } else {
                this.mGraph.setPinFilter(NetGraph.PIN_FILTER_HIDE);
                this.mGraph.setNetFilter(NetGraph.NET_FILTER_HIDE_PIN_DEVICE);
            }
            this.setLayouts(NetGraphPanel.getLayouts(this.mGraph));
        });
        return cb;
    }

    public void setShowTerm(boolean enable) {
        this.mCheckBoxTerm.setSelected(enable);
    }

    public void setShowPin(boolean enable) {
        this.mCheckBoxPin.setSelected(enable);
    }

    protected static Layout<AGraphPanel.GPVertex, AGraphPanel.GPEdge>[] getLayouts(NetGraph graph) {
        int padding = 150;
        Transformer initializer = vertex -> new Point2D.Double(vertex.getLoc().getX() + 150.0, vertex.getLoc().getY() + 150.0);
        Layout[] layouts = new Layout[]{new StaticLayout(graph.mForest, initializer), new FRLayout(graph.mForest), new FRLayout2(graph.mForest), new CircleLayout(graph.mForest)};
        return layouts;
    }

    public static void showNetGraph(Window owner, DevicePath path, Net n) {
        NetGraphPanel.showNetGraph(owner, path, n, false, false);
    }

    public static void showNetGraph(Window owner, DevicePath path, Net n, boolean showTerm, boolean showPin) {
        String dtName;
        DeviceTemplate netDT = n == null ? null : n.getDeviceTemplate();
        String netDTName = netDT == null ? "null" : netDT.getName();
        String netName = n == null ? "" : n.getName();
        String title = path == null ? String.format("Net: %s from DeviceTemplate: %s", netName, netDTName) : String.format("Net: %s from DevicePath: %s", netName, path.escapedString());
        Net topNet = path == null ? n : NetMap.getTopmostNet((Net)n, (DevicePath)path);
        DevicePath topPath = path == null ? null : NetMap.getTop((DevicePath)path, (Net)n).getPath();
        AFloatWindow d = new AFloatWindow(owner, title, Dialog.ModalityType.MODELESS);
        d.setRecallBounds(false);
        GridBagManager l = new GridBagManager(d.getContentPane());
        String noteTop = null;
        if (path == null) {
            DeviceTemplate dt;
            DeviceTemplate deviceTemplate = dt = n == null ? null : n.getDeviceTemplate();
            if (!(dt instanceof Design)) {
                dtName = dt == null ? "null" : dt.getName();
                noteTop = String.format("DeviceTemplate '%s'", dtName);
            }
        } else if (!path.getIsAbsolute()) {
            DeviceTemplate devT = path.getRoot();
            dtName = devT == null ? "<unknown>" : devT.getName();
            noteTop = String.format("DeviceTemplate '%s'", dtName);
        }
        if (noteTop != null) {
            String text = String.format("Due to this NetGraph's context, mappings are not shown above %s.", noteTop);
            JLabel lbl = new JLabel(text);
            lbl.setFont(lbl.getFont().deriveFont(2));
            Dimension dimension = lbl.getPreferredSize();
            dimension.width = 100;
            lbl.setMinimumSize(dimension);
            l.add((Component)lbl, (GridBagConstraints)GridBagManager.FILLX_REMAINX.insetBottom(0));
            l.newline();
        }
        NetGraphPanel ngp = new NetGraphPanel(topNet, topPath);
        ngp.setShowTerm(showTerm);
        ngp.setShowPin(showPin);
        l.add((Component)ngp, (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
        d.pack();
        UIUtil.center((Component)((Object)d));
        d.setVisible(true);
    }

    public static Action createShowNetGraphAction(Window owner, DevicePath path, Net n) {
        return NetGraphPanel.createShowNetGraphAction(owner, path, n, false, false);
    }

    public static Action createShowNetGraphAction(final Window owner, final DevicePath path, final Net n, final boolean showTerm, final boolean showPin) {
        return new AbstractAction("Graph Net...", OrbitIcons.GRAPHNET){

            @Override
            public void actionPerformed(ActionEvent e) {
                NetGraphPanel.showNetGraph(owner, path, n, showTerm, showPin);
            }
        };
    }

    protected static IterableIterator<JMenuItem> getMenuItemsHelper(DbObject dbo, DevicePath path) {
        ObjectActionRegistry oar;
        OrbitIO oio = OrbitIO.getApp();
        OrbitGuiWS ws = oio == null ? null : oio.getWorkspace();
        ObjectActionRegistry objectActionRegistry = oar = ws == null ? null : ws.getObjectActionRegistry();
        if (oar == null) {
            return null;
        }
        FilteringIterator<JMenuItem> itr = new FilteringIterator<JMenuItem>(oar.getJMenuItems(new HierInst(path, dbo))){

            protected boolean include(JMenuItem mi) {
                String text = mi.getText();
                if (text.endsWith("...")) {
                    text = text.substring(0, text.length() - 3);
                }
                return !UndisplayedNetContextMenuItems.contains(text);
            }
        };
        return AIterableItr.itr((Collection)AMenuUtil.groupByFirstWord((Iterator)itr));
    }

    protected static interface MenuItemProvider {
        public IterableIterator<JMenuItem> getMenuItems();
    }

    public static class Edge
    extends AGraphPanel.GPEdge {
        public Edge(AGraphPanel.GPEdge.Type type) {
            super(type);
        }
    }

    public static class PortVertex
    extends AGraphPanel.GPVertex
    implements MenuItemProvider {
        protected PinTemplate mPort;
        protected DevicePath mPath;

        public PortVertex(PinTemplate port, DevicePath path) {
            this.mPort = port;
            this.mPath = path;
        }

        @Override
        public String getLabel() {
            return this.mPort.getName();
        }

        @Override
        public Paint getPaint() {
            return Color.CYAN;
        }

        @Override
        public Icon getIcon() {
            if (this.mPort.getType() == PinTemplate.Type.BUMPPAD) {
                return DBEResources.ICON_BUMP;
            }
            if (this.mPort.getType() == PinTemplate.Type.IOPAD) {
                return DBEResources.ICON_PAD;
            }
            return DBEResources.ICON_PIN;
        }

        @Override
        public IterableIterator<JMenuItem> getMenuItems() {
            return NetGraphPanel.getMenuItemsHelper((DbObject)this.mPort, this.mPath);
        }
    }

    public static class NetVertex
    extends AGraphPanel.GPVertex
    implements MenuItemProvider {
        protected Net mNet;
        protected DevicePath mPath;
        private static final String INVALID_STRING = "<Invalid>";

        public NetVertex(Net n, DevicePath p) {
            this.mNet = n;
            this.mPath = p;
        }

        public Net getNet() {
            return this.mNet;
        }

        public DevicePath getPath() {
            return this.mPath;
        }

        @Override
        public String getLabel() {
            String dt;
            if (this.mNet == null) {
                return INVALID_STRING;
            }
            if (this.mPath != null && this.mPath.getLast() != null) {
                String devName = this.mPath.getLast().getName();
                return String.format("<html>Net:%s<br>on Device:%s<html>", AUtil.escapeHtml((String)this.mNet.getName()), AUtil.escapeHtml((String)devName));
            }
            String string = dt = this.mNet.getDeviceTemplate() == null ? "null" : this.mNet.getDeviceTemplate().getName();
            if (this.mNet.getDeviceTemplate() instanceof Design) {
                return String.format("Net:%s on Design:%s", this.mNet.getName(), ((Design)this.mNet.getDeviceTemplate()).getUserName("Design"));
            }
            return String.format("Net:%s on DeviceTemplate:%s", this.mNet.getName(), dt);
        }

        @Override
        public Paint getPaint() {
            return Color.WHITE;
        }

        @Override
        public Icon getIcon() {
            return DBEResources.ICON_NET;
        }

        @Override
        public IterableIterator<JMenuItem> getMenuItems() {
            JMenu menu;
            LinkedList<JMenu> items = new LinkedList<JMenu>();
            JMenu menuNet = new JMenu("Net");
            for (JMenuItem mi : NetGraphPanel.getMenuItemsHelper((DbObject)this.getNet(), this.mPath)) {
                menuNet.add(mi);
            }
            items.add(menuNet);
            if (this.mNet != null && this.mPath != null && this.mPath.getLast() != null) {
                menu = new JMenu("Device");
                for (JMenuItem mi : NetGraphPanel.getMenuItemsHelper((DbObject)this.mPath.getLast(), this.mPath.getParent())) {
                    menu.add(mi);
                }
                items.add(menu);
            } else if (this.mPath != null) {
                menu = new JMenu("DeviceTemplate");
                for (JMenuItem mi : NetGraphPanel.getMenuItemsHelper((DbObject)this.mPath.getDeviceTemplate(), this.mPath.getParent())) {
                    menu.add(mi);
                }
                return new AIterableItr((Object[])new JMenuItem[]{menuNet, menu});
            }
            return AIterableItr.itr(items);
        }
    }

    public static class TermVertex
    extends AGraphPanel.GPVertex
    implements MenuItemProvider {
        protected Term mTerm;
        protected DevicePath mPath;
        private static final String INVALID_STRING = "<Invalid>";

        public TermVertex(Term relateTerm, DevicePath p) {
            this.mTerm = relateTerm;
            this.mPath = p;
        }

        public Term getTerm() {
            return this.mTerm;
        }

        public DevicePath getPath() {
            return this.mPath;
        }

        @Override
        public String getLabel() {
            if (this.mTerm == null) {
                return INVALID_STRING;
            }
            if (this.mPath.getLast() == null) {
                return String.format("Term:%s on DeviceTemplate:%s", this.mTerm.getName(), this.mPath.getDeviceTemplate());
            }
            return String.format("<html>Term:%s<br>on Device:%s<html>", AUtil.escapeHtml((String)this.mTerm.getName()), AUtil.escapeHtml((String)this.mPath.getLast().getName()));
        }

        @Override
        public Paint getPaint() {
            return Color.WHITE;
        }

        @Override
        public Icon getIcon() {
            return DBEResources.ICON_TERMS;
        }

        @Override
        public IterableIterator<JMenuItem> getMenuItems() {
            LinkedList<JMenu> items = new LinkedList<JMenu>();
            JMenu menuTerm = new JMenu("Term");
            for (JMenuItem mi : NetGraphPanel.getMenuItemsHelper((DbObject)this.getTerm(), this.mPath)) {
                menuTerm.add(mi);
            }
            items.add(menuTerm);
            if (this.mTerm != null && this.mPath.getLast() != null) {
                JMenu menuDevice = new JMenu("Device");
                for (JMenuItem mi : NetGraphPanel.getMenuItemsHelper((DbObject)this.mPath.getLast(), this.mPath.getParent())) {
                    menuDevice.add(mi);
                }
                items.add(menuDevice);
            } else {
                JMenu menuDeviceT = new JMenu("DeviceTemplate");
                for (JMenuItem mi : NetGraphPanel.getMenuItemsHelper((DbObject)this.mPath.getDeviceTemplate(), this.mPath.getParent())) {
                    menuDeviceT.add(mi);
                }
                items.add(menuDeviceT);
            }
            return AIterableItr.itr(items);
        }
    }

    public static class NetGraphNet
    extends NetGraph {
        protected Net mNet;
        protected DevicePath mPath;

        public NetGraphNet(Net net, DevicePath path) {
            this.mNet = net;
            this.mPath = path;
            this.refresh();
        }

        @Override
        public void refresh() {
            this.mForest = new DirectedSparseGraph();
            this.locMap = new HashMap();
            this.mTopNets = new ArrayList();
            this.mHier2Vertex = new HashMap();
            if (this.mPath != null) {
                TermMap.getConnectedHierNets((DevicePath)this.mPath, (Net)this.mNet).forEach(hierNet -> {
                    if (NetMap.getParent((DevicePath)hierNet.getPath(), (Net)((Net)hierNet.getDbObject())) == null && !this.mTopNets.contains(hierNet)) {
                        this.mTopNets.add(hierNet);
                    }
                });
            } else {
                this.mTopNets.add(new HierInst(this.mPath, (DbObject)this.mNet));
            }
            this.addTopNets();
        }
    }

    public static abstract class NetGraph {
        public static final Predicate<PinTemplate> PIN_FILTER_ALL = APredicate.always((boolean)true, (String)"Show All Pins");
        public static final Predicate<PinTemplate> PIN_FILTER_HIDE = APredicate.always((boolean)false, (String)"Hide All Pins");
        public static final Predicate<PinTemplate> PIN_FILTER_NO_WIRE_ENDS = APredicate.create(p -> p.getType() != PinTemplate.Type.WIREEND, (String)"Show 'wire end' pins");
        public static final Predicate<Net> NET_FILTER_HIDE_PIN_DEVICE = APredicate.create(net -> !net.getDeviceTemplate().amIAPin(), (String)"Hide Nets on Pin Devices");
        public static final Predicate<Net> NET_FILTER_ALL = APredicate.always((boolean)true, (String)"Show All Nets");
        public static final Predicate<Term> TERM_FILTER_ALL = APredicate.always((boolean)true, (String)"Show All Terms");
        public static final Predicate<Term> TERM_FILTER_HIDE = APredicate.always((boolean)false, (String)"Hide All Terms");
        private static final double X_GAP = 125.0;
        private static final double Y_GAP = 125.0;
        private static final double INNER_DEV_GAP = 50.0;
        DirectedSparseGraph<AGraphPanel.GPVertex, AGraphPanel.GPEdge> mForest;
        ArrayList<HierInst<Net>> mTopNets;
        HashMap<HierInst<DbObject>, AGraphPanel.GPVertex> mHier2Vertex;
        Predicate<PinTemplate> mPinFilter = PIN_FILTER_HIDE;
        Predicate<Net> mNetFilter = NET_FILTER_HIDE_PIN_DEVICE;
        Predicate<Term> mTermFilter = TERM_FILTER_HIDE;
        HashMap<Double, Double> locMap;

        public abstract void refresh();

        public void setPinFilter(Predicate<PinTemplate> pinFilter) {
            this.mPinFilter = pinFilter;
            this.refresh();
        }

        public void setNetFilter(Predicate<Net> netFilter) {
            this.mNetFilter = netFilter;
            this.refresh();
        }

        public void setTermFilter(Predicate<Term> termFilter) {
            this.mTermFilter = termFilter;
            this.refresh();
        }

        public Predicate<PinTemplate> getPinFilter() {
            return this.mPinFilter;
        }

        public Predicate<Net> getNetFilter() {
            return this.mNetFilter;
        }

        public Predicate<Term> getTermFilter() {
            return this.mTermFilter;
        }

        protected void addTopNets() {
            for (HierInst<Net> hier : this.mTopNets) {
                NetVertex nv = new NetVertex((Net)hier.getDbObject(), hier.getPath());
                this.adjxLoc(nv, 0.0, 0.0);
                this.mForest.addVertex((Object)nv);
                this.addChildTerms(nv);
            }
        }

        protected void addChildTerms(NetVertex nv) {
            this.addNetTerms(nv);
            Net net = nv.getNet();
            DevicePath path = new DevicePath(nv.getPath());
            for (Device dev : TermMap.getChildDevices((Net)net)) {
                for (Term t : TermMap.getChildTerms((Device)dev, (Net)net)) {
                    NetVertex childNv;
                    DevicePath childPath = new DevicePath(path, dev);
                    if (this.mTermFilter.test(t) && this.mNetFilter.test(t.getNet())) {
                        TermVertex tv = (TermVertex)this.addVertexAndCreateEdge(nv, (DbObject)t, childPath, 125.0, AGraphPanel.GPEdge.Type.DOTTED);
                        if (tv == null) continue;
                        this.addTermNet(tv);
                        continue;
                    }
                    if (!this.mNetFilter.test(t.getNet()) || (childNv = (NetVertex)this.addVertexAndCreateEdge(nv, (DbObject)t.getNet(), childPath, 125.0, AGraphPanel.GPEdge.Type.DOTTED)) == null) continue;
                    this.addChildTerms(childNv);
                }
            }
            nv.getNet().getPins().stream().filter(pinT -> !pinT.getIsVirtual()).filter(this.mPinFilter).forEach(pinT -> {
                PortVertex pv = new PortVertex((PinTemplate)pinT, path);
                this.adjxLoc(pv, nv.getLoc().getX(), nv.getLoc().getY() + 50.0);
                this.mForest.addEdge((Object)new Edge(AGraphPanel.GPEdge.Type.SOLID), (Object)nv, (Object)pv);
            });
        }

        protected void addTermNet(TermVertex tv) {
            DevicePath path;
            Net net = tv.getTerm().getNet();
            NetVertex nv = (NetVertex)this.addVertexAndCreateEdge(tv, (DbObject)net, path = tv.getPath(), 50.0, AGraphPanel.GPEdge.Type.SOLID);
            if (nv == null) {
                return;
            }
            this.addChildTerms(nv);
        }

        protected void addNetTerms(NetVertex nv) {
            Net net = nv.getNet();
            DevicePath path = nv.getPath();
            for (Term netTerm : net.getTerms()) {
                if (!this.mTermFilter.test(netTerm)) continue;
                TermVertex tv = (TermVertex)this.mHier2Vertex.get(HierInst.create((DevicePath)path, (DbObject)netTerm));
                if (tv == null) {
                    tv = new TermVertex(netTerm, path);
                    this.adjxLoc(tv, nv.getLoc().getX(), nv.getLoc().getY() - 50.0);
                    this.mHier2Vertex.put((HierInst<DbObject>)HierInst.create((DevicePath)path, (DbObject)netTerm), tv);
                }
                if (this.mForest.findEdge((Object)tv, (Object)nv) != null) continue;
                this.mForest.addEdge((Object)new Edge(AGraphPanel.GPEdge.Type.SOLID), (Object)tv, (Object)nv);
            }
        }

        protected void addIntoGraph(AGraphPanel.GPVertex parent, AGraphPanel.GPVertex newChild, double gap, AGraphPanel.GPEdge.Type type) {
            this.adjxLoc(newChild, parent.getLoc().getX(), parent.getLoc().getY() + gap);
            this.mForest.addEdge((Object)new Edge(type), (Object)parent, (Object)newChild);
        }

        protected AGraphPanel.GPVertex addVertexAndCreateEdge(AGraphPanel.GPVertex p, DbObject obj, DevicePath objP, double gap, AGraphPanel.GPEdge.Type type) {
            AGraphPanel.GPVertex cv = this.mHier2Vertex.get(HierInst.create((DevicePath)objP, (DbObject)obj));
            if (cv != null) {
                if (this.mForest.findEdge((Object)p, (Object)cv) == null) {
                    this.mForest.addEdge((Object)new Edge(type), (Object)p, (Object)cv);
                }
                return null;
            }
            if (obj instanceof Term) {
                TermVertex tv = new TermVertex((Term)obj, objP);
                this.mHier2Vertex.put((HierInst<DbObject>)HierInst.create((DevicePath)objP, (DbObject)obj), tv);
                this.addIntoGraph(p, tv, gap, type);
                return tv;
            }
            if (obj instanceof Net) {
                NetVertex nv = new NetVertex((Net)obj, objP);
                this.mHier2Vertex.put((HierInst<DbObject>)HierInst.create((DevicePath)objP, (DbObject)obj), nv);
                this.addIntoGraph(p, nv, gap, type);
                return nv;
            }
            return null;
        }

        protected void adjxLoc(AGraphPanel.GPVertex v, double x, double y) {
            Double nextRowxLoc;
            Double xLoc = this.locMap.get(y);
            if (xLoc != null && x <= xLoc) {
                x = xLoc + 125.0;
            }
            if ((nextRowxLoc = this.locMap.get(y + 125.0)) != null && x < nextRowxLoc) {
                x = nextRowxLoc;
            }
            v.setLoc(new Point2D.Double(x, y));
            this.locMap.put(y, x);
        }

        public void exportVertexLog(String filePath) {
            File file = new File(filePath);
            try (PrintWriter writer = new PrintWriter(file);){
                this.mHier2Vertex.forEach((hier, vertex) -> {
                    writer.format("Path:%s, Object:%s,X:%f, Y:%f", hier.getPath(), hier.getDbObject(), vertex.getLoc().getX(), vertex.getLoc().getY());
                    writer.println();
                });
            }
            catch (FileNotFoundException fnfe) {
                ALog.logError((Throwable)fnfe, (String)"Unable to write to output file '%s'.", (Object[])new Object[]{file});
            }
        }
    }

    public static class NGVertexLabelRenderer
    extends BasicVertexLabelRenderer<AGraphPanel.GPVertex, AGraphPanel.GPEdge> {
        final double rotateDegree;

        NGVertexLabelRenderer() {
            this.position = Renderer.VertexLabel.Position.E;
            this.rotateDegree = 20.0;
        }

        public void labelVertex(RenderContext<AGraphPanel.GPVertex, AGraphPanel.GPEdge> rc, Layout<AGraphPanel.GPVertex, AGraphPanel.GPEdge> layout, AGraphPanel.GPVertex v, String label) {
            BidirectionalTransformer transformer;
            Graph graph = layout.getGraph();
            if (!rc.getVertexIncludePredicate().evaluate((Object)Context.getInstance((Object)graph, (Object)v))) {
                return;
            }
            Point2D pt = (Point2D)layout.transform((Object)v);
            pt = rc.getMultiLayerTransformer().transform(Layer.LAYOUT, pt);
            float x = (float)pt.getX();
            float y = (float)pt.getY();
            Component component = this.prepareRenderer(rc, rc.getVertexLabelRenderer(), label, rc.getPickedVertexState().isPicked((Object)v), v);
            GraphicsDecorator g = rc.getGraphicsContext();
            Dimension d = component.getPreferredSize();
            AffineTransform xform = AffineTransform.getTranslateInstance(x, y);
            Shape shape = (Shape)rc.getVertexShapeTransformer().transform((Object)v);
            shape = xform.createTransformedShape(shape);
            if (rc.getGraphicsContext() instanceof TransformingGraphics && (transformer = ((TransformingGraphics)rc.getGraphicsContext()).getTransformer()) instanceof ShapeTransformer) {
                ShapeTransformer shapeTransformer = (ShapeTransformer)transformer;
                shape = shapeTransformer.transform(shape);
            }
            Rectangle2D bounds = shape.getBounds2D();
            Point p = this.getAnchorPoint(bounds, d, this.position);
            g.translate(p.x, p.y);
            g.rotate(Math.toRadians(-this.rotateDegree));
            g.draw(component, rc.getRendererPane(), -5, -5, d.width, d.height, true);
            g.rotate(Math.toRadians(this.rotateDegree));
            g.translate(-p.x, -p.y);
        }
    }

    protected class ContextMenuPlugin
    extends AbstractPopupGraphMousePlugin {
        protected ContextMenuPlugin() {
        }

        protected void handlePopup(MouseEvent e) {
            AGraphPanel.GPVertex v;
            VisualizationViewer vv = (VisualizationViewer)e.getSource();
            Point p = e.getPoint();
            GraphElementAccessor pickSupport = vv.getPickSupport();
            if (pickSupport != null && (v = (AGraphPanel.GPVertex)pickSupport.getVertex(vv.getGraphLayout(), ((Point2D)p).getX(), ((Point2D)p).getY())) instanceof MenuItemProvider) {
                JPopupMenu popup = new JPopupMenu();
                int items = 0;
                for (JMenuItem mi : ((MenuItemProvider)((Object)v)).getMenuItems()) {
                    popup.add(mi);
                    ++items;
                }
                OrbitIO.getApp().getWorkspace().beautify(popup);
                if (items > 0) {
                    popup.show((Component)vv, e.getX(), e.getY());
                }
            }
        }
    }
}

