/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit;

import com.sigrity.acl.AEmptyItr;
import com.sigrity.acl.AIterableItr;
import com.sigrity.acl.AggregateIterator;
import com.sigrity.acl.IterableIterator;
import com.sigrity.acl.NestedIterator;
import com.sigrity.acl.ProcessingIterator;
import com.sigrity.acl.ui.AActionGroup;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;

public class ObjectActionRegistry {
    public static final String InitUnChecked = "InitUnChecked";
    public static final IterableIterator<ActionFactory<?>> NO_FACTORIES = AEmptyItr.create();
    public static final IterableIterator<Action> NO_ACTIONS = AEmptyItr.create();
    protected static final Set<ActionConstraint> NO_CONSTRAINTS = Collections.emptySet();
    public static final ActionConstraint CONSTRAINT_EXTRA_ACTIONS = new ActionConstraint(){};
    protected Map<Class<?>, ActionFactoryList> mFactories = new HashMap();

    public <T> boolean registerActionFactory(Class<T> c, ActionFactory<? extends T> a) {
        ActionFactoryList afl = this.mFactories.get(c);
        if (afl == null) {
            afl = new ActionFactoryList();
            this.mFactories.put(c, afl);
        } else if (afl.contains(a)) {
            return false;
        }
        return afl.add(a);
    }

    public <T> boolean unregisterFactory(Class<T> c, ActionFactory<? extends T> a) {
        ActionFactoryList afl = this.mFactories.get(c);
        if (afl == null) {
            return false;
        }
        return afl.remove(a);
    }

    public IterableIterator<Class<?>> getClasses() {
        return new AIterableItr(this.mFactories.keySet());
    }

    public IterableIterator<ActionFactory<?>> getFactories(Class<?> c) {
        if (c == null) {
            return NO_FACTORIES;
        }
        ActionFactoryList afl = this.mFactories.get(c);
        Object classFactories = afl == null ? NO_FACTORIES : afl.iterator();
        IterableIterator<ActionFactory<?>> superClassFactories = this.getFactories(c.getSuperclass());
        return new AggregateIterator(classFactories, superClassFactories);
    }

    public IterableIterator<Action> getActions(final Object o, final Set<ActionConstraint> constraints) {
        if (o == null) {
            return AEmptyItr.create();
        }
        IterableIterator<ActionFactory<?>> factories = this.getFactories(o.getClass());
        return new NestedIterator<ActionFactory<?>, Action>((Iterator)factories){

            public Iterator<Action> getLowerIterator(ActionFactory af) {
                return af.getActions(o, constraints);
            }
        };
    }

    public IterableIterator<Action> getActions(Object o, ActionConstraint[] constraints) {
        HashSet<ActionConstraint> hs = constraints == null ? null : new HashSet<ActionConstraint>(Arrays.asList(constraints));
        return this.getActions(o, hs);
    }

    public IterableIterator<Action> getActions(Object o) {
        return this.getActions(o, (Set<ActionConstraint>)null);
    }

    public IterableIterator<JMenuItem> getJMenuItems(Object o, Set<ActionConstraint> constraints) {
        return new ProcessingIterator<Action, JMenuItem>(this.getActions(o, constraints)){

            protected JMenuItem process(Action a) {
                return ObjectActionRegistry.getJMenuItem(a);
            }
        };
    }

    public IterableIterator<JMenuItem> getJMenuItems(Object o, ActionConstraint[] constraints) {
        return new ProcessingIterator<Action, JMenuItem>(this.getActions(o, constraints)){

            protected JMenuItem process(Action a) {
                return ObjectActionRegistry.getJMenuItem(a);
            }
        };
    }

    public IterableIterator<JMenuItem> getJMenuItems(Object o) {
        return this.getJMenuItems(o, (Set<ActionConstraint>)null);
    }

    public static JMenuItem getJMenuItem(Action a) {
        if (a instanceof AActionGroup) {
            AActionGroup agroup = (AActionGroup)a;
            return agroup.getJMenu();
        }
        if (a.getValue("SwingSelectedKey") != null) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem(a);
            if (a.getValue(InitUnChecked) != null) {
                item.setSelected(false);
                a.putValue(InitUnChecked, null);
            }
            return item;
        }
        return new JMenuItem(a);
    }

    public static interface ActionFactory<T> {
        public Iterator<Action> getActions(T var1, Set<ActionConstraint> var2);
    }

    public static class ActionFactoryList
    extends LinkedList<ActionFactory<?>> {
    }

    public static abstract class ActionConstraint {
        public boolean in(Set<ActionConstraint> cs) {
            return cs != null && cs.contains(this);
        }
    }
}

