/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit;

import com.sigrity.acl.db.std.Net;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.HierInst;
import com.sigrity.orbit.HierPort;
import java.util.LinkedList;

public class ObjectLocator {
    static LinkedList<ObjectLocatorListener> listeners = new LinkedList();

    public static void addListener(ObjectLocatorListener l) {
        listeners.add(l);
    }

    public static void remove(ObjectLocatorListener l) {
        listeners.remove(l);
    }

    public static void locateDevicePath(DevicePath path, String callerId) {
        for (ObjectLocatorListener l : listeners) {
            l.locateDevicePath(path, callerId);
        }
    }

    public static void locateHierPort(HierPort hp, String callerId) {
        for (ObjectLocatorListener l : listeners) {
            l.locateHierPort(hp, callerId);
        }
    }

    public static interface ObjectLocatorListener {
        public boolean locateDevicePath(DevicePath var1, String var2);

        public boolean locateHierPort(HierPort var1, String var2);

        public boolean locateHierNet(HierInst<Net> var1);
    }
}

