/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit;

import com.sigrity.acl.ALog;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbFieldDef;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.DbReader;
import com.sigrity.acl.db.DbRelationDef;
import com.sigrity.orbit.OrbitDbReader;
import com.sigrity.orbit.OrbitIO;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import org.xml.sax.Attributes;

public class OrbitDbReaderFiltered
extends OrbitDbReader {
    protected static final String[] CLASSES_HIERARCHY = new String[]{"Design", "Substrate", "DeviceTemplate", "Device", "Layer"};
    protected HashSet<String> mClassFilter = new HashSet<String>(Arrays.asList(CLASSES_HIERARCHY));

    public static Db readHierarchy(String filePath) {
        return OrbitDbReaderFiltered.readFiltered(filePath, CLASSES_HIERARCHY);
    }

    public static Db readFiltered(String filePath, String[] classes) {
        ALog.logInfo((String)"Parsing '%s'...", (Object[])new Object[]{filePath});
        Db db = OrbitIO.createDb();
        OrbitDbReaderFiltered dbr = new OrbitDbReaderFiltered(db, classes);
        if (!dbr.read(filePath)) {
            return null;
        }
        db.setFile(new File(filePath));
        return db;
    }

    public OrbitDbReaderFiltered(Db db, String[] classNames) {
        super(db, true);
    }

    public DbReader.DbClassElementHandler createDbClassElementHandler() {
        return new DbReader.DbClassElementHandler(){

            public void onStart(String namespaceURI, String localName, String name, Attributes attr) {
                if (OrbitDbReaderFiltered.this.mClassFilter.contains(localName)) {
                    super.onStart(namespaceURI, localName, name, attr);
                } else {
                    OrbitDbReaderFiltered.this.mCurDbClass = null;
                }
            }
        };
    }

    protected void addDeferredRelation(DbObject referrer, DbFieldDef field, long foreignId) {
        DbRelationDef relDef = field.getRelation();
        if (relDef == null) {
            return;
        }
        String rightClass = field.getRelation().getDbClassR().getName();
        if (this.mClassFilter.contains(rightClass)) {
            super.addDeferredRelation(referrer, field, foreignId);
        }
    }

    protected void processScope(Attributes attr) {
    }

    protected boolean complete() {
        return true;
    }
}

