/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APair;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.DbFieldDef;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.DbRelationDef;
import com.sigrity.acl.db.DeferredRelationSet;
import com.sigrity.acl.db.PrimaryKey;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Interface;
import com.sigrity.acl.db.std.Layer;
import com.sigrity.acl.db.std.LayerShape;
import com.sigrity.acl.db.std.PadTemplate;
import com.sigrity.acl.db.std.Personality;
import com.sigrity.acl.db.std.PinInstance;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.geom.ADistance;
import com.sigrity.acl.geom.AGeom;
import com.sigrity.acl.geom.AGrid;
import com.sigrity.acl.geom.APoint2D;
import com.sigrity.orbit.OrbitDbReader;
import com.sigrity.orbit.ui.ImportDbUI;
import gnu.trove.list.array.TLongArrayList;
import java.awt.geom.AffineTransform;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.xml.sax.Attributes;

public class OrbitDbReaderImport
extends OrbitDbReader {
    protected Map<String, Substrate> mSubstNameIn2Actual = new HashMap<String, Substrate>();
    protected ConflictOpt mTemplateConflictOpt = ConflictOpt.KeepDup;
    protected ConflictOpt mPersonalityConflictOpt = ConflictOpt.KeepDup;
    protected boolean mAllowDifferentVersion = false;
    protected Substrate mMergeUnmappedSubstToActual = null;
    protected Map<Substrate, Substrate> mSubstrateIn2Actual = new HashMap<Substrate, Substrate>();
    protected Map<Layer, Layer> mLayerIn2Actual = new HashMap<Layer, Layer>();
    protected Map<DeviceTemplate, DeviceTemplate> mDevTIn2Actual = new HashMap<DeviceTemplate, DeviceTemplate>();
    protected DbClass mImportDbClass = null;
    protected String mImportKey = null;
    protected Db mHierarchy = null;
    protected long mSynthIdDesign = 0L;
    protected DbFieldDef mFdPinInstExtConn;
    protected DbRelationDef mRdDeviceTemplate2Substrate;
    protected DbRelationDef mRdDevice2Parent;
    protected DbRelationDef mRdLayer2Substrate;
    protected DbRelationDef mRdPersonality2DeviceTemplate;
    protected DbRelationDef mRdLayerShape2Layer;
    protected DbRelationDef mRdWireLayer;
    protected DbRelationDef mRdMetal2Layer;
    protected Db mImportHierarchy = null;
    protected Map<String, String> mScope = new HashMap<String, String>();
    protected Map<Personality, String> mImportedPersonalities2OrigName = new HashMap<Personality, String>();
    protected boolean mRemovedMergedUnusedDevicePersonalities = true;
    protected List<DeviceTemplate> mCreatedDeviceTemplates = new LinkedList<DeviceTemplate>();
    protected DataScaler mScaler = new DataScaler();
    protected static boolean mQuiet = false;
    private static DeviceTemplate newlyReadDeviceTemplate = null;
    protected static final Set<DeviceTemplate.Type> SubstrateDeviceTypes = AUtil.hashSet((Object[])new DeviceTemplate.Type[]{DeviceTemplate.Type.DIE, DeviceTemplate.Type.PACKAGE, DeviceTemplate.Type.BOARD});

    public static String getUniqueName(Db db, DbClass dbClass, String base) {
        for (int i = 1; i < Integer.MAX_VALUE; ++i) {
            String n = String.format("%s_%d", base, i);
            if (dbClass.getInstanceByKeyStr(n) != null) continue;
            return n;
        }
        assert (false);
        return null;
    }

    public OrbitDbReaderImport(Db targetDb) {
        super(targetDb, false);
        this.mFdPinInstExtConn = targetDb.getDbClass(PinInstance.class).getField("externalConnected");
        this.mRdDeviceTemplate2Substrate = targetDb.getRelation("DeviceTemplate-substrate");
        this.mRdDevice2Parent = targetDb.getRelation("Device-parent");
        this.mRdLayer2Substrate = targetDb.getRelation("Layer-substrate");
        this.mRdPersonality2DeviceTemplate = targetDb.getRelation("Personality-owner");
        this.mRdLayerShape2Layer = targetDb.getRelation("LayerShape-layer");
        this.mRdWireLayer = targetDb.getRelation("Wire-layer");
        this.mRdMetal2Layer = targetDb.getRelation("Metal-layer");
    }

    public boolean setImport(DbClass dbClass, String key) {
        if (dbClass == null && key == null) {
            ALog.logInfo((String)"The entire database will be imported.");
            return true;
        }
        if (dbClass == null || key == null) {
            ALog.logWarn((String)"Both the database class and the object key must be specified to import an item from a database file.");
            return false;
        }
        String dbClassName = dbClass.getName();
        if (dbClassName.equals("DeviceTemplate") || dbClassName.equals("Device")) {
            this.mImportDbClass = dbClass;
            this.mImportKey = key;
            this.mHierarchy = ImportDbUI.getHierarchy(this.mDb.getCanonicalPath());
            return true;
        }
        ALog.logWarn((String)"Only a DeviceTemplate or Device may be specified as an item to import from a database file, '%s' items are not supported", (Object[])new Object[]{dbClassName});
        return false;
    }

    public void addSubstrateMap(String inSubstName, String destSubstName) {
        Substrate dest = Substrate.getSubstrate((Db)this.mDb, (String)destSubstName);
        if (dest == null) {
            ALog.logWarn((String)"The specified destination Substrate '%s' does not exist.", (Object[])new Object[]{destSubstName});
        } else {
            this.mSubstNameIn2Actual.put(inSubstName, dest);
        }
    }

    public void setDefaultInputSubstDest(String destSubstName) {
        Substrate dest = Substrate.getSubstrate((Db)this.mDb, (String)destSubstName);
        if (dest == null) {
            ALog.logWarn((String)"The specified destination Substrate '%s' does not exist.", (Object[])new Object[]{destSubstName});
        } else {
            this.mMergeUnmappedSubstToActual = dest;
        }
    }

    public void setConflictingTemplateOption(ConflictOpt opt) {
        this.mTemplateConflictOpt = opt;
    }

    public void setConflictingPersonalityOption(ConflictOpt opt) {
        this.mPersonalityConflictOpt = opt;
    }

    public void setAllowDifferentVersion(boolean b) {
        this.mAllowDifferentVersion = b;
    }

    public List<DeviceTemplate> getCreatedDeviceTemplates() {
        return this.mCreatedDeviceTemplates;
    }

    public static void setQuiet(boolean flag) {
        mQuiet = flag;
    }

    protected void startDbElement(Attributes attr) {
        Object scopeMsg = null;
        HashMap<String, String> distUnitInfo = new HashMap<String, String>();
        for (int i = 0; i < attr.getLength(); ++i) {
            String name = attr.getQName(i);
            if (name.startsWith("scope.")) {
                name = name.substring("scope.".length());
                String val = attr.getValue(i);
                this.mScope.put(name, val);
                scopeMsg = scopeMsg == null ? "" : (String)scopeMsg + "; ";
                scopeMsg = (String)scopeMsg + String.format("%s '%s'", name, val);
                continue;
            }
            if (!name.startsWith("du.")) continue;
            distUnitInfo.put(name.substring("du.".length()), attr.getValue(i));
        }
        this.processDistanceUnit(distUnitInfo);
        if (scopeMsg != null && !mQuiet) {
            ALog.logInfo((String)"Importing %s.", (Object[])new Object[]{scopeMsg});
        }
        super.startDbElement(attr);
    }

    public boolean preReadDb(Db db) {
        boolean preReadResult;
        if (this.mReadDbVersion.equals((Object)DBVERSION)) {
            return true;
        }
        if (!this.mAllowDifferentVersion) {
            ALog.logError((String)"Unable to import database version %s (the current version is %s).", (Object[])new Object[]{this.mReadDbVersion, DBVERSION});
            return false;
        }
        boolean bl = preReadResult = this.mConvertOld ? super.preReadDb(db) : OrbitDbReaderImport.preReadDb((OrbitDbReader.ConversionChain)new OrbitDbReader.ConversionChain(), (Db)db);
        if (!preReadResult) {
            ALog.logError((String)"Unable to import database version %s.", (Object[])new Object[]{this.mReadDbVersion});
            return false;
        }
        ALog.logInfo((String)"Importing different database version %s (the current version is %s).", (Object[])new Object[]{this.mReadDbVersion, DBVERSION});
        return true;
    }

    public boolean validateDbVersion(boolean requireCurrent) {
        return true;
    }

    protected void putSynthId(long id, DbObject dbobj) {
        if (dbobj instanceof Design) {
            this.mSynthIdDesign = id;
        }
        super.putSynthId(id, dbobj);
    }

    protected DbObject addDbObject(DbObject dbo) {
        return this._addDbObject(dbo);
    }

    protected DbObject _addDbObject(DbObject dbo) {
        Design existingDesign;
        if (dbo instanceof Design && (existingDesign = Design.getDesign((Db)this.mDb)) != null) {
            assert (this.mSynthIdDesign != 0L);
            this.mSynthId2DbObj.put(this.mSynthIdDesign, (Object)existingDesign);
            Design designIn = (Design)dbo;
            if (existingDesign.getInternalPerMicron() != designIn.getInternalPerMicron()) {
                this.mScaler.setScale((double)existingDesign.getInternalPerMicron() / (double)designIn.getInternalPerMicron());
            }
            return existingDesign;
        }
        if (!this.shouldImport(dbo)) {
            return null;
        }
        if (dbo instanceof Substrate) {
            Substrate sIn = (Substrate)dbo;
            String nameIn = sIn.getName();
            Substrate target = this.mSubstNameIn2Actual.get(nameIn);
            if (target == null && this.mMergeUnmappedSubstToActual != null) {
                target = this.mMergeUnmappedSubstToActual;
            }
            if (target != null) {
                this.mSubstrateIn2Actual.put(sIn, target);
                return target;
            }
            Substrate sExist = Substrate.getSubstrate((Db)this.mDb, (String)nameIn);
            if (sExist != null && this.mTemplateConflictOpt != ConflictOpt.UseSrcIgnoreSub) {
                String newName = Substrate.getUniqueName((Db)this.mDb, (String)nameIn);
                ALog.logInfo((String)"A Substrate named '%s' already exists in the database, imported Substrate renamed to '%s'.", (Object[])new Object[]{nameIn, newName});
                sIn.setName(newName);
            }
        } else {
            if (dbo instanceof Layer) {
                Layer l2 = (Layer)dbo;
                this.mLayerIn2Actual.put(l2, null);
                return l2;
            }
            if (dbo instanceof PadTemplate) {
                PadTemplate newPt = (PadTemplate)dbo;
                String name = newPt.getName();
                if (newPt.getSubstrate() == null) {
                    Set subs = this.mDb.getObjects(Substrate.class).stream().collect(Collectors.toSet());
                    subs.add(null);
                    boolean exists = false;
                    for (Substrate s : subs) {
                        if (PadTemplate.get((Db)this.mDb, (Substrate)s, (String)newPt.getName()) == null) continue;
                        exists = true;
                        name = PadTemplate.getUniqueName((Db)this.mDb, (Substrate)s, (String)name);
                        break;
                    }
                    if (exists) {
                        newPt.setName(name);
                    }
                } else if (PadTemplate.get((Db)this.mDb, (Substrate)newPt.getSubstrate(), (String)newPt.getName()) != null) {
                    name = PadTemplate.getUniqueName((Db)this.mDb, (Substrate)newPt.getSubstrate(), (String)name);
                    newPt.setName(name);
                }
            } else if (dbo instanceof Interface) {
                Interface newIntf;
                String name;
                boolean hasParent;
                boolean bl = hasParent = !this.mDeferredRelations.getForeignIdValues(dbo, this.mCurDbClass.getField("parent")).isEmpty();
                if (!hasParent && Interface.get((Db)this.mDb, null, (String)(name = (newIntf = (Interface)dbo).getName())).isPresent()) {
                    String newName = LongStream.iterate(1L, l -> l + 1L).mapToObj(l -> String.format("%s%d", name, l)).filter(n -> !Interface.get((Db)this.mDb, null, (String)n).isPresent()).findFirst().orElse(name);
                    newIntf.setName(newName);
                    ALog.logInfo((String)"An Interface named '%s' already exists in the design, the imported Interface with that name was renamed to '%s'", (Object[])new Object[]{name, newName});
                }
            } else if (dbo instanceof DeviceTemplate) {
                this.mCreatedDeviceTemplates.add((DeviceTemplate)dbo);
            }
        }
        return super.addDbObject(dbo);
    }

    protected boolean setField(DbObject dbobj, DbFieldDef dbfd, String val) {
        boolean res = super.setField(dbobj, dbfd, val);
        if (res) {
            this.mScaler.addScaleIfNeeded(dbobj, dbfd);
        }
        return res;
    }

    protected boolean setFieldVal(DbObject dbobj, DbFieldDef dbfd, Object val) {
        boolean res = super.setFieldVal(dbobj, dbfd, val);
        if (res) {
            this.mScaler.addScaleIfNeeded(dbobj, dbfd);
        }
        return res;
    }

    protected boolean shouldImport(DbObject dbobj) {
        if (this.mImportDbClass == null) {
            return true;
        }
        assert (this.mHierarchy != null);
        return false;
    }

    protected void processDistanceUnit(HashMap<String, String> attrs) {
        String strDbuPerMicron = attrs.get("dbuPerMicron");
        if (strDbuPerMicron == null || strDbuPerMicron.isEmpty()) {
            return;
        }
        long srcDbuPerMicron = 0L;
        try {
            srcDbuPerMicron = Long.parseLong(strDbuPerMicron);
        }
        catch (NumberFormatException nfe) {
            ALog.logError((String)"The du.dbuPerMicron value '%s' specified in the input file is not a valid long. No input data scaling will occur.", (Object[])new Object[]{strDbuPerMicron, this.mFilePath});
            return;
        }
        long tgtDbuPerMicron = Design.getUnitDistDbuPerMicron((Db)this.mDb);
        this.mScaler.setScale((double)tgtDbuPerMicron / (double)srcDbuPerMicron);
    }

    protected void processScope(Attributes attr) {
    }

    protected void processDeferredRelations() {
        for (Map.Entry<Layer, Layer> equivLyr : this.mLayerIn2Actual.entrySet()) {
            Layer inLayer = equivLyr.getKey();
            TLongArrayList synthSubstIds = this.mDeferredRelations.getForeignIdValues((DbObject)inLayer, this.mDb.getDbClass(Layer.class).getField("substrate"));
            if (synthSubstIds == null) continue;
            for (int i = 0; i < synthSubstIds.size(); ++i) {
                long synthSubstId = synthSubstIds.get(i);
                Substrate targetSubst = (Substrate)this.getSynthObjFromId(synthSubstId);
                if (targetSubst == null) continue;
                if (!this.mSubstrateIn2Actual.containsValue(targetSubst)) {
                    this.mDb.add((DbObject)inLayer);
                    continue;
                }
                String lyrName = inLayer.getName();
                Layer actualLyr = targetSubst.getLayer(lyrName);
                if (actualLyr == null) {
                    ALog.logInfo((String)"Substrate Merge: Layer '%s' can't be found in the target (pre-exsisting) substrate. The read layer is being added to the target substrate '%s'.", (Object[])new Object[]{lyrName, targetSubst.getName()});
                    this.mDb.add((DbObject)inLayer);
                    inLayer.setValue("substrate", (Object)targetSubst);
                    actualLyr = inLayer;
                }
                equivLyr.setValue(actualLyr);
            }
        }
        super.processDeferredRelations();
        Comparator comparator = (e1, e2) -> ((DeviceTemplate)e2.getKey()).compareDepthTo((DeviceTemplate)e1.getKey());
        Stream entries = this.mDevTIn2Actual.entrySet().stream().sorted(comparator);
        entries.forEach(ent -> {
            DeviceTemplate dtSrc = (DeviceTemplate)ent.getKey();
            DeviceTemplate dtTgt = (DeviceTemplate)ent.getValue();
            if (this.mTemplateConflictOpt == ConflictOpt.UseTgt) {
                for (Device d : AUtil.linkedList((Iterator)dtSrc.getDeviceInstances())) {
                    d.replaceTemplate(dtTgt);
                }
                dtSrc.deleteFromDb();
            } else if (this.mTemplateConflictOpt == ConflictOpt.UseSrc || this.mTemplateConflictOpt == ConflictOpt.UseSrcIgnoreSub) {
                for (Device d : AUtil.linkedList((Iterator)dtTgt.getDeviceInstances())) {
                    d.replaceTemplate(dtSrc);
                }
                Substrate s = dtTgt.getSubstrate();
                dtTgt.deleteFromDb();
                dtSrc.setSubstrate(s);
            } else assert (false);
        });
    }

    protected void processDeferredRelation(DeferredRelationSet.CompressedDeferredRelation dr) {
        if (dr.getReferrer() instanceof PinInstance && dr.getField() == this.mFdPinInstExtConn && this.getSynthObjFromId(dr.getFirstForeignId()) == null) {
            return;
        }
        if (dr.getReferrer() instanceof Device && this.getSynthObjFromId(dr.getFirstForeignId()) == null && dr.getField().getFieldClass() == Layer.class && dr.getField().getName().equals("mountedOnLayer")) {
            return;
        }
        super.processDeferredRelation(dr);
    }

    public static DeviceTemplate getNewlyReadDeviceTemplate() {
        return newlyReadDeviceTemplate;
    }

    protected void deferredRelate(DbRelationDef rd, DbObject referrer, DbObject relatedObj) {
        Layer actual;
        if (relatedObj instanceof Layer && (actual = this.mLayerIn2Actual.get(relatedObj)) != null) {
            relatedObj = actual;
        }
        if (rd == this.mRdDeviceTemplate2Substrate) {
            Substrate substrate = (Substrate)relatedObj;
            DeviceTemplate dt = (DeviceTemplate)referrer;
            String oldName = dt.getName();
            DeviceTemplate existingDT = substrate.getDeviceTemplate(oldName);
            if (existingDT != null) {
                boolean isScopeTemplate;
                boolean bl = isScopeTemplate = existingDT.getName().equals(this.mScope.get("DeviceTemplate")) && substrate.getName().equals(this.mScope.get("Substrate"));
                if (!(isScopeTemplate || this.mTemplateConflictOpt != ConflictOpt.UseSrc && this.mTemplateConflictOpt != ConflictOpt.UseSrcIgnoreSub && this.mTemplateConflictOpt != ConflictOpt.UseTgt)) {
                    this.mDevTIn2Actual.put(dt, existingDT);
                    return;
                }
                String newName = DeviceTemplate.getUniqueName((Substrate)substrate, (String)oldName);
                dt.setName(newName);
                if (this.mTemplateConflictOpt == ConflictOpt.UseSrcIgnoreSub) {
                    newlyReadDeviceTemplate = dt;
                } else {
                    ALog.logInfo((String)"A DeviceTemplate named '%s' already exists for the substrate '%s', the imported DeviceTemplate was renamed '%s'.", (Object[])new Object[]{oldName, substrate.getName(), newName});
                }
            }
        } else if (rd == this.mRdLayer2Substrate) {
            actual = this.mLayerIn2Actual.get(referrer);
            if (actual != null && actual != referrer) {
                return;
            }
        } else if (rd == this.mRdDevice2Parent) {
            DeviceTemplate parent = (DeviceTemplate)relatedObj;
            Device device = (Device)referrer;
            String oldName = device.getName();
            Device existingDevice = parent.getChild(oldName);
            if (existingDevice != null) {
                String newName = Device.getUniqueName((DeviceTemplate)((Design)relatedObj), (String)oldName);
                device.setName(newName);
                ALog.logInfo((String)"A Device named '%s' already exists in the parent '%s', the imported Device was renamed '%s'.", (Object[])new Object[]{oldName, parent.getName(), newName});
            }
        } else if (rd == this.mRdPersonality2DeviceTemplate) {
            String oldName;
            Personality.Type type;
            Personality existing;
            Personality personality = (Personality)referrer;
            DeviceTemplate devTemp = (DeviceTemplate)relatedObj;
            DeviceTemplate devTempActual = this.mDevTIn2Actual.get(devTemp);
            if (devTempActual != null) {
                devTemp = devTempActual;
            }
            if ((existing = (Personality)Personality.getPersonality((DeviceTemplate)devTemp, (Personality.Type)(type = personality.getType()), (String)(oldName = personality.getName())).orElse(null)) != null) {
                PrimaryKey newKey;
                String newName;
                DbClass dbcPers = personality.getDbClass();
                DbFieldDef dbfPersName = dbcPers.getField("name");
                int suffix = 0;
                while (Personality.getPersonality((DeviceTemplate)devTemp, (Personality.Type)type, (String)(newName = oldName + suffix)).orElse(null) != null || dbcPers.getInstanceByPrimaryKey(newKey = dbcPers.getPrimaryKey((DbObject)personality, dbfPersName, (Object)newName)) != null) {
                    ++suffix;
                }
                personality.setName(newName);
            }
            this.mImportedPersonalities2OrigName.put(personality, oldName);
        }
        super.deferredRelate(rd, referrer, relatedObj);
    }

    protected boolean complete() {
        Design design;
        if (!super.complete()) {
            return false;
        }
        this.mScaler.process();
        String scopeDevice = this.mScope.get("Device");
        if (scopeDevice != null) {
            Device device = (Device)this.mDb.get(Device.class, new Object[]{scopeDevice, null});
            if (device == null) {
                ALog.logError((String)"Import Device '%s' not found in imported data.", (Object[])new Object[]{scopeDevice});
            } else {
                this.processScopeDevice(device);
            }
        }
        if ((design = Design.getDesign((Db)this.mDb)) != null) {
            design.invalidateExtent();
        }
        return true;
    }

    protected void processScopeDevice(Device device) {
        String origName = device.getName();
        Design newParent = Design.getDesign((Db)this.mDb);
        DeviceTemplate.Type devType = device.getDeviceType();
        Substrate devSubstrate = device.getSubstrate();
        if (!SubstrateDeviceTypes.contains(devType) && (this.mSubstNameIn2Actual.containsValue(devSubstrate) || this.mMergeUnmappedSubstToActual != null) && AUtil.countEquals((Iterator)devSubstrate.getInstances(), (long)2L)) {
            for (Device substDev : devSubstrate.getInstances()) {
                if (substDev.getTemplate() == device.getTemplate()) continue;
                newParent = substDev.getTemplate();
            }
        }
        if (newParent != null) {
            if (Device.get((Db)this.mDb, (String)origName, (DeviceTemplate)newParent) != null) {
                String newName = Device.getUniqueName((DeviceTemplate)newParent, (String)origName);
                device.setName(newName);
                ALog.logWarn((String)"A Device named '%s' already exists in the parent template '%s', the imported Device was renamed '%s'.", (Object[])new Object[]{newParent.getName(), origName, newName});
            }
            device.setParent((DeviceTemplate)newParent);
        }
    }

    public static class DataScaler {
        protected double mScale = 1.0;
        protected LinkedList<LayerShape> mLayerShapes = new LinkedList();
        protected LinkedList<DeviceTemplate> mDeviceTemplates = new LinkedList();
        protected HashMap<APair<DbObject, DbFieldDef>, Class<?>> mValues = new HashMap();

        public boolean isScaling() {
            return this.mScale != 1.0;
        }

        public void setScale(double scale) {
            this.mScale = scale;
        }

        public void addValue(DbObject dbo, DbFieldDef fld, Class<?> type) {
            this.mValues.put((APair<DbObject, DbFieldDef>)APair.create((Object)dbo, (Object)fld), type);
        }

        public void process() {
            if (this.mScale != 1.0) {
                AffineTransform x = AffineTransform.getScaleInstance(this.mScale, this.mScale);
                for (LayerShape layerShape : this.mLayerShapes) {
                    layerShape.transform(x);
                }
                for (DeviceTemplate deviceTemplate : this.mDeviceTemplates) {
                    deviceTemplate.transform(x);
                }
                for (Map.Entry entry : this.mValues.entrySet()) {
                    AGeom g;
                    APair objField = (APair)entry.getKey();
                    DbFieldDef fld = (DbFieldDef)objField.second;
                    DbObject dbo = (DbObject)objField.first;
                    Object val = fld.getValue(dbo);
                    if (val == null) continue;
                    Class type = (Class)entry.getValue();
                    if (type == ADistance.class) {
                        ADistance d = (ADistance)val;
                        d = new ADistance((long)(this.mScale * (double)d.val()));
                        dbo.setValue(fld.getName(), (Object)d);
                        continue;
                    }
                    if (type == APoint2D.class) {
                        APoint2D p = (APoint2D)val;
                        p = p.transform(x);
                        dbo.setValue(fld.getName(), (Object)p);
                        continue;
                    }
                    if (type == AGeom.class) {
                        g = (AGeom)val;
                        g = g.transform(x);
                        dbo.setValue(fld.getName(), (Object)g);
                        continue;
                    }
                    if (type != AGrid.class) continue;
                    g = (AGrid)val;
                    dbo.setValue(fld.getName(), (Object)g);
                }
            }
            this.mLayerShapes.clear();
            this.mDeviceTemplates.clear();
            this.mValues.clear();
        }

        public void addScaleIfNeeded(DbObject dbo, DbFieldDef fld) {
            if (dbo == null || fld == null) {
                return;
            }
            Class fc = fld.getFieldClass();
            if (fc == null) {
                return;
            }
            if (ADistance.class.isAssignableFrom(fc)) {
                this.addValue(dbo, fld, ADistance.class);
            } else if (APoint2D.class.isAssignableFrom(fc)) {
                this.addValue(dbo, fld, APoint2D.class);
            } else if (AGeom.class.isAssignableFrom(fc)) {
                this.addValue(dbo, fld, AGeom.class);
            } else if (AGrid.class.isAssignableFrom(fc)) {
                this.addValue(dbo, fld, AGrid.class);
            }
        }
    }

    public static enum ConflictOpt {
        UseSrc("Replace target with source"),
        UseSrcIgnoreSub("Replace target with source but ignore the substrate"),
        UseTgt("Use target, ignore source"),
        KeepDup("Rename and use source");

        String mDesc;

        private ConflictOpt(String desc) {
            this.mDesc = desc;
        }

        public String toString() {
            return this.mDesc;
        }
    }
}

