/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit;

import com.cadence.orbit.OrbitSession;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.sigrity.acl.ABoolean;
import com.sigrity.acl.ABrowserControl;
import com.sigrity.acl.AFile;
import com.sigrity.acl.AFileFilter;
import com.sigrity.acl.ALog;
import com.sigrity.acl.AMemStatus;
import com.sigrity.acl.APair;
import com.sigrity.acl.APlatformUtil;
import com.sigrity.acl.AServiceLoader;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.AclInfo;
import com.sigrity.acl.MutableBoolean;
import com.sigrity.acl.MutableInteger;
import com.sigrity.acl.app.AApp;
import com.sigrity.acl.app.AAppEnv;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.app.ABuildInfo;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.cp.CpConsole;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbFieldDef;
import com.sigrity.acl.db.DbHistory;
import com.sigrity.acl.db.DbLoader;
import com.sigrity.acl.db.DbObject;
import com.sigrity.acl.db.DbReader;
import com.sigrity.acl.db.Selection;
import com.sigrity.acl.db.Selectors;
import com.sigrity.acl.db.std.BondFingerMonitor;
import com.sigrity.acl.db.std.BundleMonitor;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.dbui.MovingSetMonitor;
import com.sigrity.acl.netlister.NetLister;
import com.sigrity.acl.ui.ADialog;
import com.sigrity.acl.ui.AFileChooser;
import com.sigrity.acl.ui.AQueryUser;
import com.sigrity.acl.ui.AclResources;
import com.sigrity.acl.ui.GridBagManager;
import com.sigrity.acl.ui.OrbitUIEventQueue;
import com.sigrity.acl.ui.Splash;
import com.sigrity.acl.ui.UIUtil;
import com.sigrity.acl.ui.waitcursor.WaitCursorEventQueue;
import com.sigrity.lic.LSession;
import com.sigrity.orbit.DesignSettings;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.NetFilters;
import com.sigrity.orbit.ObjectActionRegistry;
import com.sigrity.orbit.OrbitAddIn;
import com.sigrity.orbit.OrbitApp;
import com.sigrity.orbit.OrbitDbReader;
import com.sigrity.orbit.OrbitIOInitializer;
import com.sigrity.orbit.OrbitIOSettings;
import com.sigrity.orbit.OrbitIOWriter;
import com.sigrity.orbit.OrbitLibChecker;
import com.sigrity.orbit.OrbitRunTimeRules;
import com.sigrity.orbit.PortFilters;
import com.sigrity.orbit.automation.DevicePinMappingTable;
import com.sigrity.orbit.automation.NetTable;
import com.sigrity.orbit.cmd.SelectionCmds;
import com.sigrity.orbit.export.AIFExport;
import com.sigrity.orbit.export.AIFIn;
import com.sigrity.orbit.export.DEFOut;
import com.sigrity.orbit.export.DiePadSpreadsheetSerializer;
import com.sigrity.orbit.export.NetLengthOut;
import com.sigrity.orbit.serial.UpdXmlReader;
import com.sigrity.orbit.spd2000.Spd2000;
import com.sigrity.orbit.ui.ProductSelector;
import com.sigrity.orbit.ui.canvas_modes.InspectMode;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import com.sigrity.orbit.ui.core.ViewColorizer;
import com.sigrity.orbit.ui.help.HelpToolTips;
import com.sigrity.orbit.ui.settings.AddInsPanel;
import com.sigrity.orbit.updio.UpdToDbProcessor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public final class OrbitIO
extends OrbitApp {
    private static final String LOG_IMPORT_FAIL = "Cannot import '%s', there is no current database.";
    public static final AFileFilter OIO_FILE_FILTER;
    public static final AFileFilter SCRIPT_FILE_FILTER;
    protected static OrbitIOInitializer[] PreregisteredInitializers;
    public static final String SETTING_GFX_ACCEL_WARN_COUNTER = "GfxAccelWarnCounter";
    protected static boolean sInitializationComplete;
    protected static String sLogFileBaseName;
    protected static int sSessionId;
    protected static OrbitRunTimeRules sRunTimeRules;
    protected static final int RETCODE_NORMAL = 0;
    protected static final int RETCODE_PARSE_ARGS_FAILED = 1;
    protected static final int RETCODE_SOURCE_EXIT = 250;
    protected static final int RETCODE_LICENSE_SYSTEM_FAILED = 251;
    protected static final int RETCODE_LICENSE_CONNECTION_LOST = 252;
    protected static final int RETCODE_LICENSE_FIND_UNABLE = 253;
    protected static final int RETCODE_LICENSE_CHECKOUT_UNABLE = 254;
    protected static final int RETCODE_LICENSE_CREATE_UNABLE = 255;
    protected static final String CLARG_VERSION = "version";
    protected static final String CLARG_PRODUCT = "product";
    protected static final String CLARG_RESET = "reset";
    protected static final String CLARG_HELP = "help";
    protected static final String CLARG_HELP_SHORT = "h";
    protected static final String CLARG_CMD = "cmd";
    protected static final String CLARG_SOURCE = "source";
    protected static final String CLARG_SOURCE_EXIT = "sourceAndExit";
    protected static final String CLARG_GUI = "gui";
    protected static final String CLARG_HIDE = "hide";
    protected static final String CLARG_CONSOLE = "console";
    protected static final String CLARG_BATCH = "batch";
    protected static final String CLARG_NO_MSGLOG = "noMsgLog";
    protected static final String CLARG_DEBUG = "debug";
    protected static final String CLARG_ENV = "E";
    protected static final String CLARG_PROPERTY = "D";
    public static final String CLARG_DEFAULT_DISTANCE_UNIT = "defDistUnit";
    protected Splash mSplash = null;
    protected OrbitGuiWS mWs = null;
    protected CpConsole mConsole = null;
    private final Map<String, SplashSetting> splashSettingByRelease = Map.of("17.2", new SplashSetting("res/img/OrbitIOSplash.png", false), "17.4", new SplashSetting("res/img/OrbitIO_174.jpg", true));
    private PortFilters mPortFilters = null;
    private NetFilters mNetFilters = null;
    protected Action mHeartbeatFailedAction = new AbstractAction("Save and Exit"){
        {
            this.putValue("ShortDescription", "Save all unsaved designs and then exit the application.");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Db first = null;
            Db db = OrbitApp.getCurDb();
            while (db != null && db != first) {
                if (first == null) {
                    first = db;
                }
                if (!db.getDirty()) {
                    OrbitIO.this.closeCurrentDesign();
                } else if (OrbitIO.this.mWs != null) {
                    MutableInteger userResponse = new MutableInteger();
                    if (OrbitIO.this.mWs.saveDesignAs(userResponse)) {
                        OrbitIO.this.closeCurrentDesign();
                    } else if (userResponse.getValue() == 1) {
                        String msg = String.format("Do you want to close '%s' without saving your changes?", db.getUserName());
                        int response = JOptionPane.showConfirmDialog(OrbitIO.getMainWindow(), msg, "Discard Changes?", 0, 3);
                        if (response == 0) {
                            OrbitApp.getCurDb().setDirty(false);
                            OrbitIO.this.closeCurrentDesign();
                        }
                    }
                } else {
                    String path = db.getCanonicalPath();
                    if (path != null) {
                        Cp.exec((String)"OrbitIO.saveCurrentDesignAs(\"%s\")", (Object[])new Object[]{path});
                    } else {
                        File f = null;
                        int i = 0;
                        while (f == null || f.exists()) {
                            f = new File(String.format("%s%s.%s", db.getUserName(), i == 0 ? "" : Integer.valueOf(i), "oio"));
                            ++i;
                        }
                        ALog.logInfo((String)"Saving unsaved design '%s' as '%s'.", (Object[])new Object[]{db.getUserName(), f.getAbsolutePath()});
                        Object o = Cp.exec((String)"OrbitIO.saveCurrentDesignAs(\"%s\")", (Object[])new Object[]{path});
                        if (o instanceof Boolean && ((Boolean)o).booleanValue()) {
                            OrbitIO.this.closeCurrentDesign();
                        } else {
                            ALog.logWarn((String)"Unexpected return from OrbitIO.saveCurrentDesignAs: %s", (Object[])new Object[]{"" + o});
                        }
                    }
                }
                db = OrbitApp.getCurDb();
            }
            if (OrbitApp.getCurDb() == null) {
                System.exit(252);
            } else {
                ALog.logError((String)"Exit aborted, there are still open designs.");
            }
        }
    };
    public static final String Action_Open = "Open";
    protected LinkedListMultimap<String, FileHandler> mActionToFileHandler = LinkedListMultimap.create();

    public static MovingSetMonitor getMovingSetMonitor() {
        return sRunTimeRules.getMovingSetMonitor();
    }

    public static BundleMonitor getBundleMonitor() {
        return sRunTimeRules.getBundleMonitor();
    }

    public static BondFingerMonitor getBondFingerMonitor() {
        return sRunTimeRules.getBondFingerMonitor();
    }

    protected static void resetConfig(Collection<String> args) {
        String OPT_ALL = "all";
        String OPT_GUI = CLARG_GUI;
        String OPT_TEST = "test";
        Set resetArgs = args.stream().map(String::toLowerCase).filter(a -> {
            switch (a) {
                case "all": 
                case "gui": 
                case "test": {
                    return true;
                }
            }
            ALog.logWarn((String)"Unrecognized option '%s' passed to command line 'reset' option, it is being ignored.", (Object[])new Object[]{a});
            return false;
        }).collect(Collectors.toSet());
        File configDir = Settings.getUserConfDir();
        if (resetArgs.contains("all")) {
            ALog.logInfo((String)"'-reset all' specified on command line, resetting all user settings.");
            if (configDir.isDirectory()) {
                AFile.deleteDirectory((File)configDir, Optional.of(ALog.LVL_WARN));
            }
        } else if (resetArgs.contains("test")) {
            AUtil.deleteFile((File)OrbitIO.getUserEnvFile());
            Settings.remove((String)"App", (String)"AppConfigDir", null);
        } else {
            ALog.logInfo((String)"GUI reset specified on command line, resetting GUI settings.");
            File f = new File(configDir, "DockingLayout.xml");
            if (f.isFile() && !f.delete()) {
                ALog.logWarn((String)"Unable to delete GUI settings file '%s'.", (Object[])new Object[]{f.getAbsolutePath()});
            }
            if ((f = new File(configDir, "GUISettings.xml")).isFile() && !f.delete()) {
                ALog.logWarn((String)"Unable to delete GUI settings file '%s'.", (Object[])new Object[]{f.getAbsolutePath()});
            }
        }
    }

    protected static void showVersion(OrbitIO app) {
        System.out.println(app.getBuildInfo());
    }

    protected static ALog.ALogFile createLogFile() {
        File lf = OrbitIO.getLogFile("msg");
        while (lf.exists()) {
            try {
                Files.delete(lf.toPath());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!lf.exists()) continue;
            lf = OrbitIO.getLogFile(String.format("s%d.msg", ++sSessionId));
        }
        return new ALog.ALogFile(lf);
    }

    protected static Options getArgsOptions() {
        Options options = new Options();
        Option help = Option.builder((String)CLARG_HELP_SHORT).longOpt(CLARG_HELP).desc("Print options description.").build();
        Option cmd = Option.builder((String)CLARG_CMD).hasArg(true).argName("java-statement").valueSeparator(':').desc("Specify a command to execute at startup.").build();
        Option source = Option.builder((String)CLARG_SOURCE).hasArg(true).argName("file-path").valueSeparator(':').desc("Specify a file to source at startup.").build();
        Option sourceAndExit = Option.builder((String)CLARG_SOURCE_EXIT).hasArg(true).argName("file-path").valueSeparator(':').desc("Specify a file to source at startup and then exit the application.").build();
        Option gui = Option.builder((String)CLARG_GUI).hasArg(false).desc("Start the application GUI.").build();
        Option hide = Option.builder((String)CLARG_HIDE).hasArg(false).desc("Start the application GUI but hide it.").build();
        Option console = Option.builder((String)CLARG_CONSOLE).hasArg(false).desc("Start the application console.").build();
        Option batch = Option.builder((String)CLARG_BATCH).hasArg(false).desc("Do not start a gui or the console.").build();
        Option version = Option.builder((String)CLARG_VERSION).hasArg(false).desc("Print the application version to stdout and exit.").build();
        Option reset = Option.builder((String)CLARG_RESET).argName("[gui|all]").hasArg(true).optionalArg(true).desc("Reset saved user preferences. If no argument or the \"gui\" argument is specified, only delete the ui settings files DockingLayout.xml and GUISettings.xml. If \"all\" is specified, delete ALL files stored in {userhome}/.OrbitIO\" including custom startup scripts (startup.bsh) and custom user commands.").build();
        Option defDistUnit = Option.builder((String)CLARG_DEFAULT_DISTANCE_UNIT).hasArg(true).argName("name> <dbuPerUnit> <dbuPerMicron> <decimalPlaces").numberOfArgs(4).valueSeparator(':').desc("Set default distance unit used for new designs for the session. Where: <name>: The name of the distance unit. <dbuPerUnit>: The number of internal units per named unit. <dbuPerMicron>: The number of internal units per micron. <decimalPlaces>: The maximum number of decimal places used when displaying or outputting.").build();
        Option product = Option.builder((String)CLARG_PRODUCT).hasArg().argName("name").numberOfArgs(1).desc("Specify a product name.").build();
        Option noMsgLog = Option.builder((String)CLARG_NO_MSGLOG).hasArg(false).desc("Turn off log to file.").build();
        Option debug = Option.builder((String)CLARG_DEBUG).hasArg(false).desc("Enable debug mode").build();
        Option env = Option.builder((String)CLARG_ENV).numberOfArgs(2).valueSeparator().desc("Set Orbit's env").argName("var=value").build();
        Option java = Option.builder((String)CLARG_PROPERTY).numberOfArgs(2).valueSeparator().desc("Java Property. Set value for given property.").argName("property=value").build();
        options.addOption(help);
        options.addOption(cmd);
        options.addOption(source);
        options.addOption(sourceAndExit);
        options.addOption(gui);
        options.addOption(hide);
        options.addOption(console);
        options.addOption(batch);
        options.addOption(version);
        options.addOption(reset);
        options.addOption(defDistUnit);
        options.addOption(product);
        options.addOption(noMsgLog);
        options.addOption(debug);
        options.addOption(env);
        options.addOption(java);
        return options;
    }

    public static void showCommandLineInterfaceHelp() {
        Options options = OrbitIO.getArgsOptions();
        System.out.println("open design usage: ./orbitio [OPTIONS] [OIO-FILE+]\n");
        PrintWriter pw = new PrintWriter(System.out);
        HelpFormatter formatter = new HelpFormatter();
        formatter.printUsage(pw, 80, "./orbitio", options);
        ArrayList sortedOptions = new ArrayList(options.getOptions());
        sortedOptions.sort((x, y) -> x.toString().compareTo(y.toString()));
        pw.println("\nDESCRIPTION");
        for (Option option : sortedOptions) {
            pw.print(" ");
            if (option.getOpt() == null) {
                pw.print(" --");
                pw.print(option.getLongOpt());
            } else {
                pw.print("-");
                pw.print(option.getOpt());
                if (option.hasLongOpt()) {
                    pw.append(",");
                    pw.append("--");
                    pw.append(option.getLongOpt());
                }
            }
            if (option.hasArg()) {
                String argName = option.getArgName();
                if (argName != null && argName.length() == 0) {
                    pw.print(" ");
                } else {
                    pw.print(" ");
                    pw.print("<");
                    pw.print(argName != null ? option.getArgName() : "arg");
                    pw.print(">");
                }
            }
            pw.println();
            pw.print("        ");
            formatter.setDescPadding(8);
            formatter.printWrapped(pw, 72, 8, option.getDescription());
            pw.println();
        }
        pw.flush();
    }

    protected static String[] upgradeArgs(String[] oldArgs) {
        ArrayList<String> gnuArgs = new ArrayList<String>();
        boolean anyChanged = false;
        for (String arg : oldArgs) {
            if (!arg.startsWith("-")) {
                gnuArgs.add(arg);
                continue;
            }
            String[] s = arg.split(":", 2);
            if (s.length == 0 || s[0].length() == 0) {
                ALog.logError((String)"Invalid argument '%s'.", (Object[])new Object[]{arg});
                System.exit(1);
            }
            gnuArgs.add(s[0]);
            if (s.length <= 1) continue;
            if (s[0].equals("-defDistUnit")) {
                gnuArgs.addAll(AUtil.arrayList((Object[])s[1].split(",")));
            } else {
                gnuArgs.add(s[1]);
            }
            anyChanged = true;
        }
        if (anyChanged) {
            ALog.logWarn((String)"Upgrade Arguments: %s", (Object[])new Object[]{String.join((CharSequence)" ", gnuArgs)});
        }
        return gnuArgs.toArray(new String[gnuArgs.size()]);
    }

    protected static void setupEnv(OrbitIO app, CommandLine line) {
        OrbitApp.setupEnv((OrbitApp)app);
        if (!line.hasOption(CLARG_ENV)) {
            return;
        }
        Properties props = line.getOptionProperties(CLARG_ENV);
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            if ("false".equals("" + e.getValue())) {
                app.unsetEnv((String)e.getKey());
                continue;
            }
            app.setEnv((String)e.getKey(), "" + e.getValue());
        }
        app.saveEnv();
    }

    protected static void setupProperty(CommandLine line) {
        if (!line.hasOption(CLARG_PROPERTY)) {
            return;
        }
        Properties props = line.getOptionProperties(CLARG_PROPERTY);
        for (Map.Entry<Object, Object> e : props.entrySet()) {
            System.setProperty("" + e.getKey(), "" + e.getValue());
        }
    }

    private static boolean shouldShowLicenseAgreement() {
        return !ABuildInfo.getRelease().equals("17.4");
    }

    private static void setupApp(OrbitIO app, CommandLine line) {
        sInitializationComplete = false;
        ALog.ALogFile logFile = null;
        if (!line.hasOption(CLARG_NO_MSGLOG)) {
            logFile = OrbitIO.createLogFile();
            ALog.getDefaultLogger().addObserver((ALog.ALogObserver)logFile);
        }
        String[] cmd = line.getOptionValues(CLARG_CMD);
        String[] sources = line.getOptionValues(CLARG_SOURCE);
        String[] sourcesAndExit = line.getOptionValues(CLARG_SOURCE_EXIT);
        boolean hideGUI = line.hasOption(CLARG_HIDE);
        boolean batch = line.hasOption(CLARG_BATCH);
        boolean useGui = hideGUI || line.hasOption(CLARG_GUI);
        boolean useConsole = line.hasOption(CLARG_CONSOLE);
        if (!(useGui || useConsole || batch)) {
            if (cmd != null) {
                useConsole = true;
            } else {
                useGui = true;
            }
        }
        if (useGui) {
            OrbitLibChecker.validateGuiLibDependency();
        }
        boolean startGui = useGui;
        boolean startConsole = useConsole;
        ALog.ALogFile finalLogFile = logFile;
        Runnable phase1 = () -> {
            if (startGui) {
                UIUtil.enableSelectAllWhenTextFieldsGainFocus();
            }
            String strProduct = line.getOptionValue(CLARG_PRODUCT);
            double versionAccepted = (Double)Settings.get((String)"App", (String)"AcceptedLicense", (Object)0.0);
            if (versionAccepted < 2012.1) {
                if (OrbitIO.shouldShowLicenseAgreement() && !OrbitIO.showLicense(startGui)) {
                    return;
                }
                Settings.set((String)"App", (String)"AcceptedLicense", (Object)2012.1);
                Settings.save((String)"App");
            }
            if (startGui && !hideGUI) {
                app.showSplash();
            }
            OrbitApp.Product product = null;
            if (strProduct != null && strProduct.length() > 0) {
                for (OrbitApp.Product p : OrbitApp.Product.values()) {
                    if (!p.toString().equalsIgnoreCase(strProduct)) continue;
                    product = p;
                    break;
                }
            }
            if (product == null) {
                app.setSplashMessage("Determining available products");
                LinkedList<OrbitApp.Product> availProducts = new LinkedList<OrbitApp.Product>();
                ALog.logDebug((String)"Querying license system for available product licenses.");
                LSession lsess = LSession.getSession((double)OrbitApp.getAppLVersion());
                if (lsess == null) {
                    // empty if block
                }
                app.setLSession(lsess);
                lsess.registerHeartbeatFailureAction(app.mHeartbeatFailedAction);
                try {
                    if (OrbitApp.Product.values().length == 1) {
                        availProducts.add(OrbitApp.Product.values()[0]);
                    } else {
                        for (OrbitApp.Product p : OrbitApp.Product.values()) {
                            if (!lsess.checkAvailable(p.mFeature)) continue;
                            availProducts.add(p);
                        }
                    }
                }
                catch (Exception le) {
                    if (availProducts.isEmpty()) {
                        OrbitApp.Product prod = OrbitApp.Product.values()[0];
                        availProducts.add(prod);
                        ALog.logWarn((Throwable)le, (String)"Unable to retrieve available product licenses. The default product '%s' (%s) will be used. You can use the '-product:' command-line flag to specify an alternate product and to avoid this warning.", (Object[])new Object[]{prod.getDisplayName(), prod.mFeature});
                    }
                    ALog.logWarn((Throwable)le, (String)"Unable to retrieve all available product licenses, some available products may not have been found. You can use the '-product:' command-line flag to specify a specific product and to avoid this warning.", (Object[])new Object[0]);
                }
                app.setSplashMessage(null);
                if (availProducts.isEmpty()) {
                    String msg = "No product licenses available.";
                    ALog.logError((String)msg);
                    if (app.mSplash != null) {
                        JOptionPane.showMessageDialog(app.mSplash, msg, "License Error", 0);
                    }
                    System.exit(253);
                } else if (availProducts.size() == 1) {
                    product = (OrbitApp.Product)availProducts.get(0);
                } else {
                    int sel = ProductSelector.select(availProducts, app.mSplash);
                    if (sel < 0) {
                        System.exit(0);
                    }
                    product = availProducts.get(sel);
                }
            }
            app.setSplashMessage(String.format("Loading %s", product.getDisplayName()));
            ALog.logInfo((String)"Starting product '%s' running on %s.", (Object[])new Object[]{product.toString(), APlatformUtil.getPlatformId()});
            String dataModel = System.getProperty("sun.arch.data.model");
            dataModel = dataModel == null || dataModel.trim().isEmpty() ? "unknown" : dataModel + "-bit";
            ALog.logInfo((String)"Using %s runtime and %s maximum memory.", (Object[])new Object[]{dataModel, AMemStatus.getMaxMem()});
            app.init(product, finalLogFile, startGui);
            Cp cp = app.getCp();
            if (startGui) {
                app.setSplashMessage("Loading workspace");
                app.startGui(hideGUI);
            }
            boolean startConsole2 = startConsole;
            Runnable phase2 = () -> {
                String[] designInput;
                File customStartScript;
                app.disposeSplash();
                ALog.logInfo((String)"%s version %s build %s (%s)", (Object[])new Object[]{app.getName(true), app.getVersion(), ABuildInfo.getVersion(), ABuildInfo.getTimestamp()});
                ALog.logInfo((String)"User config directory: %s", (Object[])new Object[]{Settings.getUserConfDir()});
                if (app.mDefaultLogFile != null && app.mDefaultLogFile.getFile() != null) {
                    ALog.logInfo((String)"Logging messages to: %s", (Object[])new Object[]{new File(app.mDefaultLogFile.getFile().getAbsolutePath())});
                }
                if (app.mCommandLogFile != null) {
                    ALog.logInfo((String)"Logging commands to: %s", (Object[])new Object[]{new File(app.mCommandLogFile.getAbsolutePath())});
                }
                if (line.hasOption(CLARG_DEFAULT_DISTANCE_UNIT)) {
                    OrbitIO.setDefaultDistUnitFromCmdLineArg(AUtil.arrayList((Object[])line.getOptionValues(CLARG_DEFAULT_DISTANCE_UNIT)));
                }
                sRunTimeRules = new OrbitRunTimeRules();
                sRunTimeRules.initRules();
                app.installFeatures();
                app.loadPlugins();
                if (startGui) {
                    app.setSplashMessage("Loading workspace i18n");
                    app.postGuiI18n();
                }
                String sourceCmd = "source(\"%s\")";
                File startupScript = new File(app.getConfigDir(), "startup.bsh");
                if (startupScript.canRead()) {
                    cp.doCmd(false, "source(\"%s\")", new Object[]{startupScript.getAbsoluteFile()});
                }
                if ((customStartScript = app.getCustomStartScript()) != null) {
                    cp.doCmd(false, "source(\"%s\")", new Object[]{customStartScript.getAbsoluteFile()});
                }
                app.setupInitCmd(cmd);
                if (sources != null) {
                    for (String source : sources) {
                        Cp.exec((String)"source(\"%s\")", (Object[])new Object[]{source});
                    }
                }
                if (sourcesAndExit != null) {
                    for (String source : sourcesAndExit) {
                        try {
                            Cp.exec((String)"source(\"%s\")", (Object[])new Object[]{source});
                        }
                        catch (Throwable t1) {
                            try {
                                ALog.logError((Throwable)t1, (String)"Caught Throwable during Cp.source('%s').", (Object[])new Object[]{source});
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                    try {
                        ALog.logInfo((String)"Exiting application due to 'sourceAndExit' command line argument.");
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    System.exit(250);
                }
                if ((designInput = line.getArgs()) != null) {
                    for (String file : designInput) {
                        File designFile;
                        Cp.exec((String)"OrbitIO.openDesign(%s);", (Object[])new Object[]{Cp.getFileAsArgument((File)new File(file))});
                        if (!APlatformUtil.isWindowsPlatform() || !(designFile = new File(file)).exists()) continue;
                        app.setAppCwd(designFile.getAbsolutePath());
                    }
                }
                sInitializationComplete = true;
                if (startConsole2) {
                    app.startConsole();
                }
            };
            if (EventQueue.isDispatchThread()) {
                EventQueue.invokeLater(phase2);
            } else {
                phase2.run();
            }
        };
        if (startGui) {
            EventQueue.invokeLater(phase1);
        } else {
            phase1.run();
        }
    }

    private void setupInitCmd(String[] cmd) {
        DbHistory history;
        List txns;
        if (cmd == null) {
            return;
        }
        for (String c : cmd) {
            this.mCp.doCmd(c, new Object[0]);
        }
        Db db = OrbitIO.getCurDb();
        if (db != null && !(txns = (history = db.getHistory()).getHistory()).isEmpty() && !((DbHistory.Transaction)txns.get(txns.size() - 1)).getClosed()) {
            ALog.logWarn((String)"Detect illegal transaction state");
        }
    }

    public static void main(String[] args) {
        OrbitIO.createApp(args);
    }

    static OrbitIO createApp(String[] args) {
        Locale.setDefault(Locale.Category.DISPLAY, new Locale("en", "us"));
        Locale.setDefault(Locale.Category.FORMAT, new Locale("en", "us"));
        OrbitIO app = new OrbitIO();
        DefaultParser parser2 = new DefaultParser();
        try {
            CommandLine line = parser2.parse(OrbitIO.getArgsOptions(), OrbitIO.upgradeArgs(args));
            if (line.hasOption(CLARG_DEBUG)) {
                AclInfo.setAclDebugMode((boolean)true);
                ALog.logInfo((String)"Starting Debug Mode");
            }
            if (line.hasOption(CLARG_HELP)) {
                OrbitIO.showCommandLineInterfaceHelp();
                System.exit(0);
            }
            if (line.hasOption(CLARG_VERSION)) {
                OrbitIO.showVersion(app);
                System.exit(0);
            }
            if (line.hasOption(CLARG_RESET)) {
                OrbitIO.resetConfig(AUtil.arrayList((Object[])line.getOptionValues(CLARG_RESET)));
            }
            OrbitIO.setupProperty(line);
            OrbitIO.setupEnv(app, line);
            OrbitIO.setupApp(app, line);
        }
        catch (ParseException exp) {
            System.err.println("Reason: " + exp.getMessage());
            System.exit(1);
        }
        return app;
    }

    private void exitLicenseSessFail() {
        String msg = "Unable to create a licensing session.";
        ALog.logError((String)msg);
        if (this.mSplash != null) {
            try {
                msg = String.format("%s%n%n%s", msg, LSession.getMessage());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            String m = String.format("%s", msg);
            JOptionPane.showMessageDialog(this.mSplash, m, "License Error", 0);
        }
        System.exit(255);
    }

    public static boolean getInitializationComplete() {
        return sInitializationComplete;
    }

    public static File getLogFile(String type) {
        SimpleDateFormat ts = new SimpleDateFormat("yyyyMMddHHmmss");
        String appName = OrbitIO.class.getSimpleName();
        if (sLogFileBaseName == null) {
            boolean sessionLogs = (Boolean)Settings.get((String)"App", (String)"SessionUniqueLogFiles", (Object)false);
            if (!sessionLogs) {
                sLogFileBaseName = String.format(appName, new Object[0]);
            } else {
                String vinf = ts.format(new Date());
                int i = 0;
                while (sLogFileBaseName == null) {
                    Object suf = i <= 0 ? "" : "-" + i;
                    String base = String.format("%s.%s%s", OrbitIO.class.getSimpleName(), vinf, suf);
                    File testFile = new File(OrbitIO.formatLogFile(base, type));
                    boolean created = false;
                    try {
                        created = testFile.createNewFile();
                    }
                    catch (IOException e) {
                        sLogFileBaseName = String.format(appName, new Object[0]);
                        ALog.logError((Throwable)e, (String)"Unable to create base log file name. Using '%s'.", (Object[])new Object[]{sLogFileBaseName});
                    }
                    if (created) {
                        sLogFileBaseName = base;
                    }
                    ++i;
                }
            }
        }
        return new File(OrbitIO.formatLogFile(sLogFileBaseName, type));
    }

    protected static String formatLogFile(String base, String type) {
        return String.format("%s.%s.log", base, type);
    }

    public static Window getMainWindow() {
        OrbitIO app = OrbitIO.getApp();
        return app == null ? null : app.getMainWin();
    }

    public static OrbitIO getOrbitIO() {
        return OrbitIO.getApp();
    }

    public static OrbitIO getApp() {
        OrbitApp app = OrbitApp.getApp();
        return app instanceof OrbitIO ? (OrbitIO)app : null;
    }

    public static AAppView getCurView() {
        OrbitIO io = OrbitIO.getOrbitIO();
        return io == null ? null : io.getCurrentView();
    }

    public static ViewColorizer getCurColorizer() {
        Db db = OrbitIO.getCurDb();
        return DesignSettings.getViewColorizer((Db)db);
    }

    public static void refreshViewsOf(DbObject dbo) {
        if (dbo == null) {
            return;
        }
        OrbitIO.refreshViewsOf(dbo.getDb());
    }

    public static void refreshViewsOf(Db db) {
        if (db == null) {
            db = OrbitIO.getCurDb();
        }
        if (db == null) {
            return;
        }
        OrbitIO oio = OrbitIO.getOrbitIO();
        if (oio == null) {
            return;
        }
        OrbitGuiWS gws = oio.getWorkspace();
        if (gws == null) {
            return;
        }
        AAppView v = gws.getView(db);
        if (v instanceof DesignView2D) {
            ((DesignView2D)v).getCanvas().refresh();
        }
    }

    public static void zoomFitViewsOf(Db db) {
        if (db == null) {
            return;
        }
        OrbitIO oio = OrbitIO.getOrbitIO();
        if (oio == null) {
            return;
        }
        OrbitGuiWS gws = oio.getWorkspace();
        if (gws == null) {
            return;
        }
        AAppView v = gws.getView(db);
        if (v instanceof DesignView2D) {
            ((DesignView2D)v).getCanvas().zoomFit();
        }
    }

    public static boolean exit() {
        OrbitIO app = OrbitIO.getOrbitIO();
        if (app == null || app.mWs != null && !app.mWs.close()) {
            return false;
        }
        System.exit(0);
        return true;
    }

    public static boolean showLicense(boolean gui) {
        File file = OrbitIO.getLicenseFile();
        if (!file.isFile() || !file.canRead()) {
            ALog.logError((String)"Unable to find license agreement '%s'.", (Object[])new Object[]{file.getPath()});
            return false;
        }
        boolean accepted = false;
        String text = null;
        try (FileInputStream stream = new FileInputStream(file);){
            FileChannel fc = stream.getChannel();
            MappedByteBuffer bb = fc.map(FileChannel.MapMode.READ_ONLY, 0L, fc.size());
            text = StandardCharsets.UTF_8.decode(bb).toString();
        }
        catch (Exception e2) {
            ALog.logError((Throwable)e2, (String)"Error reading license agreement '%s'.", (Object[])new Object[]{file.getPath()});
            return false;
        }
        String msg = "Do you accept all the terms of the preceding agreement? If you choose No, the application will close.";
        if (gui) {
            JDialog dlg = new JDialog();
            dlg.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            dlg.setDefaultCloseOperation(2);
            OrbitIO app = OrbitIO.getApp();
            String title = String.format("%s License Agreement", app == null ? "" : app.getName());
            dlg.setTitle(title);
            GridBagManager l = GridBagManager.layout((JDialog)dlg);
            JTextPane txt = new JTextPane();
            txt.setText(text);
            txt.setEditable(false);
            txt.setCaretPosition(0);
            l.addNl((Component)new JScrollPane(txt), (GridBagConstraints)GridBagManager.FILLALL_REMAINX);
            JTextArea taMsg = new JTextArea(msg);
            taMsg.setLineWrap(true);
            taMsg.setWrapStyleWord(true);
            taMsg.setFocusable(false);
            taMsg.setEditable(false);
            taMsg.setOpaque(false);
            l.addNl((Component)taMsg, (GridBagConstraints)GridBagManager.FILLX_REMAINX);
            l.addFillX();
            JButton btnOK = (JButton)l.add((Component)new JButton("Yes, I Accept"));
            JButton btnCancel = (JButton)l.add((Component)new JButton("No, I Decline"));
            MutableBoolean result = new MutableBoolean(false);
            btnOK.addActionListener(e -> {
                result.setValue(true);
                UIUtil.closeWindow((Window)dlg);
            });
            dlg.setMinimumSize(new Dimension(400, 300));
            dlg.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension dimMaxSize = new Dimension((int)((double)screenSize.width * 0.66), (int)((double)screenSize.height * 0.66));
            Dimension prefSize = dlg.getPreferredSize();
            prefSize = new Dimension(Math.min(dimMaxSize.width, prefSize.width), Math.min(dimMaxSize.height, prefSize.height));
            dlg.setPreferredSize(prefSize);
            dlg.setSize(prefSize);
            UIUtil.enableEscapeClose((Window)dlg, (AbstractButton)btnCancel);
            UIUtil.center((Component)dlg);
            dlg.setVisible(true);
            dlg.dispose();
            if (result.getValue()) {
                accepted = true;
            }
        } else {
            System.out.println(text);
            Integer respose = AQueryUser.ask((Boolean)false, (String)"License", (String)msg, (int)-1, (String[])new String[]{"Yes, I Accept", "No, I Decline"}, (int)0);
            if (respose != null && respose == 0) {
                accepted = true;
            }
        }
        return accepted;
    }

    public static File getIconFile() {
        return new File(AApp.getInstallDir(), "res/img/icon32.png");
    }

    public static File getLicenseFile() {
        return new File(AApp.getInstallDir(), "docs/license/OrbitIOLicense.txt");
    }

    OrbitIO() {
        OrbitIO.setApp((AApp)this);
    }

    protected Splash showSplash() {
        if (this.mSplash != null) {
            return this.mSplash;
        }
        String buildVersion = String.format("Build %s", ABuildInfo.getVersion());
        String releaseVersion = ABuildInfo.getRelease();
        SplashSetting splashSetting = this.splashSettingByRelease.get(releaseVersion);
        if (splashSetting == null) {
            splashSetting = this.splashSettingByRelease.get("17.4");
        }
        File imagePath = new File(AApp.getInstallDir(), splashSetting.imagePath);
        File iconPath = OrbitIO.getIconFile();
        this.mSplash = new Splash("OrbitIO", "", releaseVersion, buildVersion, imagePath, iconPath, splashSetting.imageOnly);
        this.mSplash.setCopyright(releaseVersion.equals("17.4") ? "" : this.getCopyright());
        this.mSplash.setAppVersionColor(new Color(0x606060));
        this.mSplash.setBuildVersionColor(Color.DARK_GRAY);
        this.mSplash.setMsgColor(Color.GRAY);
        this.mSplash.setInsetSize(16);
        this.mSplash.setVisible(true);
        return this.mSplash;
    }

    protected void setSplashMessage(String msg) {
        if (this.mSplash != null) {
            this.mSplash.setMessage(msg);
        }
    }

    protected void disposeSplash() {
        if (this.mSplash == null) {
            return;
        }
        this.mSplash.dispose();
        this.mSplash = null;
    }

    protected void init(OrbitApp.Product product, ALog.ALogFile logFile, boolean allowGui) {
        this.mDefaultLogFile = logFile;
        this.mProduct = product;
        this.mAllowGui = allowGui;
        Settings appSettings = Settings.getSettings((String)"App");
        OrbitIOSettings.AppStartDir startDirPref = (OrbitIOSettings.AppStartDir)appSettings.getSetting("GUIStartDir", (Object)OrbitIOSettings.AppStartDir.CWD);
        switch (startDirPref) {
            case CWD: {
                this.setAppCwd(System.getProperty("user.dir"));
                break;
            }
            case USERHOME: {
                this.setAppCwd(System.getProperty("user.home"));
                break;
            }
            case SPECIFIED: {
                this.setAppCwd((String)appSettings.getSetting("GUIStartDirSpecified", (Object)System.getProperty("user.dir")));
            }
        }
        this.initCpEnv();
        String recordFileType = CLARG_CMD;
        if (sSessionId > 1) {
            recordFileType = String.format("s%d.cmd", sSessionId);
        }
        File cpRecordFile = OrbitIO.getLogFile(recordFileType);
        if (sSessionId == 1) {
            while (cpRecordFile.exists()) {
                try {
                    cpRecordFile.delete();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (!cpRecordFile.exists()) continue;
                cpRecordFile = OrbitIO.getLogFile(String.format("s%d.cmd", ++sSessionId));
            }
        }
        try {
            FileOutputStream cmdLogFile = new FileOutputStream(cpRecordFile, false);
            try {
                String cmdLogHdr = String.format("// %s%s", this.getBuildInfo(), System.getProperty("line.separator"));
                cmdLogFile.write(cmdLogHdr.getBytes());
            }
            catch (IOException cmdLogHdr) {
                // empty catch block
            }
            this.mCp.setRecordOutput((OutputStream)cmdLogFile);
            this.mCommandLogFile = cpRecordFile;
        }
        catch (FileNotFoundException e) {
            ALog.logError((Throwable)e, (String)"Unable to open log file '%s'.", (Object[])new Object[]{cpRecordFile.getPath()});
        }
        this.mLVersion = OrbitApp.getAppLVersion();
        if (this.mProduct == null) {
            this.mProduct = OrbitApp.Product.SystemPlanner;
            ALog.logInfo((String)"No product specified, defaulting to %s.", (Object[])new Object[]{this.mProduct.toString()});
        }
        String tokenName = this.mProduct.mFeature;
        this.initAutoCommandHistory();
        this.initProfilers();
        if (OrbitIO.isOSX() && allowGui) {
            try {
                Class<?> clsOrbitOsx = Class.forName("com.sigrity.orbit.platform.osx.OrbitOSX");
                Method mthdInit = clsOrbitOsx.getMethod("init", null);
                mthdInit.invoke(null, (Object[])null);
            }
            catch (ClassNotFoundException | SecurityException e) {
                ALog.logDebug((Throwable)e, (String)"Unable to load OrbitIO OS X intialization class.", (Object[])new Object[0]);
            }
            catch (NoSuchMethodException e) {
                ALog.logDebug((Throwable)e, (String)"Unable to initialize OrbitIO OS X integration.", (Object[])new Object[0]);
            }
            catch (IllegalArgumentException e) {
                ALog.logDebug((Throwable)e, (String)"Argument error initializing OrbitIO OS X integration.", (Object[])new Object[0]);
            }
            catch (IllegalAccessException e) {
                ALog.logDebug((Throwable)e, (String)"Access error initializing OrbitIO OS X integration.", (Object[])new Object[0]);
            }
            catch (InvocationTargetException e) {
                ALog.logDebug((Throwable)e, (String)"Invocation error initializing OrbitIO OS X integration.", (Object[])new Object[0]);
            }
            catch (Throwable t) {
                ALog.logDebug((Throwable)t, (String)"Unknown error initializing OrbitIO OS X integration.", (Object[])new Object[0]);
            }
        }
        if (!ABoolean.of((Object)System.getProperty("OrbitIO.disableDbChangeMonitor"))) {
            this.initDbChangeMonitor();
        }
    }

    private void installFeatures() {
        for (OrbitIOInitializer oioi : PreregisteredInitializers) {
            oioi.initialize(this);
        }
    }

    private void startConsole() {
        this.mConsole = new CpConsole(this.mCp);
        this.mConsole.start();
    }

    private void startGui(boolean hide) {
        String d3d;
        if (this.mWs != null && this.mWs.getMainFrame() != null) {
            this.mWs.getMainFrame().setVisible(true);
            this.mWs.getMainFrame().requestFocus();
            return;
        }
        Settings s = Settings.getSettings((String)"UserPreferences");
        String laf = (String)s.getSettingOfClass("LookAndFeel", String.class);
        if (laf != null && laf.length() > 0) {
            UIUtil.setLookAndFeel((String)laf);
        }
        this.mWs = new OrbitGuiWS(this);
        this.mWs.init();
        if (!hide) {
            this.mWs.getMainFrame().setVisible(true);
        }
        this.setMainWin(this.mWs.getMainFrame());
        this.getMainWin().addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (OrbitIO.this.mConsole != null) {
                    return;
                }
                OrbitIO.this.mCp.doCmd("exit()", new Object[0]);
            }
        });
        OrbitUIEventQueue eventQueue = !APlatformUtil.isLinuxPlatform() || AUtil.getClassPropBool(OrbitIO.class, (String)"AutoWaitCursor") ? new WaitCursorEventQueue(200) : new OrbitUIEventQueue();
        ALog.logDebug((String)"Installing UI event queue of type '%s'.", (Object[])new Object[]{eventQueue.getClass().getName()});
        Toolkit.getDefaultToolkit().getSystemEventQueue().push(eventQueue);
        HelpToolTips.setMenuTipsEnabled(true);
        if (APlatformUtil.isWindowsPlatform()) {
            if (ABoolean.fromString((String)AUtil.getEnv((String)(ADialog.class.getName() + ".DisableForceToFront")))) {
                ALog.logInfo((String)"ADialog.ForceToFront disabled.");
            } else {
                ADialog.setForceToFront((boolean)true);
            }
        }
        if (APlatformUtil.isWindowsPlatform() && (d3d = System.getProperty("sun.java2d.d3d")) != null && d3d.equals("false")) {
            String platform = APlatformUtil.getPlatformId();
            int warnCounter = (Integer)Settings.get((String)platform, (String)SETTING_GFX_ACCEL_WARN_COUNTER, (Object)-3);
            if (warnCounter < 100) {
                Settings.set((String)platform, (String)SETTING_GFX_ACCEL_WARN_COUNTER, (Object)(++warnCounter));
                Settings.save((String)platform);
            }
            String msg = String.format("Graphics hardware acceleration is currently disabled. It can be enabled via \nTools > Preferences > General > JVM Startup > Enable grahics acceleration. \n\nEnabling acceleration can dramitically increase drawing performance but \nmay also cause display issues. Please verify that your display drivers are \nup to date. \n\nMore information is available at: \nhttp://www.oracle.com/technetwork/java/javase/java2d-142140.html", new Object[0]);
            if (warnCounter == 1) {
                OrbitApp.logAndDisplayWarningDialog((String)msg, (String)"Graphics Hardware Acceleration Disabled");
            } else if (warnCounter < 9) {
                ALog.logWarn((String)msg);
            }
        }
    }

    void postGuiI18n() {
        if (this.mWs != null && this.mWs.getMainFrame() != null && this.mWs.getMainFrame().isVisible()) {
            this.mWs.startGuiI18n();
        }
    }

    public JsonObject getAppInfoJson() {
        JsonObject jo = new JsonObject();
        JsonObject joOrbit = new JsonObject();
        joOrbit.add("Product", (JsonElement)new JsonPrimitive(this.getProductName()));
        joOrbit.add("Version", (JsonElement)new JsonPrimitive(this.getVersion()));
        joOrbit.add("Build", (JsonElement)new JsonPrimitive(this.getBuildVersion()));
        joOrbit.add("BuildTime", (JsonElement)new JsonPrimitive(this.getBuildTimestamp().toString()));
        jo.add("OrbitIO", (JsonElement)joOrbit);
        jo.add("ConfigDir", (JsonElement)new JsonPrimitive("" + Settings.getUserConfDir()));
        JsonObject addInInfo = new JsonObject();
        Function<OrbitIOInitializer, JsonElement> getAddInInfo = addIn -> {
            JsonObject joAddIn = new JsonObject();
            joAddIn.add("name", (JsonElement)new JsonPrimitive(OrbitAddIn.getName(addIn)));
            joAddIn.add("userName", (JsonElement)new JsonPrimitive(OrbitAddIn.getUserName(addIn)));
            joAddIn.add("provider", (JsonElement)new JsonPrimitive(OrbitAddIn.getProvider(addIn)));
            joAddIn.add(CLARG_VERSION, (JsonElement)new JsonPrimitive(OrbitAddIn.getVersion(addIn)));
            joAddIn.add("notes", (JsonElement)new JsonPrimitive(OrbitAddIn.getNotes(addIn)));
            return joAddIn;
        };
        this.getAddIns().filter(OrbitAddIn::isEnabled).forEach(addIn -> addInInfo.add(OrbitAddIn.getId(addIn), (JsonElement)getAddInInfo.apply((OrbitIOInitializer)addIn)));
        jo.add("AddIns", (JsonElement)addInInfo);
        if (OrbitIO.isDevMode()) {
            JsonArray classPath = new JsonArray();
            Arrays.asList(System.getProperty("java.class.path").split(System.getProperty("path.separator"))).stream().forEach(arg_0 -> ((JsonArray)classPath).add(arg_0));
            jo.add("Classpath", (JsonElement)classPath);
        }
        return jo;
    }

    public Optional<Design> createDesign() {
        return (Optional)Cp.exec((String)"OrbitIO.createDesign(null, \"%s\", %dL, %dL, %d)", (Object[])new Object[]{Design.getDefaultUnitDistName(), Design.getDefaultUnitDistDbuCount(), Design.getDefaultUnitDistDbuPerMicron(), Design.getDefaultUnitDistDecimalPlaces()});
    }

    public Optional<Design> createDesign(String userName) {
        return (Optional)Cp.exec((String)"OrbitIO.createDesign(\"%s\", \"%s\", %dL, %dL, %d)", (Object[])new Object[]{userName, Design.getDefaultUnitDistName(), Design.getDefaultUnitDistDbuCount(), Design.getDefaultUnitDistDbuPerMicron(), Design.getDefaultUnitDistDecimalPlaces()});
    }

    public Optional<Design> createDesign(String userName, String distUnitName, long distUnitDbuCount, long distUnitDbuPerMicron, int distUnitDecimalPlaces) {
        return this.createDesign(userName, distUnitName, distUnitDbuCount, distUnitDbuPerMicron, distUnitDecimalPlaces, true);
    }

    public Optional<Design> createDesign(String userName, String distUnitName, long distUnitDbuCount, long distUnitDbuPerMicron, int distUnitDecimalPlaces, boolean guiMode) {
        assert (Cp.getCp().isCmdRecording());
        Db db = OrbitIO.createDb();
        db.setActiveLoader((DbLoader)new DbLoader.DbIdProvider(){

            public DbLoader.DbLoadingForeignKey getLoadingKeyVal(DbObject dbo, DbFieldDef keyField) {
                assert (dbo instanceof Design);
                return null;
            }

            public Long getDbId(DbObject dbo) {
                return null;
            }
        });
        this.mOpenDbs.add(db);
        Design design = distUnitDbuCount == 0L || distUnitDbuPerMicron == 0L ? Design.create((Db)db) : Design.create((Db)db, (String)distUnitName, (long)distUnitDbuCount, (long)distUnitDbuPerMicron, (int)distUnitDecimalPlaces);
        Design design2 = design;
        if (userName != null) {
            design.setUserName(userName);
        }
        db.setActiveLoader(null);
        db.getHistory().reset();
        if (guiMode && this.mWs != null) {
            this.mWs.openView(db);
        } else {
            this.mCurrentDb = db;
        }
        return Optional.ofNullable(design);
    }

    public void closeCurrentDesign() {
        this.closeDesign(this.mCurrentDb);
    }

    public boolean closeDesign(String dbid) {
        return this.closeDesign(this.getDbById(dbid));
    }

    public boolean closeDesign(Db db) {
        if (db == null) {
            return false;
        }
        if (this.mWs != null && this.mWs.closeViews(db) == 0) {
            return false;
        }
        if (this.mOpenDbs.contains(db)) {
            this.mOpenDbs.remove((Object)db);
            String path = db.getCanonicalPath();
            OrbitSession.shared().unlock(path);
            this.mPath2Db.remove(path);
            return true;
        }
        return false;
    }

    public void forceCloseDesign(Db db) {
        String envName = OrbitGuiWS.class.getName() + ".queryUserToSaveOnExit";
        String strQrySave = System.getProperty(envName);
        if (strQrySave == null) {
            strQrySave = "true";
        }
        System.setProperty(envName, "false");
        this.closeDesign(db);
        this.mOpenDbs.remove((Object)db);
        this.mPath2Db.remove(db.getCanonicalPath());
        System.setProperty(envName, strQrySave);
    }

    public void forceCloseAllDesigns() {
        for (Db db : AUtil.arrayList(this.getOpenDBs().iterator())) {
            this.forceCloseDesign(db);
        }
    }

    public void closeCurrentView() {
        AAppView dbv = this.mWs.getCurrentView();
        Db db = dbv == null ? null : dbv.getDb();
        Db db2 = db;
        if (!this.mWs.closeCurrentView()) {
            return;
        }
        if (db != null && this.mWs.getView(db) == null) {
            this.mOpenDbs.remove((Object)db);
            this.mPath2Db.remove(db.getCanonicalPath());
        }
    }

    public boolean closeView(AAppView v) {
        Db db = v == null ? null : v.getDb();
        Db db2 = db;
        if (!this.mWs.closeView(v)) {
            return false;
        }
        if (db != null && this.mWs.getView(db) == null) {
            this.mOpenDbs.remove((Object)db);
            this.mPath2Db.remove(db.getCanonicalPath());
        }
        return true;
    }

    public boolean saveCurrentDesign() {
        Db db = this.getCurrentDb();
        if (db == null) {
            ALog.logWarn((String)"There is no current design to save.");
            return false;
        }
        boolean result = false;
        String path = db.getCanonicalPath();
        if (path != null) {
            result = this.saveCurrentDesignAs(path);
        } else if (this.mWs != null) {
            result = this.mWs.saveDesignAs();
        } else {
            ALog.logWarn((String)"The current design '%s' has never been saved and no UI is available to query user for target file, it is not being saved.", (Object[])new Object[]{this.getDbId(db)});
            return false;
        }
        if (result) {
            ALog.logInfo((String)"Design '%s' saved.", (Object[])new Object[]{db.getFile()});
        } else {
            OrbitApp.logAndDisplayWarningDialog((String)String.format("Saving '%s' failed, check messages for details.", this.getDbId(db)), (String)"Save Failed");
        }
        return result;
    }

    public boolean saveCurrentDesignAs(String path) {
        return this.saveCurrentDesignAs(path, true);
    }

    public boolean saveCurrentDesignAs(String path, boolean optimizeWrite) {
        Db db = this.getCurrentDb();
        if (db == null) {
            return false;
        }
        File oldFile = db.getFile();
        if (OrbitIOWriter.write((Db)db, (String)path, (boolean)optimizeWrite)) {
            db.setDirty(false);
            if (oldFile != null) {
                this.mPath2Db.remove(AUtil.getCanonicalPath((File)oldFile));
            }
            this.mPath2Db.put(AUtil.getCanonicalPath((File)db.getFile()), db);
            return true;
        }
        return false;
    }

    public boolean openDesign(String path) {
        return this.openDesign(path, true) != null;
    }

    public Db openDesign(String path, boolean activate) {
        assert (Cp.getCp().isCmdRecording());
        String cPath = AUtil.getCanonicalPath((File)new File(path));
        if (this.mPath2Db.containsKey(cPath)) {
            Db curDb = (Db)this.mPath2Db.get(cPath);
            if (this.mWs != null) {
                AAppView v = this.mWs.getView(curDb);
                this.mWs.activateView(v);
            } else {
                this.setCurDb(curDb);
            }
            return curDb;
        }
        if (!OrbitSession.shared().lock(path)) {
            OrbitSession.printReadWarningMessage((String)path);
        }
        path = cPath;
        File openFile = new File(path);
        ALog.logInfo((String)"Opening '%s'...", (Object[])new Object[]{openFile});
        Db db = OrbitIO.createDb();
        db.setFile(openFile);
        OrbitDbReader dbr = new OrbitDbReader(db, true);
        DbReadListener listener = new DbReadListener((DbReader)dbr);
        if (!dbr.read(path)) {
            db.setFile(null);
            this.mWs.removeMRU(openFile);
            listener.remove();
            return null;
        }
        this.mOpenDbs.add(db);
        this.mPath2Db.put(AUtil.getCanonicalPath((File)db.getFile()), db);
        AFileChooser.setUserDir((File)db.getFile());
        if (activate) {
            if (this.mWs != null) {
                this.mWs.openView(db);
            } else {
                this.mCurrentDb = db;
            }
        }
        listener.remove();
        ALog.logInfo((String)"'%s' opened.", (Object[])new Object[]{openFile});
        db.setDirty(false);
        return db;
    }

    public boolean importDesign(String path) {
        Db db = OrbitIO.getCurDb();
        if (db == null) {
            ALog.logError((String)LOG_IMPORT_FAIL, (Object[])new Object[]{path});
            return false;
        }
        ALog.logInfo((String)"Importing '%s'...", (Object[])new Object[]{path});
        OrbitDbReader dbr = new OrbitDbReader(db, false);
        DbReadListener listener = new DbReadListener((DbReader)dbr);
        if (!dbr.read(path)) {
            listener.remove();
            return false;
        }
        Design d = Design.getDesign((Db)db);
        d.binAllDevices();
        listener.remove();
        ALog.logInfo((String)"'%s' imported.", (Object[])new Object[]{path});
        return true;
    }

    protected File getCustomStartScript() {
        String customStart = AUtil.getEnv((String)(OrbitGuiWS.class.getName() + ".startScript"));
        if (customStart == null) {
            return null;
        }
        return new File(customStart);
    }

    public void setCurrentDb(String dbid) {
        if (dbid == null) {
            this.setCurDb(null);
            return;
        }
        if (this.mCurrentDb != null && this.getDbId(this.mCurrentDb).equals(dbid)) {
            return;
        }
        Db db = this.getDbById(dbid);
        if (db != null) {
            this.setCurDb(db);
        } else {
            ALog.logWarn((String)"Db '%s' is not currently open.", (Object[])new Object[]{dbid});
        }
    }

    public Db getDbById(String dbid) {
        APair parsedId = OrbitApp.parseDbId((String)dbid);
        String filePath = (String)parsedId.second;
        File file = new File(filePath);
        String canonicalPath = filePath.matches("\\*UnsavedDesign:[0-9]*\\*") ? null : AUtil.getCanonicalPath((File)file);
        for (Db db : this.getOpenDBs()) {
            String curId = this.getDbId(db);
            APair curParsedId = OrbitApp.parseDbId((String)curId);
            if (curId.equals(dbid)) {
                return db;
            }
            if (!((String)curParsedId.second).equals(canonicalPath)) continue;
            if ((Integer)parsedId.first == 0) {
                return db;
            }
            APair aPair = parsedId;
            Integer n = (Integer)aPair.first;
            aPair.first = (Integer)aPair.first - 1;
            Integer n2 = (Integer)aPair.first;
        }
        return null;
    }

    public OrbitGuiWS getWorkspace() {
        return this.mWs;
    }

    public static OrbitGuiWS getGuiWorkspace() {
        OrbitIO oio = OrbitIO.getApp();
        return oio == null ? null : oio.getWorkspace();
    }

    public static ObjectActionRegistry getGuiActionRegistry() {
        OrbitGuiWS ws = OrbitIO.getGuiWorkspace();
        return ws == null ? null : ws.getObjectActionRegistry();
    }

    public boolean hasUnsavedData() {
        for (Db db : this.getOpenDBs()) {
            if (!db.getDirty()) continue;
            return true;
        }
        return false;
    }

    public void zoomFitCurrentView() {
        if (this.mWs != null) {
            this.mWs.zoomFitCurrentView();
        }
    }

    protected BufferedImage snapShotImage(String comment) {
        return this.snapShotImage(comment, -1, -1);
    }

    protected BufferedImage snapShotImage(String comment, int width, int height) {
        AAppView ov = OrbitIO.getCurView();
        if (!(ov instanceof DesignView2D)) {
            ALog.logWarn((String)"Unable to snapshot current view %s.", (Object[])new Object[]{ov == null ? "null" : ov.getClass().getName()});
            return null;
        }
        DesignView2D v = (DesignView2D)ov;
        Date now = new Date();
        boolean sizeUp = width > 0 && height > 0;
        DesignCanvas2D d2d = v.getCanvas();
        if (d2d == null) {
            return null;
        }
        Image image = sizeUp ? d2d.getImage(false, width, height) : d2d.getImage();
        Image image2 = image;
        if (image == null) {
            return null;
        }
        BufferedImage bImage = new BufferedImage(image.getWidth(null), image.getHeight(null) + 20, 1);
        Graphics2D g = bImage.createGraphics();
        g.drawImage(image, 0, 0, null);
        Font exFont = new Font("TimesRoman", 0, 16);
        g.setFont(exFont);
        g.setColor(Color.white);
        String buffer = comment == null || comment.isEmpty() ? "SnapShot by OrbitIO " + System.getProperty("user.name") + " on " + now.toString() : comment;
        ((Graphics)g).drawString(buffer, 0, bImage.getHeight(null) - 4);
        g.dispose();
        return bImage;
    }

    public void snapShotCurrentView(OutputStream out, String comment) {
        BufferedImage bImage = this.snapShotImage(comment);
        try {
            ImageIO.write((RenderedImage)bImage, "png", out);
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Error: Snapshot", (Object[])new Object[0]);
        }
        if (this.mWs != null) {
            this.mWs.snapShotCurrentView();
        }
    }

    public void snapShotCurrentView(String fileName, String comment) {
        this.snapShotCurrentView(fileName, comment, -1, -1);
    }

    public void snapShotCurrentView(String fileName, String comment, int width, int height) {
        BufferedImage bImage = this.snapShotImage(comment, width, height);
        File outFile = new File(fileName);
        try {
            ImageIO.write((RenderedImage)bImage, "png", outFile);
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Error: SnapShot", (Object[])new Object[0]);
        }
        if (this.mWs != null) {
            this.mWs.snapShotCurrentView();
        }
    }

    public void refreshCurrentView(boolean now) {
        if (this.mWs != null) {
            this.mWs.refreshCurrentView(now);
        }
    }

    public AAppView getCurrentView() {
        if (this.mWs == null) {
            return null;
        }
        return this.mWs.getCurrentView();
    }

    public void refreshAllViews() {
        if (this.mWs == null) {
            return;
        }
        for (Db db : this.getOpenDBs()) {
            OrbitIO.refreshViewsOf(db);
        }
    }

    public Selection.Filter getVisibleItemFilter() {
        ViewColorizer colorizer = OrbitIO.getCurColorizer();
        if (colorizer == null) {
            return null;
        }
        return new Selectors.VisibleItemFilter(colorizer);
    }

    public void showInfoForUserPt(double x, double y) {
        AAppView v = this.getCurrentView();
        if (v == null) {
            ALog.logInfo((String)"There is no current view.");
            return;
        }
        if (!(v instanceof DesignView2D)) {
            StackTraceElement ste = new Throwable().getStackTrace()[0];
            String methodDesc = String.format("%s.%s", ste.getClassName(), ste.getMethodName());
            ALog.logInfo((String)"The current view (%s) is not supported by %s.", (Object[])new Object[]{v.getClass().getSimpleName(), methodDesc});
            return;
        }
        DesignView2D dv = (DesignView2D)v;
        InspectMode modeInspect = (InspectMode)dv.getMode("InspectMode");
        modeInspect.showInfoForUserPt(x, y);
    }

    public Stream<OrbitIOInitializer> getAddIns() {
        return AServiceLoader.load(OrbitIOInitializer.class).stream();
    }

    private void loadPlugins() {
        String c;
        Settings addInPrefs = Settings.getSettings((String)"AddIn");
        if (this.hasEnv(AAppEnv.UI_THEME_INNOVUS)) {
            addInPrefs.putSetting("com.cadence.orbit.pi.innovus.InnovusPI.Enabled", (Object)true);
            addInPrefs.save();
        }
        HashSet<String> enabledAddIns = new HashSet<String>();
        for (String settingName : addInPrefs.getSettingNames(null)) {
            Matcher matcher = AddInsPanel.PATTERN_AI_ENABLED.matcher(settingName);
            if (!matcher.matches() || !Boolean.TRUE.equals(addInPrefs.getSetting(settingName, (Object)false))) continue;
            enabledAddIns.add(matcher.group(1));
        }
        try {
            for (OrbitIOInitializer initializer : AServiceLoader.load(OrbitIOInitializer.class)) {
                String name = initializer.getClass().getName();
                if (!enabledAddIns.contains(name)) {
                    ALog.logDebug((String)"Discovered add in '%s' is disabled, it is not being initialized.", (Object[])new Object[]{name});
                    continue;
                }
                try {
                    if (initializer.initialize(this)) {
                        ALog.logDebug((String)"Initialized '%s'.", (Object[])new Object[]{name});
                        continue;
                    }
                    ALog.logError((String)"Failed to initialize '%s'.", (Object[])new Object[]{name});
                }
                catch (Exception e) {
                    ALog.logError((Throwable)e, (String)"Exception initializing '%s'.", (Object[])new Object[]{name});
                }
                catch (Error e) {
                    ALog.logError((Throwable)e, (String)"Error initializing '%s'.", (Object[])new Object[]{name});
                }
            }
        }
        catch (Exception e) {
            ALog.logError((Throwable)e, (String)"Exception loading OrbitIOInitializerS.", (Object[])new Object[0]);
        }
        catch (Error e) {
            ALog.logError((Throwable)e, (String)"Error loading OrbitIOInitializerS.", (Object[])new Object[0]);
        }
        Settings piSettings = Settings.getSettings((String)"Plugin");
        int i = 0;
        while ((c = (String)piSettings.getSettingOfClass("PluginClass" + i, String.class)) != null) {
            this.loadPlugin(c);
            ++i;
        }
    }

    protected void loadPlugin(String className) {
        try {
            Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            ALog.logWarn((Throwable)e, (String)"The plugin '%s' could not be found on the application's classpath.", (Object[])new Object[]{className});
        }
    }

    public PortFilters getPortFilters() {
        if (this.mPortFilters == null) {
            this.mPortFilters = new PortFilters();
        }
        return this.mPortFilters;
    }

    public NetFilters getNetFilters() {
        if (this.mNetFilters == null) {
            this.mNetFilters = new NetFilters();
        }
        return this.mNetFilters;
    }

    public DeviceTemplate.NetFilter getDefaultNetFilter() {
        String name = (String)Settings.get((String)"UserPreferences", (String)"DefaultNetFilter", (Object)NetFilters.DEFAULT.getName());
        return this.getNetFilters().getFilter(name);
    }

    public void registerFileHandler(String action, FileHandler fh) {
        if (!this.mActionToFileHandler.containsEntry((Object)action, (Object)fh)) {
            this.mActionToFileHandler.put((Object)action, (Object)fh);
        }
    }

    public boolean deregisterFileHandler(String action, FileHandler fh) {
        return this.mActionToFileHandler.remove((Object)action, (Object)fh);
    }

    public Iterator<FileHandler> getFileHandlers(String action) {
        return Lists.reverse((List)this.mActionToFileHandler.get((Object)action)).iterator();
    }

    public FileHandler getFileHandler(String action, File f) {
        for (FileHandler fh : this.mActionToFileHandler.get((Object)action)) {
            if (!fh.canHandle(action, f)) continue;
            return fh;
        }
        return null;
    }

    public void registerPlugin(Plugin pi) {
        super.registerPlugin((OrbitApp.Plugin)pi);
    }

    public static void selectMostLikelyIOPorts(String start) {
        Db db = OrbitIO.getCurDb();
        int c = SelectionCmds.selectMostLikelyIOPorts((Db)db, (String)start);
        OrbitIO.refreshViewsOf(db);
        ALog.logInfo((String)"%d IO pads were selected.", (Object[])new Object[]{c});
    }

    public static void selectDriversOfDie(String start) {
        Db db = OrbitIO.getCurDb();
        int c = SelectionCmds.selectDriversOfDie((Db)db, (String)start);
        OrbitIO.refreshViewsOf(db);
        ALog.logInfo((String)"%d IO drivers were selected", (Object[])new Object[]{c});
    }

    public static boolean importDieSpreadsheet(String filePath, String devicePathString) {
        DiePadSpreadsheetSerializer ps;
        Db db = OrbitIO.getCurDb();
        if (db == null) {
            ALog.logError((String)LOG_IMPORT_FAIL, (Object[])new Object[]{filePath});
            return false;
        }
        DevicePath devicePath = DevicePath.fromString((Db)OrbitIO.getCurDb(), (String)devicePathString);
        try {
            ps = new DiePadSpreadsheetSerializer();
        }
        catch (LSession.NoLicenseException e) {
            return false;
        }
        ps.importDie(filePath, devicePath);
        return true;
    }

    public static boolean exportCSVNetlist(String filePath, String devicePathString, int depth, boolean onlySelectedDevices, boolean absolutePaths) {
        return OrbitIO.exportCSVNetlist(filePath, devicePathString, depth, onlySelectedDevices, false, absolutePaths, false);
    }

    public static boolean exportCSVNetlist(String filePath, String devicePathString, int depth, boolean onlySelectedDevices, boolean onlySelectedPorts, boolean absolutePaths, boolean createDefaultNets) {
        Db db = OrbitIO.getCurDb();
        if (db == null) {
            ALog.logError((String)LOG_IMPORT_FAIL, (Object[])new Object[]{filePath});
            return false;
        }
        if (createDefaultNets) {
            Cp.exec((String)"createDefaultNets(\"%s\")", (Object[])new Object[]{devicePathString});
        }
        NetLister.cpExportCSV(devicePathString, filePath, depth, onlySelectedDevices, onlySelectedPorts, absolutePaths);
        return true;
    }

    public static void exportCSVNetlist(String filePath, String devicePathString, boolean includeInterfaces, boolean includeNetDirection) {
        Db db = OrbitIO.getCurDb();
        if (db == null) {
            ALog.logError((String)"Cannot export '%s', there is no current database.", (Object[])new Object[]{filePath});
        }
        DevicePath devicePath = DevicePath.fromEscapedString((Db)db, (String)devicePathString);
        NetLister.exportCSV(devicePath, filePath, includeInterfaces, includeNetDirection);
    }

    public static void exportCSVNetlist(String filePath, String devicePathString, boolean includeInterfaces) {
        OrbitIO.exportCSVNetlist(filePath, devicePathString, includeInterfaces, false);
    }

    public static boolean importCSVNetlist(String filePath, String devicePathString, boolean netsOnly) {
        return OrbitIO.importCSVNetlist(filePath, devicePathString, netsOnly, false);
    }

    public static boolean importCSVNetlist(String filePath, String devicePathString, boolean netsOnly, boolean includeIOPinsInFloorplan) {
        Db db = OrbitIO.getCurDb();
        if (db == null) {
            ALog.logError((String)LOG_IMPORT_FAIL, (Object[])new Object[]{filePath});
            return false;
        }
        DevicePath devicePath = DevicePath.fromString((Db)OrbitIO.getCurDb(), (String)devicePathString);
        NetLister nlo = new NetLister();
        if (devicePath != null) {
            nlo.importCSV(devicePathString, filePath, netsOnly, includeIOPinsInFloorplan);
        } else {
            ALog.logWarn((String)("The device " + devicePathString + " does not exist"));
        }
        return true;
    }

    public static boolean importAIF(String filePath) {
        return AIFIn.importAIF(filePath);
    }

    public static boolean importAIF(String filePath, boolean justPackage) {
        return AIFIn.importAIF(filePath, justPackage);
    }

    public static boolean exportAIF(String filePath, String devicePathString) {
        return OrbitIO.exportAIF(filePath, devicePathString, false, true);
    }

    public static boolean exportAIF(String filePath, String devicePathString, boolean isWYSIWYG, boolean sortDiePads) {
        return AIFExport.exportAIF(filePath, devicePathString, isWYSIWYG, sortDiePads);
    }

    public static boolean exportDEF(String filePath, String devicePathString, boolean exportNets, boolean exportSyn, boolean forTesting) {
        return OrbitIO.exportDEF(filePath, devicePathString, exportNets, exportSyn, forTesting, true);
    }

    public static boolean exportDEF(String filePath, String devicePathString, boolean exportNets, boolean exportSyn, boolean forTesting, boolean overwriteDefOutNames) {
        return OrbitIO.exportDEF(filePath, devicePathString, exportNets, exportSyn, forTesting, overwriteDefOutNames, false);
    }

    public static boolean exportDEF(String filePath, String devicePathString, boolean exportNets, boolean exportSyn, boolean forTesting, boolean overwriteDefOutNames, boolean writePinSection) {
        return OrbitIO.exportDEF(filePath, devicePathString, exportNets, exportSyn, forTesting, overwriteDefOutNames, writePinSection, true, true);
    }

    public static boolean exportDEF(String filePath, String devicePathString, boolean exportNets, boolean exportSyn, boolean forTesting, boolean overwriteDefOutNames, boolean writePinSection, boolean writeWires, boolean writeVias) {
        DEFOut w = new DEFOut();
        w.setOverwriteDefOutNames(overwriteDefOutNames);
        w.setWritePinSection(writePinSection);
        w.setWriteWires(writeWires);
        w.setWriteVias(writeVias);
        DevicePath devicePath = DevicePath.fromString((Db)OrbitIO.getCurDb(), (String)devicePathString);
        ALog.logInfo((String)"Exporting %s DEF to %s...", (Object[])new Object[]{devicePathString, filePath});
        w.write(devicePath, exportSyn, exportNets, filePath, forTesting);
        ALog.logInfo((String)"Export %s DEF complete", (Object[])new Object[]{devicePathString});
        return true;
    }

    public static void exportNetLength(String filePath, boolean justSelected, boolean showFile) {
        NetLengthOut w = new NetLengthOut();
        w.write(filePath, justSelected, showFile);
    }

    public static void exportNetMapping(String filePath, String devicePath, String[] childDevicePath, boolean producePicture, boolean isOpenHtmlImmediately) {
        OrbitIO.exportNetMapping(filePath, devicePath, childDevicePath, producePicture, isOpenHtmlImmediately, true);
    }

    public static void exportNetMapping(String filePath, String devicePath, String[] childDevicePath, boolean producePicture, boolean isOpenHtmlImmediately, boolean html) {
        Db db = OrbitIO.getCurDb();
        NetTable netTable = new NetTable();
        DevicePath path = DevicePath.fromString((Db)db, (String)devicePath);
        if (path == null) {
            return;
        }
        netTable.setParent(path);
        for (String p : childDevicePath) {
            netTable.addChildOfInterest(DevicePath.fromString((Db)db, (String)p));
        }
        netTable.doneWithInterestingChildren();
        netTable.setSumOfRectForDevice(path);
        if (html) {
            netTable.generateHTML(filePath, producePicture);
        } else {
            netTable.generateCSV(filePath);
        }
        if (isOpenHtmlImmediately) {
            ABrowserControl.displayFile((String)filePath);
        }
    }

    public static void exportDevicePinMapping(String filePath, String devicePath, String[] childDevicePath, boolean exportSeparateDeviceName) {
        Db db = OrbitIO.getCurDb();
        DevicePath path = DevicePath.fromString((Db)db, (String)devicePath);
        if (path == null) {
            return;
        }
        DevicePinMappingTable devicePinMappingTable = new DevicePinMappingTable(path);
        Arrays.sort(childDevicePath);
        for (String child : childDevicePath) {
            for (DevicePath p : DevicePath.fromString((Db)db, (String)child).getDescendants()) {
                devicePinMappingTable.addChildOfInterest(p);
            }
        }
        devicePinMappingTable.generateCSV(filePath, exportSeparateDeviceName);
    }

    public static boolean importUpdXml(String filePath) {
        return UpdXmlReader.importUpdXml(filePath);
    }

    public static boolean importUpd(String filePath, String rootDeviceName, String deviceTemplatePrefix, DeviceTemplate.Type templateType) {
        return OrbitIO.importUpd(filePath, rootDeviceName, deviceTemplatePrefix, templateType, true);
    }

    public static boolean importUpd(String filePath, String rootDeviceName, String deviceTemplatePrefix, DeviceTemplate.Type templateType, boolean readWires) {
        return UpdToDbProcessor.importUpd(filePath, rootDeviceName, deviceTemplatePrefix, templateType, readWires);
    }

    public static boolean importSpd(String filePath, String rootDeviceName, String deviceTemplatePrefix, DeviceTemplate.Type templateType, String substrateKeyStr) {
        return OrbitIO.importSpd(filePath, rootDeviceName, deviceTemplatePrefix, templateType, substrateKeyStr, "false", "false");
    }

    public static boolean importSpd(String filePath, String rootDeviceName, String deviceTemplatePrefix, DeviceTemplate.Type templateType, String substrateKeyStr, String isIgnoreLayerPrefix, String isIgnoreDielectric) {
        Spd2000.importFile(filePath, rootDeviceName, deviceTemplatePrefix, templateType, true, true, substrateKeyStr, Boolean.parseBoolean(isIgnoreLayerPrefix), Boolean.parseBoolean(isIgnoreDielectric));
        return true;
    }

    protected static void setDefaultDistUnitFromCmdLineArg(List<String> argParams) {
        String expectedParams = String.format("The expected paramters are:\n -%s:name,dbuPerUnit,dbuPerMicron,decimalPlaces\n  where:\n    name: The name of the distance unit.\n    dbuPerUnit: The number of internal units per named unit (long).\n    dbuPerMicron: Tthe number of internal units per micron (long).\n    decimalPlaces: the maximum number of decimal places when displaying or outputting values (integer).", CLARG_DEFAULT_DISTANCE_UNIT);
        String paramsStr = argParams == null ? null : argParams.stream().collect(Collectors.joining(","));
        List params = paramsStr == null ? List.of() : Arrays.asList(paramsStr.split(","));
        List list = params;
        if (params.size() != 4) {
            ALog.logWarn((String)"Invalid paramaters specfied '%s', default distance unit not set. %s", (Object[])new Object[]{paramsStr, expectedParams});
            return;
        }
        String name = (String)params.get(0);
        Long dbuCount = AUtil.parseLong((String)((String)params.get(1)));
        if (dbuCount == null) {
            ALog.logWarn((String)"Invalid long specified for dbuPerUnit, default distance unit not set. %s", (Object[])new Object[]{expectedParams});
            return;
        }
        Long dbuPerMicron = AUtil.parseLong((String)((String)params.get(2)));
        if (dbuPerMicron == null) {
            ALog.logWarn((String)"Invalid long specified for dbuPerMicron setting of default distance unit. %s", (Object[])new Object[]{expectedParams});
            return;
        }
        Integer decimalPlaces = AUtil.parseInt((String)((String)params.get(3)));
        if (decimalPlaces == null) {
            ALog.logWarn((String)"Invalid integer specified for decimalPlaces setting of default distance unit. %s", (Object[])new Object[]{expectedParams});
            return;
        }
        ALog.logInfo((String)"Setting default distance unit from command line '-%s' specification.\n  Unit name: '%s', dbuPerUnit: %d, dbuPerMicron: %d, decimalPlaces: %d", (Object[])new Object[]{CLARG_DEFAULT_DISTANCE_UNIT, name, dbuCount, dbuPerMicron, decimalPlaces});
        Settings s = Settings.getSettings((String)"App");
        s.putSetting("DefaultDistanceUnitName", (Object)name, Settings.Type.Session);
        s.putSetting("DefaultDistanceUnitDbuCount", (Object)dbuCount, Settings.Type.Session);
        s.putSetting("DefaultDistanceUnitDbuPerMicron", (Object)dbuPerMicron, Settings.Type.Session);
        s.putSetting("DefaultDistanceUnitDecimals", (Object)decimalPlaces, Settings.Type.Session);
    }

    static {
        System.setProperty("swing.boldMetal", "false");
        OIO_FILE_FILTER = AclResources.OIO_FILE_FILTER;
        SCRIPT_FILE_FILTER = AclResources.SCRIPT_FILE_FILTER;
        PreregisteredInitializers = new OrbitIOInitializer[0];
        sInitializationComplete = false;
        sLogFileBaseName = null;
        sSessionId = 1;
        sRunTimeRules = null;
    }

    private static class SplashSetting {
        String imagePath;
        boolean imageOnly;

        SplashSetting(String imagePath, boolean imageOnly) {
            this.imagePath = imagePath;
            this.imageOnly = imageOnly;
        }
    }

    protected class DbReadListener
    implements DbReader.StatusListener {
        protected DbReader mReader = null;

        public DbReadListener(DbReader reader) {
            this.mReader = reader;
            this.mReader.addStatusListener((DbReader.StatusListener)this);
        }

        public void remove() {
            this.status(null);
            this.status(-1.0f);
            this.mReader.removeStatusListener((DbReader.StatusListener)this);
        }

        public void status(String desc) {
            if (OrbitIO.this.mWs != null) {
                OrbitIO.this.mWs.setStatus(desc);
            }
        }

        public void status(float percent) {
            if (OrbitIO.this.mWs != null) {
                OrbitIO.this.mWs.setStatus(percent);
            }
        }
    }

    public static interface FileHandler {
        public boolean canHandle(String var1, File var2);

        public boolean handle(String var1, File var2);
    }

    public static interface Plugin
    extends OrbitApp.Plugin {
    }
}

