/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit;

import com.sigrity.acl.ALog;
import com.sigrity.acl.AUtil;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbClass;
import com.sigrity.acl.db.std.BondFingerMonitor;
import com.sigrity.acl.db.std.Bundle;
import com.sigrity.acl.db.std.BundleMonitor;
import com.sigrity.acl.db.std.Device;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Substrate;
import com.sigrity.acl.dbui.MovingSetMonitor;
import com.sigrity.orbit.DevicePath;
import com.sigrity.orbit.InterfaceCmds;
import com.sigrity.orbit.db.FloorplanPersonalityMonitor;
import com.sigrity.orbit.db.InterfaceDeviceMonitor;
import com.sigrity.orbit.ui.PersonalityMappingMgmt;
import com.sigrity.orbit.ui.core.ViewColorizer;
import java.util.Iterator;
import java.util.LinkedList;

public class OrbitRunTimeRules {
    protected MovingSetMonitor mMovingSetMonitor = null;
    protected BundleMonitor mBundleMonitor = null;
    protected BondFingerMonitor mBondFingerMonitor = null;

    public MovingSetMonitor getMovingSetMonitor() {
        return this.mMovingSetMonitor;
    }

    public BundleMonitor getBundleMonitor() {
        return this.mBundleMonitor;
    }

    public BondFingerMonitor getBondFingerMonitor() {
        return this.mBondFingerMonitor;
    }

    public void initRules() {
        ViewColorizer.registerDbListeners();
        this.initRotationRules();
        Bundle.initSchedConnListener();
        InterfaceCmds.init();
        PersonalityMappingMgmt.initPersonalityMappingListeners();
        FloorplanPersonalityMonitor.init();
        InterfaceDeviceMonitor.init();
        this.mBundleMonitor = BundleMonitor.init();
        this.mMovingSetMonitor = MovingSetMonitor.init();
        this.mBondFingerMonitor = BondFingerMonitor.init();
    }

    protected void initRotationRules() {
        Db.DbListenerAdapter dba = new Db.DbListenerAdapter(){

            public void dbLoaded(Db db) {
                DeviceRotationListener drl = new DeviceRotationListener();
                DbClass clazz = db.getDbClass("Device");
                clazz.addObjectListener((DbClass.DbObjectListener)drl, DbClass.DbObjectEventType.getUpdated());
                OrbitRunTimeRules.this.updateAllDevices(db);
            }
        };
        Db.addDbListener((Db.DbListener)dba);
    }

    protected static boolean templateHasRotationalConstraints(DeviceTemplate dt) {
        if (dt == null) {
            return true;
        }
        String tName = (String)dt.getValue("tech.rot_0_template");
        if (tName != null && !tName.isEmpty()) {
            return true;
        }
        tName = (String)dt.getValue("tech.rot_90_template");
        if (tName != null && !tName.isEmpty()) {
            return true;
        }
        tName = (String)dt.getValue("tech.rot_180_template");
        if (tName != null && !tName.isEmpty()) {
            return true;
        }
        tName = (String)dt.getValue("tech.rot_270_template");
        return tName != null && !tName.isEmpty();
    }

    protected void updateDeviceWithRotation(Device d, double newRotation) {
        String tName;
        if (d == null || d.getTemplate() == null) {
            return;
        }
        DeviceTemplate dt = d.getTemplate();
        if (newRotation == 0.0) {
            String tName2;
            String string = tName2 = dt == null ? null : dt.getStringValue("tech.rot_0_template");
            if (tName2 != null && !tName2.isEmpty()) {
                this.updateTemplate(d, tName2);
            }
        } else if (newRotation == 90.0) {
            String tName3 = (String)dt.getValue("tech.rot_90_template");
            if (tName3 != null && !tName3.isEmpty()) {
                this.updateTemplate(d, tName3);
            }
        } else if (newRotation == 180.0) {
            String tName4 = (String)dt.getValue("tech.rot_180_template");
            if (tName4 != null && !tName4.isEmpty()) {
                this.updateTemplate(d, tName4);
            }
        } else if (newRotation == 270.0 && (tName = (String)dt.getValue("tech.rot_270_template")) != null && !tName.isEmpty()) {
            this.updateTemplate(d, tName);
        }
    }

    public void updateAllDevices(Db db) {
        for (DeviceTemplate dt : AUtil.linkedList((Iterator)db.getObjects(DeviceTemplate.class))) {
            if (!OrbitRunTimeRules.templateHasRotationalConstraints(dt)) continue;
            Substrate s = dt.getSubstrate();
            for (Device d : dt.getChildren()) {
                DevicePath pathToSubstrate;
                DevicePath path = new DevicePath(dt, d);
                DevicePath devicePath = pathToSubstrate = s == null ? null : path.pathToParent(s);
                if (pathToSubstrate == null) continue;
                pathToSubstrate.removeFirst();
                double newRot = pathToSubstrate.getRot();
                d = pathToSubstrate.getLast();
                if (d == null) continue;
                this.updateDeviceWithRotation(d, newRot);
            }
        }
    }

    protected void updateDeviceForProperRotation(Device d) {
        DeviceTemplate thisTemplate = d.getTemplate();
        Substrate s = d.getSubstrate();
        LinkedList<DevicePath> pathsToCheck = new LinkedList<DevicePath>();
        if (OrbitRunTimeRules.templateHasRotationalConstraints(thisTemplate)) {
            pathsToCheck.addAll(AUtil.linkedList((Iterator)d.getHierarchicalInstances()));
        }
        DevicePath surPath = d.getADevicePath();
        for (DevicePath descendent : surPath.getDescendants()) {
            Device last = descendent.getLast();
            DeviceTemplate lastTemplate = last.getTemplate();
            if (!OrbitRunTimeRules.templateHasRotationalConstraints(lastTemplate)) continue;
            pathsToCheck.add(descendent);
        }
        for (DevicePath path : pathsToCheck) {
            DevicePath pathToSubstrate;
            DevicePath devicePath = pathToSubstrate = s == null ? null : path.pathToParent(s);
            if (pathToSubstrate == null) continue;
            pathToSubstrate.removeFirst();
            d = pathToSubstrate.getLast();
            if (d == null) continue;
            double newRot = pathToSubstrate.getRot();
            this.updateDeviceWithRotation(d, newRot);
        }
    }

    protected void updateTemplate(Device d, String tName) {
        DeviceTemplate dt = d.getTemplate();
        if (!tName.equals(dt.getName())) {
            DeviceTemplate newTemplate = DeviceTemplate.get((Db)d.getDb(), (String)d.getSubstrate().getName(), (String)tName);
            if (newTemplate != null) {
                d.replaceTemplate(newTemplate);
                ALog.logInfo((String)("The DeviceTemplate for " + d.getName() + ", has been substituted to " + tName));
            } else {
                ALog.logInfo((String)("The DeviceTemplate " + tName + " is being requested, but is not found on the substrate"));
            }
        }
    }

    protected class DeviceRotationListener
    implements DbClass.DbObjectListener {
        protected DeviceRotationListener() {
        }

        public boolean addingObject(DbClass.ObjectAdd add) {
            return false;
        }

        public boolean changingObject(DbClass.ObjectChange change) {
            return false;
        }

        public boolean removingObject(DbClass.ObjectRemove remove) {
            return false;
        }

        public void addedObject(DbClass.ObjectAdd add) {
            Device d = (Device)add.getDbObject();
            OrbitRunTimeRules.this.updateDeviceForProperRotation(d);
        }

        public void changedObject(DbClass.ObjectChange change) {
            if (change.getField().getName() != null && change.getField().getName().equals("rotate")) {
                Device d = (Device)change.getDbObject();
                OrbitRunTimeRules.this.updateDeviceForProperRotation(d);
            }
        }

        public void removedObject(DbClass.ObjectRemove remove) {
        }
    }
}

