/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit;

import com.sigrity.acl.AArrays;
import com.sigrity.acl.ALog;
import com.sigrity.acl.cp.Cp;
import com.sigrity.acl.db.Db;
import com.sigrity.acl.db.DbCompare;
import com.sigrity.acl.db.std.Design;
import com.sigrity.acl.xml.AXDomUtil;
import com.sigrity.orbit.DesignSettings;
import com.sigrity.orbit.OrbitDbReader;
import com.sigrity.orbit.OrbitDbReaderImport;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.test.ViewColorizerDiff;
import com.sigrity.orbit.ui.ImportDbUI;
import com.sigrity.orbit.ui.core.DesignView2D;
import com.sigrity.orbit.ui.core.OrbitGuiWS;
import com.sigrity.orbit.ui.core.ViewColorizer;
import java.io.File;
import java.io.IOException;
import org.w3c.dom.Element;

public class OrbitTest {
    private static Long sMaxDiffs;
    private static boolean sStrictComparison;
    public final File testScript;
    public final String rootDir;
    public final String outDir;
    public final String refDir;

    public static void setMaxDiffs(long v) {
        sMaxDiffs = v;
    }

    public static void resetMaxDiffs() {
        sMaxDiffs = null;
    }

    public static void setStrict(boolean enable) {
        sStrictComparison = enable;
    }

    public static Object run(String testScript) {
        return OrbitTest.run(testScript, Cp.getCp());
    }

    public static Object run(String testScript, Cp cp) {
        ALog.resetLogExceptionCount();
        DbCompare.setCheckInvalidObject((boolean)true);
        OrbitTest test = new OrbitTest(new File(testScript));
        cp.setInterpreterValue("test", (Object)test);
        Cp.getCp().setInterpreterValue("Cp", (Object)cp);
        Object result = Cp.exec((String)"Cp.source(\"%s\", false)", (Object[])new Object[]{testScript});
        if (result instanceof Boolean && Boolean.TRUE.equals(result)) {
            ALog.logInfo((String)("Test returned: " + result));
        } else {
            ALog.logError((String)("Test returned: " + result));
        }
        if (ALog.getLogExceptionCount() > 0L) {
            ALog.logError((Throwable)ALog.getLogLastException(), (String)"Exist %d exceptions, change result to false", (Object[])new Object[]{ALog.getLogExceptionCount()});
            result = false;
        }
        DbCompare.setCheckInvalidObject((boolean)false);
        ALog.resetLogExceptionCount();
        OrbitGuiWS ws = OrbitIO.getGuiWorkspace();
        if (ws != null) {
            ws.getMessagePanel().clearMessages();
        }
        return result;
    }

    protected OrbitTest(File testScript) {
        this.testScript = testScript;
        String[] config = this.getConfig();
        if (config == null) {
            this.rootDir = ".";
            this.outDir = "./out";
            this.refDir = "./ref";
        } else {
            this.rootDir = config[0];
            this.outDir = config[1];
            this.refDir = config[2];
        }
        File out = new File(this.outDir);
        if (!out.isDirectory() && !out.mkdir()) {
            ALog.logWarn((String)"Unable to create output directory '%s'.", (Object[])new Object[]{out.getAbsolutePath()});
        }
    }

    public String[] getConfig() {
        if (this.testScript == null || !this.testScript.isFile()) {
            ALog.logError((String)"Unable to determine OrbitTest source script file.");
            return null;
        }
        File sourceFile = this.testScript.getAbsoluteFile();
        File testFileDir = sourceFile.getParentFile();
        File cfgFile = OrbitTest.getConfigFile(testFileDir);
        if (cfgFile == null) {
            ALog.logError((String)"Unable to find ATestRunner configuration file for '%s'.", (Object[])new Object[]{sourceFile.getPath()});
            return null;
        }
        Element xDoc = AXDomUtil.getDocumentElement((File)cfgFile);
        if (xDoc == null) {
            ALog.logError((String)"Invalid ATestRunner configuration file '%s'.", (Object[])new Object[]{cfgFile.getPath()});
            return null;
        }
        File cfgFileDir = cfgFile.getParentFile();
        File root = OrbitTest.resolvePath(cfgFileDir, xDoc.getAttribute("rootDir"));
        File out = OrbitTest.resolvePath(testFileDir, xDoc.getAttribute("outDirName"));
        File ref = OrbitTest.resolvePath(testFileDir, xDoc.getAttribute("refDirName"));
        try {
            root = root.getCanonicalFile();
            out = out.getCanonicalFile();
            ref = ref.getCanonicalFile();
        }
        catch (IOException ioe) {
            ALog.logError((Throwable)ioe, (String)"Unexpected exception while getting OrbitTest configuration.", (Object[])new Object[0]);
        }
        return new String[]{root.getPath(), out.getPath(), ref.getPath()};
    }

    public static File resolvePath(File referenceDir, String path) {
        File f = new File(path);
        if (f.isAbsolute()) {
            return f;
        }
        return new File(referenceDir, path);
    }

    public static File getConfigFile(File startDir) {
        if (startDir == null) {
            return null;
        }
        for (File curDir = startDir; curDir != null && curDir.isDirectory(); curDir = curDir.getParentFile()) {
            File cfg = new File(curDir, "ATestRunner.xml");
            if (!cfg.isFile()) continue;
            return cfg;
        }
        return null;
    }

    public static Db getDesign(String path) {
        OrbitIO oio = OrbitIO.getApp();
        Db db = oio.getDesign(path);
        if (db == null) {
            db = oio.openDesign(path, false);
        }
        return db;
    }

    public static Db importDesign(String path) {
        DesignView2D.setQuiet(true);
        OrbitDbReaderImport.setQuiet(true);
        OrbitIO oio = OrbitIO.getApp();
        oio.createDesign();
        if (!ImportDbUI.importDb(path, null, null, true)) {
            return null;
        }
        Db db = oio.getCurrentDb();
        db.setFile(new File(path));
        DesignView2D.setQuiet(false);
        OrbitDbReaderImport.setQuiet(false);
        return db;
    }

    public static boolean assertSame(String path) {
        return OrbitTest.assertSame(path, (String[])null);
    }

    public static boolean assertSame(String pathRef, String pathNew) {
        return OrbitTest.assertSame(pathRef, pathNew, null);
    }

    public static boolean assertSame(String path, String[] ignorePatterns) {
        Db dbNew = OrbitIO.getApp().getCurrentDb();
        return OrbitTest.assertSame(path, dbNew, ignorePatterns);
    }

    public static boolean assertSame(String pathRef, String pathNew, String[] ignorePatterns) {
        OrbitIO oio = OrbitIO.getApp();
        Db dbNew = OrbitTest.getDesign(pathNew);
        if (dbNew == null) {
            ALog.logError((String)"Unable to open design '%s'.", (Object[])new Object[]{pathNew});
            return false;
        }
        boolean result = OrbitTest.assertSame(pathRef, dbNew, ignorePatterns);
        oio.closeDesign(dbNew);
        return result;
    }

    public static boolean assertSame(String pathRef, Db dbNew, String[] ignorePatterns) {
        boolean result;
        Db dbRef = OrbitTest.getDesign(pathRef);
        if (dbRef == null) {
            ALog.logError((String)"Unable to open design '%s'.", (Object[])new Object[]{pathRef});
            return false;
        }
        Db.Version dbVerRef = OrbitDbReader.getLastReadVersion((Db)dbRef);
        if (dbVerRef != null && dbVerRef.compareTo(OrbitDbReader.DBVERSION_DOT20) < 1) {
            ALog.logInfo((String)"OrbitTest.assertSame: Reference database was read from a file prior to version %s, newly set extent fields on DeviceTemplates are being ignored.", (Object[])new Object[]{OrbitDbReader.DBVERSION_DOT20});
            ignorePatterns = (String[])AArrays.append((Object[])ignorePatterns, (Object)"^On '(?:DeviceTemplate|Design)' with key '.*' field 'extent' changed from 'null' to 'ARect .*'.$");
        }
        ignorePatterns = (String[])AArrays.append((Object[])ignorePatterns, (Object)"^On '(?:DeviceTemplate|Design)' with key '.*' field 'extent' changed from 'ARect .*' to 'null'.$");
        DbCompare dbCompare = new DbCompare(dbRef, dbNew, ignorePatterns);
        if (sMaxDiffs != null) {
            DbCompare.setMaxDiff((long)sMaxDiffs);
        }
        boolean bl = result = (result = dbCompare.compare()) && OrbitTest.compareDesignSettings(dbRef, dbNew);
        if (dbNew != dbRef) {
            OrbitIO.getApp().forceCloseDesign(dbRef);
        }
        return result;
    }

    static boolean compareDesignSettings(Db dbRef, Db dbNew) {
        ViewColorizer colorRef = null;
        ViewColorizer colorNew = null;
        Design design = Design.getDesign((Db)dbRef, (boolean)false);
        if (design != null) {
            colorRef = (ViewColorizer)DesignSettings.get((Design)design, (String)"ViewColorizer", ViewColorizer.class);
        }
        if ((design = Design.getDesign((Db)dbNew, (boolean)false)) != null) {
            colorNew = (ViewColorizer)DesignSettings.get((Design)design, (String)"ViewColorizer", ViewColorizer.class);
        }
        if (colorRef == null && colorNew == null) {
            return true;
        }
        if (colorRef == null || colorNew == null) {
            return false;
        }
        ViewColorizerDiff diff = new ViewColorizerDiff(colorRef, colorNew);
        if (sStrictComparison) {
            return diff.sameColor() && diff.sameVisible();
        }
        return diff.sameVisible();
    }

    public static boolean assertSameTemplates(String pathRef, String pathNew, String[] ignorePatterns, boolean quiet) {
        if (quiet) {
            ALog.setQuietPlease((boolean)quiet);
        }
        OrbitIO oio = OrbitIO.getApp();
        Db dbRef = OrbitTest.importDesign(pathRef);
        if (dbRef == null) {
            if (quiet) {
                ALog.setQuietPlease((boolean)false);
            }
            ALog.logError((String)"Unable to open template '%s'.", (Object[])new Object[]{pathRef});
            return false;
        }
        Db dbNew = OrbitTest.importDesign(pathNew);
        if (dbNew == null) {
            oio.closeDesign(dbRef);
            if (quiet) {
                ALog.setQuietPlease((boolean)false);
            }
            ALog.logError((String)"Unable to open template '%s'.", (Object[])new Object[]{pathNew});
            return false;
        }
        DbCompare dbCompare = new DbCompare(dbRef, dbNew, ignorePatterns);
        boolean result = dbCompare.compare();
        String strQrySave = System.getProperty(OrbitGuiWS.class.getName() + ".queryUserToSaveOnExit");
        if (strQrySave == null) {
            strQrySave = "true";
        }
        System.setProperty(OrbitGuiWS.class.getName() + ".queryUserToSaveOnExit", "false");
        oio.closeDesign(dbRef);
        oio.closeDesign(dbNew);
        System.setProperty(OrbitGuiWS.class.getName() + ".queryUserToSaveOnExit", strQrySave);
        if (quiet) {
            ALog.setQuietPlease((boolean)false);
        }
        return result;
    }

    static {
        sStrictComparison = false;
    }
}

