/*
 * Decompiled with CFR 0.152.
 */
package com.sigrity.orbit;

import com.sigrity.acl.ALog;
import com.sigrity.acl.APlatformUtil;
import com.sigrity.acl.AReflection;
import com.sigrity.acl.app.AAppView;
import com.sigrity.acl.app.Settings;
import com.sigrity.acl.db.std.DeviceTemplate;
import com.sigrity.acl.db.std.Net;
import com.sigrity.acl.geom.ARect;
import com.sigrity.orbit.OrbitIO;
import com.sigrity.orbit.ui.core.DesignCanvas2D;
import com.sigrity.orbit.ui.core.DesignView2D;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;

public class OrbitUtil {
    private OrbitUtil() {
    }

    public static boolean allNetsAreUnused(DeviceTemplate t) {
        return t.getNets().stream().allMatch(Net::isUnused);
    }

    public static boolean editXml(File file) {
        Settings settings = Settings.getSettings((String)"App");
        Object cmd = (String)settings.getSetting("EditorXML", (Object)"");
        if (((String)cmd).length() == 0) {
            cmd = APlatformUtil.isWindowsPlatform() ? "notepad {0}" : "vi {0}";
        } else if (!((String)cmd).contains("{")) {
            cmd = (String)cmd + " {0}";
        }
        cmd = MessageFormat.format((String)cmd, file.getAbsolutePath());
        try {
            Runtime.getRuntime().exec((String)cmd);
        }
        catch (IOException e) {
            ALog.logError((Throwable)e, (String)"Unable to execute '%s'.", (Object[])new Object[]{cmd});
            return false;
        }
        return true;
    }

    public static void logZoom() {
        AAppView view = OrbitIO.getCurView();
        if (!(view instanceof DesignView2D)) {
            ALog.logWarn((String)"No active 2D view.");
            return;
        }
        DesignView2D v2d = (DesignView2D)view;
        DesignCanvas2D canvas = v2d.getCanvas();
        ARect bounds = canvas.getXForm().getWorld();
        ALog.logInfo((String)"OrbitIO.getCurView().getCanvas().zoomTo(%dL, %dL, %dL, %dL)", (Object[])new Object[]{bounds.left(), bounds.bottom(), bounds.right(), bounds.top()});
    }

    public static String softFieldName(Class<?> owner, String name) {
        return String.format("%s.%s", AReflection.getJavaClassName(owner), name);
    }
}

